/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.LIFOSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeLIFOSet<E>
extends LIFOSet<E> {
    final int maxSize;
    private final EjectionPolicy policy;

    public FixedSizeLIFOSet(int n) {
        this(n, EjectionPolicy.LIFO);
    }

    public FixedSizeLIFOSet(int n, EjectionPolicy ejectionPolicy) {
        this.maxSize = n;
        this.policy = ejectionPolicy;
    }

    public FixedSizeLIFOSet(int n, int n2, float f) {
        this(n, n2, f, EjectionPolicy.LIFO);
    }

    public FixedSizeLIFOSet(int n, int n2, float f, EjectionPolicy ejectionPolicy) {
        super(n2, f);
        this.maxSize = n;
        this.policy = ejectionPolicy;
    }

    @Override
    public boolean add(E e) {
        boolean bl = super.add(e);
        if (bl && this.size() > this.maxSize) {
            if (this.policy == EjectionPolicy.FIFO) {
                this.remove(0);
            } else {
                this.remove(Math.max(0, this.size() - 2));
            }
            assert (this.size() <= this.maxSize);
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EjectionPolicy {
        LIFO,
        FIFO;

    }
}

