/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import org.limewire.collection.BitField;
import org.limewire.collection.BitSet;

public class BitFieldSet
implements BitField {
    private final int maxSize;
    private final BitSet bs;

    public BitFieldSet(BitSet bitSet, int n) {
        this.bs = bitSet;
        this.maxSize = n;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int cardinality() {
        if (this.bs.length() <= this.maxSize) {
            return this.bs.cardinality();
        }
        return this.bs.get(0, this.maxSize).cardinality();
    }

    public boolean get(int n) {
        if (n > this.maxSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.bs.get(n);
    }

    public int nextClearBit(int n) {
        int n2 = this.bs.nextClearBit(n);
        return n2 >= this.maxSize ? -1 : n2;
    }

    public int nextSetBit(int n) {
        int n2 = this.bs.nextSetBit(n);
        return n2 >= this.maxSize ? -1 : n2;
    }
}

