/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2010-09-13 00:49
   Version 4.5.0 
   linux-unix-gnu-x86 [ manyargs dload ptables ]
   compiled 2010-05-25 on hd-t1179cl (Linux)
   command line: posixunix.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -no-warnings -explicit-use -no-trace -output-file posixunix.c
   unit: posix
*/

#include "chicken.h"


#include <signal.h>
#include <errno.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <utime.h>

#if defined(__sun__) && defined(__svr4__)
# include <sys/tty.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)      C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)       (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)      C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)    (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_do_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))

#ifdef C_GNU_ENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

static void C_set_timeval(C_word num, struct timeval *tm)
{
  if((num & C_FIXNUM_BIT) != 0) {
    tm->tv_sec = C_unfix(num);
    tm->tv_usec = 0;
  }
  else {
    double i;
    tm->tv_usec = (int)(modf(C_flonum_magnitude(num), &i) * 1000000);
    tm->tv_sec = (int)i;
  }
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_set_timeval(t, &C_timeval), \
			       C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4) || defined(C_MACOSX)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t C_timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#else
#define C_timegm timegm
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    (memset((ptm), 0, sizeof(struct tm)), \
    (ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix(-(ptm)->tm_gmtoff)))

#define C_tm_set_08(v)  cpy_tmvec_to_tmstc08( &C_tm, (v) )
#define C_tm_set_9(v)   cpy_tmvec_to_tmstc9( &C_tm, (v) )

#define C_tm_get_08(v)  cpy_tmstc08_to_tmvec( (v), &C_tm )
#define C_tm_get_9(v)   cpy_tmstc9_to_tmvec( (v), &C_tm )

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  return v;
}

#else

static struct tm *
C_tm_set( C_word v )
{
  C_tm_set_08( v );
  C_tm_set_9( v );
  return &C_tm;
}

static C_word
C_tm_get( C_word v )
{
  C_tm_get_08( v );
  C_tm_get_9( v );
  return v;
}

#endif

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_a_mktime(ptr, c, v)  C_flonum(ptr, mktime(C_tm_set(v)))
#define C_a_timegm(ptr, c, v)  C_flonum(ptr, C_timegm(C_tm_set(v)))

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#ifdef __linux__
extern char *strptime(const char *s, const char *format, struct tm *tm);
extern pid_t getpgid(pid_t pid);
#endif

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_strptime(s, f, v) \
        (strptime(C_c_string(s), C_c_string(f), &C_tm) ? C_tm_get(v) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#ifdef TIOCGWINSZ
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif

static int set_file_mtime(char *filename, C_word tm)
{
  struct utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return utime(filename, &tb);
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[457];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,54,56,32,108,111,99,54,57,32,109,115,103,55,48,32,46,32,97,114,103,115,55,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,48,32,108,105,110,107,56,49,32,101,114,114,56,50,32,108,111,99,56,51,41,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,116,97,116,32,102,57,53,32,46,32,116,109,112,57,52,57,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,49,56,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,50,48,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,50,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,50,52,41,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,50,54,41};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,24),40,98,111,100,121,49,51,56,32,108,105,110,107,49,52,54,32,101,114,114,49,52,55,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,101,114,114,49,52,49,32,37,108,105,110,107,49,51,54,49,53,53,41};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,108,105,110,107,49,52,48,41,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,51,52,32,46,32,116,109,112,49,51,51,49,51,53,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,49,41,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,24),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,105,108,101,49,54,50,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,23),40,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,105,108,101,49,54,51,41,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,27),40,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,105,108,101,49,54,52,41,0,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,16),40,102,95,50,51,53,48,32,102,105,108,101,49,54,53,41};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,17),40,115,111,99,107,101,116,63,32,102,105,108,101,49,54,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,54,55,41,0,0,0,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,49,55,52,49,55,53,41,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,26),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,49,56,54,41,0,0,0,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,35),40,98,111,100,121,50,48,48,32,115,112,101,99,50,48,56,32,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,48,57,41,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,35),40,100,101,102,45,115,104,111,119,45,100,111,116,102,105,108,101,115,63,50,48,51,32,37,115,112,101,99,49,57,56,50,51,51,41,0,0,0,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,115,112,101,99,50,48,50,41,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,49,57,54,49,57,55,41,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,7),40,97,50,54,50,53,41,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,11),40,103,50,54,55,32,109,50,54,57,41,0,0,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,50,54,49,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,46),40,97,50,54,51,49,32,100,105,114,50,52,51,50,52,52,50,52,57,32,102,105,108,50,52,53,50,52,54,50,53,48,32,101,120,116,50,52,55,50,52,56,50,53,49,41,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,50,52,49,41,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,50,51,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,7),40,97,50,55,56,49,41,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,7),40,97,50,55,56,54,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,7),40,97,50,56,49,48,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,102,115,50,57,55,32,114,50,57,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,13),40,102,95,50,56,54,53,32,120,50,57,53,41,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,15),40,102,95,50,56,56,52,32,46,32,95,50,56,57,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,15),40,102,95,50,56,55,54,32,46,32,95,50,56,56,41,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,72),40,35,35,115,121,115,35,102,105,110,100,45,102,105,108,101,115,32,100,105,114,50,55,53,32,112,114,101,100,50,55,54,32,97,99,116,105,111,110,50,55,55,32,105,100,50,55,56,32,108,105,109,105,116,50,55,57,32,100,111,116,50,56,49,32,108,111,99,50,56,50,41};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,42),40,98,111,100,121,51,51,49,32,112,114,101,100,51,52,49,32,97,99,116,105,111,110,51,52,50,32,105,100,51,52,51,32,108,105,109,105,116,51,52,52,41,0,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,50),40,100,101,102,45,108,105,109,105,116,51,51,54,32,37,112,114,101,100,51,50,55,51,52,54,32,37,97,99,116,105,111,110,51,50,56,51,52,55,32,37,105,100,51,50,57,51,52,56,41,0,0,0,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,37),40,100,101,102,45,105,100,51,51,53,32,37,112,114,101,100,51,50,55,51,53,48,32,37,97,99,116,105,111,110,51,50,56,51,53,49,41,0,0,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,17),40,97,50,57,50,49,32,120,51,53,52,32,121,51,53,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,97,99,116,105,111,110,51,51,52,32,37,112,114,101,100,51,50,55,51,53,51,41,0,0,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,14),40,97,50,57,51,50,32,46,32,95,51,53,55,41,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,112,114,101,100,51,51,51,41,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,51,48,51,52,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,7),40,97,51,48,51,55,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,51,48,52,48,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,7),40,97,51,48,52,51,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,18),40,102,95,51,48,52,57,32,120,51,55,54,32,121,51,55,55,41,0,0,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,7),40,97,51,48,52,54,41,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,15),40,102,95,51,48,53,55,32,46,32,95,51,55,52,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,7),40,97,51,48,53,52,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,19),40,97,51,48,49,48,32,46,32,116,109,112,51,55,49,51,55,50,41,0,0,0,0,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,29),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,51,49,57,32,46,32,97,114,103,115,51,50,48,41,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,97,52,48,53,52,48,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,97,52,48,57,52,49,50,41,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,52,50,56,32,99,109,100,52,50,57,32,46,32,116,109,112,52,50,55,52,51,48,41,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,52,51,56,32,102,108,97,103,115,52,51,57,32,46,32,109,111,100,101,52,52,48,41,0,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,52,52,55,41,0,0,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,52,53,48,32,115,105,122,101,52,53,49,32,46,32,98,117,102,102,101,114,52,53,50,41,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,52,54,48,32,98,117,102,102,101,114,52,54,49,32,46,32,115,105,122,101,52,54,50,41,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,52,55,48,41,0,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,6),40,103,53,56,52,41,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,53,55,55,32,103,53,56,49,53,56,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,6),40,103,53,54,55,41,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,53,54,48,32,103,53,54,52,53,54,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,6),40,103,53,52,48,41,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,53,51,51,32,103,53,51,55,53,51,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,6),40,103,53,49,54,41,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,53,48,57,32,103,53,49,51,53,49,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,52,57,53,32,102,100,115,119,52,57,54,32,46,32,116,105,109,101,111,117,116,52,57,55,41,0,0,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,53,57,52,32,112,111,115,53,57,53,32,46,32,119,104,101,110,99,101,53,57,54,41,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,100,105,114,54,50,55,41,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,7),40,97,51,55,56,55,41,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,47),40,97,51,55,57,51,32,100,105,114,54,51,53,54,51,54,54,52,49,32,102,105,108,101,54,51,55,54,51,56,54,52,50,32,101,120,116,54,51,57,54,52,48,54,52,51,41,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,54,49,55,32,46,32,116,109,112,54,49,54,54,49,56,41,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,54,53,51,41,0,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,108,111,99,54,54,50,32,99,109,100,54,54,51,32,105,110,112,54,54,52,32,114,54,54,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,54,54,56,32,46,32,109,54,54,57,41,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,54,55,55,32,46,32,109,54,55,56,41};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,54,56,54,41,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,7),40,97,51,57,57,57,41,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,20),40,97,52,48,48,53,32,46,32,114,101,115,117,108,116,115,55,48,48,41,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,54,57,54,32,112,114,111,99,54,57,55,32,46,32,109,111,100,101,54,57,56,41,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,7),40,97,52,48,50,51,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,20),40,97,52,48,50,57,32,46,32,114,101,115,117,108,116,115,55,48,54,41,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,55,48,50,32,112,114,111,99,55,48,51,32,46,32,109,111,100,101,55,48,52,41};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,20),40,97,52,48,52,56,32,46,32,114,101,115,117,108,116,115,55,49,51,41,0,0,0,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,55,48,56,32,116,104,117,110,107,55,48,57,32,46,32,109,111,100,101,55,49,48,41};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,20),40,97,52,48,54,56,32,46,32,114,101,115,117,108,116,115,55,50,50,41,0,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,55,49,55,32,116,104,117,110,107,55,49,56,32,46,32,109,111,100,101,55,49,57,41,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,13),40,99,114,101,97,116,101,45,112,105,112,101,41,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,115,105,103,55,50,57,41,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,55,51,49,32,112,114,111,99,55,51,50,41,0,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,55,51,54,32,115,116,97,116,101,55,51,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,55,52,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,55,52,50,41,0,0,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,22),40,108,111,111,112,32,115,105,103,115,55,54,50,32,109,97,115,107,55,54,51,41,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,13),40,115,105,103,110,97,108,45,109,97,115,107,41,0,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,55,54,54,41,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,21),40,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,55,54,56,41,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,55,55,49,41,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,38),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,55,57,57,32,46,32,116,109,112,55,57,56,56,48,48,41,0,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,56,51,49,41,0,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,40),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,103,114,111,117,112,56,50,48,32,46,32,116,109,112,56,49,57,56,50,49,41};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,56,52,55,41,0,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,12),40,103,101,116,45,103,114,111,117,112,115,41,0,0,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,23),40,100,111,108,111,111,112,56,53,51,32,108,115,116,56,53,53,32,105,56,53,54,41,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,21),40,115,101,116,45,103,114,111,117,112,115,33,32,108,115,116,48,56,53,50,41,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,33),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,117,115,101,114,56,55,50,32,105,100,56,55,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,56,55,55,32,109,56,55,56,41};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,39),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,102,110,56,56,49,32,117,105,100,56,56,50,32,103,105,100,56,56,51,41,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,56,56,56,32,97,99,99,56,56,57,32,108,111,99,56,57,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,56,57,52,41,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,56,57,53,41};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,56,57,54,41,0,0,0,0,0,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,16),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,36),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,57,49,51,32,110,101,119,57,49,52,41,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,41),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,57,50,53,32,46,32,116,109,112,57,50,52,57,50,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,108,105,110,107,32,111,108,100,57,52,54,32,110,101,119,57,52,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,57,53,50,32,109,57,53,51,32,108,111,99,57,53,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,57,54,52,32,102,100,57,54,53,32,105,110,112,57,54,54,32,114,57,54,55,41};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,57,55,48,32,46,32,109,57,55,49,41,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,57,55,51,32,46,32,109,57,55,52,41};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,57,55,57,41,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,57,56,54,32,46,32,110,101,119,57,56,55,41,0,0,0,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,8),40,114,101,97,100,121,63,41};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,7),40,102,101,116,99,104,41,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,7),40,97,53,50,56,52,41,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,7),40,97,53,50,57,55,41,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,7),40,97,53,51,48,57,41,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,7),40,97,53,51,51,48,41,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,28),40,108,111,111,112,32,110,49,48,53,55,32,109,49,48,53,56,32,115,116,97,114,116,49,48,53,57,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,41),40,97,53,51,51,57,32,112,111,114,116,49,48,53,50,32,110,49,48,53,51,32,100,101,115,116,49,48,53,52,32,115,116,97,114,116,49,48,53,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,24),40,98,117,109,112,101,114,32,99,117,114,49,48,55,55,32,112,116,114,49,48,55,56,41};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,7),40,97,53,53,48,49,41,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,42),40,97,53,53,48,55,32,100,101,115,116,49,48,57,55,49,48,57,56,49,49,48,49,32,99,111,110,116,63,49,48,57,57,49,49,48,48,49,49,48,50,41,0,0,0,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,115,116,114,49,48,55,53,41,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,26),40,97,53,52,49,53,32,112,111,114,116,49,48,55,50,32,108,105,109,105,116,49,48,55,51,41,0,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,59),40,98,111,100,121,49,48,48,55,32,110,111,110,98,108,111,99,107,105,110,103,63,49,48,49,55,32,98,117,102,105,49,48,49,56,32,111,110,45,99,108,111,115,101,49,48,49,57,32,109,111,114,101,63,49,48,50,48,41,0,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,69),40,100,101,102,45,109,111,114,101,63,49,48,49,50,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,48,48,51,49,49,49,49,32,37,98,117,102,105,49,48,48,52,49,49,49,50,32,37,111,110,45,99,108,111,115,101,49,48,48,53,49,49,49,51,41,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,54),40,100,101,102,45,111,110,45,99,108,111,115,101,49,48,49,49,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,48,48,51,49,49,49,53,32,37,98,117,102,105,49,48,48,52,49,49,49,54,41,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,36),40,100,101,102,45,98,117,102,105,49,48,49,48,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,48,48,51,49,49,49,56,41,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,110,111,110,98,108,111,99,107,105,110,103,63,49,48,48,57,41,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,60),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,57,57,57,32,110,97,109,49,48,48,48,32,102,100,49,48,48,49,32,46,32,116,109,112,57,57,56,49,48,48,50,41,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,22),40,112,111,107,101,32,115,116,114,49,49,53,53,32,108,101,110,49,49,53,54,41,0,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,15),40,97,53,54,57,56,32,115,116,114,49,49,56,48,41,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,7),40,97,53,55,48,52,41,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,7),40,97,53,55,50,53,41,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,16),40,102,95,53,55,51,52,32,115,116,114,49,49,54,51,41};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,114,101,109,49,49,54,56,32,115,116,97,114,116,49,49,54,57,32,108,101,110,49,49,55,48,41};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,16),40,102,95,53,55,52,57,32,115,116,114,49,49,54,54,41};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,49),40,98,111,100,121,49,49,52,49,32,110,111,110,98,108,111,99,107,105,110,103,63,49,49,53,48,32,98,117,102,105,49,49,53,49,32,111,110,45,99,108,111,115,101,49,49,53,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,54),40,100,101,102,45,111,110,45,99,108,111,115,101,49,49,52,53,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,49,51,56,49,49,56,56,32,37,98,117,102,105,49,49,51,57,49,49,56,57,41,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,36),40,100,101,102,45,98,117,102,105,49,49,52,52,32,37,110,111,110,98,108,111,99,107,105,110,103,63,49,49,51,56,49,49,57,49,41,0,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,110,111,110,98,108,111,99,107,105,110,103,63,49,49,52,51,41,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,49,51,52,32,110,97,109,49,49,51,53,32,102,100,49,49,51,54,32,46,32,116,109,112,49,49,51,51,49,49,51,55,41,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,49,49,57,57,32,111,102,102,49,50,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,33),40,115,101,116,117,112,32,112,111,114,116,49,50,48,55,32,97,114,103,115,49,50,48,56,32,108,111,99,49,50,48,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,30),40,101,114,114,32,109,115,103,49,50,50,51,32,108,111,99,107,49,50,50,52,32,108,111,99,49,50,50,53,41,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,108,111,99,107,32,112,111,114,116,49,50,50,54,32,46,32,97,114,103,115,49,50,50,55,41,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,40),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,49,50,50,57,32,46,32,97,114,103,115,49,50,51,48,41};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,36),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,112,111,114,116,49,50,51,50,32,46,32,97,114,103,115,49,50,51,51,41,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,117,110,108,111,99,107,32,108,111,99,107,49,50,52,56,41,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,49,50,53,49,32,46,32,109,111,100,101,49,50,53,50,41,0,0,0,0,0,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,20),40,102,105,102,111,63,32,102,105,108,101,110,97,109,101,49,50,53,54,41,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,24),40,115,101,116,101,110,118,32,118,97,114,49,50,53,57,32,118,97,108,49,50,54,48,41};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,18),40,117,110,115,101,116,101,110,118,32,118,97,114,49,50,54,52,41,0,0,0,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,12),40,115,99,97,110,32,106,49,50,55,55,41,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,55,52,41,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,49,50,57,56,32,108,101,110,49,50,57,57,32,112,114,111,116,49,51,48,48,32,102,108,97,103,49,51,48,49,32,102,100,49,51,48,50,32,46,32,111,102,102,49,51,48,51,41};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,49,51,49,57,32,46,32,108,101,110,49,51,50,48,41,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,49,51,50,51,41,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,49,51,50,53,41,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,34),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,49,51,50,54,32,116,109,49,51,50,55,41,0,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,35),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,49,51,51,52,49,51,51,53,41,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,49,51,52,53,49,51,52,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,49,51,54,50,49,51,54,51,41,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,35),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,49,51,56,57,32,46,32,116,109,112,49,51,56,56,49,51,57,48,41,0,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,36),40,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,49,52,49,53,32,46,32,116,109,112,49,52,49,52,49,52,49,54,41,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,28),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,49,52,50,50,41,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,26),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,49,52,50,53,41,0,0,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,52,51,54,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,97,108,97,114,109,33,32,97,49,52,51,55,49,52,52,48,41,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,52,52,49,32,109,111,100,101,49,52,52,50,32,46,32,115,105,122,101,49,52,52,51,41,0,0,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,52,53,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,116,101,114,109,105,110,97,108,45,99,104,101,99,107,32,99,97,108,108,101,114,49,52,53,55,32,112,111,114,116,49,52,53,56,41,0,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,112,111,114,116,49,52,54,55,41};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,52,55,56,41};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,116,104,117,110,107,49,52,57,57,41,0,0,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,28),40,115,101,116,97,114,103,32,97,49,53,50,48,49,53,50,54,32,97,49,53,49,57,49,53,50,55,41,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,28),40,115,101,116,101,110,118,32,97,49,53,51,50,49,53,51,56,32,97,49,53,51,49,49,53,51,57,41,0,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,49,53,54,56,32,105,49,53,55,49,41,0,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,49,53,54,52,32,97,108,49,53,54,54,32,105,49,53,54,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,34),40,98,111,100,121,49,53,53,51,32,97,114,103,108,105,115,116,49,53,54,49,32,101,110,118,108,105,115,116,49,53,54,50,41,0,0,0,0,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,34),40,100,101,102,45,101,110,118,108,105,115,116,49,53,53,54,32,37,97,114,103,108,105,115,116,49,53,53,49,49,53,57,49,41,0,0,0,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,17),40,100,101,102,45,97,114,103,108,105,115,116,49,53,53,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,53,52,57,32,46,32,116,109,112,49,53,52,56,49,53,53,48,41,0,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,53,57,55,32,110,111,104,97,110,103,49,53,57,56,41,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,7),40,97,55,50,54,48,41,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,36),40,97,55,50,54,54,32,101,112,105,100,49,54,49,56,32,101,110,111,114,109,49,54,49,57,32,101,99,111,100,101,49,54,50,48,41,0,0,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,25),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,49,54,48,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,19),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,17),40,115,108,101,101,112,32,97,49,54,50,54,49,54,50,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,49,54,51,48,32,46,32,115,105,103,49,54,51,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,54,51,57,41,0,0,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,54,52,48,32,46,32,97,114,103,115,49,54,52,49,41,0,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,7),40,97,55,52,51,54,41,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,29),40,97,55,52,52,50,32,95,49,54,54,51,32,102,108,103,49,54,54,52,32,99,111,100,49,54,54,53,41,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,8),40,102,95,55,52,50,50,41};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,68),40,109,97,107,101,45,111,110,45,99,108,111,115,101,32,108,111,99,49,54,53,54,32,112,105,100,49,54,53,55,32,99,108,115,118,101,99,49,54,53,56,32,105,100,120,49,54,53,57,32,105,100,120,97,49,54,54,48,32,105,100,120,98,49,54,54,49,41,0,0,0,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,7),40,97,55,52,54,53,41,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,19),40,97,55,52,55,49,32,105,49,54,55,48,32,111,49,54,55,49,41,0,0,0,0,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,22),40,110,101,101,100,101,100,45,112,105,112,101,32,112,111,114,116,49,54,54,56,41,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,34),40,99,111,110,110,101,99,116,45,112,97,114,101,110,116,32,112,105,112,101,49,54,55,51,32,112,111,114,116,49,54,55,52,41,0,0,0,0,0,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,43),40,99,111,110,110,101,99,116,45,99,104,105,108,100,32,112,105,112,101,49,54,56,49,32,112,111,114,116,49,54,56,50,32,115,116,100,102,100,49,54,56,51,41,0,0,0,0,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,7),40,97,55,53,52,54,41,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,67),40,115,112,97,119,110,32,99,109,100,49,54,57,52,32,97,114,103,115,49,54,57,53,32,101,110,118,49,54,57,54,32,115,116,100,111,117,116,102,49,54,57,55,32,115,116,100,105,110,102,49,54,57,56,32,115,116,100,101,114,114,102,49,54,57,57,41,0,0,0,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,59),40,105,110,112,117,116,45,112,111,114,116,32,108,111,99,49,55,48,54,32,99,109,100,49,55,48,56,32,112,105,112,101,49,55,48,57,32,115,116,100,102,49,55,49,48,32,111,110,45,99,108,111,115,101,49,55,49,50,41,0,0,0,0,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,60),40,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,55,49,52,32,99,109,100,49,55,49,54,32,112,105,112,101,49,55,49,55,32,115,116,100,102,49,55,49,56,32,111,110,45,99,108,111,115,101,49,55,50,48,41,0,0,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,7),40,97,55,53,57,54,41,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,50),40,97,55,54,48,50,32,105,110,112,105,112,101,49,55,50,57,32,111,117,116,112,105,112,101,49,55,51,48,32,101,114,114,112,105,112,101,49,55,51,49,32,112,105,100,49,55,51,50,41,0,0,0,0,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,83),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,55,50,50,32,99,109,100,49,55,50,51,32,97,114,103,115,49,55,50,52,32,101,110,118,49,55,50,53,32,115,116,100,111,117,116,102,49,55,50,54,32,115,116,100,105,110,102,49,55,50,55,32,115,116,100,101,114,114,102,49,55,50,56,41,0,0,0,0,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,21),40,97,55,54,53,55,32,103,49,55,53,48,49,55,53,49,49,55,53,50,41,0,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,49,55,52,49,41,0,0,0,0,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,7),40,97,55,54,55,53,41,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,38),40,97,55,54,56,49,32,105,110,49,55,53,55,32,111,117,116,49,55,53,56,32,112,105,100,49,55,53,57,32,101,114,114,49,55,54,48,41,0,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,52),40,37,112,114,111,99,101,115,115,32,108,111,99,49,55,51,53,32,101,114,114,63,49,55,51,54,32,99,109,100,49,55,51,55,32,97,114,103,115,49,55,51,56,32,101,110,118,49,55,51,57,41,0,0,0,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,27),40,98,111,100,121,49,55,55,52,32,97,114,103,115,49,55,56,50,32,101,110,118,49,55,56,51,41,0,0,0,0,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,55,55,55,32,37,97,114,103,115,49,55,55,50,49,55,56,53,41,0,0,0,0,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,55,55,54,41,0,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,49,55,55,48,32,46,32,116,109,112,49,55,54,57,49,55,55,49,41,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,27),40,98,111,100,121,49,56,48,49,32,97,114,103,115,49,56,48,57,32,101,110,118,49,56,49,48,41,0,0,0,0,0};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,27),40,100,101,102,45,101,110,118,49,56,48,52,32,37,97,114,103,115,49,55,57,57,49,56,49,50,41,0,0,0,0,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,97,114,103,115,49,56,48,51,41,0,0};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,49,55,57,55,32,46,32,116,109,112,49,55,57,54,49,55,57,56,41};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,29),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,49,56,50,54,41,0,0,0};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,14),40,97,55,56,54,51,32,112,105,100,57,48,51,41,0,0};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,22),40,97,55,56,56,49,32,112,105,100,57,48,56,32,112,103,105,100,57,48,57,41,0,0};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,7),40,97,55,57,48,50,41,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,13),40,97,55,57,48,53,32,105,100,55,57,49,41,0,0,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,7),40,97,55,57,50,48,41,0};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,13),40,97,55,57,50,51,32,105,100,55,56,55,41,0,0,0};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,7),40,97,55,57,51,56,41,0};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,13),40,97,55,57,52,49,32,105,100,55,56,51,41,0,0,0};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,7),40,97,55,57,53,54,41,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,13),40,97,55,57,53,57,32,105,100,55,55,57,41,0,0,0};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,12),40,97,55,57,55,52,32,110,55,55,52,41,0,0,0,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,15),40,97,55,57,56,48,32,112,111,114,116,54,48,53,41,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,12),40,97,56,48,50,49,32,102,49,48,50,41,0,0,0,0};
static C_char C_TLS li262[] C_aligned={C_lihdr(0,0,17),40,97,56,48,50,55,32,102,49,48,52,32,116,49,48,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li263[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k7831 in set-root-directory! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub1821(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1821(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k7318 */
static C_word C_fcall stub1627(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1627(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub1624(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1624(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub1622(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1622(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub1541(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1541(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k7024 */
static C_word C_fcall stub1534(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1534(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub1529(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1529(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k7005 */
static C_word C_fcall stub1522(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1522(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k6981 */
static C_word C_fcall stub1510(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1510(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub1497(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1497(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1491(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1491(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) C_return(NULL);else C_return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k6900 */
static C_word C_fcall stub1473(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1473(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from k6877 */
static C_word C_fcall stub1463(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1463(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k6766 */
static C_word C_fcall stub1438(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1438(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k6744 */
static C_word C_fcall stub1433(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1433(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1428(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1428(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = time(NULL);struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
C_return(z);
C_ret:
#undef return

return C_r;}

/* from strptime */
static C_word C_fcall stub1404(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1404(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=((C_word)C_strptime(t0,t1,t2));
return C_r;}

/* from strftime */
static C_word C_fcall stub1378(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1378(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub1372(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1372(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k6526 */
static C_word C_fcall stub1353(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1353(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k6376 */
static C_word C_fcall stub1313(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1313(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k6314 */
static C_word C_fcall stub1287(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub1287(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k6214 */
static C_word C_fcall stub1269(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1269(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k4960 in k4956 in file-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub938(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub938(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k4663 */
static C_word C_fcall stub866(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub866(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub839(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub839(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) C_return(0);else C_return(1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub835(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub835(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
C_return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub810(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub810(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
C_return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a7902 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub789(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub789(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a7920 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub785(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub785(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a7938 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub781(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub781(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a7956 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub777(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub777(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k3370 */
static C_word C_fcall stub491(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub491(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k3360 */
static C_word C_fcall stub485(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub485(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k3350 */
static C_word C_fcall stub480(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub480(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k3132 */
static C_word C_fcall stub417(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub417(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub410(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub410(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) C_return(-1);else C_return(FD_ISSET(fd, &in) ? 1 : 0);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub406(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub406(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) C_return(0);C_return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from k8036 in k8059 in a8027 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall stub111(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub111(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2081 */
static C_word C_fcall stub64(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub64(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2057)
static void C_ccall f_2057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2060)
static void C_ccall f_2060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2063)
static void C_ccall f_2063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2066)
static void C_ccall f_2066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2069)
static void C_ccall f_2069(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2072)
static void C_ccall f_2072(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8028)
static void C_ccall f_8028(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8061)
static void C_ccall f_8061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8038)
static void C_ccall f_8038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8048)
static void C_fcall f_8048(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8022)
static void C_ccall f_8022(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8026)
static void C_ccall f_8026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2179)
static void C_ccall f_2179(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7981)
static void C_ccall f_7981(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7997)
static void C_ccall f_7997(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7985)
static void C_ccall f_7985(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7988)
static void C_ccall f_7988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3713)
static void C_ccall f_3713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4124)
static void C_ccall f_4124(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7975)
static void C_ccall f_7975(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4281)
static void C_ccall f_4281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7960)
static void C_ccall f_7960(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7970)
static void C_ccall f_7970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7957)
static void C_ccall f_7957(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4323)
static void C_ccall f_4323(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7942)
static void C_ccall f_7942(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7952)
static void C_ccall f_7952(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7939)
static void C_ccall f_7939(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4327)
static void C_ccall f_4327(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7924)
static void C_ccall f_7924(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7934)
static void C_ccall f_7934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7921)
static void C_ccall f_7921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4331)
static void C_ccall f_4331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7906)
static void C_ccall f_7906(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7916)
static void C_ccall f_7916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7903)
static void C_ccall f_7903(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4335)
static void C_ccall f_4335(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7882)
static void C_ccall f_7882(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7898)
static void C_ccall f_7898(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7864)
static void C_ccall f_7864(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7877)
static void C_ccall f_7877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7871)
static void C_ccall f_7871(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4853)
static void C_ccall f_4853(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4892)
static void C_ccall f_4892(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7841)
static void C_ccall f_7841(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7833)
static void C_ccall f_7833(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7851)
static void C_fcall f_7851(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7768)
static void C_ccall f_7768(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7768)
static void C_ccall f_7768r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7780)
static void C_fcall f_7780(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7775)
static void C_fcall f_7775(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7770)
static void C_fcall f_7770(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7708)
static void C_ccall f_7708(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7708)
static void C_ccall f_7708r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7720)
static void C_fcall f_7720(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7715)
static void C_fcall f_7715(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7710)
static void C_fcall f_7710(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7647)
static void C_fcall f_7647(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7702)
static void C_ccall f_7702(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7706)
static void C_ccall f_7706(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7668)
static void C_ccall f_7668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7671)
static void C_ccall f_7671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7682)
static void C_ccall f_7682(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7676)
static void C_ccall f_7676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7649)
static void C_fcall f_7649(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7658)
static void C_ccall f_7658(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7591)
static void C_ccall f_7591(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_7603)
static void C_ccall f_7603(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7634)
static void C_ccall f_7634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7614)
static void C_ccall f_7614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7630)
static void C_ccall f_7630(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7618)
static void C_ccall f_7618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7626)
static void C_ccall f_7626(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7622)
static void C_ccall f_7622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7597)
static void C_ccall f_7597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7580)
static void C_fcall f_7580(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_7584)
static void C_ccall f_7584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7569)
static void C_fcall f_7569(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_7573)
static void C_ccall f_7573(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7524)
static void C_fcall f_7524(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_7528)
static void C_ccall f_7528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7531)
static void C_ccall f_7531(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7534)
static void C_ccall f_7534(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7541)
static void C_fcall f_7541(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7547)
static void C_ccall f_7547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7551)
static void C_ccall f_7551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7554)
static void C_ccall f_7554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7557)
static void C_ccall f_7557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7545)
static void C_ccall f_7545(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7491)
static void C_fcall f_7491(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7504)
static void C_ccall f_7504(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7416)
static void C_ccall f_7416(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7477)
static void C_fcall f_7477(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7490)
static void C_ccall f_7490(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7457)
static void C_fcall f_7457(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7472)
static void C_ccall f_7472(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7466)
static void C_ccall f_7466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7420)
static void C_fcall f_7420(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_7422)
static void C_ccall f_7422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7443)
static void C_ccall f_7443(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7437)
static void C_ccall f_7437(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7364)
static void C_ccall f_7364(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7364)
static void C_ccall f_7364r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7371)
static void C_ccall f_7371(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7390)
static void C_ccall f_7390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7394)
static void C_ccall f_7394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7358)
static void C_ccall f_7358(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7349)
static void C_ccall f_7349(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7353)
static void C_ccall f_7353(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7322)
static void C_ccall f_7322(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7322)
static void C_ccall f_7322r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7315)
static void C_ccall f_7315(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7312)
static void C_ccall f_7312(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7309)
static void C_ccall f_7309(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7231)
static void C_ccall f_7231(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7231)
static void C_ccall f_7231r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7267)
static void C_ccall f_7267(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7261)
static void C_ccall f_7261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7214)
static void C_ccall f_7214(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7032)
static void C_ccall f_7032(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7032)
static void C_ccall f_7032r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7166)
static void C_fcall f_7166(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7161)
static void C_fcall f_7161(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7034)
static void C_fcall f_7034(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7044)
static void C_ccall f_7044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7052)
static void C_fcall f_7052(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7098)
static C_word C_fcall f_7098(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_7065)
static void C_fcall f_7065(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7090)
static void C_ccall f_7090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7068)
static void C_ccall f_7068(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7013)
static C_word C_fcall f_7013(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6994)
static C_word C_fcall f_6994(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6952)
static void C_ccall f_6952(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6952)
static void C_ccall f_6952r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6977)
static void C_ccall f_6977(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6938)
static void C_ccall f_6938(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6942)
static void C_ccall f_6942(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6945)
static void C_ccall f_6945(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6903)
static void C_ccall f_6903(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6907)
static void C_ccall f_6907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6927)
static void C_ccall f_6927(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6931)
static void C_ccall f_6931(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6880)
static void C_ccall f_6880(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6884)
static void C_ccall f_6884(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6848)
static void C_fcall f_6848(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6852)
static void C_ccall f_6852(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6829)
static void C_ccall f_6829(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6833)
static void C_ccall f_6833(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6836)
static void C_ccall f_6836(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6770)
static void C_ccall f_6770(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_6770)
static void C_ccall f_6770r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6774)
static void C_ccall f_6774(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6780)
static void C_ccall f_6780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6789)
static void C_fcall f_6789(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6763)
static void C_ccall f_6763(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6747)
static void C_ccall f_6747(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6747)
static void C_ccall f_6747r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6735)
static void C_ccall f_6735(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6720)
static void C_ccall f_6720(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6724)
static void C_ccall f_6724(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6730)
static void C_ccall f_6730(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6705)
static void C_ccall f_6705(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6709)
static void C_ccall f_6709(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6715)
static void C_ccall f_6715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6659)
static void C_ccall f_6659(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6659)
static void C_ccall f_6659r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6663)
static void C_ccall f_6663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6676)
static void C_ccall f_6676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6680)
static void C_ccall f_6680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6590)
static void C_ccall f_6590(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6590)
static void C_ccall f_6590r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6594)
static void C_ccall f_6594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6597)
static void C_ccall f_6597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6619)
static void C_ccall f_6619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6616)
static void C_ccall f_6616(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6606)
static void C_ccall f_6606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6529)
static void C_ccall f_6529(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6529)
static void C_ccall f_6529r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6533)
static void C_ccall f_6533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6539)
static void C_ccall f_6539(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6485)
static void C_ccall f_6485(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6485)
static void C_ccall f_6485r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6489)
static void C_ccall f_6489(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6451)
static void C_ccall f_6451(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6451)
static void C_ccall f_6451r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6455)
static void C_ccall f_6455(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6432)
static void C_fcall f_6432(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6426)
static void C_ccall f_6426(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6417)
static void C_ccall f_6417(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6382)
static void C_ccall f_6382(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6382)
static void C_ccall f_6382r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6320)
static void C_ccall f_6320(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_6320)
static void C_ccall f_6320r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_6324)
static void C_ccall f_6324(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6330)
static void C_ccall f_6330(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6349)
static void C_ccall f_6349(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6336)
static void C_ccall f_6336(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6217)
static void C_ccall f_6217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6223)
static void C_fcall f_6223(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6227)
static void C_ccall f_6227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6235)
static void C_fcall f_6235(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6261)
static void C_ccall f_6261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6265)
static void C_ccall f_6265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6253)
static void C_ccall f_6253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6197)
static void C_ccall f_6197(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6205)
static void C_ccall f_6205(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6180)
static void C_ccall f_6180(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6191)
static void C_ccall f_6191(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6195)
static void C_ccall f_6195(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6154)
static void C_ccall f_6154(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6178)
static void C_ccall f_6178(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6161)
static void C_ccall f_6161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6111)
static void C_ccall f_6111(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6111)
static void C_ccall f_6111r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6118)
static void C_fcall f_6118(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6139)
static void C_ccall f_6139(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6135)
static void C_ccall f_6135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6083)
static void C_ccall f_6083(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6056)
static void C_ccall f_6056(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6056)
static void C_ccall f_6056r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6060)
static void C_ccall f_6060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6041)
static void C_ccall f_6041(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6041)
static void C_ccall f_6041r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6045)
static void C_ccall f_6045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6026)
static void C_ccall f_6026(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6026)
static void C_ccall f_6026r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6030)
static void C_ccall f_6030(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6008)
static void C_fcall f_6008(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5934)
static void C_fcall f_5934(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5956)
static void C_ccall f_5956(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5962)
static void C_fcall f_5962(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5895)
static void C_ccall f_5895(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5923)
static void C_ccall f_5923(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5919)
static void C_ccall f_5919(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5912)
static void C_ccall f_5912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5905)
static void C_fcall f_5905(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5636)
static void C_ccall f_5636(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_5636)
static void C_ccall f_5636r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_5832)
static void C_fcall f_5832(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5827)
static void C_fcall f_5827(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5822)
static void C_fcall f_5822(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5638)
static void C_fcall f_5638(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5642)
static void C_ccall f_5642(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5748)
static void C_ccall f_5748(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5749)
static void C_ccall f_5749(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5766)
static void C_fcall f_5766(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5776)
static void C_ccall f_5776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5734)
static void C_ccall f_5734(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5690)
static void C_fcall f_5690(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5726)
static void C_ccall f_5726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5705)
static void C_ccall f_5705(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5715)
static void C_ccall f_5715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5699)
static void C_ccall f_5699(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5694)
static void C_ccall f_5694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5697)
static void C_ccall f_5697(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5644)
static void C_fcall f_5644(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5679)
static void C_ccall f_5679(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5660)
static void C_ccall f_5660(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5154)
static void C_ccall f_5154(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_5154)
static void C_ccall f_5154r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_5558)
static void C_fcall f_5558(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5553)
static void C_fcall f_5553(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5548)
static void C_fcall f_5548(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5543)
static void C_fcall f_5543(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5156)
static void C_fcall f_5156(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5160)
static void C_ccall f_5160(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5166)
static void C_ccall f_5166(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5416)
static void C_ccall f_5416(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5422)
static void C_fcall f_5422(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5518)
static void C_ccall f_5518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5508)
static void C_ccall f_5508(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5502)
static void C_ccall f_5502(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5424)
static void C_ccall f_5424(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5474)
static void C_ccall f_5474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5431)
static void C_ccall f_5431(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5441)
static void C_ccall f_5441(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5340)
static void C_ccall f_5340(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5348)
static void C_fcall f_5348(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5350)
static void C_fcall f_5350(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5398)
static void C_ccall f_5398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5331)
static void C_ccall f_5331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5335)
static void C_ccall f_5335(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5310)
static void C_ccall f_5310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5320)
static void C_ccall f_5320(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5298)
static void C_ccall f_5298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5285)
static void C_ccall f_5285(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5289)
static void C_ccall f_5289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5280)
static void C_ccall f_5280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5283)
static void C_ccall f_5283(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5198)
static void C_fcall f_5198(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5210)
static void C_fcall f_5210(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5247)
static void C_ccall f_5247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5256)
static void C_ccall f_5256(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5250)
static void C_ccall f_5250(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5226)
static void C_ccall f_5226(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5229)
static void C_ccall f_5229(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5190)
static C_word C_fcall f_5190(C_word t0);
C_noret_decl(f_5167)
static void C_fcall f_5167(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5171)
static void C_ccall f_5171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5127)
static void C_ccall f_5127(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5127)
static void C_ccall f_5127r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5134)
static void C_fcall f_5134(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5137)
static void C_ccall f_5137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5082)
static void C_ccall f_5082(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5086)
static void C_ccall f_5086(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5121)
static void C_ccall f_5121(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5104)
static void C_ccall f_5104(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5068)
static void C_ccall f_5068(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5068)
static void C_ccall f_5068r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5080)
static void C_ccall f_5080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5054)
static void C_ccall f_5054(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5054)
static void C_ccall f_5054r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5066)
static void C_ccall f_5066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5039)
static void C_fcall f_5039(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5052)
static void C_ccall f_5052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5002)
static void C_fcall f_5002(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5010)
static void C_ccall f_5010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4977)
static void C_ccall f_4977(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4958)
static void C_ccall f_4958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4962)
static void C_ccall f_4962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4990)
static void C_fcall f_4990(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4893)
static void C_ccall f_4893(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4893)
static void C_ccall f_4893r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4897)
static void C_ccall f_4897(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4932)
static void C_ccall f_4932(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4904)
static void C_ccall f_4904(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4907)
static void C_ccall f_4907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4910)
static void C_ccall f_4910(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4916)
static void C_ccall f_4916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4855)
static void C_ccall f_4855(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4888)
static void C_ccall f_4888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4876)
static void C_ccall f_4876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4884)
static void C_ccall f_4884(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4880)
static void C_ccall f_4880(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4836)
static void C_ccall f_4836(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4846)
static void C_ccall f_4846(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4840)
static void C_ccall f_4840(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4830)
static void C_ccall f_4830(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4824)
static void C_ccall f_4824(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4818)
static void C_ccall f_4818(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4794)
static void C_fcall f_4794(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4816)
static void C_ccall f_4816(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4812)
static void C_ccall f_4812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4804)
static void C_ccall f_4804(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4764)
static void C_ccall f_4764(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4792)
static void C_ccall f_4792(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4788)
static void C_ccall f_4788(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4737)
static void C_ccall f_4737(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4762)
static void C_ccall f_4762(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4758)
static void C_ccall f_4758(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4673)
static void C_ccall f_4673(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4661)
static void C_ccall f_4661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4689)
static void C_ccall f_4689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4599)
static void C_ccall f_4599(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4603)
static void C_ccall f_4603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4608)
static void C_fcall f_4608(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4624)
static void C_ccall f_4624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4536)
static void C_ccall f_4536(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4594)
static void C_ccall f_4594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4540)
static void C_ccall f_4540(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4543)
static void C_ccall f_4543(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4575)
static void C_ccall f_4575(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4546)
static void C_ccall f_4546(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4551)
static void C_fcall f_4551(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4565)
static void C_ccall f_4565(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4443)
static void C_ccall f_4443(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4443)
static void C_ccall f_4443r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4447)
static void C_ccall f_4447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4501)
static void C_ccall f_4501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4450)
static void C_fcall f_4450(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4463)
static void C_ccall f_4463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4467)
static void C_ccall f_4467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4473)
static void C_fcall f_4473(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4477)
static void C_ccall f_4477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4487)
static void C_ccall f_4487(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4471)
static void C_ccall f_4471(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4418)
static void C_ccall f_4418(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4430)
static void C_ccall f_4430(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4426)
static void C_ccall f_4426(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4404)
static void C_ccall f_4404(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4416)
static void C_ccall f_4416(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4412)
static void C_ccall f_4412(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4337)
static void C_ccall f_4337(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4337)
static void C_ccall f_4337r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4341)
static void C_ccall f_4341(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4383)
static void C_ccall f_4383(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4344)
static void C_fcall f_4344(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4357)
static void C_ccall f_4357(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4361)
static void C_ccall f_4361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4365)
static void C_ccall f_4365(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4369)
static void C_ccall f_4369(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4373)
static void C_ccall f_4373(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4283)
static void C_ccall f_4283(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4316)
static void C_ccall f_4316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4287)
static void C_ccall f_4287(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4294)
static void C_ccall f_4294(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4298)
static void C_ccall f_4298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4302)
static void C_ccall f_4302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4306)
static void C_ccall f_4306(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4310)
static void C_ccall f_4310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4265)
static void C_ccall f_4265(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4250)
static void C_ccall f_4250(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4244)
static void C_ccall f_4244(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4212)
static void C_ccall f_4212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4218)
static void C_fcall f_4218(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4166)
static void C_ccall f_4166(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4184)
static C_word C_fcall f_4184(C_word t0);
C_noret_decl(f_4148)
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4158)
static void C_ccall f_4158(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4135)
static void C_ccall f_4135(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4126)
static void C_ccall f_4126(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4079)
static void C_ccall f_4079(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4083)
static void C_ccall f_4083(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4059)
static void C_ccall f_4059(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4059)
static void C_ccall f_4059r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4063)
static void C_ccall f_4063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4069)
static void C_ccall f_4069(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4069)
static void C_ccall f_4069r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4073)
static void C_ccall f_4073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4039)
static void C_ccall f_4039(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4039)
static void C_ccall f_4039r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4043)
static void C_ccall f_4043(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4049)
static void C_ccall f_4049(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4049)
static void C_ccall f_4049r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4053)
static void C_ccall f_4053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4015)
static void C_ccall f_4015(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4015)
static void C_ccall f_4015r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4019)
static void C_ccall f_4019(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4030)
static void C_ccall f_4030(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4030)
static void C_ccall f_4030r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4034)
static void C_ccall f_4034(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4024)
static void C_ccall f_4024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3991)
static void C_ccall f_3991(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3991)
static void C_ccall f_3991r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3995)
static void C_ccall f_3995(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4006)
static void C_ccall f_4006(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4006)
static void C_ccall f_4006r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4010)
static void C_ccall f_4010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4000)
static void C_ccall f_4000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3975)
static void C_ccall f_3975(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3979)
static void C_ccall f_3979(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3982)
static void C_ccall f_3982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3939)
static void C_ccall f_3939(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3939)
static void C_ccall f_3939r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3970)
static void C_ccall f_3970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3960)
static void C_ccall f_3960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3953)
static void C_ccall f_3953(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3903)
static void C_ccall f_3903(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3903)
static void C_ccall f_3903r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3934)
static void C_ccall f_3934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3924)
static void C_ccall f_3924(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3917)
static void C_ccall f_3917(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3888)
static void C_fcall f_3888(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3901)
static void C_ccall f_3901(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3848)
static void C_ccall f_3848(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3868)
static void C_ccall f_3868(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3855)
static void C_ccall f_3855(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3858)
static void C_ccall f_3858(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3715)
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3715)
static void C_ccall f_3715r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3719)
static void C_ccall f_3719(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3725)
static void C_ccall f_3725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3734)
static void C_ccall f_3734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3817)
static void C_ccall f_3817(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3794)
static void C_ccall f_3794(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3788)
static void C_ccall f_3788(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3744)
static void C_ccall f_3744(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3746)
static void C_fcall f_3746(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3786)
static void C_ccall f_3786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3753)
static void C_fcall f_3753(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3779)
static void C_ccall f_3779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3756)
static void C_ccall f_3756(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3772)
static void C_ccall f_3772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3728)
static void C_ccall f_3728(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3653)
static void C_ccall f_3653(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3653)
static void C_ccall f_3653r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3666)
static void C_ccall f_3666(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3678)
static void C_ccall f_3678(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3672)
static void C_ccall f_3672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3373)
static void C_ccall f_3373(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3373)
static void C_ccall f_3373r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3612)
static void C_fcall f_3612(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3620)
static C_word C_fcall f_3620(C_word t0,C_word t1);
C_noret_decl(f_3389)
static void C_ccall f_3389(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3564)
static void C_fcall f_3564(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3572)
static C_word C_fcall f_3572(C_word t0,C_word t1);
C_noret_decl(f_3395)
static void C_ccall f_3395(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3398)
static void C_fcall f_3398(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3502)
static void C_fcall f_3502(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3510)
static C_word C_fcall f_3510(C_word *a,C_word t0,C_word t1);
C_noret_decl(f_3500)
static void C_ccall f_3500(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3437)
static void C_fcall f_3437(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3455)
static void C_fcall f_3455(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3463)
static C_word C_fcall f_3463(C_word *a,C_word t0,C_word t1);
C_noret_decl(f_3453)
static void C_ccall f_3453(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3322)
static void C_ccall f_3322(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3328)
static void C_ccall f_3328(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3335)
static void C_ccall f_3335(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3276)
static void C_ccall f_3276(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3276)
static void C_ccall f_3276r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3283)
static void C_ccall f_3283(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3292)
static void C_ccall f_3292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3234)
static void C_ccall f_3234(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3234)
static void C_ccall f_3234r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3244)
static void C_ccall f_3244(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3247)
static void C_ccall f_3247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3250)
static void C_ccall f_3250(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3219)
static void C_ccall f_3219(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3181)
static void C_ccall f_3181(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3181)
static void C_ccall f_3181r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3211)
static void C_ccall f_3211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3198)
static void C_ccall f_3198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3201)
static void C_ccall f_3201(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3135)
static void C_ccall f_3135(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3135)
static void C_ccall f_3135r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3139)
static void C_ccall f_3139(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3078)
static void C_ccall f_3078(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3071)
static void C_ccall f_3071(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2890)
static void C_ccall f_2890(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2890)
static void C_ccall f_2890r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3065)
static void C_ccall f_3065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2900)
static void C_fcall f_2900(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3011)
static void C_ccall f_3011(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3011)
static void C_ccall f_3011r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3055)
static void C_ccall f_3055(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3057)
static void C_ccall f_3057(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3015)
static void C_ccall f_3015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3047)
static void C_ccall f_3047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3049)
static void C_ccall f_3049(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3018)
static void C_ccall f_3018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3044)
static void C_ccall f_3044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3021)
static void C_ccall f_3021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3041)
static void C_ccall f_3041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3024)
static void C_ccall f_3024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3038)
static void C_ccall f_3038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3027)
static void C_ccall f_3027(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3035)
static void C_ccall f_3035(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3030)
static void C_ccall f_3030(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2927)
static void C_fcall f_2927(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2933)
static void C_ccall f_2933(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2916)
static void C_fcall f_2916(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2922)
static void C_ccall f_2922(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2911)
static void C_fcall f_2911(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2906)
static void C_fcall f_2906(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2901)
static void C_fcall f_2901(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_2717)
static void C_fcall f_2717(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_2876)
static void C_ccall f_2876(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2884)
static void C_ccall f_2884(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2724)
static void C_fcall f_2724(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2861)
static void C_ccall f_2861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2864)
static void C_ccall f_2864(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2865)
static void C_ccall f_2865(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2727)
static void C_fcall f_2727(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2851)
static void C_ccall f_2851(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2734)
static void C_ccall f_2734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2736)
static void C_fcall f_2736(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2755)
static void C_ccall f_2755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2837)
static void C_ccall f_2837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2844)
static void C_ccall f_2844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2831)
static void C_ccall f_2831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2770)
static void C_ccall f_2770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2824)
static void C_ccall f_2824(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2821)
static void C_ccall f_2821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2811)
static void C_ccall f_2811(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2787)
static void C_ccall f_2787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2809)
static void C_ccall f_2809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2795)
static void C_ccall f_2795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2802)
static void C_ccall f_2802(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2799)
static void C_ccall f_2799(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2782)
static void C_ccall f_2782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2780)
static void C_ccall f_2780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2605)
static void C_ccall f_2605(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2605)
static void C_ccall f_2605r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2611)
static void C_fcall f_2611(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2632)
static void C_ccall f_2632(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2711)
static void C_ccall f_2711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2636)
static void C_ccall f_2636(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2639)
static void C_ccall f_2639(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2646)
static void C_ccall f_2646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2648)
static void C_fcall f_2648(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2665)
static void C_ccall f_2665(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2669)
static void C_fcall f_2669(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2677)
static void C_ccall f_2677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2681)
static void C_ccall f_2681(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2626)
static void C_ccall f_2626(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2448)
static void C_ccall f_2448(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2448)
static void C_ccall f_2448r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2553)
static void C_fcall f_2553(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2561)
static void C_ccall f_2561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2548)
static void C_fcall f_2548(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2450)
static void C_fcall f_2450(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2457)
static void C_ccall f_2457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2460)
static void C_ccall f_2460(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2463)
static void C_ccall f_2463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2547)
static void C_ccall f_2547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2467)
static void C_ccall f_2467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2481)
static void C_fcall f_2481(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2491)
static void C_ccall f_2491(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2503)
static void C_fcall f_2503(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2513)
static void C_ccall f_2513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2426)
static void C_ccall f_2426(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2446)
static void C_ccall f_2446(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2433)
static void C_ccall f_2433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2436)
static void C_ccall f_2436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2380)
static void C_ccall f_2380(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2380)
static void C_ccall f_2380r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2384)
static void C_ccall f_2384(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2393)
static void C_ccall f_2393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2396)
static void C_ccall f_2396(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2370)
static void C_ccall f_2370(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2378)
static void C_ccall f_2378(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2360)
static void C_ccall f_2360(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2368)
static void C_ccall f_2368(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2350)
static void C_ccall f_2350(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2358)
static void C_ccall f_2358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2340)
static void C_ccall f_2340(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2348)
static void C_ccall f_2348(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2330)
static void C_ccall f_2330(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2338)
static void C_ccall f_2338(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2320)
static void C_ccall f_2320(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2328)
static void C_ccall f_2328(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2310)
static void C_ccall f_2310(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2318)
static void C_ccall f_2318(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2211)
static void C_ccall f_2211(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2211)
static void C_ccall f_2211r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2262)
static void C_fcall f_2262(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2257)
static void C_fcall f_2257(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2213)
static void C_fcall f_2213(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2220)
static void C_ccall f_2220(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2205)
static void C_ccall f_2205(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2209)
static void C_ccall f_2209(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2199)
static void C_ccall f_2199(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2203)
static void C_ccall f_2203(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2193)
static void C_ccall f_2193(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2197)
static void C_ccall f_2197(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2187)
static void C_ccall f_2187(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2191)
static void C_ccall f_2191(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2181)
static void C_ccall f_2181(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2185)
static void C_ccall f_2185(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2146)
static void C_ccall f_2146(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2146)
static void C_ccall f_2146r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2150)
static void C_ccall f_2150(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2153)
static void C_ccall f_2153(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2102)
static void C_fcall f_2102(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2141)
static void C_ccall f_2141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2137)
static void C_ccall f_2137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2130)
static void C_ccall f_2130(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2106)
static void C_ccall f_2106(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2084)
static void C_ccall f_2084(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_2084)
static void C_ccall f_2084r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_2088)
static void C_ccall f_2088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2099)
static void C_ccall f_2099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2095)
static void C_ccall f_2095(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_8048)
static void C_fcall trf_8048(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8048(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8048(t0,t1);}

C_noret_decl(trf_7851)
static void C_fcall trf_7851(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7851(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7851(t0,t1);}

C_noret_decl(trf_7780)
static void C_fcall trf_7780(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7780(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7780(t0,t1);}

C_noret_decl(trf_7775)
static void C_fcall trf_7775(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7775(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7775(t0,t1,t2);}

C_noret_decl(trf_7770)
static void C_fcall trf_7770(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7770(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7770(t0,t1,t2,t3);}

C_noret_decl(trf_7720)
static void C_fcall trf_7720(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7720(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7720(t0,t1);}

C_noret_decl(trf_7715)
static void C_fcall trf_7715(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7715(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7715(t0,t1,t2);}

C_noret_decl(trf_7710)
static void C_fcall trf_7710(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7710(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7710(t0,t1,t2,t3);}

C_noret_decl(trf_7647)
static void C_fcall trf_7647(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7647(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_7647(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_7649)
static void C_fcall trf_7649(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7649(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7649(t0,t1,t2);}

C_noret_decl(trf_7580)
static void C_fcall trf_7580(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7580(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_7580(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_7569)
static void C_fcall trf_7569(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7569(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_7569(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_7524)
static void C_fcall trf_7524(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7524(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_7524(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_7541)
static void C_fcall trf_7541(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7541(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7541(t0,t1);}

C_noret_decl(trf_7491)
static void C_fcall trf_7491(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7491(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7491(t0,t1,t2,t3);}

C_noret_decl(trf_7477)
static void C_fcall trf_7477(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7477(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7477(t0,t1,t2);}

C_noret_decl(trf_7457)
static void C_fcall trf_7457(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7457(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7457(t0,t1);}

C_noret_decl(trf_7420)
static void C_fcall trf_7420(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7420(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_7420(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_7166)
static void C_fcall trf_7166(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7166(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7166(t0,t1);}

C_noret_decl(trf_7161)
static void C_fcall trf_7161(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7161(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7161(t0,t1,t2);}

C_noret_decl(trf_7034)
static void C_fcall trf_7034(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7034(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7034(t0,t1,t2,t3);}

C_noret_decl(trf_7052)
static void C_fcall trf_7052(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7052(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7052(t0,t1,t2,t3);}

C_noret_decl(trf_7065)
static void C_fcall trf_7065(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7065(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7065(t0,t1);}

C_noret_decl(trf_6848)
static void C_fcall trf_6848(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6848(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6848(t0,t1,t2);}

C_noret_decl(trf_6789)
static void C_fcall trf_6789(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6789(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6789(t0,t1);}

C_noret_decl(trf_6432)
static void C_fcall trf_6432(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6432(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6432(t0,t1,t2);}

C_noret_decl(trf_6223)
static void C_fcall trf_6223(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6223(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6223(t0,t1,t2);}

C_noret_decl(trf_6235)
static void C_fcall trf_6235(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6235(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6235(t0,t1,t2);}

C_noret_decl(trf_6118)
static void C_fcall trf_6118(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6118(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6118(t0,t1);}

C_noret_decl(trf_6008)
static void C_fcall trf_6008(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6008(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6008(t0,t1,t2,t3);}

C_noret_decl(trf_5934)
static void C_fcall trf_5934(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5934(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5934(t0,t1,t2,t3);}

C_noret_decl(trf_5962)
static void C_fcall trf_5962(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5962(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5962(t0,t1);}

C_noret_decl(trf_5905)
static void C_fcall trf_5905(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5905(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5905(t0,t1);}

C_noret_decl(trf_5832)
static void C_fcall trf_5832(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5832(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5832(t0,t1);}

C_noret_decl(trf_5827)
static void C_fcall trf_5827(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5827(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5827(t0,t1,t2);}

C_noret_decl(trf_5822)
static void C_fcall trf_5822(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5822(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5822(t0,t1,t2,t3);}

C_noret_decl(trf_5638)
static void C_fcall trf_5638(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5638(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5638(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5766)
static void C_fcall trf_5766(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5766(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5766(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5690)
static void C_fcall trf_5690(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5690(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5690(t0,t1);}

C_noret_decl(trf_5644)
static void C_fcall trf_5644(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5644(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5644(t0,t1,t2,t3);}

C_noret_decl(trf_5558)
static void C_fcall trf_5558(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5558(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5558(t0,t1);}

C_noret_decl(trf_5553)
static void C_fcall trf_5553(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5553(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5553(t0,t1,t2);}

C_noret_decl(trf_5548)
static void C_fcall trf_5548(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5548(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5548(t0,t1,t2,t3);}

C_noret_decl(trf_5543)
static void C_fcall trf_5543(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5543(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5543(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5156)
static void C_fcall trf_5156(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5156(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_5156(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_5422)
static void C_fcall trf_5422(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5422(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5422(t0,t1,t2);}

C_noret_decl(trf_5348)
static void C_fcall trf_5348(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5348(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5348(t0,t1);}

C_noret_decl(trf_5350)
static void C_fcall trf_5350(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5350(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5350(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5198)
static void C_fcall trf_5198(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5198(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5198(t0,t1);}

C_noret_decl(trf_5210)
static void C_fcall trf_5210(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5210(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5210(t0,t1);}

C_noret_decl(trf_5167)
static void C_fcall trf_5167(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5167(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5167(t0,t1);}

C_noret_decl(trf_5134)
static void C_fcall trf_5134(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5134(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5134(t0,t1);}

C_noret_decl(trf_5039)
static void C_fcall trf_5039(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5039(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5039(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5002)
static void C_fcall trf_5002(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5002(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5002(t0,t1,t2,t3);}

C_noret_decl(trf_4990)
static void C_fcall trf_4990(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4990(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4990(t0,t1);}

C_noret_decl(trf_4794)
static void C_fcall trf_4794(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4794(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4794(t0,t1,t2,t3);}

C_noret_decl(trf_4608)
static void C_fcall trf_4608(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4608(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4608(t0,t1,t2,t3);}

C_noret_decl(trf_4551)
static void C_fcall trf_4551(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4551(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4551(t0,t1,t2);}

C_noret_decl(trf_4450)
static void C_fcall trf_4450(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4450(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4450(t0,t1);}

C_noret_decl(trf_4473)
static void C_fcall trf_4473(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4473(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4473(t0,t1,t2);}

C_noret_decl(trf_4344)
static void C_fcall trf_4344(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4344(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4344(t0,t1);}

C_noret_decl(trf_4218)
static void C_fcall trf_4218(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4218(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4218(t0,t1,t2,t3);}

C_noret_decl(trf_3888)
static void C_fcall trf_3888(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3888(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3888(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3746)
static void C_fcall trf_3746(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3746(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3746(t0,t1,t2);}

C_noret_decl(trf_3753)
static void C_fcall trf_3753(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3753(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3753(t0,t1);}

C_noret_decl(trf_3612)
static void C_fcall trf_3612(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3612(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3612(t0,t1,t2);}

C_noret_decl(trf_3564)
static void C_fcall trf_3564(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3564(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3564(t0,t1,t2);}

C_noret_decl(trf_3398)
static void C_fcall trf_3398(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3398(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3398(t0,t1);}

C_noret_decl(trf_3502)
static void C_fcall trf_3502(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3502(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3502(t0,t1,t2);}

C_noret_decl(trf_3437)
static void C_fcall trf_3437(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3437(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3437(t0,t1);}

C_noret_decl(trf_3455)
static void C_fcall trf_3455(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3455(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3455(t0,t1,t2);}

C_noret_decl(trf_2900)
static void C_fcall trf_2900(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2900(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2900(t0,t1);}

C_noret_decl(trf_2927)
static void C_fcall trf_2927(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2927(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2927(t0,t1);}

C_noret_decl(trf_2916)
static void C_fcall trf_2916(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2916(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2916(t0,t1,t2);}

C_noret_decl(trf_2911)
static void C_fcall trf_2911(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2911(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2911(t0,t1,t2,t3);}

C_noret_decl(trf_2906)
static void C_fcall trf_2906(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2906(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2906(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2901)
static void C_fcall trf_2901(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2901(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_2901(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_2717)
static void C_fcall trf_2717(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2717(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_2717(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_2724)
static void C_fcall trf_2724(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2724(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2724(t0,t1);}

C_noret_decl(trf_2727)
static void C_fcall trf_2727(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2727(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2727(t0,t1);}

C_noret_decl(trf_2736)
static void C_fcall trf_2736(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2736(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2736(t0,t1,t2,t3);}

C_noret_decl(trf_2611)
static void C_fcall trf_2611(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2611(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2611(t0,t1,t2);}

C_noret_decl(trf_2648)
static void C_fcall trf_2648(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2648(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2648(t0,t1,t2);}

C_noret_decl(trf_2669)
static void C_fcall trf_2669(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2669(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2669(t0,t1,t2);}

C_noret_decl(trf_2553)
static void C_fcall trf_2553(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2553(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2553(t0,t1);}

C_noret_decl(trf_2548)
static void C_fcall trf_2548(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2548(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2548(t0,t1,t2);}

C_noret_decl(trf_2450)
static void C_fcall trf_2450(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2450(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2450(t0,t1,t2,t3);}

C_noret_decl(trf_2481)
static void C_fcall trf_2481(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2481(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2481(t0,t1);}

C_noret_decl(trf_2503)
static void C_fcall trf_2503(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2503(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2503(t0,t1);}

C_noret_decl(trf_2262)
static void C_fcall trf_2262(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2262(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2262(t0,t1);}

C_noret_decl(trf_2257)
static void C_fcall trf_2257(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2257(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2257(t0,t1,t2);}

C_noret_decl(trf_2213)
static void C_fcall trf_2213(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2213(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2213(t0,t1,t2,t3);}

C_noret_decl(trf_2102)
static void C_fcall trf_2102(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2102(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2102(t0,t1,t2,t3,t4);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr7r)
static void C_fcall tr7r(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7r(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n*3);
t7=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3358)){
C_save(t1);
C_rereclaim2(3358*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,457);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[10]=C_h_intern(&lf[10],11,"\000file-error");
lf[11]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[12]=C_h_intern(&lf[12],17,"\003sysmake-c-string");
lf[13]=C_h_intern(&lf[13],27,"\003sysplatform-fixup-pathname");
lf[14]=C_h_intern(&lf[14],20,"\003sysexpand-home-path");
lf[15]=C_h_intern(&lf[15],11,"\000type-error");
lf[16]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[17]=C_h_intern(&lf[17],9,"file-stat");
lf[18]=C_h_intern(&lf[18],16,"_stat_st_blksize");
lf[19]=C_h_intern(&lf[19],15,"_stat_st_blocks");
lf[20]=C_h_intern(&lf[20],9,"\003syserror");
lf[21]=C_h_intern(&lf[21],22,"file-modification-time");
lf[22]=C_h_intern(&lf[22],16,"file-access-time");
lf[23]=C_h_intern(&lf[23],16,"file-change-time");
lf[24]=C_h_intern(&lf[24],10,"file-owner");
lf[25]=C_h_intern(&lf[25],16,"file-permissions");
lf[26]=C_h_intern(&lf[26],9,"file-size");
lf[27]=C_h_intern(&lf[27],9,"file-type");
lf[28]=C_h_intern(&lf[28],13,"symbolic-link");
lf[29]=C_h_intern(&lf[29],9,"directory");
lf[30]=C_h_intern(&lf[30],16,"character-device");
lf[31]=C_h_intern(&lf[31],12,"block-device");
lf[32]=C_h_intern(&lf[32],4,"fifo");
lf[33]=C_h_intern(&lf[33],6,"socket");
lf[34]=C_h_intern(&lf[34],12,"regular-file");
lf[35]=C_h_intern(&lf[35],13,"regular-file\077");
lf[36]=C_h_intern(&lf[36],14,"symbolic-link\077");
lf[37]=C_h_intern(&lf[37],13,"block-device\077");
lf[38]=C_h_intern(&lf[38],17,"character-device\077");
lf[39]=C_h_intern(&lf[39],5,"fifo\077");
lf[40]=C_h_intern(&lf[40],7,"socket\077");
lf[41]=C_h_intern(&lf[41],10,"directory\077");
lf[42]=C_h_intern(&lf[42],11,"make-string");
lf[43]=C_h_intern(&lf[43],17,"current-directory");
lf[44]=C_h_intern(&lf[44],16,"change-directory");
lf[45]=C_h_intern(&lf[45],13,"\003syssubstring");
lf[46]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[47]=C_h_intern(&lf[47],16,"delete-directory");
lf[48]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[50]=C_h_intern(&lf[50],16,"\003sysmake-pointer");
lf[51]=C_h_intern(&lf[51],4,"glob");
lf[52]=C_h_intern(&lf[52],18,"decompose-pathname");
lf[53]=C_h_intern(&lf[53],13,"make-pathname");
lf[54]=C_h_intern(&lf[54],12,"string-match");
lf[55]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[56]=C_h_intern(&lf[56],6,"regexp");
lf[57]=C_h_intern(&lf[57],12,"glob->regexp");
lf[58]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[62]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[63]=C_h_intern(&lf[63],16,"\003sysdynamic-wind");
lf[64]=C_h_intern(&lf[64],13,"pathname-file");
lf[65]=C_decode_literal(C_heaptop,"\376B\000\000\002\077*");
lf[66]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[67]=C_h_intern(&lf[67],7,"regexp\077");
lf[68]=C_h_intern(&lf[68],10,"find-files");
lf[69]=C_h_intern(&lf[69],15,"\003sysget-keyword");
lf[70]=C_h_intern(&lf[70],16,"\000follow-symlinks");
lf[71]=C_h_intern(&lf[71],9,"\000dotfiles");
lf[72]=C_h_intern(&lf[72],6,"\000limit");
lf[73]=C_h_intern(&lf[73],5,"\000seed");
lf[74]=C_h_intern(&lf[74],7,"\000action");
lf[75]=C_h_intern(&lf[75],5,"\000test");
lf[76]=C_h_intern(&lf[76],8,"keyword\077");
lf[77]=C_h_intern(&lf[77],21,"\003sysfile-nonblocking!");
lf[78]=C_h_intern(&lf[78],19,"\003sysfile-select-one");
lf[79]=C_h_intern(&lf[79],8,"pipe/buf");
lf[80]=C_h_intern(&lf[80],11,"fcntl/dupfd");
lf[81]=C_h_intern(&lf[81],11,"fcntl/getfd");
lf[82]=C_h_intern(&lf[82],11,"fcntl/setfd");
lf[83]=C_h_intern(&lf[83],11,"fcntl/getfl");
lf[84]=C_h_intern(&lf[84],11,"fcntl/setfl");
lf[85]=C_h_intern(&lf[85],11,"open/rdonly");
lf[86]=C_h_intern(&lf[86],11,"open/wronly");
lf[87]=C_h_intern(&lf[87],9,"open/rdwr");
lf[88]=C_h_intern(&lf[88],9,"open/read");
lf[89]=C_h_intern(&lf[89],10,"open/write");
lf[90]=C_h_intern(&lf[90],10,"open/creat");
lf[91]=C_h_intern(&lf[91],11,"open/append");
lf[92]=C_h_intern(&lf[92],9,"open/excl");
lf[93]=C_h_intern(&lf[93],11,"open/noctty");
lf[94]=C_h_intern(&lf[94],13,"open/nonblock");
lf[95]=C_h_intern(&lf[95],10,"open/trunc");
lf[96]=C_h_intern(&lf[96],9,"open/sync");
lf[97]=C_h_intern(&lf[97],10,"open/fsync");
lf[98]=C_h_intern(&lf[98],11,"open/binary");
lf[99]=C_h_intern(&lf[99],9,"open/text");
lf[100]=C_h_intern(&lf[100],10,"perm/irusr");
lf[101]=C_h_intern(&lf[101],10,"perm/iwusr");
lf[102]=C_h_intern(&lf[102],10,"perm/ixusr");
lf[103]=C_h_intern(&lf[103],10,"perm/irgrp");
lf[104]=C_h_intern(&lf[104],10,"perm/iwgrp");
lf[105]=C_h_intern(&lf[105],10,"perm/ixgrp");
lf[106]=C_h_intern(&lf[106],10,"perm/iroth");
lf[107]=C_h_intern(&lf[107],10,"perm/iwoth");
lf[108]=C_h_intern(&lf[108],10,"perm/ixoth");
lf[109]=C_h_intern(&lf[109],10,"perm/irwxu");
lf[110]=C_h_intern(&lf[110],10,"perm/irwxg");
lf[111]=C_h_intern(&lf[111],10,"perm/irwxo");
lf[112]=C_h_intern(&lf[112],10,"perm/isvtx");
lf[113]=C_h_intern(&lf[113],10,"perm/isuid");
lf[114]=C_h_intern(&lf[114],10,"perm/isgid");
lf[115]=C_h_intern(&lf[115],12,"file-control");
lf[116]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[117]=C_h_intern(&lf[117],9,"file-open");
lf[118]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[119]=C_h_intern(&lf[119],10,"file-close");
lf[120]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[121]=C_h_intern(&lf[121],9,"file-read");
lf[122]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[124]=C_h_intern(&lf[124],10,"file-write");
lf[125]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[127]=C_h_intern(&lf[127],12,"file-mkstemp");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[129]=C_h_intern(&lf[129],11,"file-select");
lf[130]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[131]=C_h_intern(&lf[131],8,"seek/set");
lf[132]=C_h_intern(&lf[132],8,"seek/end");
lf[133]=C_h_intern(&lf[133],8,"seek/cur");
lf[134]=C_h_intern(&lf[134],18,"set-file-position!");
lf[135]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[136]=C_h_intern(&lf[136],6,"stream");
lf[137]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[138]=C_h_intern(&lf[138],5,"port\077");
lf[139]=C_h_intern(&lf[139],13,"\000bounds-error");
lf[140]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[141]=C_h_intern(&lf[141],13,"file-position");
lf[142]=C_h_intern(&lf[142],16,"create-directory");
lf[143]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[144]=C_h_intern(&lf[144],18,"pathname-directory");
lf[145]=C_h_intern(&lf[145],12,"file-exists\077");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[147]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[148]=C_h_intern(&lf[148],13,"\003sysmake-port");
lf[149]=C_h_intern(&lf[149],21,"\003sysstream-port-class");
lf[150]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[151]=C_h_intern(&lf[151],15,"open-input-pipe");
lf[152]=C_h_intern(&lf[152],5,"\000text");
lf[153]=C_h_intern(&lf[153],7,"\000binary");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[155]=C_h_intern(&lf[155],16,"open-output-pipe");
lf[156]=C_h_intern(&lf[156],16,"close-input-pipe");
lf[157]=C_h_intern(&lf[157],23,"close-input/output-pipe");
lf[158]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[159]=C_h_intern(&lf[159],14,"\003syscheck-port");
lf[160]=C_h_intern(&lf[160],17,"close-output-pipe");
lf[161]=C_h_intern(&lf[161],20,"call-with-input-pipe");
lf[162]=C_h_intern(&lf[162],21,"call-with-output-pipe");
lf[163]=C_h_intern(&lf[163],20,"with-input-from-pipe");
lf[164]=C_h_intern(&lf[164],18,"\003sysstandard-input");
lf[165]=C_h_intern(&lf[165],19,"with-output-to-pipe");
lf[166]=C_h_intern(&lf[166],19,"\003sysstandard-output");
lf[167]=C_h_intern(&lf[167],11,"create-pipe");
lf[168]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[169]=C_h_intern(&lf[169],11,"signal/term");
lf[170]=C_h_intern(&lf[170],11,"signal/kill");
lf[171]=C_h_intern(&lf[171],10,"signal/int");
lf[172]=C_h_intern(&lf[172],10,"signal/hup");
lf[173]=C_h_intern(&lf[173],10,"signal/fpe");
lf[174]=C_h_intern(&lf[174],10,"signal/ill");
lf[175]=C_h_intern(&lf[175],11,"signal/segv");
lf[176]=C_h_intern(&lf[176],11,"signal/abrt");
lf[177]=C_h_intern(&lf[177],11,"signal/trap");
lf[178]=C_h_intern(&lf[178],11,"signal/quit");
lf[179]=C_h_intern(&lf[179],11,"signal/alrm");
lf[180]=C_h_intern(&lf[180],13,"signal/vtalrm");
lf[181]=C_h_intern(&lf[181],11,"signal/prof");
lf[182]=C_h_intern(&lf[182],9,"signal/io");
lf[183]=C_h_intern(&lf[183],10,"signal/urg");
lf[184]=C_h_intern(&lf[184],11,"signal/chld");
lf[185]=C_h_intern(&lf[185],11,"signal/cont");
lf[186]=C_h_intern(&lf[186],11,"signal/stop");
lf[187]=C_h_intern(&lf[187],11,"signal/tstp");
lf[188]=C_h_intern(&lf[188],11,"signal/pipe");
lf[189]=C_h_intern(&lf[189],11,"signal/xcpu");
lf[190]=C_h_intern(&lf[190],11,"signal/xfsz");
lf[191]=C_h_intern(&lf[191],11,"signal/usr1");
lf[192]=C_h_intern(&lf[192],11,"signal/usr2");
lf[193]=C_h_intern(&lf[193],12,"signal/winch");
lf[194]=C_h_intern(&lf[194],12,"signals-list");
lf[195]=C_h_intern(&lf[195],18,"\003sysinterrupt-hook");
lf[196]=C_h_intern(&lf[196],14,"signal-handler");
lf[197]=C_h_intern(&lf[197],19,"set-signal-handler!");
lf[198]=C_h_intern(&lf[198],16,"set-signal-mask!");
lf[199]=C_h_intern(&lf[199],14,"\000process-error");
lf[200]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[201]=C_h_intern(&lf[201],11,"signal-mask");
lf[202]=C_h_intern(&lf[202],14,"signal-masked\077");
lf[203]=C_h_intern(&lf[203],12,"signal-mask!");
lf[204]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[205]=C_h_intern(&lf[205],14,"signal-unmask!");
lf[206]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[207]=C_h_intern(&lf[207],18,"system-information");
lf[208]=C_h_intern(&lf[208],25,"\003syspeek-nonnull-c-string");
lf[209]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[210]=C_h_intern(&lf[210],15,"current-user-id");
lf[211]=C_h_intern(&lf[211],25,"current-effective-user-id");
lf[212]=C_h_intern(&lf[212],16,"current-group-id");
lf[213]=C_h_intern(&lf[213],26,"current-effective-group-id");
lf[214]=C_h_intern(&lf[214],16,"user-information");
lf[215]=C_h_intern(&lf[215],6,"vector");
lf[216]=C_h_intern(&lf[216],4,"list");
lf[217]=C_h_intern(&lf[217],17,"current-user-name");
lf[218]=C_h_intern(&lf[218],27,"current-effective-user-name");
lf[219]=C_h_intern(&lf[219],17,"group-information");
lf[220]=C_h_intern(&lf[220],10,"get-groups");
lf[221]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[222]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[223]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[224]=C_h_intern(&lf[224],11,"set-groups!");
lf[225]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[226]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[227]=C_h_intern(&lf[227],17,"initialize-groups");
lf[228]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[229]=C_h_intern(&lf[229],10,"errno/perm");
lf[230]=C_h_intern(&lf[230],11,"errno/noent");
lf[231]=C_h_intern(&lf[231],10,"errno/srch");
lf[232]=C_h_intern(&lf[232],10,"errno/intr");
lf[233]=C_h_intern(&lf[233],8,"errno/io");
lf[234]=C_h_intern(&lf[234],12,"errno/noexec");
lf[235]=C_h_intern(&lf[235],10,"errno/badf");
lf[236]=C_h_intern(&lf[236],11,"errno/child");
lf[237]=C_h_intern(&lf[237],11,"errno/nomem");
lf[238]=C_h_intern(&lf[238],11,"errno/acces");
lf[239]=C_h_intern(&lf[239],11,"errno/fault");
lf[240]=C_h_intern(&lf[240],10,"errno/busy");
lf[241]=C_h_intern(&lf[241],12,"errno/notdir");
lf[242]=C_h_intern(&lf[242],11,"errno/isdir");
lf[243]=C_h_intern(&lf[243],11,"errno/inval");
lf[244]=C_h_intern(&lf[244],11,"errno/mfile");
lf[245]=C_h_intern(&lf[245],11,"errno/nospc");
lf[246]=C_h_intern(&lf[246],11,"errno/spipe");
lf[247]=C_h_intern(&lf[247],10,"errno/pipe");
lf[248]=C_h_intern(&lf[248],11,"errno/again");
lf[249]=C_h_intern(&lf[249],10,"errno/rofs");
lf[250]=C_h_intern(&lf[250],11,"errno/exist");
lf[251]=C_h_intern(&lf[251],16,"errno/wouldblock");
lf[252]=C_h_intern(&lf[252],10,"errno/2big");
lf[253]=C_h_intern(&lf[253],12,"errno/deadlk");
lf[254]=C_h_intern(&lf[254],9,"errno/dom");
lf[255]=C_h_intern(&lf[255],10,"errno/fbig");
lf[256]=C_h_intern(&lf[256],11,"errno/ilseq");
lf[257]=C_h_intern(&lf[257],11,"errno/mlink");
lf[258]=C_h_intern(&lf[258],17,"errno/nametoolong");
lf[259]=C_h_intern(&lf[259],11,"errno/nfile");
lf[260]=C_h_intern(&lf[260],11,"errno/nodev");
lf[261]=C_h_intern(&lf[261],11,"errno/nolck");
lf[262]=C_h_intern(&lf[262],11,"errno/nosys");
lf[263]=C_h_intern(&lf[263],14,"errno/notempty");
lf[264]=C_h_intern(&lf[264],11,"errno/notty");
lf[265]=C_h_intern(&lf[265],10,"errno/nxio");
lf[266]=C_h_intern(&lf[266],11,"errno/range");
lf[267]=C_h_intern(&lf[267],10,"errno/xdev");
lf[268]=C_h_intern(&lf[268],16,"change-file-mode");
lf[269]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[270]=C_h_intern(&lf[270],17,"change-file-owner");
lf[271]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[272]=C_h_intern(&lf[272],17,"file-read-access\077");
lf[273]=C_h_intern(&lf[273],18,"file-write-access\077");
lf[274]=C_h_intern(&lf[274],20,"file-execute-access\077");
lf[275]=C_h_intern(&lf[275],14,"create-session");
lf[276]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[277]=C_h_intern(&lf[277],16,"process-group-id");
lf[278]=C_h_intern(&lf[278],20,"create-symbolic-link");
lf[279]=C_h_intern(&lf[279],18,"create-symbol-link");
lf[280]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[281]=C_h_intern(&lf[281],9,"substring");
lf[282]=C_h_intern(&lf[282],18,"read-symbolic-link");
lf[283]=C_h_intern(&lf[283],12,"canonicalize");
lf[284]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[285]=C_h_intern(&lf[285],9,"file-link");
lf[286]=C_h_intern(&lf[286],9,"hard-link");
lf[287]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[288]=C_h_intern(&lf[288],12,"fileno/stdin");
lf[289]=C_h_intern(&lf[289],13,"fileno/stdout");
lf[290]=C_h_intern(&lf[290],13,"fileno/stderr");
lf[291]=C_h_intern(&lf[291],7,"\000append");
lf[292]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[293]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[294]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[296]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[297]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[298]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[299]=C_h_intern(&lf[299],16,"open-input-file*");
lf[300]=C_h_intern(&lf[300],17,"open-output-file*");
lf[301]=C_h_intern(&lf[301],12,"port->fileno");
lf[302]=C_h_intern(&lf[302],20,"\003systcp-port->fileno");
lf[303]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[305]=C_h_intern(&lf[305],25,"\003syspeek-unsigned-integer");
lf[306]=C_h_intern(&lf[306],16,"duplicate-fileno");
lf[307]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[308]=C_h_intern(&lf[308],21,"\003syscustom-input-port");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[310]=C_h_intern(&lf[310],17,"\003systhread-yield!");
lf[311]=C_h_intern(&lf[311],25,"\003systhread-block-for-i/o!");
lf[312]=C_h_intern(&lf[312],18,"\003syscurrent-thread");
lf[313]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[314]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[315]=C_h_intern(&lf[315],14,"set-port-name!");
lf[316]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[317]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[318]=C_h_intern(&lf[318],17,"\003sysstring-append");
lf[319]=C_h_intern(&lf[319],15,"\003sysmake-string");
lf[320]=C_h_intern(&lf[320],20,"\003sysscan-buffer-line");
lf[321]=C_h_intern(&lf[321],15,"make-input-port");
lf[322]=C_h_intern(&lf[322],4,"void");
lf[323]=C_h_intern(&lf[323],22,"\003syscustom-output-port");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[326]=C_h_intern(&lf[326],16,"make-output-port");
lf[327]=C_h_intern(&lf[327],13,"file-truncate");
lf[328]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[329]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[330]=C_h_intern(&lf[330],4,"lock");
lf[331]=C_h_intern(&lf[331],9,"file-lock");
lf[332]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[333]=C_h_intern(&lf[333],18,"file-lock/blocking");
lf[334]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[335]=C_h_intern(&lf[335],14,"file-test-lock");
lf[336]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[337]=C_h_intern(&lf[337],11,"file-unlock");
lf[338]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[339]=C_h_intern(&lf[339],11,"create-fifo");
lf[340]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[342]=C_h_intern(&lf[342],13,"\003sysfile-info");
lf[343]=C_h_intern(&lf[343],6,"setenv");
lf[344]=C_h_intern(&lf[344],8,"unsetenv");
lf[345]=C_h_intern(&lf[345],25,"get-environment-variables");
lf[346]=C_h_intern(&lf[346],9,"prot/read");
lf[347]=C_h_intern(&lf[347],10,"prot/write");
lf[348]=C_h_intern(&lf[348],9,"prot/exec");
lf[349]=C_h_intern(&lf[349],9,"prot/none");
lf[350]=C_h_intern(&lf[350],9,"map/fixed");
lf[351]=C_h_intern(&lf[351],10,"map/shared");
lf[352]=C_h_intern(&lf[352],11,"map/private");
lf[353]=C_h_intern(&lf[353],13,"map/anonymous");
lf[354]=C_h_intern(&lf[354],8,"map/file");
lf[355]=C_h_intern(&lf[355],18,"map-file-to-memory");
lf[356]=C_h_intern(&lf[356],4,"mmap");
lf[357]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[358]=C_h_intern(&lf[358],20,"\003syspointer->address");
lf[359]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[360]=C_h_intern(&lf[360],16,"\003sysnull-pointer");
lf[361]=C_h_intern(&lf[361],22,"unmap-file-from-memory");
lf[362]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[363]=C_h_intern(&lf[363],26,"memory-mapped-file-pointer");
lf[364]=C_h_intern(&lf[364],19,"memory-mapped-file\077");
lf[366]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[367]=C_h_intern(&lf[367],19,"seconds->local-time");
lf[368]=C_h_intern(&lf[368],18,"\003sysdecode-seconds");
lf[369]=C_h_intern(&lf[369],15,"current-seconds");
lf[370]=C_h_intern(&lf[370],17,"seconds->utc-time");
lf[371]=C_h_intern(&lf[371],15,"seconds->string");
lf[372]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[373]=C_h_intern(&lf[373],12,"time->string");
lf[374]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[375]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[376]=C_h_intern(&lf[376],12,"string->time");
lf[377]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[378]=C_h_intern(&lf[378],19,"local-time->seconds");
lf[379]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[380]=C_h_intern(&lf[380],3,"fp=");
lf[381]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[382]=C_h_intern(&lf[382],17,"utc-time->seconds");
lf[383]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[384]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[385]=C_h_intern(&lf[385],27,"local-timezone-abbreviation");
lf[386]=C_h_intern(&lf[386],5,"_exit");
lf[387]=C_h_intern(&lf[387],10,"set-alarm!");
lf[388]=C_h_intern(&lf[388],19,"set-buffering-mode!");
lf[389]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[390]=C_h_intern(&lf[390],5,"\000full");
lf[391]=C_h_intern(&lf[391],5,"\000line");
lf[392]=C_h_intern(&lf[392],5,"\000none");
lf[393]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[394]=C_h_intern(&lf[394],14,"terminal-port\077");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[397]=C_h_intern(&lf[397],13,"terminal-name");
lf[398]=C_h_intern(&lf[398],13,"terminal-size");
lf[399]=C_h_intern(&lf[399],6,"\000error");
lf[400]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[401]=C_h_intern(&lf[401],17,"\003sysmake-locative");
lf[402]=C_h_intern(&lf[402],8,"location");
lf[403]=C_h_intern(&lf[403],13,"get-host-name");
lf[404]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[405]=C_h_intern(&lf[405],12,"process-fork");
lf[406]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[407]=C_h_intern(&lf[407],24,"pathname-strip-directory");
lf[408]=C_h_intern(&lf[408],15,"process-execute");
lf[409]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[410]=C_h_intern(&lf[410],16,"\003sysprocess-wait");
lf[411]=C_h_intern(&lf[411],12,"process-wait");
lf[412]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[413]=C_h_intern(&lf[413],18,"current-process-id");
lf[414]=C_h_intern(&lf[414],17,"parent-process-id");
lf[415]=C_h_intern(&lf[415],5,"sleep");
lf[416]=C_h_intern(&lf[416],14,"process-signal");
lf[417]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[418]=C_h_intern(&lf[418],17,"\003sysshell-command");
lf[419]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[420]=C_h_intern(&lf[420],24,"get-environment-variable");
lf[421]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[422]=C_h_intern(&lf[422],27,"\003sysshell-command-arguments");
lf[423]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[424]=C_h_intern(&lf[424],11,"process-run");
lf[425]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[426]=C_h_intern(&lf[426],11,"\003sysprocess");
lf[427]=C_h_intern(&lf[427],16,"\003syscheck-string");
lf[428]=C_h_intern(&lf[428],12,"\003sysfor-each");
lf[429]=C_h_intern(&lf[429],7,"process");
lf[430]=C_h_intern(&lf[430],8,"process*");
lf[431]=C_h_intern(&lf[431],19,"set-root-directory!");
lf[432]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[433]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[434]=C_h_intern(&lf[434],21,"set-process-group-id!");
lf[435]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[436]=C_h_intern(&lf[436],18,"getter-with-setter");
lf[437]=C_decode_literal(C_heaptop,"\376B\000\000\026(process-group-id pid)");
lf[438]=C_h_intern(&lf[438],26,"effective-group-id!-setter");
lf[439]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[440]=C_decode_literal(C_heaptop,"\376B\000\000\034(current-effective-group-id)");
lf[441]=C_h_intern(&lf[441],12,"set-user-id!");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[443]=C_decode_literal(C_heaptop,"\376B\000\000\022(current-group-id)");
lf[444]=C_h_intern(&lf[444],25,"effective-user-id!-setter");
lf[445]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[446]=C_decode_literal(C_heaptop,"\376B\000\000\033(current-effective-used-id)");
lf[447]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[448]=C_decode_literal(C_heaptop,"\376B\000\000\021(current-user-id)");
lf[449]=C_h_intern(&lf[449],23,"\003sysuser-interrupt-hook");
lf[450]=C_h_intern(&lf[450],11,"make-vector");
lf[451]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[452]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[454]=C_h_intern(&lf[454],26,"set-file-modification-time");
lf[455]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[456]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,457,create_ptable());
t2=C_mutate(&lf[0] /* (set! c100 ...) */,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2057,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k2055 */
static void C_ccall f_2057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2057,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2060,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2058 in k2055 */
static void C_ccall f_2060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2060,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2063,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2061 in k2058 in k2055 */
static void C_ccall f_2063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2063,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2066,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2066,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2069,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2069(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2069,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2072,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2072(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2072,2,t0,t1);}
t2=*((C_word*)lf[2]+1);
t3=C_mutate(&lf[3] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2084,a[2]=t2,a[3]=((C_word)li0),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[8]+1 /* (set! ##sys#posix-error ...) */,lf[3]);
t5=C_mutate(&lf[9] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2102,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[17]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2146,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2179,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8022,a[2]=((C_word)li261),tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8028,a[2]=((C_word)li262),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:128: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[436]+1)))(5,*((C_word*)lf[436]+1),t7,t8,t9,lf[456]);}

/* a8027 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_8028(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8028,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[454]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8048,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8061,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:134: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t6,t2);}

/* k8059 in a8027 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_8061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8061,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8038,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t4=C_i_foreign_string_argumentp(t1);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,t4);}
else{
t4=((C_word*)t0)[2];
f_8048(t4,stub111(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t2));}}

/* k8036 in k8059 in a8027 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_8038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_8048(t2,stub111(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[2]));}

/* k8046 in a8027 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_8048(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:136: posix-error */
t2=lf[3];
f_2084(7,t2,((C_word*)t0)[4],lf[10],lf[454],lf[455],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* a8021 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_8022(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8022,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8026,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:130: ##sys#stat */
f_2102(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* k8024 in a8021 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_8026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8026,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2179(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word ab[105],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2179,2,t0,t1);}
t2=C_mutate((C_word*)lf[21]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate((C_word*)lf[22]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2181,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[23]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2187,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[24]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2193,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[25]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2199,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[26]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2205,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[27]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2211,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[35]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2310,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[36]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2320,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[37]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2330,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[38]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2340,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[39]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2350,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[40]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2360,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[41]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2370,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t16=*((C_word*)lf[42]+1);
t17=C_mutate((C_word*)lf[43]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2380,a[2]=t16,a[3]=((C_word)li19),tmp=(C_word)a,a+=4,tmp));
t18=C_mutate((C_word*)lf[47]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2426,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t19=*((C_word*)lf[42]+1);
t20=C_mutate((C_word*)lf[29]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2448,a[2]=t19,a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp));
t21=C_mutate((C_word*)lf[51]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2605,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate(&lf[59] /* (set! ##sys#find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2717,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[68]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2890,a[2]=((C_word)li56),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[77]+1 /* (set! ##sys#file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3071,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[78]+1 /* (set! ##sys#file-select-one ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3078,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[79]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t27=C_mutate((C_word*)lf[80]+1 /* (set! fcntl/dupfd ...) */,C_fix((C_word)F_DUPFD));
t28=C_mutate((C_word*)lf[81]+1 /* (set! fcntl/getfd ...) */,C_fix((C_word)F_GETFD));
t29=C_mutate((C_word*)lf[82]+1 /* (set! fcntl/setfd ...) */,C_fix((C_word)F_SETFD));
t30=C_mutate((C_word*)lf[83]+1 /* (set! fcntl/getfl ...) */,C_fix((C_word)F_GETFL));
t31=C_mutate((C_word*)lf[84]+1 /* (set! fcntl/setfl ...) */,C_fix((C_word)F_SETFL));
t32=C_mutate((C_word*)lf[85]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t33=C_mutate((C_word*)lf[86]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t34=C_mutate((C_word*)lf[87]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t35=C_mutate((C_word*)lf[88]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDONLY));
t36=C_mutate((C_word*)lf[89]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t37=C_mutate((C_word*)lf[90]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t38=C_mutate((C_word*)lf[91]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t39=C_mutate((C_word*)lf[92]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t40=C_mutate((C_word*)lf[93]+1 /* (set! open/noctty ...) */,C_fix((C_word)O_NOCTTY));
t41=C_mutate((C_word*)lf[94]+1 /* (set! open/nonblock ...) */,C_fix((C_word)O_NONBLOCK));
t42=C_mutate((C_word*)lf[95]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t43=C_mutate((C_word*)lf[96]+1 /* (set! open/sync ...) */,C_fix((C_word)O_FSYNC));
t44=C_mutate((C_word*)lf[97]+1 /* (set! open/fsync ...) */,C_fix((C_word)O_FSYNC));
t45=C_mutate((C_word*)lf[98]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t46=C_mutate((C_word*)lf[99]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t47=C_mutate((C_word*)lf[100]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IRUSR));
t48=C_mutate((C_word*)lf[101]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWUSR));
t49=C_mutate((C_word*)lf[102]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IXUSR));
t50=C_mutate((C_word*)lf[103]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IRGRP));
t51=C_mutate((C_word*)lf[104]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWGRP));
t52=C_mutate((C_word*)lf[105]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IXGRP));
t53=C_mutate((C_word*)lf[106]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IROTH));
t54=C_mutate((C_word*)lf[107]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWOTH));
t55=C_mutate((C_word*)lf[108]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IXOTH));
t56=C_mutate((C_word*)lf[109]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IRWXU));
t57=C_mutate((C_word*)lf[110]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IRWXG));
t58=C_mutate((C_word*)lf[111]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IRWXO));
t59=C_mutate((C_word*)lf[112]+1 /* (set! perm/isvtx ...) */,C_fix((C_word)S_ISVTX));
t60=C_mutate((C_word*)lf[113]+1 /* (set! perm/isuid ...) */,C_fix((C_word)S_ISUID));
t61=C_mutate((C_word*)lf[114]+1 /* (set! perm/isgid ...) */,C_fix((C_word)S_ISGID));
t62=C_mutate((C_word*)lf[115]+1 /* (set! file-control ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3135,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp));
t63=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t64=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t63);
t65=C_mutate((C_word*)lf[117]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3181,a[2]=t64,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t66=C_mutate((C_word*)lf[119]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3219,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp));
t67=*((C_word*)lf[42]+1);
t68=C_mutate((C_word*)lf[121]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3234,a[2]=t67,a[3]=((C_word)li62),tmp=(C_word)a,a+=4,tmp));
t69=C_mutate((C_word*)lf[124]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3276,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[127]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3315,a[2]=((C_word)li64),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[129]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3373,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[131]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t73=C_mutate((C_word*)lf[132]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t74=C_mutate((C_word*)lf[133]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t75=C_mutate((C_word*)lf[134]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3653,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t76=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3713,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t77=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7981,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:727: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[436]+1)))(5,*((C_word*)lf[436]+1),t76,t77,*((C_word*)lf[134]+1),lf[453]);}

/* a7980 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7981(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7981,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7985,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7997,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:729: port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[138]+1)))(3,*((C_word*)lf[138]+1),t4,t2);}

/* k7995 in a7980 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7997(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[3],C_fix(7));
t3=C_eqp(t2,lf[136]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
f_7985(2,t5,t4);}
else{
t4=((C_word*)t0)[2];
f_7985(2,t4,C_fix(-1));}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t2=C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[2];
f_7985(2,t3,t2);}
else{
/* posixunix.scm:736: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),((C_word*)t0)[2],lf[15],lf[141],lf[452],((C_word*)t0)[3]);}}}

/* k7983 in a7980 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7985(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7985,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7988,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t1,C_fix(0)))){
/* posixunix.scm:738: posix-error */
t3=lf[3];
f_2084(6,t3,t2,lf[10],lf[141],lf[451],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k7986 in k7983 in a7980 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word ab[114],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3713,2,t0,t1);}
t2=C_mutate((C_word*)lf[141]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[142]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3715,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[44]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3848,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3888,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp);
t6=C_mutate((C_word*)lf[151]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3903,a[2]=t5,a[3]=((C_word)li81),tmp=(C_word)a,a+=4,tmp));
t7=C_mutate((C_word*)lf[155]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3939,a[2]=t5,a[3]=((C_word)li82),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate((C_word*)lf[156]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3975,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[160]+1 /* (set! close-output-pipe ...) */,*((C_word*)lf[156]+1));
t10=C_mutate((C_word*)lf[161]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3991,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[162]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4015,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[163]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4039,a[2]=((C_word)li91),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[165]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4059,a[2]=((C_word)li93),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[167]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4079,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[169]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t16=C_mutate((C_word*)lf[170]+1 /* (set! signal/kill ...) */,C_fix((C_word)SIGKILL));
t17=C_mutate((C_word*)lf[171]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t18=C_mutate((C_word*)lf[172]+1 /* (set! signal/hup ...) */,C_fix((C_word)SIGHUP));
t19=C_mutate((C_word*)lf[173]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t20=C_mutate((C_word*)lf[174]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t21=C_mutate((C_word*)lf[175]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t22=C_mutate((C_word*)lf[176]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t23=C_mutate((C_word*)lf[177]+1 /* (set! signal/trap ...) */,C_fix((C_word)SIGTRAP));
t24=C_mutate((C_word*)lf[178]+1 /* (set! signal/quit ...) */,C_fix((C_word)SIGQUIT));
t25=C_mutate((C_word*)lf[179]+1 /* (set! signal/alrm ...) */,C_fix((C_word)SIGALRM));
t26=C_mutate((C_word*)lf[180]+1 /* (set! signal/vtalrm ...) */,C_fix((C_word)SIGVTALRM));
t27=C_mutate((C_word*)lf[181]+1 /* (set! signal/prof ...) */,C_fix((C_word)SIGPROF));
t28=C_mutate((C_word*)lf[182]+1 /* (set! signal/io ...) */,C_fix((C_word)SIGIO));
t29=C_mutate((C_word*)lf[183]+1 /* (set! signal/urg ...) */,C_fix((C_word)SIGURG));
t30=C_mutate((C_word*)lf[184]+1 /* (set! signal/chld ...) */,C_fix((C_word)SIGCHLD));
t31=C_mutate((C_word*)lf[185]+1 /* (set! signal/cont ...) */,C_fix((C_word)SIGCONT));
t32=C_mutate((C_word*)lf[186]+1 /* (set! signal/stop ...) */,C_fix((C_word)SIGSTOP));
t33=C_mutate((C_word*)lf[187]+1 /* (set! signal/tstp ...) */,C_fix((C_word)SIGTSTP));
t34=C_mutate((C_word*)lf[188]+1 /* (set! signal/pipe ...) */,C_fix((C_word)SIGPIPE));
t35=C_mutate((C_word*)lf[189]+1 /* (set! signal/xcpu ...) */,C_fix((C_word)SIGXCPU));
t36=C_mutate((C_word*)lf[190]+1 /* (set! signal/xfsz ...) */,C_fix((C_word)SIGXFSZ));
t37=C_mutate((C_word*)lf[191]+1 /* (set! signal/usr1 ...) */,C_fix((C_word)SIGUSR1));
t38=C_mutate((C_word*)lf[192]+1 /* (set! signal/usr2 ...) */,C_fix((C_word)SIGUSR2));
t39=C_mutate((C_word*)lf[193]+1 /* (set! signal/winch ...) */,C_fix((C_word)SIGWINCH));
t40=C_a_i_list(&a,25,*((C_word*)lf[169]+1),*((C_word*)lf[170]+1),*((C_word*)lf[171]+1),*((C_word*)lf[172]+1),*((C_word*)lf[173]+1),*((C_word*)lf[174]+1),*((C_word*)lf[175]+1),*((C_word*)lf[176]+1),*((C_word*)lf[177]+1),*((C_word*)lf[178]+1),*((C_word*)lf[179]+1),*((C_word*)lf[180]+1),*((C_word*)lf[181]+1),*((C_word*)lf[182]+1),*((C_word*)lf[183]+1),*((C_word*)lf[184]+1),*((C_word*)lf[185]+1),*((C_word*)lf[186]+1),*((C_word*)lf[187]+1),*((C_word*)lf[188]+1),*((C_word*)lf[189]+1),*((C_word*)lf[190]+1),*((C_word*)lf[191]+1),*((C_word*)lf[192]+1),*((C_word*)lf[193]+1));
t41=C_mutate((C_word*)lf[194]+1 /* (set! signals-list ...) */,t40);
t42=*((C_word*)lf[195]+1);
t43=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4124,a[2]=((C_word*)t0)[2],a[3]=t42,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:928: make-vector */
((C_proc4)C_retrieve_proc(*((C_word*)lf[450]+1)))(4,*((C_word*)lf[450]+1),t43,C_fix(256),C_SCHEME_FALSE);}

/* k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4124(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[34],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4124,2,t0,t1);}
t2=C_mutate((C_word*)lf[196]+1 /* (set! signal-handler ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4126,a[2]=t1,a[3]=((C_word)li95),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[197]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4135,a[2]=t1,a[3]=((C_word)li96),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[195]+1 /* (set! ##sys#interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4148,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li97),tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[198]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4166,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[201]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4212,a[2]=((C_word)li101),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[202]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4244,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[203]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4250,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[205]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4265,a[2]=((C_word)li104),tmp=(C_word)a,a+=3,tmp));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4281,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7975,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:984: set-signal-handler! */
t12=*((C_word*)lf[197]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,*((C_word*)lf[171]+1),t11);}

/* a7974 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7975(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7975,3,t0,t1,t2);}
/* posixunix.scm:986: ##sys#user-interrupt-hook */
((C_proc2)C_retrieve_proc(*((C_word*)lf[449]+1)))(2,*((C_word*)lf[449]+1),t1);}

/* k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4281,2,t0,t1);}
t2=C_mutate((C_word*)lf[207]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4283,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp));
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4323,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7957,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7960,a[2]=((C_word)li258),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1010: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[436]+1)))(5,*((C_word*)lf[436]+1),t3,t4,t5,lf[448]);}

/* a7959 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7960(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7960,3,t0,t1,t2);}
if(C_truep(C_fixnum_lessp(C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7970,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1014: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k7968 in a7959 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1015: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[441],lf[447],((C_word*)t0)[2]);}

/* a7956 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7957(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7957,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub777(C_SCHEME_UNDEFINED));}

/* k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4323(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4323,2,t0,t1);}
t2=C_mutate((C_word*)lf[210]+1 /* (set! current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4327,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7939,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7942,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1019: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[436]+1)))(5,*((C_word*)lf[436]+1),t3,t4,t5,lf[446]);}

/* a7941 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7942(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7942,3,t0,t1,t2);}
if(C_truep(C_fixnum_lessp(C_seteuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7952,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1023: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k7950 in a7941 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1024: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[444],lf[445],((C_word*)t0)[2]);}

/* a7938 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7939(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7939,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub781(C_SCHEME_UNDEFINED));}

/* k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4327,2,t0,t1);}
t2=C_mutate((C_word*)lf[211]+1 /* (set! current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4331,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7921,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7924,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1029: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[436]+1)))(5,*((C_word*)lf[436]+1),t3,t4,t5,lf[443]);}

/* a7923 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7924(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7924,3,t0,t1,t2);}
if(C_truep(C_fixnum_lessp(C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7934,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1033: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k7932 in a7923 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1034: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[441],lf[442],((C_word*)t0)[2]);}

/* a7920 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7921,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub785(C_SCHEME_UNDEFINED));}

/* k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4331,2,t0,t1);}
t2=C_mutate((C_word*)lf[212]+1 /* (set! current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4335,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7903,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7906,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1038: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[436]+1)))(5,*((C_word*)lf[436]+1),t3,t4,t5,lf[440]);}

/* a7905 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7906(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7906,3,t0,t1,t2);}
if(C_truep(C_fixnum_lessp(C_setegid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7916,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1042: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k7914 in a7905 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1043: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[438],lf[439],((C_word*)t0)[2]);}

/* a7902 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7903(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7903,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub789(C_SCHEME_UNDEFINED));}

/* k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word ab[54],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4335,2,t0,t1);}
t2=C_mutate((C_word*)lf[213]+1 /* (set! current-effective-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[214]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4337,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[217]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4404,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[218]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4418,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[219]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4443,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[220]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4536,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[224]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4599,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[227]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4673,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[229]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t11=C_mutate((C_word*)lf[230]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t12=C_mutate((C_word*)lf[231]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t13=C_mutate((C_word*)lf[232]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t14=C_mutate((C_word*)lf[233]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t15=C_mutate((C_word*)lf[234]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t16=C_mutate((C_word*)lf[235]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t17=C_mutate((C_word*)lf[236]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t18=C_mutate((C_word*)lf[237]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t19=C_mutate((C_word*)lf[238]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t20=C_mutate((C_word*)lf[239]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t21=C_mutate((C_word*)lf[240]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t22=C_mutate((C_word*)lf[241]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t23=C_mutate((C_word*)lf[242]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t24=C_mutate((C_word*)lf[243]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t25=C_mutate((C_word*)lf[244]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t26=C_mutate((C_word*)lf[245]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t27=C_mutate((C_word*)lf[246]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t28=C_mutate((C_word*)lf[247]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t29=C_mutate((C_word*)lf[248]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t30=C_mutate((C_word*)lf[249]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t31=C_mutate((C_word*)lf[250]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t32=C_mutate((C_word*)lf[251]+1 /* (set! errno/wouldblock ...) */,C_fix((C_word)EWOULDBLOCK));
t33=C_set_block_item(lf[252] /* errno/2big */,0,C_fix(0));
t34=C_set_block_item(lf[253] /* errno/deadlk */,0,C_fix(0));
t35=C_set_block_item(lf[254] /* errno/dom */,0,C_fix(0));
t36=C_set_block_item(lf[255] /* errno/fbig */,0,C_fix(0));
t37=C_set_block_item(lf[256] /* errno/ilseq */,0,C_fix(0));
t38=C_set_block_item(lf[257] /* errno/mlink */,0,C_fix(0));
t39=C_set_block_item(lf[258] /* errno/nametoolong */,0,C_fix(0));
t40=C_set_block_item(lf[259] /* errno/nfile */,0,C_fix(0));
t41=C_set_block_item(lf[260] /* errno/nodev */,0,C_fix(0));
t42=C_set_block_item(lf[261] /* errno/nolck */,0,C_fix(0));
t43=C_set_block_item(lf[262] /* errno/nosys */,0,C_fix(0));
t44=C_set_block_item(lf[263] /* errno/notempty */,0,C_fix(0));
t45=C_set_block_item(lf[264] /* errno/notty */,0,C_fix(0));
t46=C_set_block_item(lf[265] /* errno/nxio */,0,C_fix(0));
t47=C_set_block_item(lf[266] /* errno/range */,0,C_fix(0));
t48=C_set_block_item(lf[267] /* errno/xdev */,0,C_fix(0));
t49=C_mutate((C_word*)lf[268]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4737,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[270]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4764,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4794,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp);
t52=C_mutate((C_word*)lf[272]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4818,a[2]=t51,a[3]=((C_word)li119),tmp=(C_word)a,a+=4,tmp));
t53=C_mutate((C_word*)lf[273]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4824,a[2]=t51,a[3]=((C_word)li120),tmp=(C_word)a,a+=4,tmp));
t54=C_mutate((C_word*)lf[274]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4830,a[2]=t51,a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[275]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4836,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t56=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4853,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7864,a[2]=((C_word)li249),tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7882,a[2]=((C_word)li250),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1259: getter-with-setter */
((C_proc5)C_retrieve_proc(*((C_word*)lf[436]+1)))(5,*((C_word*)lf[436]+1),t56,t57,t58,lf[437]);}

/* a7881 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7882(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7882,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[434]);
t5=C_i_check_exact_2(t3,lf[434]);
if(C_truep(C_fixnum_lessp(C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7898,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1271: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k7896 in a7881 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7898(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1272: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[434],lf[435],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a7863 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7864(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7864,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[277]);
t4=C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7871,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7877,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1264: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t4);}}

/* k7875 in a7863 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1265: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[277],lf[433],((C_word*)t0)[2]);}

/* k7869 in a7863 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4853(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4853,2,t0,t1);}
t2=C_mutate((C_word*)lf[277]+1 /* (set! process-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[278]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4855,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp));
t4=*((C_word*)lf[281]+1);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4892,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm:1293: make-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[42]+1)))(3,*((C_word*)lf[42]+1),t5,t6);}

/* k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word ab[237],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4892,2,t0,t1);}
t2=C_mutate((C_word*)lf[282]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4893,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li124),tmp=(C_word)a,a+=5,tmp));
t3=C_mutate((C_word*)lf[285]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4977,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[288]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[289]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[290]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5002,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t12=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5039,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[299]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5054,a[2]=t8,a[3]=t10,a[4]=((C_word)li128),tmp=(C_word)a,a+=5,tmp));
t14=C_mutate((C_word*)lf[300]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5068,a[2]=t8,a[3]=t10,a[4]=((C_word)li129),tmp=(C_word)a,a+=5,tmp));
t15=C_mutate((C_word*)lf[301]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5082,a[2]=((C_word)li130),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[306]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5127,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[308]+1 /* (set! ##sys#custom-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5154,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[323]+1 /* (set! ##sys#custom-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5636,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[327]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5895,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t20=C_SCHEME_UNDEFINED;
t21=(*a=C_VECTOR_TYPE|1,a[1]=t20,tmp=(C_word)a,a+=2,tmp);
t22=C_SCHEME_UNDEFINED;
t23=(*a=C_VECTOR_TYPE|1,a[1]=t22,tmp=(C_word)a,a+=2,tmp);
t24=C_set_block_item(t21,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5934,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t25=C_set_block_item(t23,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6008,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[331]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6026,a[2]=t21,a[3]=t23,a[4]=((C_word)li167),tmp=(C_word)a,a+=5,tmp));
t27=C_mutate((C_word*)lf[333]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6041,a[2]=t21,a[3]=t23,a[4]=((C_word)li168),tmp=(C_word)a,a+=5,tmp));
t28=C_mutate((C_word*)lf[335]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6056,a[2]=t21,a[3]=t23,a[4]=((C_word)li169),tmp=(C_word)a,a+=5,tmp));
t29=C_mutate((C_word*)lf[337]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6083,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[339]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6111,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[39]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6154,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[343]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6180,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[344]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6197,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[345]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6217,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[346]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t36=C_mutate((C_word*)lf[347]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t37=C_mutate((C_word*)lf[348]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t38=C_mutate((C_word*)lf[349]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t39=C_mutate((C_word*)lf[350]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t40=C_mutate((C_word*)lf[351]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t41=C_mutate((C_word*)lf[352]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t42=C_mutate((C_word*)lf[353]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANON));
t43=C_mutate((C_word*)lf[354]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t44=C_mutate((C_word*)lf[355]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6320,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[361]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6382,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[363]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6417,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[364]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6426,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate(&lf[365] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6432,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[367]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6451,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[370]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6485,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[371]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6529,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[373]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6590,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[376]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6659,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[378]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6705,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[382]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6720,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[385]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6735,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[386]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6747,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[387]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6763,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[388]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6770,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[394]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6829,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate(&lf[395] /* (set! ##sys#terminal-check ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6848,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[397]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6880,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[398]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6903,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[403]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6938,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[405]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6952,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t66=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6994,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp);
t67=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7013,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp);
t68=*((C_word*)lf[407]+1);
t69=C_mutate((C_word*)lf[408]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7032,a[2]=t68,a[3]=t67,a[4]=t66,a[5]=((C_word)li207),tmp=(C_word)a,a+=6,tmp));
t70=C_mutate((C_word*)lf[410]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7214,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[411]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7231,a[2]=((C_word)li211),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[413]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7309,a[2]=((C_word)li212),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[414]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7312,a[2]=((C_word)li213),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[415]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7315,a[2]=((C_word)li214),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[416]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7322,a[2]=((C_word)li215),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[418]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7349,a[2]=((C_word)li216),tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[422]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7358,a[2]=((C_word)li217),tmp=(C_word)a,a+=3,tmp));
t78=C_mutate((C_word*)lf[424]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7364,a[2]=((C_word)li218),tmp=(C_word)a,a+=3,tmp));
t79=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7420,a[2]=((C_word)li222),tmp=(C_word)a,a+=3,tmp);
t80=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7457,a[2]=((C_word)li225),tmp=(C_word)a,a+=3,tmp);
t81=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7477,a[2]=((C_word)li226),tmp=(C_word)a,a+=3,tmp);
t82=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7491,a[2]=((C_word)li227),tmp=(C_word)a,a+=3,tmp);
t83=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7524,a[2]=t80,a[3]=t82,a[4]=((C_word)li229),tmp=(C_word)a,a+=5,tmp);
t84=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7569,a[2]=t81,a[3]=((C_word)li230),tmp=(C_word)a,a+=4,tmp);
t85=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7580,a[2]=t81,a[3]=((C_word)li231),tmp=(C_word)a,a+=4,tmp);
t86=C_mutate((C_word*)lf[426]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7591,a[2]=t85,a[3]=t79,a[4]=t84,a[5]=t83,a[6]=((C_word)li234),tmp=(C_word)a,a+=7,tmp));
t87=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7647,a[2]=((C_word)li239),tmp=(C_word)a,a+=3,tmp);
t88=C_mutate((C_word*)lf[429]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7708,a[2]=t87,a[3]=((C_word)li243),tmp=(C_word)a,a+=4,tmp));
t89=C_mutate((C_word*)lf[430]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7768,a[2]=t87,a[3]=((C_word)li247),tmp=(C_word)a,a+=4,tmp));
t90=C_mutate((C_word*)lf[431]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7841,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp));
t91=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t91+1)))(2,t91,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7841(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7841,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[431]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7851,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7833,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t5)){
t7=C_i_foreign_string_argumentp(t5);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t6,t7);}
else{
t7=stub1821(C_SCHEME_UNDEFINED,C_SCHEME_FALSE);
t8=t4;
f_7851(t8,C_fixnum_lessp(t7,C_fix(0)));}}

/* k7831 in set-root-directory! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7833(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=stub1821(C_SCHEME_UNDEFINED,t1);
t3=((C_word*)t0)[2];
f_7851(t3,C_fixnum_lessp(t2,C_fix(0)));}

/* k7849 in set-root-directory! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7851(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:2082: posix-error */
t2=lf[3];
f_2084(6,t2,((C_word*)t0)[3],lf[10],lf[431],lf[432],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* process* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7768(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_7768r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7768r(t0,t1,t2,t3);}}

static void C_ccall f_7768r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7770,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li244),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7775,a[2]=t4,a[3]=((C_word)li245),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7780,a[2]=t5,a[3]=((C_word)li246),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-args18031813 */
t7=t6;
f_7780(t7,t1);}
else{
t7=C_i_car(t3);
t8=C_i_cdr(t3);
if(C_truep(C_i_nullp(t8))){
/* def-env18041811 */
t9=t5;
f_7775(t9,t1,t7);}
else{
t9=C_i_car(t8);
t10=C_i_cdr(t8);
if(C_truep(C_i_nullp(t10))){
/* body18011808 */
t11=t4;
f_7770(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args1803 in process* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7780(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7780,NULL,2,t0,t1);}
/* def-env18041811 */
t2=((C_word*)t0)[2];
f_7775(t2,t1,C_SCHEME_FALSE);}

/* def-env1804 in process* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7775(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7775,NULL,3,t0,t1,t2);}
/* body18011808 */
t3=((C_word*)t0)[2];
f_7770(t3,t1,t2,C_SCHEME_FALSE);}

/* body1801 in process* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7770(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7770,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm:2072: %process */
f_7647(t1,lf[430],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3);}

/* process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7708(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_7708r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7708r(t0,t1,t2,t3);}}

static void C_ccall f_7708r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7710,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li240),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7715,a[2]=t4,a[3]=((C_word)li241),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7720,a[2]=t5,a[3]=((C_word)li242),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-args17761786 */
t7=t6;
f_7720(t7,t1);}
else{
t7=C_i_car(t3);
t8=C_i_cdr(t3);
if(C_truep(C_i_nullp(t8))){
/* def-env17771784 */
t9=t5;
f_7715(t9,t1,t7);}
else{
t9=C_i_car(t8);
t10=C_i_cdr(t8);
if(C_truep(C_i_nullp(t10))){
/* body17741781 */
t11=t4;
f_7710(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args1776 in process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7720(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7720,NULL,2,t0,t1);}
/* def-env17771784 */
t2=((C_word*)t0)[2];
f_7715(t2,t1,C_SCHEME_FALSE);}

/* def-env1777 in process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7715(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7715,NULL,3,t0,t1,t2);}
/* body17741781 */
t3=((C_word*)t0)[2];
f_7710(t3,t1,t2,C_SCHEME_FALSE);}

/* body1774 in process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7710(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7710,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm:2069: %process */
f_7647(t1,lf[429],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3);}

/* %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7647(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7647,NULL,6,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7649,a[2]=t2,a[3]=((C_word)li236),tmp=(C_word)a,a+=4,tmp);
t10=C_i_check_string_2(((C_word*)t7)[1],t2);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7668,a[2]=t9,a[3]=t1,a[4]=t3,a[5]=t6,a[6]=t8,a[7]=t7,a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
/* posixunix.scm:2058: chkstrlst */
t12=t9;
f_7649(t12,t11,((C_word*)t8)[1]);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7702,a[2]=t11,a[3]=t7,a[4]=t8,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:2060: ##sys#shell-command-arguments */
t13=*((C_word*)lf[422]+1);
((C_proc3)(void*)(*((C_word*)t13+1)))(3,t13,t12,((C_word*)t7)[1]);}}

/* k7700 in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7702,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7706,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:2061: ##sys#shell-command */
t4=*((C_word*)lf[418]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k7704 in k7700 in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7706(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_7668(2,t3,t2);}

/* k7666 in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7668,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7671,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm:2062: chkstrlst */
t3=((C_word*)t0)[2];
f_7649(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_7671(2,t3,C_SCHEME_UNDEFINED);}}

/* k7669 in k7666 in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7671,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7676,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word)li237),tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7682,a[2]=((C_word*)t0)[3],a[3]=((C_word)li238),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a7681 in k7669 in k7666 in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7682(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_7682,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm:2065: values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixunix.scm:2066: values */
C_values(5,0,t1,t2,t3,t4);}}

/* a7675 in k7669 in k7666 in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7676,2,t0,t1);}
/* posixunix.scm:2063: ##sys#process */
t2=*((C_word*)lf[426]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[3],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[2]);}

/* chkstrlst in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7649(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7649,NULL,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7658,a[2]=((C_word*)t0)[2],a[3]=((C_word)li235),tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[428]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a7657 in chkstrlst in %process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7658(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7658,3,t0,t1,t2);}
t3=*((C_word*)lf[427]+1);
/* g17531754 */
t4=t3;
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,((C_word*)t0)[2]);}

/* ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7591(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[21],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_7591,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7597,a[2]=t8,a[3]=t7,a[4]=t6,a[5]=t5,a[6]=t4,a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word)li232),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7603,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=t6,a[9]=t7,a[10]=((C_word)li233),tmp=(C_word)a,a+=11,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}

/* a7602 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7603(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_7603,6,t0,t1,t2,t3,t4,t5);}
t6=C_i_not(((C_word*)t0)[9]);
t7=C_i_not(((C_word*)t0)[8]);
t8=C_i_not(((C_word*)t0)[7]);
t9=C_a_i_vector(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_7614,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t9,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=t5,a[13]=t1,tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7634,a[2]=((C_word*)t0)[9],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t10,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:2039: make-on-close */
f_7420(t11,((C_word*)t0)[5],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k7632 in a7602 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:2038: input-port */
t2=((C_word*)t0)[7];
f_7569(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7612 in a7602 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7614,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7618,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[12],a[10]=t1,a[11]=((C_word*)t0)[13],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7630,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],a[6]=t2,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:2041: make-on-close */
f_7420(t3,((C_word*)t0)[10],((C_word*)t0)[12],((C_word*)t0)[5],C_fix(1),C_fix(0),C_fix(2));}

/* k7628 in k7612 in a7602 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:2040: output-port */
t2=((C_word*)t0)[7];
f_7580(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7616 in k7612 in a7602 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7618,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7622,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7626,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:2044: make-on-close */
f_7420(t3,((C_word*)t0)[7],((C_word*)t0)[9],((C_word*)t0)[2],C_fix(2),C_fix(0),C_fix(1));}

/* k7624 in k7616 in k7612 in a7602 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:2043: input-port */
t2=((C_word*)t0)[7];
f_7569(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7620 in k7616 in k7612 in a7602 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:2037: values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a7596 in ##sys#process in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7597,2,t0,t1);}
/* posixunix.scm:2032: spawn */
t2=((C_word*)t0)[8];
f_7524(t2,t1,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7580(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7580,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7584,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:2028: connect-parent */
f_7477(t7,t4,t5);}

/* k7582 in output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:2029: ##sys#custom-output-port */
t2=*((C_word*)lf[323]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7569(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7569,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7573,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:2024: connect-parent */
f_7477(t7,t4,t5);}

/* k7571 in input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7573(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:2025: ##sys#custom-input-port */
t2=*((C_word*)lf[308]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7524(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7524,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7528,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t5,a[5]=t7,a[6]=((C_word*)t0)[3],a[7]=t4,a[8]=t3,a[9]=t2,a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:2011: needed-pipe */
f_7457(t8,t6);}

/* k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7528,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7531,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t1,a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:2012: needed-pipe */
f_7457(t2,((C_word*)t0)[4]);}

/* k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7531(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7531,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7534,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:2013: needed-pipe */
f_7457(t2,((C_word*)t0)[5]);}

/* k7532 in k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7534(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7534,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7541,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t1,a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
t3=((C_word*)t0)[3];
if(C_truep(t3)){
t4=C_i_cdr(t3);
t5=C_i_car(t3);
t6=t2;
f_7541(t6,C_a_i_cons(&a,2,t4,t5));}
else{
t4=t2;
f_7541(t4,C_SCHEME_FALSE);}}

/* k7539 in k7532 in k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7541(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7541,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7545,a[2]=((C_word*)t0)[10],a[3]=t1,a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[12],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7547,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word)li228),tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:2016: process-fork */
t4=*((C_word*)lf[405]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a7546 in k7539 in k7532 in k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7547,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7551,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:2018: connect-child */
f_7491(t2,((C_word*)t0)[3],((C_word*)t0)[2],*((C_word*)lf[288]+1));}

/* k7549 in a7546 in k7539 in k7532 in k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7551,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7554,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],tmp=(C_word)a,a+=9,tmp);
t3=((C_word*)t0)[3];
if(C_truep(t3)){
t4=C_i_cdr(t3);
t5=C_i_car(t3);
t6=C_a_i_cons(&a,2,t4,t5);
/* posixunix.scm:2019: connect-child */
f_7491(t2,t6,((C_word*)t0)[2],*((C_word*)lf[289]+1));}
else{
/* posixunix.scm:2019: connect-child */
f_7491(t2,C_SCHEME_FALSE,((C_word*)t0)[2],*((C_word*)lf[289]+1));}}

/* k7552 in k7549 in a7546 in k7539 in k7532 in k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7554,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7557,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[4];
if(C_truep(t3)){
t4=C_i_cdr(t3);
t5=C_i_car(t3);
t6=C_a_i_cons(&a,2,t4,t5);
/* posixunix.scm:2020: connect-child */
f_7491(t2,t6,((C_word*)t0)[2],*((C_word*)lf[290]+1));}
else{
/* posixunix.scm:2020: connect-child */
f_7491(t2,C_SCHEME_FALSE,((C_word*)t0)[2],*((C_word*)lf[290]+1));}}

/* k7555 in k7552 in k7549 in a7546 in k7539 in k7532 in k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:2021: process-execute */
t2=*((C_word*)lf[408]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k7543 in k7539 in k7532 in k7529 in k7526 in spawn in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:2014: values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* connect-child in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7491(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7491,NULL,4,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=C_i_car(t2);
t6=C_i_cdr(t2);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7504,a[2]=t5,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:2002: file-close */
t8=*((C_word*)lf[119]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t6);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k7502 in connect-child in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7504,2,t0,t1);}
t2=((C_word*)t0)[4];
t3=((C_word*)t0)[3];
t4=C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=t2;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7416,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1976: duplicate-fileno */
t6=*((C_word*)lf[306]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t3);}}

/* k7414 in k7502 in connect-child in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1977: file-close */
t2=*((C_word*)lf[119]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* connect-parent in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7477(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7477,NULL,3,t1,t2,t3);}
if(C_truep(t3)){
t4=C_i_car(t2);
t5=C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7490,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1996: file-close */
t7=*((C_word*)lf[119]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k7488 in connect-parent in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7490(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* needed-pipe in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7457(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7457,NULL,2,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7466,a[2]=((C_word)li223),tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7472,a[2]=((C_word)li224),tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* a7471 in needed-pipe in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7472(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7472,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* a7465 in needed-pipe in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7466,2,t0,t1);}
/* posixunix.scm:1991: create-pipe */
t2=*((C_word*)lf[167]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* make-on-close in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7420(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7420,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7422,a[2]=t2,a[3]=t3,a[4]=t7,a[5]=t6,a[6]=t5,a[7]=t4,a[8]=((C_word)li221),tmp=(C_word)a,a+=9,tmp));}

/* f_7422 in make-on-close in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7422,2,t0,t1);}
t2=C_i_vector_set(((C_word*)t0)[7],((C_word*)t0)[6],C_SCHEME_TRUE);
t3=C_i_vector_ref(((C_word*)t0)[7],((C_word*)t0)[5]);
t4=(C_truep(t3)?C_i_vector_ref(((C_word*)t0)[7],((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7437,a[2]=((C_word*)t0)[3],a[3]=((C_word)li219),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7443,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word)li220),tmp=(C_word)a,a+=5,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* a7442 */
static void C_ccall f_7443(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_7443,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
/* posixunix.scm:1986: ##sys#signal-hook */
((C_proc7)C_retrieve_proc(*((C_word*)lf[4]+1)))(7,*((C_word*)lf[4]+1),t1,lf[199],((C_word*)t0)[3],lf[425],((C_word*)t0)[2],t4);}}

/* a7436 */
static void C_ccall f_7437(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7437,2,t0,t1);}
/* posixunix.scm:1984: process-wait */
t2=*((C_word*)lf[411]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7364(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7364r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7364r(t0,t1,t2,t3);}}

static void C_ccall f_7364r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_i_car(t3):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7371,a[2]=t2,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1946: process-fork */
t7=*((C_word*)lf[405]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k7369 in process-run in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7371,2,t0,t1);}
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[4])){
/* posixunix.scm:1948: process-execute */
t3=*((C_word*)lf[408]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7390,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1950: ##sys#shell-command */
t4=*((C_word*)lf[418]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}
else{
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k7388 in k7369 in process-run in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7390,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7394,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1950: ##sys#shell-command-arguments */
t3=*((C_word*)lf[422]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k7392 in k7388 in k7369 in process-run in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1950: process-execute */
t2=*((C_word*)lf[408]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7358(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7358,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_list(&a,2,lf[423],t2));}

/* ##sys#shell-command in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7349,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7353,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1938: get-environment-variable */
((C_proc3)C_retrieve_proc(*((C_word*)lf[420]+1)))(3,*((C_word*)lf[420]+1),t2,lf[421]);}

/* k7351 in ##sys#shell-command in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7353(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[419]);}}

/* process-signal in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7322(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_7322r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7322r(t0,t1,t2,t3);}}

static void C_ccall f_7322r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_i_car(t3):C_fix((C_word)SIGTERM));
t6=C_i_check_exact_2(t2,lf[416]);
t7=C_i_check_exact_2(t5,lf[416]);
t8=C_kill(t2,t5);
t9=C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm:1935: posix-error */
t10=lf[3];
f_2084(7,t10,t1,lf[199],lf[416],lf[417],t2,t5);}
else{
t10=C_SCHEME_UNDEFINED;
t11=t1;
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t10);}}

/* sleep in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7315(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7315,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1627(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7312(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7312,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1624(C_SCHEME_UNDEFINED));}

/* current-process-id in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7309(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7309,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1622(C_SCHEME_UNDEFINED));}

/* process-wait in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7231(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_7231r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_7231r(t0,t1,t2);}}

static void C_ccall f_7231r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(9);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
if(C_truep(C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=C_i_check_exact_2(t11,lf[411]);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7261,a[2]=t8,a[3]=t11,a[4]=((C_word)li209),tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7267,a[2]=t11,a[3]=((C_word)li210),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t13,t14);}
else{
/* ##sys#error */
t11=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}

/* a7266 in process-wait in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7267(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_7267,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm:1921: posix-error */
t6=lf[3];
f_2084(6,t6,t1,lf[199],lf[411],lf[412],((C_word*)t0)[2]);}
else{
/* posixunix.scm:1922: values */
C_values(5,0,t1,t2,t3,t4);}}

/* a7260 in process-wait in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7261,2,t0,t1);}
/* posixunix.scm:1919: ##sys#process-wait */
t2=*((C_word*)lf[410]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7214(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7214,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=C_waitpid(t2,t4);
t6=C_WIFEXITED(C_fix((C_word)C_wait_status));
if(C_truep(t6)){
t7=C_WEXITSTATUS(C_fix((C_word)C_wait_status));
/* posixunix.scm:1906: values */
C_values(5,0,t1,t5,t6,t7);}
else{
if(C_truep(C_WIFSIGNALED(C_fix((C_word)C_wait_status)))){
t7=C_WTERMSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1906: values */
C_values(5,0,t1,t5,t6,t7);}
else{
t7=C_WSTOPSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1906: values */
C_values(5,0,t1,t5,t6,t7);}}}

/* process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7032(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr3r,(void*)f_7032r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7032r(t0,t1,t2,t3);}}

static void C_ccall f_7032r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7034,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word)li204),tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7161,a[2]=t4,a[3]=((C_word)li205),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7166,a[2]=t5,a[3]=((C_word)li206),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-arglist15551592 */
t7=t6;
f_7166(t7,t1);}
else{
t7=C_i_car(t3);
t8=C_i_cdr(t3);
if(C_truep(C_i_nullp(t8))){
/* def-envlist15561590 */
t9=t5;
f_7161(t9,t1,t7);}
else{
t9=C_i_car(t8);
t10=C_i_cdr(t8);
if(C_truep(C_i_nullp(t10))){
/* body15531560 */
t11=t4;
f_7034(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-arglist1555 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7166(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7166,NULL,2,t0,t1);}
/* def-envlist15561590 */
t2=((C_word*)t0)[2];
f_7161(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist1556 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7161(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7161,NULL,3,t0,t1,t2);}
/* body15531560 */
t3=((C_word*)t0)[2];
f_7034(t3,t1,t2,C_SCHEME_FALSE);}

/* body1553 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7034(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7034,NULL,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(((C_word*)t0)[5],lf[408]);
t5=C_i_check_list_2(t2,lf[408]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7044,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1874: pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[5]);}

/* k7042 in body1553 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7044,2,t0,t1);}
t2=C_block_size(t1);
t3=f_6994(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7052,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word)li203),tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_7052(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* doloop1564 in k7042 in body1553 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7052(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
a=C_alloc(9);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_7052,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=f_6994(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7065,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=C_i_check_list_2(((C_word*)t0)[5],lf[408]);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7098,a[2]=((C_word*)t0)[3],a[3]=((C_word)li202),tmp=(C_word)a,a+=4,tmp);
t8=t5;
f_7065(t8,f_7098(t7,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_7065(t6,C_SCHEME_UNDEFINED);}}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,lf[408]);
t6=C_block_size(t4);
t7=f_6994(t3,t4,t6);
t8=C_i_cdr(t2);
t9=C_fixnum_plus(t3,C_fix(1));
t15=t1;
t16=t8;
t17=t9;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}

/* doloop1568 in doloop1564 in k7042 in body1553 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_7098(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
C_stack_check;
if(C_truep(C_i_nullp(t1))){
return(f_7013(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=C_i_car(t1);
t4=C_i_check_string_2(t3,lf[408]);
t5=C_block_size(t3);
t6=f_7013(t2,t3,t5);
t7=C_i_cdr(t1);
t8=C_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k7063 in doloop1564 in k7042 in body1553 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_7065(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7065,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7068,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7090,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1888: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,((C_word*)t0)[2]);}

/* k7088 in k7063 in doloop1564 in k7042 in body1553 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1888: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[408]);}

/* k7066 in k7063 in doloop1564 in k7042 in body1553 in process-execute in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_7068(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?C_execve(t1):C_execvp(t1));
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=stub1529(C_SCHEME_UNDEFINED);
t5=stub1541(C_SCHEME_UNDEFINED);
/* posixunix.scm:1895: posix-error */
t6=lf[3];
f_2084(6,t6,((C_word*)t0)[3],lf[199],lf[408],lf[409],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_7013(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=C_i_foreign_fixnum_argumentp(t3);
return(stub1534(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* setarg in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_6994(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=C_i_foreign_fixnum_argumentp(t3);
return(stub1522(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-fork in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6952(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_6952r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6952r(t0,t1,t2);}}

static void C_ccall f_6952r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=stub1497(C_SCHEME_UNDEFINED);
t4=C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm:1859: posix-error */
t5=lf[3];
f_2084(5,t5,t1,lf[199],lf[405],lf[406]);}
else{
t5=C_i_pairp(t2);
t6=(C_truep(t5)?C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=C_i_car(t2);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6977,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* g15051506 */
t9=t7;
((C_proc2)C_retrieve_proc(t9))(2,t9,t8);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k6975 in process-fork in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6977(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_i_foreign_fixnum_argumentp(C_fix(0));
t4=t2;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1510(C_SCHEME_UNDEFINED,t3));}

/* get-host-name in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6938(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6938,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6942,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,stub1491(t3),C_fix(0));}

/* k6940 in get-host-name in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6942(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6942,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6945,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}
else{
/* posixunix.scm:1849: posix-error */
t3=lf[3];
f_2084(5,t3,t2,lf[399],lf[403],lf[404]);}}

/* k6943 in k6940 in get-host-name in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-size in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6903(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6903,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6907,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1830: ##sys#terminal-check */
f_6848(t3,lf[398],t2);}

/* k6905 in terminal-size in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6907,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=C_a_i_bytevector(&a,1,C_fix(1));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6927,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[401]+1)))(6,*((C_word*)lf[401]+1),t4,t2,C_fix(0),C_SCHEME_FALSE,lf[402]);}

/* k6925 in k6905 in terminal-size in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6927(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6927,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6931,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#make-locative */
((C_proc6)C_retrieve_proc(*((C_word*)lf[401]+1)))(6,*((C_word*)lf[401]+1),t2,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,lf[402]);}

/* k6929 in k6925 in k6905 in terminal-size in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6931(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
t2=C_C_fileno(((C_word*)t0)[6]);
t3=((C_word*)t0)[5];
t4=C_i_foreign_fixnum_argumentp(t2);
t5=C_i_foreign_pointer_argumentp(t3);
t6=C_i_foreign_pointer_argumentp(t1);
t7=stub1473(C_SCHEME_UNDEFINED,t4,t5,t6);
t8=C_eqp(C_fix(0),t7);
if(C_truep(t8)){
/* posixunix.scm:1837: values */
C_values(4,0,((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[3]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixunix.scm:1838: posix-error */
t9=lf[3];
f_2084(6,t9,((C_word*)t0)[4],lf[399],lf[398],lf[400],((C_word*)t0)[6]);}}

/* terminal-name in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6880(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6880,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6884,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1822: ##sys#terminal-check */
f_6848(t3,lf[397],t2);}

/* k6882 in terminal-name in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6884(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6884,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=C_C_fileno(((C_word*)t0)[2]);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t3);
t6=stub1463(t4,t5);
/* ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* ##sys#terminal-check in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_6848(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6848,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6852,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1814: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[159]+1)))(4,*((C_word*)lf[159]+1),t4,t3,t2);}

/* k6850 in ##sys#terminal-check in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6852(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=C_slot(((C_word*)t0)[4],C_fix(7));
t3=C_eqp(lf[136],t2);
t4=(C_truep(t3)?C_tty_portp(((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
/* posixunix.scm:1817: ##sys#error */
t5=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[2],lf[396],((C_word*)t0)[4]);}}

/* terminal-port? in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6829(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6829,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6833,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1809: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[159]+1)))(4,*((C_word*)lf[159]+1),t3,t2,lf[394]);}

/* k6831 in terminal-port? in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6833(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6833,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6836,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1810: ##sys#peek-unsigned-integer */
((C_proc4)C_retrieve_proc(*((C_word*)lf[305]+1)))(4,*((C_word*)lf[305]+1),t2,((C_word*)t0)[2],C_fix(0));}

/* k6834 in k6831 in terminal-port? in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6836(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}
else{
t3=C_tty_portp(((C_word*)t0)[2]);
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* set-buffering-mode! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6770(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_6770r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_6770r(t0,t1,t2,t3,t4);}}

static void C_ccall f_6770r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6774,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1794: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[159]+1)))(4,*((C_word*)lf[159]+1),t5,t2,lf[388]);}

/* k6772 in set-buffering-mode! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6774(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6774,2,t0,t1);}
t2=C_i_pairp(((C_word*)t0)[5]);
t3=(C_truep(t2)?C_i_car(((C_word*)t0)[5]):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6780,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=C_eqp(t4,lf[390]);
if(C_truep(t6)){
t7=t5;
f_6780(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=C_eqp(t4,lf[391]);
if(C_truep(t7)){
t8=C_fix((C_word)_IOLBF);
t9=t5;
f_6780(2,t9,t8);}
else{
t8=C_eqp(t4,lf[392]);
if(C_truep(t8)){
t9=t5;
f_6780(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm:1800: ##sys#error */
t9=*((C_word*)lf[20]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[388],lf[393],((C_word*)t0)[4],((C_word*)t0)[2]);}}}}

/* k6778 in k6772 in set-buffering-mode! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6780,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[4],lf[388]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6789,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=C_slot(((C_word*)t0)[2],C_fix(7));
t5=C_eqp(lf[136],t4);
if(C_truep(t5)){
t6=C_setvbuf(((C_word*)t0)[2],t1,((C_word*)t0)[4]);
t7=t3;
f_6789(t7,C_fixnum_lessp(t6,C_fix(0)));}
else{
t6=t3;
f_6789(t6,C_SCHEME_TRUE);}}

/* k6787 in k6778 in k6772 in set-buffering-mode! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_6789(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1806: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[388],lf[389],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* set-alarm! in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6763(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6763,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1438(C_SCHEME_UNDEFINED,t3));}

/* _exit in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6747(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_6747r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6747r(t0,t1,t2);}}

static void C_ccall f_6747r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
if(C_truep(C_i_pairp(t2))){
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,stub1433(C_SCHEME_UNDEFINED,t5));}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub1433(C_SCHEME_UNDEFINED,t4));}}

/* local-timezone-abbreviation in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6735,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,stub1428(t2),C_fix(0));}

/* utc-time->seconds in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6720(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6720,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6724,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1761: check-time-vector */
f_6432(t3,lf[382],t2);}

/* k6722 in utc-time->seconds in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6724(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6724,2,t0,t1);}
t2=C_a_timegm(&a,1,((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6730,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1763: fp= */
((C_proc4)C_retrieve_proc(*((C_word*)lf[380]+1)))(4,*((C_word*)lf[380]+1),t3,lf[384],t2);}

/* k6728 in k6722 in utc-time->seconds in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6730(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1764: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[382],lf[383],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}}

/* local-time->seconds in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6705(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6705,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6709,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1754: check-time-vector */
f_6432(t3,lf[378],t2);}

/* k6707 in local-time->seconds in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6709,2,t0,t1);}
t2=C_a_mktime(&a,1,((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6715,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1756: fp= */
((C_proc4)C_retrieve_proc(*((C_word*)lf[380]+1)))(4,*((C_word*)lf[380]+1),t3,lf[381],t2);}

/* k6713 in k6707 in local-time->seconds in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1757: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[378],lf[379],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}}

/* string->time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6659(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_6659r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6659r(t0,t1,t2,t3);}}

static void C_ccall f_6659r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6663,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_6663(2,t5,lf[377]);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_6663(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k6661 in string->time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6663,2,t0,t1);}
t2=C_i_check_string_2(((C_word*)t0)[3],lf[376]);
t3=C_i_check_string_2(t1,lf[376]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6676,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1751: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,((C_word*)t0)[3],lf[376]);}

/* k6674 in k6661 in string->time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6676,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6680,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1751: ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t2,((C_word*)t0)[2]);}

/* k6678 in k6674 in k6661 in string->time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6680,2,t0,t1);}
t2=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[2];
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub1404(C_SCHEME_UNDEFINED,t4,t1,t2));}

/* time->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6590(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_6590r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6590r(t0,t1,t2,t3);}}

static void C_ccall f_6590r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6594,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_6594(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_6594(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k6592 in time->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6594,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6597,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1735: check-time-vector */
f_6432(t2,lf[373],((C_word*)t0)[2]);}

/* k6595 in k6592 in time->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6597,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=C_i_check_string_2(((C_word*)t0)[4],lf[373]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6606,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6616,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1739: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,((C_word*)t0)[4],lf[373]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6619,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,stub1372(t4,t3),C_fix(0));}}

/* k6617 in k6595 in k6592 in time->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posixunix.scm:1743: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm:1744: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[373],lf[375],((C_word*)t0)[2]);}}

/* k6614 in k6595 in k6592 in time->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6616(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6616,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],stub1378(t3,t2,t1),C_fix(0));}

/* k6604 in k6595 in k6592 in time->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixunix.scm:1740: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[373],lf[374],((C_word*)t0)[2]);}}

/* seconds->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6529(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_6529r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6529r(t0,t1,t2);}}

static void C_ccall f_6529r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6533,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixunix.scm:1724: current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[369]+1)))(2,*((C_word*)lf[369]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_6533(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k6531 in seconds->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6533,2,t0,t1);}
t2=C_i_check_number_2(t1,lf[371]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6539,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=t1;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_integer_argumentp(t4);
t7=stub1353(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k6537 in k6531 in seconds->string in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6539(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posixunix.scm:1728: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm:1729: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[371],lf[372],((C_word*)t0)[2]);}}

/* seconds->utc-time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6485(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_6485r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6485r(t0,t1,t2);}}

static void C_ccall f_6485r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6489,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixunix.scm:1718: current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[369]+1)))(2,*((C_word*)lf[369]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=C_i_car(t2);
t6=C_i_check_number_2(t5,lf[370]);
/* posixunix.scm:1720: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[368]+1)))(4,*((C_word*)lf[368]+1),t1,t5,C_SCHEME_TRUE);}
else{
/* ##sys#error */
t5=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k6487 in seconds->utc-time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[370]);
/* posixunix.scm:1720: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[368]+1)))(4,*((C_word*)lf[368]+1),((C_word*)t0)[2],t1,C_SCHEME_TRUE);}

/* seconds->local-time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6451(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_6451r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6451r(t0,t1,t2);}}

static void C_ccall f_6451r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6455,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posixunix.scm:1714: current-seconds */
((C_proc2)C_retrieve_proc(*((C_word*)lf[369]+1)))(2,*((C_word*)lf[369]+1),t3);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=C_i_car(t2);
t6=C_i_check_number_2(t5,lf[367]);
/* posixunix.scm:1716: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[368]+1)))(4,*((C_word*)lf[368]+1),t1,t5,C_SCHEME_FALSE);}
else{
/* ##sys#error */
t5=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k6453 in seconds->local-time in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[367]);
/* posixunix.scm:1716: ##sys#decode-seconds */
((C_proc4)C_retrieve_proc(*((C_word*)lf[368]+1)))(4,*((C_word*)lf[368]+1),((C_word*)t0)[2],t1,C_SCHEME_FALSE);}

/* check-time-vector in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_6432(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6432,NULL,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm:1712: ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[366],t3);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* memory-mapped-file? in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6426(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6426,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_i_structurep(t2,lf[356]));}

/* memory-mapped-file-pointer in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6417(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6417,3,t0,t1,t2);}
t3=C_i_check_structure_2(t2,lf[356],lf[363]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6382(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_6382r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6382r(t0,t1,t2,t3);}}

static void C_ccall f_6382r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t4=C_i_check_structure_2(t2,lf[356],lf[361]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_i_car(t3):C_slot(t2,C_fix(2)));
t7=C_slot(t2,C_fix(1));
t8=(C_truep(t7)?C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=C_i_foreign_integer_argumentp(t6);
t10=stub1313(C_SCHEME_UNDEFINED,t8,t9);
t11=C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=C_SCHEME_UNDEFINED;
t13=t1;
((C_proc2)(void*)(*((C_word*)t13+1)))(2,t13,t12);}
else{
/* posixunix.scm:1698: posix-error */
t12=lf[3];
f_2084(7,t12,t1,lf[10],lf[361],lf[362],t2,t6);}}

/* map-file-to-memory in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6320(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7r,(void*)f_6320r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest(a,C_rest_count(0));
f_6320r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_6320r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6324,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_6324(2,t10,t2);}
else{
/* posixunix.scm:1683: ##sys#null-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[360]+1)))(2,*((C_word*)lf[360]+1),t8);}}

/* k6322 in map-file-to-memory in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6324(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6324,2,t0,t1);}
t2=C_i_pairp(((C_word*)t0)[7]);
t3=(C_truep(t2)?C_i_car(((C_word*)t0)[7]):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6330,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_blockp(t1))){
if(C_truep(C_specialp(t1))){
t5=t4;
f_6330(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1686: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),t4,lf[15],lf[355],lf[359],t1);}}
else{
/* posixunix.scm:1686: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),t4,lf[15],lf[355],lf[359],t1);}}

/* k6328 in k6322 in map-file-to-memory in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6330,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=C_i_foreign_integer_argumentp(t3);
t10=C_i_foreign_fixnum_argumentp(t4);
t11=C_i_foreign_fixnum_argumentp(t5);
t12=C_i_foreign_fixnum_argumentp(t6);
t13=C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=stub1287(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6336,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6349,a[2]=t14,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=t15,tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1688: ##sys#pointer->address */
((C_proc3)C_retrieve_proc(*((C_word*)lf[358]+1)))(3,*((C_word*)lf[358]+1),t16,t14);}

/* k6347 in k6328 in k6322 in map-file-to-memory in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6349,2,t0,t1);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm:1689: posix-error */
t3=lf[3];
f_2084(11,t3,((C_word*)t0)[10],lf[10],lf[355],lf[357],((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_record(&a,3,lf[356],((C_word*)t0)[2],((C_word*)t0)[8]));}}

/* k6334 in k6328 in k6322 in map-file-to-memory in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6336(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6336,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_record(&a,3,lf[356],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* get-environment-variables in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6217,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6223,a[2]=t3,a[3]=((C_word)li176),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_6223(t5,t1,C_fix(0));}

/* loop in get-environment-variables in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_6223(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6223,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6227,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub1269(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k6225 in loop in get-environment-variables in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6227,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6235,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word)li175),tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_6235(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k6225 in loop in get-environment-variables in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_6235(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6235,NULL,3,t0,t1,t2);}
t3=C_eqp(C_make_character(61),C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6261,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1649: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm:1652: scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k6259 in scan in k6225 in loop in get-environment-variables in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6261,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6265,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=C_block_size(((C_word*)t0)[2]);
/* posixunix.scm:1650: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),t2,((C_word*)t0)[2],t3,t4);}

/* k6263 in k6259 in scan in k6225 in loop in get-environment-variables in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6265,2,t0,t1);}
t2=C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6253,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:1651: loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_6223(t5,t3,t4);}

/* k6251 in k6263 in k6259 in scan in k6225 in loop in get-environment-variables in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6253,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6197(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6197,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[344]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6205,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1638: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t2,lf[344]);}

/* k6203 in unsetenv in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6205(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_unsetenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6180(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6180,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[343]);
t5=C_i_check_string_2(t3,lf[343]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6191,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1633: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t6,t2,lf[343]);}

/* k6189 in setenv in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6191(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6191,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6195,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1633: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t2,((C_word*)t0)[2],lf[343]);}

/* k6193 in k6189 in setenv in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6195(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6154(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6154,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[39]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6161,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6178,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1621: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t5,t2);}

/* k6176 in fifo? in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1621: ##sys#file-info */
((C_proc3)C_retrieve_proc(*((C_word*)lf[342]+1)))(3,*((C_word*)lf[342]+1),((C_word*)t0)[2],t1);}

/* k6159 in fifo? in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm:1624: posix-error */
t2=lf[3];
f_2084(6,t2,((C_word*)t0)[3],lf[10],lf[39],lf[341],((C_word*)t0)[2]);}}

/* create-fifo in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6111(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_6111r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6111r(t0,t1,t2,t3);}}

static void C_ccall f_6111r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=C_i_check_string_2(t2,lf[339]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6118,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t5;
f_6118(t6,C_i_car(t3));}
else{
t6=C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_6118(t7,C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k6116 in create-fifo in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_6118(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6118,NULL,2,t0,t1);}
t2=C_i_check_exact_2(t1,lf[339]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6135,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6139,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1615: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t4,((C_word*)t0)[2]);}

/* k6137 in k6116 in create-fifo in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1615: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[339]);}

/* k6133 in k6116 in create-fifo in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1616: posix-error */
t3=lf[3];
f_2084(7,t3,((C_word*)t0)[3],lf[10],lf[339],lf[340],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* file-unlock in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6083(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6083,3,t0,t1,t2);}
t3=C_i_check_structure_2(t2,lf[330],lf[337]);
t4=C_slot(t2,C_fix(2));
t5=C_slot(t2,C_fix(3));
t6=C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=C_slot(t2,C_fix(1));
t8=C_flock_lock(t7);
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:1605: posix-error */
t9=lf[3];
f_2084(6,t9,t1,lf[10],lf[337],lf[338],t2);}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}}

/* file-test-lock in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6056(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6056r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6056r(t0,t1,t2,t3);}}

static void C_ccall f_6056r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6060,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1596: setup */
f_5934(t4,t2,t3,lf[335]);}

/* k6058 in file-test-lock in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=C_eqp(t2,C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_truep(t4)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm:1598: err */
f_6008(((C_word*)t0)[3],lf[336],t1,lf[335]);}}

/* file-lock/blocking in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6041(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6041r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6041r(t0,t1,t2,t3);}}

static void C_ccall f_6041r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6045,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1590: setup */
f_5934(t4,t2,t3,lf[333]);}

/* k6043 in file-lock/blocking in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm:1592: err */
f_6008(((C_word*)t0)[2],lf[334],t1,lf[333]);}
else{
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* file-lock in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6026(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_6026r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6026r(t0,t1,t2,t3);}}

static void C_ccall f_6026r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6030,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1584: setup */
f_5934(t4,t2,t3,lf[331]);}

/* k6028 in file-lock in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_6030(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm:1586: err */
f_6008(((C_word*)t0)[2],lf[332],t1,lf[331]);}
else{
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* err in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_6008(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6008,NULL,4,t1,t2,t3,t4);}
t5=C_slot(t3,C_fix(1));
t6=C_slot(t3,C_fix(2));
t7=C_slot(t3,C_fix(3));
/* posixunix.scm:1581: posix-error */
t8=lf[3];
f_2084(8,t8,t1,lf[10],t4,t2,t5,t6,t7);}

/* setup in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5934(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5934,NULL,4,t1,t2,t3,t4);}
t5=C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):C_i_car(t3));
t7=C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
if(C_truep(C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5956,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1573: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[159]+1)))(4,*((C_word*)lf[159]+1),t15,t2,t4);}
else{
/* ##sys#error */
t15=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}

/* k5954 in setup in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5956(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5956,2,t0,t1);}
t2=C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5962,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_5962(t6,t5);}
else{
t5=t3;
f_5962(t5,C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k5960 in k5954 in setup in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5962(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5962,NULL,2,t0,t1);}
t2=C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_record(&a,4,lf[330],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5895(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[15],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5895,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[327]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5905,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5912,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5919,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5923,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1556: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t8,t2);}
else{
if(C_truep(C_fixnump(t2))){
t7=C_ftruncate(t2,t3);
t8=t5;
f_5905(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
/* posixunix.scm:1558: ##sys#error */
t7=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,lf[327],lf[329],t2);}}}

/* k5921 in file-truncate in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5923(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1556: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[327]);}

/* k5917 in file-truncate in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5919(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_truncate(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
f_5905(t3,C_fixnum_lessp(t2,C_fix(0)));}

/* k5910 in file-truncate in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5905(t2,C_fixnum_lessp(t1,C_fix(0)));}

/* k5903 in file-truncate in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5905(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1560: posix-error */
t2=lf[3];
f_2084(7,t2,((C_word*)t0)[4],lf[10],lf[327],lf[328],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5636(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+18)){
C_save_and_reclaim((void*)tr5r,(void*)f_5636r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_5636r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_5636r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(18);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5638,a[2]=t3,a[3]=t2,a[4]=t4,a[5]=((C_word)li159),tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5822,a[2]=t6,a[3]=((C_word)li160),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5827,a[2]=t7,a[3]=((C_word)li161),tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5832,a[2]=t8,a[3]=((C_word)li162),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t5))){
/* def-nonblocking?11431192 */
t10=t9;
f_5832(t10,t1);}
else{
t10=C_i_car(t5);
t11=C_i_cdr(t5);
if(C_truep(C_i_nullp(t11))){
/* def-bufi11441190 */
t12=t8;
f_5827(t12,t1,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* def-on-close11451187 */
t14=t7;
f_5822(t14,t1,t10,t12);}
else{
t14=C_i_car(t13);
t15=C_i_cdr(t13);
if(C_truep(C_i_nullp(t15))){
/* body11411149 */
t16=t6;
f_5638(t16,t1,t10,t12,t14);}
else{
/* ##sys#error */
t16=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t1,lf[0],t15);}}}}}

/* def-nonblocking?1143 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5832(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5832,NULL,2,t0,t1);}
/* def-bufi11441190 */
t2=((C_word*)t0)[2];
f_5827(t2,t1,C_SCHEME_FALSE);}

/* def-bufi1144 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5827(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5827,NULL,3,t0,t1,t2);}
/* def-on-close11451187 */
t3=((C_word*)t0)[2];
f_5822(t3,t1,t2,C_fix(0));}

/* def-on-close1145 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5822(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5822,NULL,4,t0,t1,t2,t3);}
/* body11411149 */
t4=((C_word*)t0)[2];
f_5638(t4,t1,t2,t3,*((C_word*)lf[322]+1));}

/* body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5638(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5638,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5642,a[2]=t4,a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
/* posixunix.scm:1498: ##sys#file-nonblocking! */
t6=*((C_word*)lf[77]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[4]);}
else{
t6=t5;
f_5642(2,t6,C_SCHEME_UNDEFINED);}}

/* k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5642(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5642,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5644,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t3,a[5]=((C_word*)t0)[7],a[6]=((C_word)li152),tmp=(C_word)a,a+=7,tmp));
t7=C_fixnump(((C_word*)t0)[4]);
t8=(C_truep(t7)?((C_word*)t0)[4]:C_block_size(((C_word*)t0)[4]));
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5690,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[3],a[7]=t5,tmp=(C_word)a,a+=8,tmp);
t10=C_eqp(C_fix(0),t8);
if(C_truep(t10)){
t11=t9;
f_5690(t11,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5734,a[2]=t3,a[3]=((C_word)li156),tmp=(C_word)a,a+=4,tmp));}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5748,a[2]=t3,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm:1517: ##sys#make-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[319]+1)))(3,*((C_word*)lf[319]+1),t11,((C_word*)t0)[4]);}
else{
t12=t11;
f_5748(2,t12,((C_word*)t0)[4]);}}}

/* k5746 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5748(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5748,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[4];
f_5690(t4,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5749,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word)li158),tmp=(C_word)a,a+=7,tmp));}

/* f_5749 in k5746 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5749(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5749,3,t0,t1,t2);}
if(C_truep(t2)){
t3=C_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5766,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t6,a[7]=((C_word*)t0)[4],a[8]=((C_word)li157),tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_5766(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep(C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:1533: poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_5644(t3,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* loop */
static void C_fcall f_5766(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5766,NULL,5,t0,t1,t2,t3,t4);}
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5776,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1523: poke */
t7=((C_word*)((C_word*)t0)[4])[1];
f_5644(t7,t6,((C_word*)t0)[3],((C_word*)t0)[5]);}
else{
if(C_truep(C_fixnum_lessp(t2,t4))){
t6=C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t2,((C_word*)((C_word*)t0)[7])[1]);
t7=C_fixnum_difference(t4,t2);
/* posixunix.scm:1528: loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t4,((C_word*)((C_word*)t0)[7])[1]);
t7=C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[7])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k5774 in loop */
static void C_ccall f_5776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_fix(0));
/* posixunix.scm:1525: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_5766(t3,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* f_5734 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5734(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5734,3,t0,t1,t2);}
if(C_truep(t2)){
t3=C_block_size(t2);
/* posixunix.scm:1516: poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_5644(t4,t1,t2,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k5688 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5690(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5690,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[7])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5694,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5699,a[2]=((C_word*)t0)[7],a[3]=((C_word)li153),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5705,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t4,a[7]=((C_word)li154),tmp=(C_word)a,a+=8,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5726,a[2]=((C_word*)t0)[7],a[3]=((C_word)li155),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1536: make-output-port */
((C_proc5)C_retrieve_proc(*((C_word*)lf[326]+1)))(5,*((C_word*)lf[326]+1),t5,t6,t7,t8);}

/* a5725 in k5688 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5726,2,t0,t1);}
/* posixunix.scm:1546: store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_FALSE);}

/* a5704 in k5688 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5705,2,t0,t1);}
if(C_truep(C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5715,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm:1543: posix-error */
t3=lf[3];
f_2084(7,t3,t2,lf[10],((C_word*)t0)[3],lf[325],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
/* posixunix.scm:1544: on-close */
t3=((C_word*)t0)[5];
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}}}

/* k5713 in a5704 in k5688 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1544: on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a5698 in k5688 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5699(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5699,3,t0,t1,t2);}
/* posixunix.scm:1538: store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t3))(3,t3,t1,t2);}

/* k5692 in k5688 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5694,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5697,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1547: set-port-name! */
((C_proc4)C_retrieve_proc(*((C_word*)lf[315]+1)))(4,*((C_word*)lf[315]+1),t3,((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[2]);}

/* k5695 in k5692 in k5688 in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* poke in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5644(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5644,NULL,4,t0,t1,t2,t3);}
t4=C_write(((C_word*)t0)[5],t2,t3);
t5=C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
t6=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5660,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1506: ##sys#thread-yield! */
((C_proc2)C_retrieve_proc(*((C_word*)lf[310]+1)))(2,*((C_word*)lf[310]+1),t7);}
else{
/* posixunix.scm:1508: posix-error */
t7=lf[3];
f_2084(7,t7,t1,((C_word*)t0)[3],lf[10],lf[324],((C_word*)t0)[5],((C_word*)t0)[2]);}}
else{
if(C_truep(C_fixnum_lessp(t4,t3))){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5679,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1510: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),t6,t2,t4,t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}}

/* k5677 in poke in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[4]);
/* posixunix.scm:1510: poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_5644(t3,((C_word*)t0)[2],t1,t2);}

/* k5658 in poke in k5640 in body1141 in ##sys#custom-output-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5660(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1507: poke */
t2=((C_word*)((C_word*)t0)[5])[1];
f_5644(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5154(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+22)){
C_save_and_reclaim((void*)tr5r,(void*)f_5154r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_5154r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_5154r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(22);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5156,a[2]=t3,a[3]=t4,a[4]=t2,a[5]=((C_word)li146),tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5543,a[2]=t6,a[3]=((C_word)li147),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5548,a[2]=t7,a[3]=((C_word)li148),tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5553,a[2]=t8,a[3]=((C_word)li149),tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5558,a[2]=t9,a[3]=((C_word)li150),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t5))){
/* def-nonblocking?10091119 */
t11=t10;
f_5558(t11,t1);}
else{
t11=C_i_car(t5);
t12=C_i_cdr(t5);
if(C_truep(C_i_nullp(t12))){
/* def-bufi10101117 */
t13=t9;
f_5553(t13,t1,t11);}
else{
t13=C_i_car(t12);
t14=C_i_cdr(t12);
if(C_truep(C_i_nullp(t14))){
/* def-on-close10111114 */
t15=t8;
f_5548(t15,t1,t11,t13);}
else{
t15=C_i_car(t14);
t16=C_i_cdr(t14);
if(C_truep(C_i_nullp(t16))){
/* def-more?10121110 */
t17=t7;
f_5543(t17,t1,t11,t13,t15);}
else{
t17=C_i_car(t16);
t18=C_i_cdr(t16);
if(C_truep(C_i_nullp(t18))){
/* body10071016 */
t19=t6;
f_5156(t19,t1,t11,t13,t15,t17);}
else{
/* ##sys#error */
t19=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t19+1)))(4,t19,t1,lf[0],t18);}}}}}}

/* def-nonblocking?1009 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5558(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5558,NULL,2,t0,t1);}
/* def-bufi10101117 */
t2=((C_word*)t0)[2];
f_5553(t2,t1,C_SCHEME_FALSE);}

/* def-bufi1010 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5553(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5553,NULL,3,t0,t1,t2);}
/* def-on-close10111114 */
t3=((C_word*)t0)[2];
f_5548(t3,t1,t2,C_fix(1));}

/* def-on-close1011 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5548(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5548,NULL,4,t0,t1,t2,t3);}
/* def-more?10121110 */
t4=((C_word*)t0)[2];
f_5543(t4,t1,t2,t3,*((C_word*)lf[322]+1));}

/* def-more?1012 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5543(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5543,NULL,5,t0,t1,t2,t3,t4);}
/* body10071016 */
t5=((C_word*)t0)[2];
f_5156(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5156(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5156,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5160,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t2)){
/* posixunix.scm:1374: ##sys#file-nonblocking! */
t7=*((C_word*)lf[77]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[3]);}
else{
t7=t6;
f_5160(2,t7,C_SCHEME_UNDEFINED);}}

/* k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5160,2,t0,t1);}
t2=C_fixnump(((C_word*)t0)[8]);
t3=(C_truep(t2)?((C_word*)t0)[8]:C_block_size(((C_word*)t0)[8]));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5166,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t3,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[8]))){
/* posixunix.scm:1376: ##sys#make-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[319]+1)))(3,*((C_word*)lf[319]+1),t4,((C_word*)t0)[8]);}
else{
t5=t4;
f_5166(2,t5,((C_word*)t0)[8]);}}

/* k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word ab[72],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5166,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5167,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word)li132),tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5190,a[2]=t1,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5198,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[7],a[8]=t3,a[9]=t5,a[10]=((C_word)li134),tmp=(C_word)a,a+=11,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5280,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=t10,tmp=(C_word)a,a+=5,tmp);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5285,a[2]=t8,a[3]=t5,a[4]=t7,a[5]=((C_word)li135),tmp=(C_word)a,a+=6,tmp);
t13=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5298,a[2]=t6,a[3]=t3,a[4]=t5,a[5]=((C_word)li136),tmp=(C_word)a,a+=6,tmp);
t14=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5310,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[2],a[6]=t10,a[7]=((C_word)li137),tmp=(C_word)a,a+=8,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5331,a[2]=t8,a[3]=t7,a[4]=((C_word)li138),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5340,a[2]=t8,a[3]=t1,a[4]=t3,a[5]=t5,a[6]=((C_word)li140),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5416,a[2]=t1,a[3]=t8,a[4]=t3,a[5]=t5,a[6]=((C_word)li145),tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1424: make-input-port */
((C_proc8)C_retrieve_proc(*((C_word*)lf[321]+1)))(8,*((C_word*)lf[321]+1),t11,t12,t13,t14,t15,t16,t17);}

/* a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5416(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5416,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5422,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word)li144),tmp=(C_word)a,a+=9,tmp));
t7=((C_word*)t5)[1];
f_5422(t7,t1,C_SCHEME_FALSE);}

/* loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5422(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5422,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5424,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li141),tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5502,a[2]=t3,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],a[6]=((C_word)li142),tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5508,a[2]=((C_word*)t0)[2],a[3]=((C_word)li143),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5518,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1489: fetch */
t5=((C_word*)t0)[5];
f_5198(t5,t4);}}

/* k5516 in loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
/* posixunix.scm:1491: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5422(t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}}

/* a5507 in loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5508(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5508,4,t0,t1,t2,t3);}
if(C_truep(t3)){
/* posixunix.scm:1486: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_5422(t4,t1,t2);}
else{
t4=t2;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* a5501 in loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5502(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5502,2,t0,t1);}
/* posixunix.scm:1484: ##sys#scan-buffer-line */
((C_proc6)C_retrieve_proc(*((C_word*)lf[320]+1)))(6,*((C_word*)lf[320]+1),t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]);}

/* bumper in loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5424(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5424,4,t0,t1,t2,t3);}
t4=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[7])[1]);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5431,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t6=C_eqp(C_fix(0),t4);
if(C_truep(t6)){
t7=((C_word*)t0)[3];
t8=t5;
f_5431(2,t8,(C_truep(t7)?t7:lf[317]));}
else{
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5474,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1466: ##sys#make-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[319]+1)))(3,*((C_word*)lf[319]+1),t7,t4);}}

/* k5472 in bumper in loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
t2=C_substring_copy(((C_word*)t0)[8],t1,((C_word*)((C_word*)t0)[7])[1],((C_word*)t0)[6],C_fix(0));
t3=C_slot(((C_word*)t0)[5],C_fix(5));
t4=C_fixnum_plus(t3,((C_word*)t0)[4]);
t5=C_i_set_i_slot(((C_word*)t0)[5],C_fix(5),t4);
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm:1472: ##sys#string-append */
((C_proc4)C_retrieve_proc(*((C_word*)lf[318]+1)))(4,*((C_word*)lf[318]+1),((C_word*)t0)[2],((C_word*)t0)[3],t1);}
else{
t6=t1;
t7=((C_word*)t0)[2];
f_5431(2,t7,t6);}}

/* k5429 in bumper in loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5431(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5431,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[8])+1,((C_word*)t0)[7]);
t3=C_eqp(((C_word*)t0)[6],((C_word*)t0)[7]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5441,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1476: fetch */
t5=((C_word*)t0)[3];
f_5198(t5,t4);}
else{
t4=C_slot(((C_word*)t0)[2],C_fix(4));
t5=C_fixnum_plus(t4,C_fix(1));
t6=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t5);
t7=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
/* posixunix.scm:1481: values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}

/* k5439 in k5429 in bumper in loop in a5415 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5441(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
/* posixunix.scm:1477: values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* a5339 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5340(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5340,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5348,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_5348(t7,t3);}
else{
t7=C_block_size(t4);
t8=t6;
f_5348(t8,C_fixnum_difference(t7,t5));}}

/* k5346 in a5339 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5348(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5348,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5350,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li139),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_5350(t5,((C_word*)t0)[3],t1,C_fix(0),((C_word*)t0)[2]);}

/* loop in k5346 in a5339 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5350(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5350,NULL,5,t0,t1,t2,t3,t4);}
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t3;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[7])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t10=C_substring_copy(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[7])[1],t9,t4);
t11=C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t12=C_mutate(((C_word *)((C_word*)t0)[7])+1,t11);
t13=C_fixnum_difference(t2,t8);
t14=C_fixnum_plus(t3,t8);
t15=C_fixnum_plus(t4,t8);
/* posixunix.scm:1452: loop */
t19=t1;
t20=t13;
t21=t14;
t22=t15;
t1=t19;
t2=t20;
t3=t21;
t4=t22;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5398,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t3,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1454: fetch */
t7=((C_word*)t0)[2];
f_5198(t7,t6);}}}

/* k5396 in loop in k5346 in a5339 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),((C_word*)((C_word*)t0)[7])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[6];
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
/* posixunix.scm:1457: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_5350(t3,((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[6],((C_word*)t0)[2]);}}

/* a5330 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5331,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5335,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1442: fetch */
t3=((C_word*)t0)[2];
f_5198(t3,t2);}

/* k5333 in a5330 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1443: peek */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,f_5190(((C_word*)t0)[2]));}

/* a5309 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5310,2,t0,t1);}
if(C_truep(C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5320,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm:1439: posix-error */
t3=lf[3];
f_2084(7,t3,t2,lf[10],((C_word*)t0)[3],lf[316],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
/* posixunix.scm:1440: on-close */
t3=((C_word*)t0)[5];
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}}}

/* k5318 in a5309 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1440: on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a5297 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5298,2,t0,t1);}
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm:1434: ready? */
t3=((C_word*)t0)[2];
f_5167(t3,t1);}}

/* a5284 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5285,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5289,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1426: fetch */
t3=((C_word*)t0)[2];
f_5198(t3,t2);}

/* k5287 in a5284 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_5190(((C_word*)t0)[4]);
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[3])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

/* k5278 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5280,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5283,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1493: set-port-name! */
((C_proc4)C_retrieve_proc(*((C_word*)lf[315]+1)))(4,*((C_word*)lf[315]+1),t3,((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[2]);}

/* k5281 in k5278 in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5283(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* fetch in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5198(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5198,NULL,2,t0,t1);}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[9])[1],((C_word*)((C_word*)t0)[8])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5210,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],a[11]=((C_word)li133),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];
f_5210(t5,t1);}
else{
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* loop in fetch in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5210(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5210,NULL,2,t0,t1);}
t2=C_read(((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5226,a[2]=t1,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1401: ##sys#thread-block-for-i/o! */
((C_proc5)C_retrieve_proc(*((C_word*)lf[311]+1)))(5,*((C_word*)lf[311]+1),t5,*((C_word*)lf[312]+1),((C_word*)t0)[10],C_SCHEME_TRUE);}
else{
/* posixunix.scm:1404: posix-error */
t5=lf[3];
f_2084(7,t5,t1,lf[10],((C_word*)t0)[6],lf[313],((C_word*)t0)[10],((C_word*)t0)[5]);}}
else{
t4=(C_truep(((C_word*)t0)[4])?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5247,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1408: more? */
t6=((C_word*)t0)[4];
((C_proc2)C_retrieve_proc(t6))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t6=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k5245 in loop in fetch in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5247,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5250,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1410: ##sys#thread-yield! */
((C_proc2)C_retrieve_proc(*((C_word*)lf[310]+1)))(2,*((C_word*)lf[310]+1),t2);}
else{
t2=C_read(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5256,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=C_set_block_item(t3,0,C_fix(0));
t8=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)t3)[1]);
t9=C_set_block_item(((C_word*)t0)[4],0,C_fix(0));
t10=((C_word*)t0)[9];
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}
else{
/* posixunix.scm:1416: posix-error */
t7=lf[3];
f_2084(7,t7,t4,lf[10],((C_word*)t0)[3],lf[314],((C_word*)t0)[8],((C_word*)t0)[2]);}}
else{
t6=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)t3)[1]);
t7=C_set_block_item(((C_word*)t0)[4],0,C_fix(0));
t8=((C_word*)t0)[9];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}}

/* k5254 in k5245 in loop in fetch in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)((C_word*)t0)[4])[1]);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5248 in k5245 in loop in fetch in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1411: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_5210(t2,((C_word*)t0)[2]);}

/* k5224 in loop in fetch in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5226(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5226,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5229,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1402: ##sys#thread-yield! */
((C_proc2)C_retrieve_proc(*((C_word*)lf[310]+1)))(2,*((C_word*)lf[310]+1),t2);}

/* k5227 in k5224 in loop in fetch in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1403: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_5210(t2,((C_word*)t0)[2]);}

/* peek in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_5190(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
C_stack_check;
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]))){
return(C_SCHEME_END_OF_FILE);}
else{
t1=C_subchar(((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);
return(t1);}}

/* ready? in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5167(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5167,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5171,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1382: ##sys#file-select-one */
t3=*((C_word*)lf[78]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* k5169 in ready? in k5164 in k5158 in body1007 in ##sys#custom-input-port in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t3)){
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
/* posixunix.scm:1386: posix-error */
t4=lf[3];
f_2084(7,t4,((C_word*)t0)[5],lf[10],((C_word*)t0)[4],lf[309],((C_word*)t0)[3],((C_word*)t0)[2]);}}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_eqp(C_fix(1),t1));}}

/* duplicate-fileno in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5127(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5127r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5127r(t0,t1,t2,t3);}}

static void C_ccall f_5127r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[306]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5134,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_5134(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[306]);
t8=t5;
f_5134(t8,C_dup2(t2,t6));}}

/* k5132 in duplicate-fileno in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5134(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5134,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5137,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1369: posix-error */
t3=lf[3];
f_2084(6,t3,t2,lf[10],lf[306],lf[307],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k5135 in k5132 in duplicate-fileno in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5082(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5082,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5086,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1351: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[159]+1)))(4,*((C_word*)lf[159]+1),t3,t2,lf[301]);}

/* k5084 in port->fileno in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5086(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5086,2,t0,t1);}
t2=C_slot(((C_word*)t0)[3],C_fix(7));
t3=C_eqp(lf[33],t2);
if(C_truep(t3)){
/* posixunix.scm:1352: ##sys#tcp-port->fileno */
((C_proc3)C_retrieve_proc(*((C_word*)lf[302]+1)))(3,*((C_word*)lf[302]+1),((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5121,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1353: ##sys#peek-unsigned-integer */
((C_proc4)C_retrieve_proc(*((C_word*)lf[305]+1)))(4,*((C_word*)lf[305]+1),t4,((C_word*)t0)[3],C_fix(0));}}

/* k5119 in k5084 in port->fileno in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5121(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5121,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posixunix.scm:1358: posix-error */
t2=lf[3];
f_2084(6,t2,((C_word*)t0)[3],lf[15],lf[301],lf[303],((C_word*)t0)[2]);}
else{
t2=C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5104,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1356: posix-error */
t4=lf[3];
f_2084(6,t4,t3,lf[10],lf[301],lf[304],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* k5102 in k5119 in k5084 in port->fileno in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5104(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5068(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5068r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5068r(t0,t1,t2,t3);}}

static void C_ccall f_5068r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[300]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5080,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1347: mode */
f_5002(t5,C_SCHEME_FALSE,t3,lf[300]);}

/* k5078 in open-output-file* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5080,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm:1347: check */
f_5039(((C_word*)t0)[2],lf[300],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5054(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5054r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5054r(t0,t1,t2,t3);}}

static void C_ccall f_5054r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[299]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5066,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1343: mode */
f_5002(t5,C_SCHEME_TRUE,t3,lf[299]);}

/* k5064 in open-input-file* in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5066,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm:1343: check */
f_5039(((C_word*)t0)[2],lf[299],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5039(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5039,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posixunix.scm:1336: posix-error */
t6=lf[3];
f_2084(6,t6,t1,lf[10],t2,lf[297],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5052,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1337: ##sys#make-port */
((C_proc6)C_retrieve_proc(*((C_word*)lf[148]+1)))(6,*((C_word*)lf[148]+1),t6,t4,*((C_word*)lf[149]+1),lf[298],lf[136]);}}

/* k5050 in check in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=t1;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* mode in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_5002(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5002,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5010,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=C_i_car(t3);
t7=C_eqp(t6,lf[291]);
if(C_truep(t7)){
t8=t2;
if(C_truep(t8)){
/* posixunix.scm:1329: ##sys#error */
t9=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[292],t6);}
else{
/* posixunix.scm:1325: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[293],t4);}}
else{
/* posixunix.scm:1330: ##sys#error */
t8=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t5,lf[294],t6);}}
else{
if(C_truep(t2)){
/* posixunix.scm:1325: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[295],t4);}
else{
/* posixunix.scm:1325: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[296],t4);}}}

/* k5008 in mode in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_5010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1325: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* file-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4977(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4977,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[285]);
t5=C_i_check_string_2(t3,lf[285]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4990,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=t2;
t8=t3;
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4958,a[2]=t8,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t7)){
t10=C_i_foreign_string_argumentp(t7);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t9,t10);}
else{
t10=t9;
f_4958(2,t10,C_SCHEME_FALSE);}}

/* k4956 in file-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4958,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4962,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t2,t3);}
else{
t3=stub938(C_SCHEME_UNDEFINED,t1,C_SCHEME_FALSE);
t4=((C_word*)t0)[3];
f_4990(t4,C_fixnum_lessp(t3,C_fix(0)));}}

/* k4960 in k4956 in file-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=stub938(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
f_4990(t3,C_fixnum_lessp(t2,C_fix(0)));}

/* k4988 in file-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4990(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1310: posix-error */
t2=lf[3];
f_2084(7,t2,((C_word*)t0)[4],lf[10],lf[286],lf[287],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* read-symbolic-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4893(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3r,(void*)f_4893r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4893r(t0,t1,t2,t3);}}

static void C_ccall f_4893r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4897,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_4897(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_4897(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k4895 in read-symbolic-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4897,2,t0,t1);}
t2=C_i_check_string_2(((C_word*)t0)[5],lf[282]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4904,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4932,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1296: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t4,((C_word*)t0)[5]);}

/* k4930 in k4895 in read-symbolic-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4932(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1296: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[282]);}

/* k4902 in k4895 in read-symbolic-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4904(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4904,2,t0,t1);}
t2=C_do_readlink(t1,((C_word*)t0)[6]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4907,a[2]=t2,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1298: posix-error */
t4=lf[3];
f_2084(6,t4,t3,lf[10],lf[282],lf[284],((C_word*)t0)[2]);}
else{
t4=t3;
f_4907(2,t4,C_SCHEME_UNDEFINED);}}

/* k4905 in k4902 in k4895 in read-symbolic-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4907,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4910,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1299: substring */
t3=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t3))(5,t3,t2,((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* k4908 in k4905 in k4902 in k4895 in read-symbolic-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4910(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4910,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4916,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm:1300: symbolic-link? */
t3=*((C_word*)lf[36]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}
else{
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4914 in k4908 in k4905 in k4902 in k4895 in read-symbolic-link in k4890 in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1301: read-symbolic-link */
t2=*((C_word*)lf[282]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[283]);}
else{
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* create-symbolic-link in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4855(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4855,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[278]);
t5=C_i_check_string_2(t3,lf[278]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4876,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4888,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1284: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* k4886 in create-symbolic-link in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1284: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[278]);}

/* k4874 in create-symbolic-link in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4876,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4880,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4884,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1285: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,((C_word*)t0)[2]);}

/* k4882 in k4874 in create-symbolic-link in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4884(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1285: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[278]);}

/* k4878 in k4874 in create-symbolic-link in k4851 in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_symlink(((C_word*)t0)[5],t1);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1287: posix-error */
t3=lf[3];
f_2084(7,t3,((C_word*)t0)[4],lf[10],lf[279],lf[280],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* create-session in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4836(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4836,2,t0,t1);}
t2=C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4840,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4846,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1254: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4844 in create-session in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4846(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1255: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[275],lf[276]);}

/* k4838 in create-session in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4840(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4830(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4830,3,t0,t1,t2);}
/* posixunix.scm:1249: check */
f_4794(t1,t2,C_fix((C_word)X_OK),lf[274]);}

/* file-write-access? in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4824(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4824,3,t0,t1,t2);}
/* posixunix.scm:1248: check */
f_4794(t1,t2,C_fix((C_word)W_OK),lf[273]);}

/* file-read-access? in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4818(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4818,3,t0,t1,t2);}
/* posixunix.scm:1247: check */
f_4794(t1,t2,C_fix((C_word)R_OK),lf[272]);}

/* check in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4794(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4794,NULL,4,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4812,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4816,a[2]=t4,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1244: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* k4814 in check in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1244: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k4810 in check in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4812,2,t0,t1);}
t2=C_test_access(t1,((C_word*)t0)[3]);
t3=C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4804,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t3);}
else{
/* posixunix.scm:1245: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}}

/* k4802 in k4810 in check in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4804(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-owner in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4764(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4764,5,t0,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,lf[270]);
t6=C_i_check_exact_2(t3,lf[270]);
t7=C_i_check_exact_2(t4,lf[270]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4788,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4792,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1234: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t9,t2);}

/* k4790 in change-file-owner in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1234: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[270]);}

/* k4786 in change-file-owner in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1235: posix-error */
t3=lf[3];
f_2084(8,t3,((C_word*)t0)[3],lf[10],lf[270],lf[271],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* change-file-mode in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4737(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4737,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[268]);
t5=C_i_check_exact_2(t3,lf[268]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4758,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4762,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1226: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* k4760 in change-file-mode in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4762(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1226: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[268]);}

/* k4756 in change-file-mode in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_chmod(t1,((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1227: posix-error */
t3=lf[3];
f_2084(7,t3,((C_word*)t0)[3],lf[10],lf[268],lf[269],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* initialize-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4673(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4673,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[227]);
t5=C_i_check_exact_2(t3,lf[227]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4661,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
((C_proc3)C_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t8,t9);}
else{
t9=t8;
f_4661(2,t9,C_SCHEME_FALSE);}}

/* k4659 in initialize-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4661,2,t0,t1);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t3=stub866(C_SCHEME_UNDEFINED,t1,t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4689,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1147: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k4687 in k4659 in initialize-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1148: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[227],lf[228],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4599(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4599,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4603,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_i_length(t2);
t5=C_i_foreign_fixnum_argumentp(t4);
if(C_truep(stub839(C_SCHEME_UNDEFINED,t5))){
t6=t3;
f_4603(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1130: ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[224],lf[226]);}}

/* k4601 in set-groups! in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4603,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4608,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word)li113),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_4608(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* doloop853 in k4601 in set-groups! in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4608(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4608,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
if(C_truep(C_fixnum_lessp(C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4624,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1135: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_exact_2(t4,lf[224]);
t6=C_set_gid(t3,t4);
t7=C_slot(t2,C_fix(1));
t8=C_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k4622 in doloop853 in k4601 in set-groups! in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1136: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[224],lf[225],((C_word*)t0)[2]);}

/* get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4536(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4536,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4540,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4594,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1116: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}
else{
t4=t3;
f_4540(2,t4,C_SCHEME_UNDEFINED);}}

/* k4592 in get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1117: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[220],lf[223]);}

/* k4538 in get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4540(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4540,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4543,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
if(C_truep(stub839(C_SCHEME_UNDEFINED,t3))){
t4=t2;
f_4543(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1119: ##sys#error */
t4=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[220],lf[222]);}}

/* k4541 in k4538 in get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4543(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4543,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4546,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=stub835(C_SCHEME_UNDEFINED,t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4575,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1121: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}
else{
t5=t2;
f_4546(2,t5,C_SCHEME_UNDEFINED);}}

/* k4573 in k4541 in k4538 in get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1122: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[220],lf[221]);}

/* k4544 in k4541 in k4538 in get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4546,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4551,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word)li111),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_4551(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k4544 in k4541 in k4538 in get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4551(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4551,NULL,3,t0,t1,t2);}
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4565,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm:1126: loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k4563 in loop in k4544 in k4541 in k4538 in get-groups in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4565(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4565,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,C_get_gid(((C_word*)t0)[2]),t1));}

/* group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4443(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4443r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4443r(t0,t1,t2,t3);}}

static void C_ccall f_4443r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4447,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_4447(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_4447(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4447,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4450,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f_4450(t3,C_getgrgid(((C_word*)t0)[2]));}
else{
t3=C_i_check_string_2(((C_word*)t0)[2],lf[219]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4501,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1090: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,((C_word*)t0)[2],lf[219]);}}

/* k4499 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_4450(t2,C_getgrnam(t1));}

/* k4448 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4450(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4450,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[3])?*((C_word*)lf[215]+1):*((C_word*)lf[216]+1));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4463,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k4461 in k4448 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4463,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4467,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k4465 in k4461 in k4448 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4467,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4471,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4473,a[2]=t4,a[3]=((C_word)li109),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_4473(t6,t2,C_fix(0));}

/* loop in k4465 in k4461 in k4448 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4473(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4473,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4477,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub810(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k4475 in loop in k4465 in k4461 in k4448 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4477,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4487,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:1099: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4473(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k4485 in k4475 in loop in k4465 in k4461 in k4448 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4487(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4487,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k4469 in k4465 in k4461 in k4448 in k4445 in group-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4471(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* g828829 */
t2=((C_word*)t0)[5];
((C_proc6)C_retrieve_proc(t2))(6,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* current-effective-user-name in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4418(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4418,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4426,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4430,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1075: current-effective-user-id */
t4=*((C_word*)lf[211]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4428 in current-effective-user-name in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1075: user-information */
t2=*((C_word*)lf[214]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4424 in current-effective-user-name in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4426(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_i_car(t1));}

/* current-user-name in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4404(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4404,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4412,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4416,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1072: current-user-id */
t4=*((C_word*)lf[210]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4414 in current-user-name in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1072: user-information */
t2=*((C_word*)lf[214]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4410 in current-user-name in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4412(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_i_car(t1));}

/* user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4337(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4337r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4337r(t0,t1,t2,t3);}}

static void C_ccall f_4337r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4341,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_4341(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_4341(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4341,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4344,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f_4344(t3,C_getpwuid(((C_word*)t0)[2]));}
else{
t3=C_i_check_string_2(((C_word*)t0)[2],lf[214]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4383,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1060: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,((C_word*)t0)[2],lf[214]);}}

/* k4381 in k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_4344(t2,C_getpwnam(t1));}

/* k4342 in k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4344(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4344,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[3])?*((C_word*)lf[215]+1):*((C_word*)lf[216]+1));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4357,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k4355 in k4342 in k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4357(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4357,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4361,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k4359 in k4355 in k4342 in k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4361,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4365,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k4363 in k4359 in k4355 in k4342 in k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4365(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4365,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4369,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k4367 in k4363 in k4359 in k4355 in k4342 in k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4369(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4369,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4373,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k4371 in k4367 in k4363 in k4359 in k4355 in k4342 in k4339 in user-information in k4333 in k4329 in k4325 in k4321 in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4373(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* g807808 */
t2=((C_word*)t0)[7];
((C_proc9)C_retrieve_proc(t2))(9,t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4283(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4283,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4287,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4316,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1001: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=t2;
f_4287(2,t3,C_SCHEME_UNDEFINED);}}

/* k4314 in system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1002: ##sys#error */
t2=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[207],lf[209]);}

/* k4285 in system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4287,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4294,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k4292 in k4285 in system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4294(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4294,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4298,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k4296 in k4292 in k4285 in system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4298,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4302,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k4300 in k4296 in k4292 in k4285 in system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4302,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4306,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k4304 in k4300 in k4296 in k4292 in k4285 in system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4306(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4306,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4310,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[208]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k4308 in k4304 in k4300 in k4296 in k4292 in k4285 in system-information in k4279 in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4310,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* signal-unmask! in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4265(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4265,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[205]);
t4=C_sigdelset(t2);
if(C_truep(C_fixnum_lessp(C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm:980: posix-error */
t5=lf[3];
f_2084(5,t5,t1,lf[199],lf[205],lf[206]);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* signal-mask! in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4250(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4250,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[203]);
t4=C_sigaddset(t2);
if(C_truep(C_fixnum_lessp(C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm:974: posix-error */
t5=lf[3];
f_2084(5,t5,t1,lf[199],lf[203],lf[204]);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* signal-masked? in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4244(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4244,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[202]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_sigismember(t2));}

/* signal-mask in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4212,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4218,a[2]=t3,a[3]=((C_word)li100),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4218(t5,t1,*((C_word*)lf[194]+1),C_SCHEME_END_OF_LIST);}

/* loop in signal-mask in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_4218(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4218,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_i_car(t2);
t5=C_i_cdr(t2);
if(C_truep(C_sigismember(t4))){
t6=C_a_i_cons(&a,2,t4,t3);
/* posixunix.scm:964: loop */
t10=t1;
t11=t5;
t12=t6;
t1=t10;
t2=t11;
t3=t12;
goto loop;}
else{
t6=t3;
/* posixunix.scm:964: loop */
t10=t1;
t11=t5;
t12=t6;
t1=t10;
t2=t11;
t3=t12;
goto loop;}}}

/* set-signal-mask! in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4166(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4166,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,lf[198]);
t4=C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4184,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp);
t6=f_4184(t2);
if(C_truep(C_fixnum_lessp(C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm:957: posix-error */
t7=lf[3];
f_2084(5,t7,t1,lf[199],lf[198],lf[200]);}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* loop745 in set-signal-mask! in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_4184(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
loop:
C_stack_check;
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_i_check_exact_2(t2,lf[198]);
t4=C_sigaddset(t2);
t5=C_slot(t1,C_fix(1));
t8=t5;
t1=t8;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* ##sys#interrupt-hook in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4148,4,t0,t1,t2,t3);}
t4=C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4158,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:943: h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixunix.scm:945: oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k4156 in ##sys#interrupt-hook in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4158(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:944: ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4135(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4135,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[197]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_i_vector_set(((C_word*)t0)[2],t2,t3));}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_i_vector_set(((C_word*)t0)[2],t2,t3));}}

/* signal-handler in k4122 in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4126(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4126,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[196]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4079(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4079,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4083,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm:860: posix-error */
t3=lf[3];
f_2084(5,t3,t2,lf[10],lf[167],lf[168]);}
else{
/* posixunix.scm:861: values */
C_values(4,0,t1,C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}}

/* k4081 in create-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:861: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4059(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4059r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4059r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4059r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=*((C_word*)lf[166]+1);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4063,a[2]=t3,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t6,*((C_word*)lf[155]+1),t2,t4);}

/* k4061 in with-output-to-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4063,2,t0,t1);}
t2=C_mutate((C_word*)lf[166]+1 /* (set! ##sys#standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4069,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li92),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:848: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a4068 in k4061 in with-output-to-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4069(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_4069r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4069r(t0,t1,t2);}}

static void C_ccall f_4069r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4073,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:850: close-output-pipe */
t4=*((C_word*)lf[160]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4071 in a4068 in k4061 in with-output-to-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[166]+1 /* (set! ##sys#standard-output ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4039(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4039r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4039r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4039r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=*((C_word*)lf[164]+1);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4043,a[2]=t3,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t6,*((C_word*)lf[151]+1),t2,t4);}

/* k4041 in with-input-from-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4043(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4043,2,t0,t1);}
t2=C_mutate((C_word*)lf[164]+1 /* (set! ##sys#standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4049,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li90),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:838: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a4048 in k4041 in with-input-from-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4049(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_4049r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4049r(t0,t1,t2);}}

static void C_ccall f_4049r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4053,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:840: close-input-pipe */
t4=*((C_word*)lf[156]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4051 in a4048 in k4041 in with-input-from-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[164]+1 /* (set! ##sys#standard-input ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4015(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4015r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4015r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4015r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4019,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[155]+1),t2,t4);}

/* k4017 in call-with-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4019(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4019,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4024,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li87),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4030,a[2]=t1,a[3]=((C_word)li88),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:827: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4029 in k4017 in call-with-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4030(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4030r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4030r(t0,t1,t2);}}

static void C_ccall f_4030r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4034,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:830: close-output-pipe */
t4=*((C_word*)lf[160]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4032 in a4029 in k4017 in call-with-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4034(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a4023 in k4017 in call-with-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4024,2,t0,t1);}
/* posixunix.scm:828: proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3991(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_3991r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3991r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3991r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3995,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[151]+1),t2,t4);}

/* k3993 in call-with-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3995(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3995,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4000,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li84),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4006,a[2]=t1,a[3]=((C_word)li85),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:818: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4005 in k3993 in call-with-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4006(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4006r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4006r(t0,t1,t2);}}

static void C_ccall f_4006r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4010,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:821: close-input-pipe */
t4=*((C_word*)lf[156]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4008 in a4005 in k3993 in call-with-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3999 in k3993 in call-with-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_4000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4000,2,t0,t1);}
/* posixunix.scm:819: proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3975(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3975,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3979,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:809: ##sys#check-port */
((C_proc4)C_retrieve_proc(*((C_word*)lf[159]+1)))(4,*((C_word*)lf[159]+1),t3,t2,lf[156]);}

/* k3977 in close-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3979(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3979,2,t0,t1);}
t2=close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3982,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:811: posix-error */
t5=lf[3];
f_2084(6,t5,t3,lf[10],lf[157],lf[158],((C_word*)t0)[3]);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k3980 in k3977 in close-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3939(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3939r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3939r(t0,t1,t2,t3);}}

static void C_ccall f_3939r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[155]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[152]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3953,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[152]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3960,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:804: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t9,t2,lf[155]);}
else{
t9=C_eqp(t6,lf[153]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3970,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:805: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t10,t2,lf[155]);}
else{
/* posixunix.scm:778: ##sys#error */
t10=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[154],t6);}}}

/* k3968 in open-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3970,2,t0,t1);}
t2=open_binary_output_pipe(&a,1,t1);
/* posixunix.scm:800: check */
f_3888(((C_word*)t0)[3],lf[155],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k3958 in open-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3960,2,t0,t1);}
t2=open_text_output_pipe(&a,1,t1);
/* posixunix.scm:800: check */
f_3888(((C_word*)t0)[3],lf[155],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k3951 in open-output-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3953(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:800: check */
f_3888(((C_word*)t0)[3],lf[155],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3903(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_3903r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3903r(t0,t1,t2,t3);}}

static void C_ccall f_3903r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[151]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[152]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3917,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[152]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3924,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:793: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t9,t2,lf[151]);}
else{
t9=C_eqp(t6,lf[153]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3934,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:794: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t10,t2,lf[151]);}
else{
/* posixunix.scm:778: ##sys#error */
t10=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[154],t6);}}}

/* k3932 in open-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3934,2,t0,t1);}
t2=open_binary_input_pipe(&a,1,t1);
/* posixunix.scm:789: check */
f_3888(((C_word*)t0)[3],lf[151],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3922 in open-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3924(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3924,2,t0,t1);}
t2=open_text_input_pipe(&a,1,t1);
/* posixunix.scm:789: check */
f_3888(((C_word*)t0)[3],lf[151],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3915 in open-input-pipe in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:789: check */
f_3888(((C_word*)t0)[3],lf[151],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3888(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3888,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posixunix.scm:781: posix-error */
t6=lf[3];
f_2084(6,t6,t1,lf[10],t2,lf[147],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3901,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:782: ##sys#make-port */
((C_proc6)C_retrieve_proc(*((C_word*)lf[148]+1)))(6,*((C_word*)lf[148]+1),t6,t4,*((C_word*)lf[149]+1),lf[150],lf[136]);}}

/* k3899 in check in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3901(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=t1;
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* change-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3848(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3848,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[44]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3855,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3868,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:768: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t5,t2);}

/* k3866 in change-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3868(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:768: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[44]);}

/* k3853 in change-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3855(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3855,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3858,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(0),C_chdir(t1));
if(C_truep(t3)){
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[2]);}
else{
/* posixunix.scm:770: posix-error */
t4=lf[3];
f_2084(6,t4,t2,lf[10],lf[44],lf[146],((C_word*)t0)[2]);}}

/* k3856 in k3853 in change-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3858(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3715r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3715r(t0,t1,t2,t3);}}

static void C_ccall f_3715r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3719,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_3719(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_3719(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3719(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3719,2,t0,t1);}
t2=C_i_check_string_2(((C_word*)t0)[3],lf[142]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3725,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:753: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,((C_word*)t0)[3]);}

/* k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3725,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3728,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_block_size(t1);
t4=C_eqp(C_fix(0),t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3734,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
if(C_truep(t4)){
t6=t5;
f_3734(2,t6,t4);}
else{
/* posixunix.scm:755: file-exists? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[145]+1)))(3,*((C_word*)lf[145]+1),t5,t1);}}

/* k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3734,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[4]);}
else{
if(C_truep(((C_word*)t0)[3])){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3744,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3788,a[2]=((C_word*)t0)[4],a[3]=((C_word)li76),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3794,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t2,t3,t4);}
else{
t2=((C_word*)t0)[4];
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3817,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:747: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t3,t2,lf[142]);}}}

/* k3815 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3817(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[4]);}
else{
/* posixunix.scm:748: posix-error */
t4=lf[3];
f_2084(6,t4,((C_word*)t0)[3],lf[10],lf[142],lf[143],((C_word*)t0)[2]);}}

/* a3793 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3794(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3794,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
/* posixunix.scm:758: make-pathname */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t1,t2,t3,t4);}
else{
t5=t2;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* a3787 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3788,2,t0,t1);}
/* posixunix.scm:757: decompose-pathname */
((C_proc3)C_retrieve_proc(*((C_word*)lf[52]+1)))(3,*((C_word*)lf[52]+1),t1,((C_word*)t0)[2]);}

/* k3742 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3744(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3744,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3746,a[2]=t3,a[3]=((C_word)li75),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3746(t5,((C_word*)t0)[2],t1);}

/* loop in k3742 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3746(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3746,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3753,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3786,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:759: directory? */
t5=*((C_word*)lf[41]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}
else{
t4=t3;
f_3753(t4,C_SCHEME_FALSE);}}

/* k3784 in loop in k3742 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_3753(t2,C_i_not(t1));}

/* k3751 in loop in k3742 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3753(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3753,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3756,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3779,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:760: pathname-directory */
((C_proc3)C_retrieve_proc(*((C_word*)lf[144]+1)))(3,*((C_word*)lf[144]+1),t3,((C_word*)t0)[3]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k3777 in k3751 in loop in k3742 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:760: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_3746(t2,((C_word*)t0)[2],t1);}

/* k3754 in k3751 in loop in k3742 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3756(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3756,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3772,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:747: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t3,lf[142]);}

/* k3770 in k3754 in k3751 in loop in k3742 in k3732 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posixunix.scm:748: posix-error */
t4=lf[3];
f_2084(6,t4,((C_word*)t0)[3],lf[10],lf[142],lf[143],((C_word*)t0)[2]);}}

/* k3726 in k3723 in k3717 in create-directory in k3711 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3728(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-file-position! in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3653(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3653r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3653r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3653r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_i_car(t4):C_fix((C_word)SEEK_SET));
t7=C_i_check_exact_2(t3,lf[134]);
t8=C_i_check_exact_2(t6,lf[134]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3666,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_negativep(t3))){
/* posixunix.scm:716: ##sys#signal-hook */
((C_proc7)C_retrieve_proc(*((C_word*)lf[4]+1)))(7,*((C_word*)lf[4]+1),t9,lf[139],lf[134],lf[140],t3,t2);}
else{
t10=t9;
f_3666(2,t10,C_SCHEME_UNDEFINED);}}

/* k3664 in set-file-position! in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3666(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3666,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3672,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3678,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:717: port? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[138]+1)))(3,*((C_word*)lf[138]+1),t3,((C_word*)t0)[4]);}

/* k3676 in k3664 in set-file-position! in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3678(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[5],C_fix(7));
t3=C_eqp(t2,lf[136]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
f_3672(2,t5,t4);}
else{
t4=((C_word*)t0)[2];
f_3672(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
t2=C_lseek(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
f_3672(2,t3,t2);}
else{
/* posixunix.scm:723: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),((C_word*)t0)[2],lf[15],lf[134],lf[137],((C_word*)t0)[5]);}}}

/* k3670 in k3664 in set-file-position! in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm:724: posix-error */
t2=lf[3];
f_2084(7,t2,((C_word*)t0)[4],lf[10],lf[134],lf[135],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3373(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr4r,(void*)f_3373r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3373r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3373r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word *a=C_alloc(16);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_i_pairp(t4);
t8=(C_truep(t7)?C_i_car(t4):C_SCHEME_FALSE);
t9=C_i_foreign_fixnum_argumentp(C_fix(0));
t10=stub480(C_SCHEME_UNDEFINED,t9);
t11=C_i_foreign_fixnum_argumentp(C_fix(1));
t12=stub480(C_SCHEME_UNDEFINED,t11);
t13=C_i_not(t2);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3389,a[2]=t6,a[3]=t8,a[4]=t2,a[5]=t1,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t13)){
t15=t14;
f_3389(2,t15,t13);}
else{
if(C_truep(C_fixnump(t2))){
t15=C_set_block_item(t6,0,t2);
t16=t2;
t17=C_i_foreign_fixnum_argumentp(C_fix(0));
t18=C_i_foreign_fixnum_argumentp(t16);
t19=t14;
f_3389(2,t19,stub485(C_SCHEME_UNDEFINED,t17,t18));}
else{
t15=C_i_check_list_2(t2,lf[129]);
t16=C_SCHEME_UNDEFINED;
t17=(*a=C_VECTOR_TYPE|1,a[1]=t16,tmp=(C_word)a,a+=2,tmp);
t18=C_set_block_item(t17,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3612,a[2]=t17,a[3]=t6,a[4]=((C_word)li72),tmp=(C_word)a,a+=5,tmp));
t19=((C_word*)t17)[1];
f_3612(t19,t14,t2);}}}

/* loop509 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3612(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3612,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3620,a[2]=((C_word*)t0)[3],a[3]=((C_word)li71),tmp=(C_word)a,a+=4,tmp);
t4=C_slot(t2,C_fix(0));
t5=f_3620(t3,t4);
t6=C_slot(t2,C_fix(1));
t9=t1;
t10=t6;
t1=t9;
t2=t10;
goto loop;}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* g516 in loop509 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_3620(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t2=C_i_check_exact_2(t1,lf[129]);
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t1));
t4=t1;
t5=C_i_foreign_fixnum_argumentp(C_fix(0));
t6=C_i_foreign_fixnum_argumentp(t4);
return(stub485(C_SCHEME_UNDEFINED,t5,t6));}

/* k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3389(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3389,2,t0,t1);}
t2=C_i_not(((C_word*)t0)[6]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3395,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(t2)){
t4=t3;
f_3395(2,t4,t2);}
else{
if(C_truep(C_fixnump(((C_word*)t0)[6]))){
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[6]);
t5=((C_word*)t0)[6];
t6=C_i_foreign_fixnum_argumentp(C_fix(1));
t7=C_i_foreign_fixnum_argumentp(t5);
t8=t3;
f_3395(2,t8,stub485(C_SCHEME_UNDEFINED,t6,t7));}
else{
t4=C_i_check_list_2(((C_word*)t0)[6],lf[129]);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3564,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=((C_word)li70),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_3564(t8,t3,((C_word*)t0)[6]);}}}

/* loop533 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3564(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3564,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3572,a[2]=((C_word*)t0)[3],a[3]=((C_word)li69),tmp=(C_word)a,a+=4,tmp);
t4=C_slot(t2,C_fix(0));
t5=f_3572(t3,t4);
t6=C_slot(t2,C_fix(1));
t9=t1;
t10=t6;
t1=t9;
t2=t10;
goto loop;}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* g540 in loop533 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_3572(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t2=C_i_check_exact_2(t1,lf[129]);
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t1));
t4=t1;
t5=C_i_foreign_fixnum_argumentp(C_fix(1));
t6=C_i_foreign_fixnum_argumentp(t4);
return(stub485(C_SCHEME_UNDEFINED,t5,t6));}

/* k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3395(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3395,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3398,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=C_i_check_number_2(((C_word*)t0)[3],lf[129]);
t4=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_3398(t5,C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_3398(t4,C_C_select(t3));}}

/* k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3398(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3398,NULL,2,t0,t1);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:682: posix-error */
t2=lf[3];
f_2084(7,t2,((C_word*)t0)[4],lf[10],lf[129],lf[130],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=C_i_pairp(((C_word*)t0)[3]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
if(C_truep(C_i_pairp(((C_word*)t0)[2]))){
/* posixunix.scm:683: values */
C_values(4,0,((C_word*)t0)[4],t4,C_SCHEME_END_OF_LIST);}
else{
/* posixunix.scm:683: values */
C_values(4,0,((C_word*)t0)[4],t4,C_SCHEME_FALSE);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3437,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t4=((C_word*)t0)[3];
t5=C_i_foreign_fixnum_argumentp(C_fix(0));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=t3;
f_3437(t7,stub491(C_SCHEME_UNDEFINED,t5,t6));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3500,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3502,a[2]=t8,a[3]=t5,a[4]=((C_word)li68),tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_3502(t10,t6,((C_word*)t0)[3]);}}
else{
t4=t3;
f_3437(t4,C_SCHEME_FALSE);}}}}

/* loop560 in k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3502(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3502,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3510,a[2]=((C_word*)t0)[3],a[3]=((C_word)li67),tmp=(C_word)a,a+=4,tmp);
t4=C_slot(t2,C_fix(0));
t5=f_3510(C_a_i(&a,3),t3,t4);
t6=C_slot(t2,C_fix(1));
t9=t1;
t10=t6;
t1=t9;
t2=t10;
goto loop;}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* g567 in loop560 in k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_3510(C_word *a,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_check;
t2=t1;
t3=C_i_foreign_fixnum_argumentp(C_fix(0));
t4=C_i_foreign_fixnum_argumentp(t2);
if(C_truep(stub491(C_SCHEME_UNDEFINED,t3,t4))){
t5=C_a_i_cons(&a,2,t1,((C_word*)((C_word*)t0)[2])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[2])+1,t5);
return(t6);}
else{
t5=C_SCHEME_UNDEFINED;
return(t5);}}

/* k3498 in k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3500(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=((C_word*)((C_word*)t0)[3])[1];
t3=((C_word*)t0)[2];
f_3437(t3,t2);}

/* k3435 in k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3437(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3437,NULL,2,t0,t1);}
if(C_truep(((C_word*)t0)[3])){
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[3];
t3=C_i_foreign_fixnum_argumentp(C_fix(1));
t4=C_i_foreign_fixnum_argumentp(t2);
t5=stub491(C_SCHEME_UNDEFINED,t3,t4);
/* posixunix.scm:685: values */
C_values(4,0,((C_word*)t0)[2],t1,t5);}
else{
t2=C_SCHEME_END_OF_LIST;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3453,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3455,a[2]=t6,a[3]=t3,a[4]=((C_word)li66),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_3455(t8,t4,((C_word*)t0)[3]);}}
else{
/* posixunix.scm:685: values */
C_values(4,0,((C_word*)t0)[2],t1,C_SCHEME_FALSE);}}

/* loop577 in k3435 in k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_3455(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3455,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3463,a[2]=((C_word*)t0)[3],a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp);
t4=C_slot(t2,C_fix(0));
t5=f_3463(C_a_i(&a,3),t3,t4);
t6=C_slot(t2,C_fix(1));
t9=t1;
t10=t6;
t1=t9;
t2=t10;
goto loop;}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* g584 in loop577 in k3435 in k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static C_word C_fcall f_3463(C_word *a,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_check;
t2=t1;
t3=C_i_foreign_fixnum_argumentp(C_fix(1));
t4=C_i_foreign_fixnum_argumentp(t2);
if(C_truep(stub491(C_SCHEME_UNDEFINED,t3,t4))){
t5=C_a_i_cons(&a,2,t1,((C_word*)((C_word*)t0)[2])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[2])+1,t5);
return(t6);}
else{
t5=C_SCHEME_UNDEFINED;
return(t5);}}

/* k3451 in k3435 in k3396 in k3393 in k3387 in file-select in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3453(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
/* posixunix.scm:685: values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* file-mkstemp in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3315(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3315,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[127]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3322,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:634: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t2,lf[127]);}

/* k3320 in file-mkstemp in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3322(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3322,2,t0,t1);}
t2=C_mkstemp(t1);
t3=C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3328,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm:638: posix-error */
t6=lf[3];
f_2084(6,t6,t4,lf[10],lf[127],lf[128],((C_word*)t0)[2]);}
else{
t6=t4;
f_3328(2,t6,C_SCHEME_UNDEFINED);}}

/* k3326 in k3320 in file-mkstemp in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3328(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3328,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3335,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:639: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k3333 in k3326 in k3320 in file-mkstemp in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:639: values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3276(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3276r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3276r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3276r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=C_i_check_exact_2(t2,lf[124]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3283,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;
f_3283(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:623: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),t6,lf[15],lf[124],lf[126],t3);}}
else{
/* posixunix.scm:623: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),t6,lf[15],lf[124],lf[126],t3);}}

/* k3281 in file-write in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3283(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3283,2,t0,t1);}
t2=C_i_pairp(((C_word*)t0)[5]);
t3=(C_truep(t2)?C_i_car(((C_word*)t0)[5]):C_block_size(((C_word*)t0)[4]));
t4=C_i_check_exact_2(t3,lf[124]);
t5=C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3292,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:628: posix-error */
t8=lf[3];
f_2084(7,t8,t6,lf[10],lf[124],lf[125],((C_word*)t0)[3],t3);}
else{
t8=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t5);}}

/* k3290 in k3281 in file-write in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3234(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3234r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3234r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3234r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=C_i_check_exact_2(t2,lf[121]);
t6=C_i_check_exact_2(t3,lf[121]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3244,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t7;
f_3244(2,t8,C_i_car(t4));}
else{
/* posixunix.scm:611: make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k3242 in file-read in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3244(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3244,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3247,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t1))){
if(C_truep(C_byteblockp(t1))){
t3=t2;
f_3247(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:613: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),t2,lf[15],lf[121],lf[123],t1);}}
else{
/* posixunix.scm:613: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),t2,lf[15],lf[121],lf[123],t1);}}

/* k3245 in k3242 in file-read in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3247,2,t0,t1);}
t2=C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3250,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:616: posix-error */
t5=lf[3];
f_2084(7,t5,t3,lf[10],lf[121],lf[122],((C_word*)t0)[5],((C_word*)t0)[3]);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_list(&a,2,((C_word*)t0)[4],t2));}}

/* k3248 in k3245 in k3242 in file-read in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3250,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3219(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3219,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[119]);
if(C_truep(C_fixnum_lessp(C_close(t2),C_fix(0)))){
/* posixunix.scm:604: posix-error */
t4=lf[3];
f_2084(6,t4,t1,lf[10],lf[119],lf[120],t2);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* file-open in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3181(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4r,(void*)f_3181r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3181r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3181r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_i_car(t4):((C_word*)t0)[2]);
t7=C_i_check_string_2(t2,lf[117]);
t8=C_i_check_exact_2(t3,lf[117]);
t9=C_i_check_exact_2(t6,lf[117]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3198,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3211,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:595: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t11,t2);}

/* k3209 in file-open in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:595: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[117]);}

/* k3196 in file-open in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3198,2,t0,t1);}
t2=C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3201,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:597: posix-error */
t5=lf[3];
f_2084(8,t5,t3,lf[10],lf[117],lf[118],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k3199 in k3196 in file-open in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-control in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3135(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3135r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3135r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3135r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3139,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_nullp(t4))){
t6=t5;
f_3139(2,t6,C_fix(0));}
else{
t6=C_i_cdr(t4);
if(C_truep(C_i_nullp(t6))){
t7=t5;
f_3139(2,t7,C_i_car(t4));}
else{
/* ##sys#error */
t7=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t4);}}}

/* k3137 in file-control in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
t2=C_i_check_exact_2(((C_word*)t0)[4],lf[115]);
t3=C_i_check_exact_2(((C_word*)t0)[3],lf[115]);
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[3];
t6=C_i_foreign_fixnum_argumentp(t4);
t7=C_i_foreign_fixnum_argumentp(t5);
t8=C_i_foreign_integer_argumentp(t1);
t9=stub417(C_SCHEME_UNDEFINED,t6,t7,t8);
t10=C_eqp(t9,C_fix(-1));
if(C_truep(t10)){
/* posixunix.scm:585: posix-error */
t11=lf[3];
f_2084(7,t11,((C_word*)t0)[2],lf[10],lf[115],lf[116],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t11=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t9);}}

/* ##sys#file-select-one in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3078(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3078,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub410(C_SCHEME_UNDEFINED,t3));}

/* ##sys#file-nonblocking! in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3071(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3071,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub406(C_SCHEME_UNDEFINED,t3));}

/* find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2890(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_2890r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2890r(t0,t1,t2,t3);}}

static void C_ccall f_2890r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(8);
t4=C_i_nullp(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2900,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
t6=t5;
f_2900(t6,t4);}
else{
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3065,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=C_i_car(t3);
/* posix-common.scm:284: keyword? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[76]+1)))(3,*((C_word*)lf[76]+1),t6,t7);}}

/* k3063 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2900(t2,C_i_not(t1));}

/* k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2900(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2900,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2901,a[2]=((C_word*)t0)[3],a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2906,a[2]=t3,a[3]=((C_word)li41),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2911,a[2]=t4,a[3]=((C_word)li42),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2916,a[2]=t5,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2927,a[2]=t6,a[3]=((C_word)li46),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* def-pred333356 */
t8=t7;
f_2927(t8,((C_word*)t0)[2]);}
else{
t8=C_i_car(t2);
t9=C_i_cdr(t2);
if(C_truep(C_i_nullp(t9))){
/* def-action334352 */
t10=t6;
f_2916(t10,((C_word*)t0)[2],t8);}
else{
t10=C_i_car(t9);
t11=C_i_cdr(t9);
if(C_truep(C_i_nullp(t11))){
/* def-id335349 */
t12=t5;
f_2911(t12,((C_word*)t0)[2],t8,t10);}
else{
t12=C_i_car(t11);
t13=C_i_cdr(t11);
if(C_truep(C_i_nullp(t13))){
/* def-limit336345 */
t14=t4;
f_2906(t14,((C_word*)t0)[2],t8,t10,t12);}
else{
t14=C_i_car(t13);
t15=C_i_cdr(t13);
if(C_truep(C_i_nullp(t15))){
/* body331340 */
t16=t3;
f_2901(t16,((C_word*)t0)[2],t8,t10,t12,t14);}
else{
/* ##sys#error */
t16=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,((C_word*)t0)[2],lf[0],t15);}}}}}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3011,a[2]=((C_word*)t0)[3],a[3]=((C_word)li55),tmp=(C_word)a,a+=4,tmp);
C_apply(4,0,((C_word*)t0)[2],t2,((C_word*)t0)[4]);}}

/* a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3011(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr2r,(void*)f_3011r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3011r(t0,t1,t2);}}

static void C_ccall f_3011r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3015,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3055,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[69]+1)))(5,*((C_word*)lf[69]+1),t3,lf[75],t2,t4);}

/* a3054 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3055,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3057,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));}

/* f_3057 in a3054 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3057(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3057,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3015,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3018,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3047,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[69]+1)))(5,*((C_word*)lf[69]+1),t2,lf[74],((C_word*)t0)[2],t3);}

/* a3046 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3047,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3049,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));}

/* f_3049 in a3046 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3049(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3049,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3018,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3021,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3044,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[69]+1)))(5,*((C_word*)lf[69]+1),t2,lf[73],((C_word*)t0)[2],t3);}

/* a3043 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3044,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}

/* k3019 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3021,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3024,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3041,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[69]+1)))(5,*((C_word*)lf[69]+1),t2,lf[72],((C_word*)t0)[2],t3);}

/* a3040 in k3019 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3041,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* k3022 in k3019 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3024,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3027,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3038,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[69]+1)))(5,*((C_word*)lf[69]+1),t2,lf[71],((C_word*)t0)[2],t3);}

/* a3037 in k3022 in k3019 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3038,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* k3025 in k3022 in k3019 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3027(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3027,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3030,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3035,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
/* ##sys#get-keyword */
((C_proc5)C_retrieve_proc(*((C_word*)lf[69]+1)))(5,*((C_word*)lf[69]+1),t2,lf[70],((C_word*)t0)[2],t3);}

/* a3034 in k3025 in k3022 in k3019 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3035(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3035,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k3028 in k3025 in k3022 in k3019 in k3016 in k3013 in a3010 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_3030(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:299: ##sys#find-files */
f_2717(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],lf[68]);}

/* def-pred333 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2927(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2927,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2933,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
/* def-action334352 */
t3=((C_word*)t0)[2];
f_2916(t3,t1,t2);}

/* a2932 in def-pred333 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2933(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2933,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* def-action334 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2916(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2916,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2922,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
/* def-id335349 */
t4=((C_word*)t0)[2];
f_2911(t4,t1,t2,t3);}

/* a2921 in def-action334 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2922(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2922,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* def-id335 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2911(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2911,NULL,4,t0,t1,t2,t3);}
/* def-limit336345 */
t4=((C_word*)t0)[2];
f_2906(t4,t1,t2,t3,C_SCHEME_END_OF_LIST);}

/* def-limit336 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2906(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2906,NULL,5,t0,t1,t2,t3,t4);}
/* body331340 */
t5=((C_word*)t0)[2];
f_2901(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body331 in k2898 in find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2901(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2901,NULL,6,t0,t1,t2,t3,t4,t5);}
/* posix-common.scm:290: ##sys#find-files */
f_2717(t1,((C_word*)t0)[2],t2,t3,t4,t5,C_SCHEME_FALSE,lf[68]);}

/* ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2717(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2717,NULL,8,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=C_i_check_string_2(t2,t8);
t10=C_fix(0);
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2724,a[2]=t3,a[3]=t2,a[4]=t7,a[5]=t5,a[6]=t1,a[7]=t4,a[8]=t11,tmp=(C_word)a,a+=9,tmp);
t13=t6;
if(C_truep(t13)){
if(C_truep(C_fixnump(t6))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2884,a[2]=t6,a[3]=t11,a[4]=((C_word)li37),tmp=(C_word)a,a+=5,tmp);
t15=t12;
f_2724(t15,t14);}
else{
t14=t6;
t15=t12;
f_2724(t15,t14);}}
else{
t14=t12;
f_2724(t14,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2876,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));}}

/* f_2876 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2876(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2876,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_2884 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2884(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2884,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2724(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2724,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2727,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t1,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=C_i_stringp(((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2861,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2861(2,t5,t3);}
else{
/* posix-common.scm:262: regexp? */
((C_proc3)C_retrieve_proc(*((C_word*)lf[67]+1)))(3,*((C_word*)lf[67]+1),t4,((C_word*)t0)[2]);}}

/* k2859 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2861,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2864,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:263: regexp */
((C_proc3)C_retrieve_proc(*((C_word*)lf[56]+1)))(3,*((C_word*)lf[56]+1),t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_2727(t2,((C_word*)t0)[2]);}}

/* k2862 in k2859 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2864(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2864,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2727(t2,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2865,a[2]=t1,a[3]=((C_word)li36),tmp=(C_word)a,a+=4,tmp));}

/* f_2865 in k2862 in k2859 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2865(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2865,3,t0,t1,t2);}
/* posix-common.scm:264: string-match */
((C_proc4)C_retrieve_proc(*((C_word*)lf[54]+1)))(4,*((C_word*)lf[54]+1),t1,((C_word*)t0)[2],t2);}

/* k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2727(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2727,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2734,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2851,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posix-common.scm:266: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[53]+1)))(4,*((C_word*)lf[53]+1),t3,((C_word*)t0)[2],lf[65]);}
else{
/* posix-common.scm:266: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[53]+1)))(4,*((C_word*)lf[53]+1),t3,((C_word*)t0)[2],lf[66]);}}

/* k2849 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:266: glob */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2734,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2736,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t3,a[7]=((C_word)li35),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2736(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2736(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2736,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2755,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=t5,a[9]=t1,a[10]=((C_word*)t0)[6],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:272: directory? */
t7=*((C_word*)lf[41]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2755,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2831,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:273: pathname-file */
((C_proc3)C_retrieve_proc(*((C_word*)lf[64]+1)))(3,*((C_word*)lf[64]+1),t2,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2837,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:280: pproc */
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[4]);}}

/* k2835 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2837,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2844,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:280: action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posix-common.scm:281: loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_2736(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k2842 in k2835 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:280: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2736(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2831,2,t0,t1);}
if(C_truep((C_truep(C_i_equalp(t1,lf[60]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(t1,lf[61]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:273: loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_2736(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2770,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:274: lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[4]);}}

/* k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2770,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2780,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2782,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=((C_word)li32),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2787,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word)li33),tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2811,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=((C_word)li34),tmp=(C_word)a,a+=6,tmp);
/* ##sys#dynamic-wind */
t11=*((C_word*)lf[63]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2821,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2824,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t2,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:279: pproc */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}}

/* k2822 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:279: action */
t2=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:279: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2736(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k2819 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:279: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2736(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a2810 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2811(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2811,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a2786 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2787,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2795,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2809,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:277: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[53]+1)))(4,*((C_word*)lf[53]+1),t3,((C_word*)t0)[4],lf[62]);}

/* k2807 in a2786 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:277: glob */
t2=*((C_word*)lf[51]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2793 in a2786 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2795,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2799,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2802,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t2,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:278: pproc */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k2800 in k2793 in a2786 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:278: action */
t2=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:277: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2736(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}}

/* k2797 in k2793 in a2786 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2799(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:277: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2736(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a2781 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2782,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k2778 in k2768 in k2829 in k2753 in loop in k2732 in k2725 in k2722 in ##sys#find-files in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:275: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2736(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2605(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_2605r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2605r(t0,t1,t2);}}

static void C_ccall f_2605r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2611,a[2]=t4,a[3]=((C_word)li30),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_2611(t6,t1,t2);}

/* conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2611(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2611,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2626,a[2]=t3,a[3]=((C_word)li26),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2632,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li29),tmp=(C_word)a,a+=5,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2632(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2632,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2636,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2711,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t7=t3;
/* posix-common.scm:242: make-pathname */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t6,C_SCHEME_FALSE,t7,t4);}
else{
/* posix-common.scm:242: make-pathname */
((C_proc5)C_retrieve_proc(*((C_word*)lf[53]+1)))(5,*((C_word*)lf[53]+1),t6,C_SCHEME_FALSE,lf[58],t4);}}

/* k2709 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:242: glob->regexp */
((C_proc3)C_retrieve_proc(*((C_word*)lf[57]+1)))(3,*((C_word*)lf[57]+1),((C_word*)t0)[2],t1);}

/* k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2636(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2636,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2639,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:243: regexp */
((C_proc3)C_retrieve_proc(*((C_word*)lf[56]+1)))(3,*((C_word*)lf[56]+1),t2,t1);}

/* k2637 in k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2639(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2639,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2646,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=((C_word*)t0)[3];
/* posix-common.scm:244: directory */
t4=*((C_word*)lf[29]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}
else{
/* posix-common.scm:244: directory */
t3=*((C_word*)lf[29]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,lf[55],C_SCHEME_TRUE);}}

/* k2644 in k2637 in k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2646,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2648,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li28),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2648(t5,((C_word*)t0)[2],t1);}

/* loop in k2644 in k2637 in k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2648(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2648,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[6]);
/* posix-common.scm:245: conc-loop */
t4=((C_word*)((C_word*)t0)[5])[1];
f_2611(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2665,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:246: string-match */
((C_proc4)C_retrieve_proc(*((C_word*)lf[54]+1)))(4,*((C_word*)lf[54]+1),t3,((C_word*)t0)[2],t4);}}

/* k2663 in loop in k2644 in k2637 in k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2665(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2665,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2669,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li27),tmp=(C_word)a,a+=6,tmp);
/* g267268 */
t3=t2;
f_2669(t3,((C_word*)t0)[2],t1);}
else{
t2=C_i_cdr(((C_word*)t0)[5]);
/* posix-common.scm:248: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2648(t3,((C_word*)t0)[2],t2);}}

/* g267 in k2663 in loop in k2644 in k2637 in k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2669(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2669,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2677,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_i_car(t2);
/* posix-common.scm:247: make-pathname */
((C_proc4)C_retrieve_proc(*((C_word*)lf[53]+1)))(4,*((C_word*)lf[53]+1),t3,((C_word*)t0)[2],t4);}

/* k2675 in g267 in k2663 in loop in k2644 in k2637 in k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2677,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2681,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:247: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2648(t4,t2,t3);}

/* k2679 in k2675 in g267 in k2663 in loop in k2644 in k2637 in k2634 in a2631 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2681,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a2625 in conc-loop in glob in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2626,2,t0,t1);}
/* posix-common.scm:241: decompose-pathname */
((C_proc3)C_retrieve_proc(*((C_word*)lf[52]+1)))(3,*((C_word*)lf[52]+1),t1,((C_word*)t0)[2]);}

/* directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2448(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_2448r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2448r(t0,t1,t2);}}

static void C_ccall f_2448r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2450,a[2]=((C_word*)t0)[2],a[3]=((C_word)li22),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2548,a[2]=t3,a[3]=((C_word)li23),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2553,a[2]=t4,a[3]=((C_word)li24),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
/* def-spec202234 */
t6=t5;
f_2553(t6,t1);}
else{
t6=C_i_car(t2);
t7=C_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
/* def-show-dotfiles?203232 */
t8=t4;
f_2548(t8,t1,t6);}
else{
t8=C_i_car(t7);
t9=C_i_cdr(t7);
if(C_truep(C_i_nullp(t9))){
/* body200207 */
t10=t3;
f_2450(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[0],t9);}}}}

/* def-spec202 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2553(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2553,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2561,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:205: current-directory */
t3=*((C_word*)lf[43]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2559 in def-spec202 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?203232 */
t2=((C_word*)t0)[3];
f_2548(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?203 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2548(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2548,NULL,3,t0,t1,t2);}
/* body200207 */
t3=((C_word*)t0)[2];
f_2450(t3,t1,t2,C_SCHEME_FALSE);}

/* body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2450(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2450,NULL,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[29]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2457,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:207: make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2457,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2460,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:208: ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[50]+1)))(2,*((C_word*)lf[50]+1),t2);}

/* k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2460(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2460,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2463,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:209: ##sys#make-pointer */
((C_proc2)C_retrieve_proc(*((C_word*)lf[50]+1)))(2,*((C_word*)lf[50]+1),t2);}

/* k2461 in k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2463,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2467,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2547,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:212: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,((C_word*)t0)[4]);}

/* k2545 in k2461 in k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:212: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[29]);}

/* k2465 in k2461 in k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2467,2,t0,t1);}
t2=C_opendir(t1,((C_word*)t0)[7]);
if(C_truep(C_null_pointerp(((C_word*)t0)[7]))){
/* posix-common.scm:214: posix-error */
t3=lf[3];
f_2084(6,t3,((C_word*)t0)[6],lf[10],lf[29],lf[49],((C_word*)t0)[5]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2481,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word)li21),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2481(t6,((C_word*)t0)[6]);}}

/* loop in k2465 in k2461 in k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2481(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2481,NULL,2,t0,t1);}
t2=C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep(C_null_pointerp(((C_word*)t0)[5]))){
t3=C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2491,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:222: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k2489 in loop in k2465 in k2461 in k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2491(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2491,2,t0,t1);}
t2=C_i_string_ref(t1,C_fix(0));
t3=C_fixnum_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2503,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=C_eqp(C_make_character(46),t2);
if(C_truep(t6)){
t7=C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_2503(t8,t7);}
else{
t8=C_eqp(C_make_character(46),t4);
if(C_truep(t8)){
t9=C_eqp(C_fix(2),((C_word*)t0)[5]);
t10=t5;
f_2503(t10,(C_truep(t9)?t9:C_i_not(((C_word*)t0)[2])));}
else{
t9=t5;
f_2503(t9,C_i_not(((C_word*)t0)[2]));}}}
else{
t7=t5;
f_2503(t7,C_SCHEME_FALSE);}}

/* k2501 in k2489 in loop in k2465 in k2461 in k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2503(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2503,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:229: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2481(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2513,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:230: loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2481(t3,t2);}}

/* k2511 in k2501 in k2489 in loop in k2465 in k2461 in k2458 in k2455 in body200 in directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2513,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2426(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2426,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[47]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2433,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2446,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:198: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t5,t2);}

/* k2444 in delete-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2446(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:198: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[47]);}

/* k2431 in delete-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2433,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2436,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(0),C_rmdir(t1));
if(C_truep(t3)){
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[2]);}
else{
/* posix-common.scm:200: posix-error */
t4=lf[3];
f_2084(6,t4,t2,lf[10],lf[47],lf[48],((C_word*)t0)[2]);}}

/* k2434 in k2431 in delete-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* current-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2380(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2380r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2380r(t0,t1,t2);}}

static void C_ccall f_2380r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2384,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t2))){
t4=t3;
f_2384(2,t4,C_SCHEME_FALSE);}
else{
t4=C_i_cdr(t2);
if(C_truep(C_i_nullp(t4))){
t5=t3;
f_2384(2,t5,C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k2382 in current-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2384,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:186: change-directory */
t2=*((C_word*)lf[44]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2393,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:187: make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(1024));}}

/* k2391 in k2382 in current-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2393,2,t0,t1);}
t2=C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2396,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:190: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}

/* k2394 in k2391 in k2382 in current-directory in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2396(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posix-common.scm:192: ##sys#substring */
((C_proc5)C_retrieve_proc(*((C_word*)lf[45]+1)))(5,*((C_word*)lf[45]+1),((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posix-common.scm:193: ##sys#signal-hook */
((C_proc5)C_retrieve_proc(*((C_word*)lf[4]+1)))(5,*((C_word*)lf[4]+1),((C_word*)t0)[3],lf[10],lf[43],lf[46]);}}

/* directory? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2370(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2370,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2378,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:177: file-type */
t4=*((C_word*)lf[27]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2376 in directory? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2378(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[29],t1));}

/* socket? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2360(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2360,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2368,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:174: file-type */
t4=*((C_word*)lf[27]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2366 in socket? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2368(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[33],t1));}

/* f_2350 in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2350(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2350,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2358,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:171: file-type */
t4=*((C_word*)lf[27]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2356 */
static void C_ccall f_2358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[32],t1));}

/* character-device? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2340(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2340,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2348,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:168: file-type */
t4=*((C_word*)lf[27]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2346 in character-device? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[30],t1));}

/* block-device? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2330(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2330,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2338,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:165: file-type */
t4=*((C_word*)lf[27]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2336 in block-device? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[31],t1));}

/* symbolic-link? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2320(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2320,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2328,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:162: file-type */
t4=*((C_word*)lf[27]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* k2326 in symbolic-link? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2328(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[28],t1));}

/* regular-file? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2310(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2310,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2318,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:159: file-type */
t4=*((C_word*)lf[27]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2316 in regular-file? in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2318(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[34],t1));}

/* file-type in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2211(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_2211r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2211r(t0,t1,t2,t3);}}

static void C_ccall f_2211r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2213,a[2]=t2,a[3]=((C_word)li8),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2257,a[2]=t4,a[3]=((C_word)li9),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2262,a[2]=t5,a[3]=((C_word)li10),tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* def-link140156 */
t7=t6;
f_2262(t7,t1);}
else{
t7=C_i_car(t3);
t8=C_i_cdr(t3);
if(C_truep(C_i_nullp(t8))){
/* def-err141154 */
t9=t5;
f_2257(t9,t1,t7);}
else{
t9=C_i_car(t8);
t10=C_i_cdr(t8);
if(C_truep(C_i_nullp(t10))){
/* body138145 */
t11=t4;
f_2213(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-link140 in file-type in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2262(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2262,NULL,2,t0,t1);}
/* def-err141154 */
t2=((C_word*)t0)[2];
f_2257(t2,t1,C_SCHEME_FALSE);}

/* def-err141 in file-type in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2257(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2257,NULL,3,t0,t1,t2);}
/* body138145 */
t3=((C_word*)t0)[2];
f_2213(t3,t1,t2,C_SCHEME_TRUE);}

/* body138 in file-type in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2213(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2213,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2220,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:148: ##sys#stat */
f_2102(t4,((C_word*)t0)[2],t2,t3,lf[27]);}

/* k2218 in body138 in file-type in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[28]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[29]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[30]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[31]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[32]);}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?lf[33]:lf[34]));}}}}}}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-size in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2205(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2205,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2209,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:145: ##sys#stat */
f_2102(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[26]);}

/* k2207 in file-size in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2209(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2209,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-permissions in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2199(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2199,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2203,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:144: ##sys#stat */
f_2102(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[25]);}

/* k2201 in file-permissions in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2203(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2193(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2193,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2197,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:143: ##sys#stat */
f_2102(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[24]);}

/* k2195 in file-owner in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2197(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2187(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2187,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2191,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:142: ##sys#stat */
f_2102(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[23]);}

/* k2189 in file-change-time in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2191(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2191,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2181(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2181,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2185,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:141: ##sys#stat */
f_2102(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[22]);}

/* k2183 in file-access-time in k2177 in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2185(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2185,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2146(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2146r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2146r(t0,t1,t2,t3);}}

static void C_ccall f_2146r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2150,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t5=t4;
f_2150(2,t5,C_SCHEME_FALSE);}
else{
t5=C_i_cdr(t3);
if(C_truep(C_i_nullp(t5))){
t6=t4;
f_2150(2,t6,C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[20]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[0],t3);}}}

/* k2148 in file-stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2150(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2150,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2153,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:120: ##sys#stat */
f_2102(t2,((C_word*)t0)[2],t1,C_SCHEME_TRUE,lf[17]);}

/* k2151 in k2148 in file-stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2153(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2153,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),*((C_word*)lf[18]+1),*((C_word*)lf[19]+1)));}

/* ##sys#stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_fcall f_2102(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2102,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2106,a[2]=t2,a[3]=t5,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_2106(2,t7,C_fstat(t2));}
else{
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2130,a[2]=t3,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2137,a[2]=t5,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2141,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:105: ##sys#expand-home-path */
((C_proc3)C_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t9,t2);}
else{
/* posix-common.scm:111: ##sys#signal-hook */
((C_proc6)C_retrieve_proc(*((C_word*)lf[4]+1)))(6,*((C_word*)lf[4]+1),t6,lf[15],t5,lf[16],t2);}}}

/* k2139 in ##sys#stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:104: ##sys#platform-fixup-pathname */
((C_proc3)C_retrieve_proc(*((C_word*)lf[13]+1)))(3,*((C_word*)lf[13]+1),((C_word*)t0)[2],t1);}

/* k2135 in ##sys#stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:103: ##sys#make-c-string */
((C_proc4)C_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k2128 in ##sys#stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2130(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2106(2,t2,(C_truep(((C_word*)t0)[2])?C_lstat(t1):C_stat(t1)));}

/* k2104 in ##sys#stat in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2106(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[5])){
/* posix-common.scm:115: posix-error */
t2=lf[3];
f_2084(6,t2,((C_word*)t0)[4],lf[10],((C_word*)t0)[3],lf[11],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}}

/* posix-error in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2084(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_2084r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_2084r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_2084r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2088,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:63: ##sys#update-errno */
((C_proc2)C_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}

/* k2086 in posix-error in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2088,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2095,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2099,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub64(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k2097 in k2086 in posix-error in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:64: string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[5],t1);}

/* k2093 in k2086 in posix-error in k2070 in k2067 in k2064 in k2061 in k2058 in k2055 */
static void C_ccall f_2095(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[4]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[603] = {
{"toplevel:posixunix_scm",(void*)C_posix_toplevel},
{"f_2057:posixunix_scm",(void*)f_2057},
{"f_2060:posixunix_scm",(void*)f_2060},
{"f_2063:posixunix_scm",(void*)f_2063},
{"f_2066:posixunix_scm",(void*)f_2066},
{"f_2069:posixunix_scm",(void*)f_2069},
{"f_2072:posixunix_scm",(void*)f_2072},
{"f_8028:posixunix_scm",(void*)f_8028},
{"f_8061:posixunix_scm",(void*)f_8061},
{"f_8038:posixunix_scm",(void*)f_8038},
{"f_8048:posixunix_scm",(void*)f_8048},
{"f_8022:posixunix_scm",(void*)f_8022},
{"f_8026:posixunix_scm",(void*)f_8026},
{"f_2179:posixunix_scm",(void*)f_2179},
{"f_7981:posixunix_scm",(void*)f_7981},
{"f_7997:posixunix_scm",(void*)f_7997},
{"f_7985:posixunix_scm",(void*)f_7985},
{"f_7988:posixunix_scm",(void*)f_7988},
{"f_3713:posixunix_scm",(void*)f_3713},
{"f_4124:posixunix_scm",(void*)f_4124},
{"f_7975:posixunix_scm",(void*)f_7975},
{"f_4281:posixunix_scm",(void*)f_4281},
{"f_7960:posixunix_scm",(void*)f_7960},
{"f_7970:posixunix_scm",(void*)f_7970},
{"f_7957:posixunix_scm",(void*)f_7957},
{"f_4323:posixunix_scm",(void*)f_4323},
{"f_7942:posixunix_scm",(void*)f_7942},
{"f_7952:posixunix_scm",(void*)f_7952},
{"f_7939:posixunix_scm",(void*)f_7939},
{"f_4327:posixunix_scm",(void*)f_4327},
{"f_7924:posixunix_scm",(void*)f_7924},
{"f_7934:posixunix_scm",(void*)f_7934},
{"f_7921:posixunix_scm",(void*)f_7921},
{"f_4331:posixunix_scm",(void*)f_4331},
{"f_7906:posixunix_scm",(void*)f_7906},
{"f_7916:posixunix_scm",(void*)f_7916},
{"f_7903:posixunix_scm",(void*)f_7903},
{"f_4335:posixunix_scm",(void*)f_4335},
{"f_7882:posixunix_scm",(void*)f_7882},
{"f_7898:posixunix_scm",(void*)f_7898},
{"f_7864:posixunix_scm",(void*)f_7864},
{"f_7877:posixunix_scm",(void*)f_7877},
{"f_7871:posixunix_scm",(void*)f_7871},
{"f_4853:posixunix_scm",(void*)f_4853},
{"f_4892:posixunix_scm",(void*)f_4892},
{"f_7841:posixunix_scm",(void*)f_7841},
{"f_7833:posixunix_scm",(void*)f_7833},
{"f_7851:posixunix_scm",(void*)f_7851},
{"f_7768:posixunix_scm",(void*)f_7768},
{"f_7780:posixunix_scm",(void*)f_7780},
{"f_7775:posixunix_scm",(void*)f_7775},
{"f_7770:posixunix_scm",(void*)f_7770},
{"f_7708:posixunix_scm",(void*)f_7708},
{"f_7720:posixunix_scm",(void*)f_7720},
{"f_7715:posixunix_scm",(void*)f_7715},
{"f_7710:posixunix_scm",(void*)f_7710},
{"f_7647:posixunix_scm",(void*)f_7647},
{"f_7702:posixunix_scm",(void*)f_7702},
{"f_7706:posixunix_scm",(void*)f_7706},
{"f_7668:posixunix_scm",(void*)f_7668},
{"f_7671:posixunix_scm",(void*)f_7671},
{"f_7682:posixunix_scm",(void*)f_7682},
{"f_7676:posixunix_scm",(void*)f_7676},
{"f_7649:posixunix_scm",(void*)f_7649},
{"f_7658:posixunix_scm",(void*)f_7658},
{"f_7591:posixunix_scm",(void*)f_7591},
{"f_7603:posixunix_scm",(void*)f_7603},
{"f_7634:posixunix_scm",(void*)f_7634},
{"f_7614:posixunix_scm",(void*)f_7614},
{"f_7630:posixunix_scm",(void*)f_7630},
{"f_7618:posixunix_scm",(void*)f_7618},
{"f_7626:posixunix_scm",(void*)f_7626},
{"f_7622:posixunix_scm",(void*)f_7622},
{"f_7597:posixunix_scm",(void*)f_7597},
{"f_7580:posixunix_scm",(void*)f_7580},
{"f_7584:posixunix_scm",(void*)f_7584},
{"f_7569:posixunix_scm",(void*)f_7569},
{"f_7573:posixunix_scm",(void*)f_7573},
{"f_7524:posixunix_scm",(void*)f_7524},
{"f_7528:posixunix_scm",(void*)f_7528},
{"f_7531:posixunix_scm",(void*)f_7531},
{"f_7534:posixunix_scm",(void*)f_7534},
{"f_7541:posixunix_scm",(void*)f_7541},
{"f_7547:posixunix_scm",(void*)f_7547},
{"f_7551:posixunix_scm",(void*)f_7551},
{"f_7554:posixunix_scm",(void*)f_7554},
{"f_7557:posixunix_scm",(void*)f_7557},
{"f_7545:posixunix_scm",(void*)f_7545},
{"f_7491:posixunix_scm",(void*)f_7491},
{"f_7504:posixunix_scm",(void*)f_7504},
{"f_7416:posixunix_scm",(void*)f_7416},
{"f_7477:posixunix_scm",(void*)f_7477},
{"f_7490:posixunix_scm",(void*)f_7490},
{"f_7457:posixunix_scm",(void*)f_7457},
{"f_7472:posixunix_scm",(void*)f_7472},
{"f_7466:posixunix_scm",(void*)f_7466},
{"f_7420:posixunix_scm",(void*)f_7420},
{"f_7422:posixunix_scm",(void*)f_7422},
{"f_7443:posixunix_scm",(void*)f_7443},
{"f_7437:posixunix_scm",(void*)f_7437},
{"f_7364:posixunix_scm",(void*)f_7364},
{"f_7371:posixunix_scm",(void*)f_7371},
{"f_7390:posixunix_scm",(void*)f_7390},
{"f_7394:posixunix_scm",(void*)f_7394},
{"f_7358:posixunix_scm",(void*)f_7358},
{"f_7349:posixunix_scm",(void*)f_7349},
{"f_7353:posixunix_scm",(void*)f_7353},
{"f_7322:posixunix_scm",(void*)f_7322},
{"f_7315:posixunix_scm",(void*)f_7315},
{"f_7312:posixunix_scm",(void*)f_7312},
{"f_7309:posixunix_scm",(void*)f_7309},
{"f_7231:posixunix_scm",(void*)f_7231},
{"f_7267:posixunix_scm",(void*)f_7267},
{"f_7261:posixunix_scm",(void*)f_7261},
{"f_7214:posixunix_scm",(void*)f_7214},
{"f_7032:posixunix_scm",(void*)f_7032},
{"f_7166:posixunix_scm",(void*)f_7166},
{"f_7161:posixunix_scm",(void*)f_7161},
{"f_7034:posixunix_scm",(void*)f_7034},
{"f_7044:posixunix_scm",(void*)f_7044},
{"f_7052:posixunix_scm",(void*)f_7052},
{"f_7098:posixunix_scm",(void*)f_7098},
{"f_7065:posixunix_scm",(void*)f_7065},
{"f_7090:posixunix_scm",(void*)f_7090},
{"f_7068:posixunix_scm",(void*)f_7068},
{"f_7013:posixunix_scm",(void*)f_7013},
{"f_6994:posixunix_scm",(void*)f_6994},
{"f_6952:posixunix_scm",(void*)f_6952},
{"f_6977:posixunix_scm",(void*)f_6977},
{"f_6938:posixunix_scm",(void*)f_6938},
{"f_6942:posixunix_scm",(void*)f_6942},
{"f_6945:posixunix_scm",(void*)f_6945},
{"f_6903:posixunix_scm",(void*)f_6903},
{"f_6907:posixunix_scm",(void*)f_6907},
{"f_6927:posixunix_scm",(void*)f_6927},
{"f_6931:posixunix_scm",(void*)f_6931},
{"f_6880:posixunix_scm",(void*)f_6880},
{"f_6884:posixunix_scm",(void*)f_6884},
{"f_6848:posixunix_scm",(void*)f_6848},
{"f_6852:posixunix_scm",(void*)f_6852},
{"f_6829:posixunix_scm",(void*)f_6829},
{"f_6833:posixunix_scm",(void*)f_6833},
{"f_6836:posixunix_scm",(void*)f_6836},
{"f_6770:posixunix_scm",(void*)f_6770},
{"f_6774:posixunix_scm",(void*)f_6774},
{"f_6780:posixunix_scm",(void*)f_6780},
{"f_6789:posixunix_scm",(void*)f_6789},
{"f_6763:posixunix_scm",(void*)f_6763},
{"f_6747:posixunix_scm",(void*)f_6747},
{"f_6735:posixunix_scm",(void*)f_6735},
{"f_6720:posixunix_scm",(void*)f_6720},
{"f_6724:posixunix_scm",(void*)f_6724},
{"f_6730:posixunix_scm",(void*)f_6730},
{"f_6705:posixunix_scm",(void*)f_6705},
{"f_6709:posixunix_scm",(void*)f_6709},
{"f_6715:posixunix_scm",(void*)f_6715},
{"f_6659:posixunix_scm",(void*)f_6659},
{"f_6663:posixunix_scm",(void*)f_6663},
{"f_6676:posixunix_scm",(void*)f_6676},
{"f_6680:posixunix_scm",(void*)f_6680},
{"f_6590:posixunix_scm",(void*)f_6590},
{"f_6594:posixunix_scm",(void*)f_6594},
{"f_6597:posixunix_scm",(void*)f_6597},
{"f_6619:posixunix_scm",(void*)f_6619},
{"f_6616:posixunix_scm",(void*)f_6616},
{"f_6606:posixunix_scm",(void*)f_6606},
{"f_6529:posixunix_scm",(void*)f_6529},
{"f_6533:posixunix_scm",(void*)f_6533},
{"f_6539:posixunix_scm",(void*)f_6539},
{"f_6485:posixunix_scm",(void*)f_6485},
{"f_6489:posixunix_scm",(void*)f_6489},
{"f_6451:posixunix_scm",(void*)f_6451},
{"f_6455:posixunix_scm",(void*)f_6455},
{"f_6432:posixunix_scm",(void*)f_6432},
{"f_6426:posixunix_scm",(void*)f_6426},
{"f_6417:posixunix_scm",(void*)f_6417},
{"f_6382:posixunix_scm",(void*)f_6382},
{"f_6320:posixunix_scm",(void*)f_6320},
{"f_6324:posixunix_scm",(void*)f_6324},
{"f_6330:posixunix_scm",(void*)f_6330},
{"f_6349:posixunix_scm",(void*)f_6349},
{"f_6336:posixunix_scm",(void*)f_6336},
{"f_6217:posixunix_scm",(void*)f_6217},
{"f_6223:posixunix_scm",(void*)f_6223},
{"f_6227:posixunix_scm",(void*)f_6227},
{"f_6235:posixunix_scm",(void*)f_6235},
{"f_6261:posixunix_scm",(void*)f_6261},
{"f_6265:posixunix_scm",(void*)f_6265},
{"f_6253:posixunix_scm",(void*)f_6253},
{"f_6197:posixunix_scm",(void*)f_6197},
{"f_6205:posixunix_scm",(void*)f_6205},
{"f_6180:posixunix_scm",(void*)f_6180},
{"f_6191:posixunix_scm",(void*)f_6191},
{"f_6195:posixunix_scm",(void*)f_6195},
{"f_6154:posixunix_scm",(void*)f_6154},
{"f_6178:posixunix_scm",(void*)f_6178},
{"f_6161:posixunix_scm",(void*)f_6161},
{"f_6111:posixunix_scm",(void*)f_6111},
{"f_6118:posixunix_scm",(void*)f_6118},
{"f_6139:posixunix_scm",(void*)f_6139},
{"f_6135:posixunix_scm",(void*)f_6135},
{"f_6083:posixunix_scm",(void*)f_6083},
{"f_6056:posixunix_scm",(void*)f_6056},
{"f_6060:posixunix_scm",(void*)f_6060},
{"f_6041:posixunix_scm",(void*)f_6041},
{"f_6045:posixunix_scm",(void*)f_6045},
{"f_6026:posixunix_scm",(void*)f_6026},
{"f_6030:posixunix_scm",(void*)f_6030},
{"f_6008:posixunix_scm",(void*)f_6008},
{"f_5934:posixunix_scm",(void*)f_5934},
{"f_5956:posixunix_scm",(void*)f_5956},
{"f_5962:posixunix_scm",(void*)f_5962},
{"f_5895:posixunix_scm",(void*)f_5895},
{"f_5923:posixunix_scm",(void*)f_5923},
{"f_5919:posixunix_scm",(void*)f_5919},
{"f_5912:posixunix_scm",(void*)f_5912},
{"f_5905:posixunix_scm",(void*)f_5905},
{"f_5636:posixunix_scm",(void*)f_5636},
{"f_5832:posixunix_scm",(void*)f_5832},
{"f_5827:posixunix_scm",(void*)f_5827},
{"f_5822:posixunix_scm",(void*)f_5822},
{"f_5638:posixunix_scm",(void*)f_5638},
{"f_5642:posixunix_scm",(void*)f_5642},
{"f_5748:posixunix_scm",(void*)f_5748},
{"f_5749:posixunix_scm",(void*)f_5749},
{"f_5766:posixunix_scm",(void*)f_5766},
{"f_5776:posixunix_scm",(void*)f_5776},
{"f_5734:posixunix_scm",(void*)f_5734},
{"f_5690:posixunix_scm",(void*)f_5690},
{"f_5726:posixunix_scm",(void*)f_5726},
{"f_5705:posixunix_scm",(void*)f_5705},
{"f_5715:posixunix_scm",(void*)f_5715},
{"f_5699:posixunix_scm",(void*)f_5699},
{"f_5694:posixunix_scm",(void*)f_5694},
{"f_5697:posixunix_scm",(void*)f_5697},
{"f_5644:posixunix_scm",(void*)f_5644},
{"f_5679:posixunix_scm",(void*)f_5679},
{"f_5660:posixunix_scm",(void*)f_5660},
{"f_5154:posixunix_scm",(void*)f_5154},
{"f_5558:posixunix_scm",(void*)f_5558},
{"f_5553:posixunix_scm",(void*)f_5553},
{"f_5548:posixunix_scm",(void*)f_5548},
{"f_5543:posixunix_scm",(void*)f_5543},
{"f_5156:posixunix_scm",(void*)f_5156},
{"f_5160:posixunix_scm",(void*)f_5160},
{"f_5166:posixunix_scm",(void*)f_5166},
{"f_5416:posixunix_scm",(void*)f_5416},
{"f_5422:posixunix_scm",(void*)f_5422},
{"f_5518:posixunix_scm",(void*)f_5518},
{"f_5508:posixunix_scm",(void*)f_5508},
{"f_5502:posixunix_scm",(void*)f_5502},
{"f_5424:posixunix_scm",(void*)f_5424},
{"f_5474:posixunix_scm",(void*)f_5474},
{"f_5431:posixunix_scm",(void*)f_5431},
{"f_5441:posixunix_scm",(void*)f_5441},
{"f_5340:posixunix_scm",(void*)f_5340},
{"f_5348:posixunix_scm",(void*)f_5348},
{"f_5350:posixunix_scm",(void*)f_5350},
{"f_5398:posixunix_scm",(void*)f_5398},
{"f_5331:posixunix_scm",(void*)f_5331},
{"f_5335:posixunix_scm",(void*)f_5335},
{"f_5310:posixunix_scm",(void*)f_5310},
{"f_5320:posixunix_scm",(void*)f_5320},
{"f_5298:posixunix_scm",(void*)f_5298},
{"f_5285:posixunix_scm",(void*)f_5285},
{"f_5289:posixunix_scm",(void*)f_5289},
{"f_5280:posixunix_scm",(void*)f_5280},
{"f_5283:posixunix_scm",(void*)f_5283},
{"f_5198:posixunix_scm",(void*)f_5198},
{"f_5210:posixunix_scm",(void*)f_5210},
{"f_5247:posixunix_scm",(void*)f_5247},
{"f_5256:posixunix_scm",(void*)f_5256},
{"f_5250:posixunix_scm",(void*)f_5250},
{"f_5226:posixunix_scm",(void*)f_5226},
{"f_5229:posixunix_scm",(void*)f_5229},
{"f_5190:posixunix_scm",(void*)f_5190},
{"f_5167:posixunix_scm",(void*)f_5167},
{"f_5171:posixunix_scm",(void*)f_5171},
{"f_5127:posixunix_scm",(void*)f_5127},
{"f_5134:posixunix_scm",(void*)f_5134},
{"f_5137:posixunix_scm",(void*)f_5137},
{"f_5082:posixunix_scm",(void*)f_5082},
{"f_5086:posixunix_scm",(void*)f_5086},
{"f_5121:posixunix_scm",(void*)f_5121},
{"f_5104:posixunix_scm",(void*)f_5104},
{"f_5068:posixunix_scm",(void*)f_5068},
{"f_5080:posixunix_scm",(void*)f_5080},
{"f_5054:posixunix_scm",(void*)f_5054},
{"f_5066:posixunix_scm",(void*)f_5066},
{"f_5039:posixunix_scm",(void*)f_5039},
{"f_5052:posixunix_scm",(void*)f_5052},
{"f_5002:posixunix_scm",(void*)f_5002},
{"f_5010:posixunix_scm",(void*)f_5010},
{"f_4977:posixunix_scm",(void*)f_4977},
{"f_4958:posixunix_scm",(void*)f_4958},
{"f_4962:posixunix_scm",(void*)f_4962},
{"f_4990:posixunix_scm",(void*)f_4990},
{"f_4893:posixunix_scm",(void*)f_4893},
{"f_4897:posixunix_scm",(void*)f_4897},
{"f_4932:posixunix_scm",(void*)f_4932},
{"f_4904:posixunix_scm",(void*)f_4904},
{"f_4907:posixunix_scm",(void*)f_4907},
{"f_4910:posixunix_scm",(void*)f_4910},
{"f_4916:posixunix_scm",(void*)f_4916},
{"f_4855:posixunix_scm",(void*)f_4855},
{"f_4888:posixunix_scm",(void*)f_4888},
{"f_4876:posixunix_scm",(void*)f_4876},
{"f_4884:posixunix_scm",(void*)f_4884},
{"f_4880:posixunix_scm",(void*)f_4880},
{"f_4836:posixunix_scm",(void*)f_4836},
{"f_4846:posixunix_scm",(void*)f_4846},
{"f_4840:posixunix_scm",(void*)f_4840},
{"f_4830:posixunix_scm",(void*)f_4830},
{"f_4824:posixunix_scm",(void*)f_4824},
{"f_4818:posixunix_scm",(void*)f_4818},
{"f_4794:posixunix_scm",(void*)f_4794},
{"f_4816:posixunix_scm",(void*)f_4816},
{"f_4812:posixunix_scm",(void*)f_4812},
{"f_4804:posixunix_scm",(void*)f_4804},
{"f_4764:posixunix_scm",(void*)f_4764},
{"f_4792:posixunix_scm",(void*)f_4792},
{"f_4788:posixunix_scm",(void*)f_4788},
{"f_4737:posixunix_scm",(void*)f_4737},
{"f_4762:posixunix_scm",(void*)f_4762},
{"f_4758:posixunix_scm",(void*)f_4758},
{"f_4673:posixunix_scm",(void*)f_4673},
{"f_4661:posixunix_scm",(void*)f_4661},
{"f_4689:posixunix_scm",(void*)f_4689},
{"f_4599:posixunix_scm",(void*)f_4599},
{"f_4603:posixunix_scm",(void*)f_4603},
{"f_4608:posixunix_scm",(void*)f_4608},
{"f_4624:posixunix_scm",(void*)f_4624},
{"f_4536:posixunix_scm",(void*)f_4536},
{"f_4594:posixunix_scm",(void*)f_4594},
{"f_4540:posixunix_scm",(void*)f_4540},
{"f_4543:posixunix_scm",(void*)f_4543},
{"f_4575:posixunix_scm",(void*)f_4575},
{"f_4546:posixunix_scm",(void*)f_4546},
{"f_4551:posixunix_scm",(void*)f_4551},
{"f_4565:posixunix_scm",(void*)f_4565},
{"f_4443:posixunix_scm",(void*)f_4443},
{"f_4447:posixunix_scm",(void*)f_4447},
{"f_4501:posixunix_scm",(void*)f_4501},
{"f_4450:posixunix_scm",(void*)f_4450},
{"f_4463:posixunix_scm",(void*)f_4463},
{"f_4467:posixunix_scm",(void*)f_4467},
{"f_4473:posixunix_scm",(void*)f_4473},
{"f_4477:posixunix_scm",(void*)f_4477},
{"f_4487:posixunix_scm",(void*)f_4487},
{"f_4471:posixunix_scm",(void*)f_4471},
{"f_4418:posixunix_scm",(void*)f_4418},
{"f_4430:posixunix_scm",(void*)f_4430},
{"f_4426:posixunix_scm",(void*)f_4426},
{"f_4404:posixunix_scm",(void*)f_4404},
{"f_4416:posixunix_scm",(void*)f_4416},
{"f_4412:posixunix_scm",(void*)f_4412},
{"f_4337:posixunix_scm",(void*)f_4337},
{"f_4341:posixunix_scm",(void*)f_4341},
{"f_4383:posixunix_scm",(void*)f_4383},
{"f_4344:posixunix_scm",(void*)f_4344},
{"f_4357:posixunix_scm",(void*)f_4357},
{"f_4361:posixunix_scm",(void*)f_4361},
{"f_4365:posixunix_scm",(void*)f_4365},
{"f_4369:posixunix_scm",(void*)f_4369},
{"f_4373:posixunix_scm",(void*)f_4373},
{"f_4283:posixunix_scm",(void*)f_4283},
{"f_4316:posixunix_scm",(void*)f_4316},
{"f_4287:posixunix_scm",(void*)f_4287},
{"f_4294:posixunix_scm",(void*)f_4294},
{"f_4298:posixunix_scm",(void*)f_4298},
{"f_4302:posixunix_scm",(void*)f_4302},
{"f_4306:posixunix_scm",(void*)f_4306},
{"f_4310:posixunix_scm",(void*)f_4310},
{"f_4265:posixunix_scm",(void*)f_4265},
{"f_4250:posixunix_scm",(void*)f_4250},
{"f_4244:posixunix_scm",(void*)f_4244},
{"f_4212:posixunix_scm",(void*)f_4212},
{"f_4218:posixunix_scm",(void*)f_4218},
{"f_4166:posixunix_scm",(void*)f_4166},
{"f_4184:posixunix_scm",(void*)f_4184},
{"f_4148:posixunix_scm",(void*)f_4148},
{"f_4158:posixunix_scm",(void*)f_4158},
{"f_4135:posixunix_scm",(void*)f_4135},
{"f_4126:posixunix_scm",(void*)f_4126},
{"f_4079:posixunix_scm",(void*)f_4079},
{"f_4083:posixunix_scm",(void*)f_4083},
{"f_4059:posixunix_scm",(void*)f_4059},
{"f_4063:posixunix_scm",(void*)f_4063},
{"f_4069:posixunix_scm",(void*)f_4069},
{"f_4073:posixunix_scm",(void*)f_4073},
{"f_4039:posixunix_scm",(void*)f_4039},
{"f_4043:posixunix_scm",(void*)f_4043},
{"f_4049:posixunix_scm",(void*)f_4049},
{"f_4053:posixunix_scm",(void*)f_4053},
{"f_4015:posixunix_scm",(void*)f_4015},
{"f_4019:posixunix_scm",(void*)f_4019},
{"f_4030:posixunix_scm",(void*)f_4030},
{"f_4034:posixunix_scm",(void*)f_4034},
{"f_4024:posixunix_scm",(void*)f_4024},
{"f_3991:posixunix_scm",(void*)f_3991},
{"f_3995:posixunix_scm",(void*)f_3995},
{"f_4006:posixunix_scm",(void*)f_4006},
{"f_4010:posixunix_scm",(void*)f_4010},
{"f_4000:posixunix_scm",(void*)f_4000},
{"f_3975:posixunix_scm",(void*)f_3975},
{"f_3979:posixunix_scm",(void*)f_3979},
{"f_3982:posixunix_scm",(void*)f_3982},
{"f_3939:posixunix_scm",(void*)f_3939},
{"f_3970:posixunix_scm",(void*)f_3970},
{"f_3960:posixunix_scm",(void*)f_3960},
{"f_3953:posixunix_scm",(void*)f_3953},
{"f_3903:posixunix_scm",(void*)f_3903},
{"f_3934:posixunix_scm",(void*)f_3934},
{"f_3924:posixunix_scm",(void*)f_3924},
{"f_3917:posixunix_scm",(void*)f_3917},
{"f_3888:posixunix_scm",(void*)f_3888},
{"f_3901:posixunix_scm",(void*)f_3901},
{"f_3848:posixunix_scm",(void*)f_3848},
{"f_3868:posixunix_scm",(void*)f_3868},
{"f_3855:posixunix_scm",(void*)f_3855},
{"f_3858:posixunix_scm",(void*)f_3858},
{"f_3715:posixunix_scm",(void*)f_3715},
{"f_3719:posixunix_scm",(void*)f_3719},
{"f_3725:posixunix_scm",(void*)f_3725},
{"f_3734:posixunix_scm",(void*)f_3734},
{"f_3817:posixunix_scm",(void*)f_3817},
{"f_3794:posixunix_scm",(void*)f_3794},
{"f_3788:posixunix_scm",(void*)f_3788},
{"f_3744:posixunix_scm",(void*)f_3744},
{"f_3746:posixunix_scm",(void*)f_3746},
{"f_3786:posixunix_scm",(void*)f_3786},
{"f_3753:posixunix_scm",(void*)f_3753},
{"f_3779:posixunix_scm",(void*)f_3779},
{"f_3756:posixunix_scm",(void*)f_3756},
{"f_3772:posixunix_scm",(void*)f_3772},
{"f_3728:posixunix_scm",(void*)f_3728},
{"f_3653:posixunix_scm",(void*)f_3653},
{"f_3666:posixunix_scm",(void*)f_3666},
{"f_3678:posixunix_scm",(void*)f_3678},
{"f_3672:posixunix_scm",(void*)f_3672},
{"f_3373:posixunix_scm",(void*)f_3373},
{"f_3612:posixunix_scm",(void*)f_3612},
{"f_3620:posixunix_scm",(void*)f_3620},
{"f_3389:posixunix_scm",(void*)f_3389},
{"f_3564:posixunix_scm",(void*)f_3564},
{"f_3572:posixunix_scm",(void*)f_3572},
{"f_3395:posixunix_scm",(void*)f_3395},
{"f_3398:posixunix_scm",(void*)f_3398},
{"f_3502:posixunix_scm",(void*)f_3502},
{"f_3510:posixunix_scm",(void*)f_3510},
{"f_3500:posixunix_scm",(void*)f_3500},
{"f_3437:posixunix_scm",(void*)f_3437},
{"f_3455:posixunix_scm",(void*)f_3455},
{"f_3463:posixunix_scm",(void*)f_3463},
{"f_3453:posixunix_scm",(void*)f_3453},
{"f_3315:posixunix_scm",(void*)f_3315},
{"f_3322:posixunix_scm",(void*)f_3322},
{"f_3328:posixunix_scm",(void*)f_3328},
{"f_3335:posixunix_scm",(void*)f_3335},
{"f_3276:posixunix_scm",(void*)f_3276},
{"f_3283:posixunix_scm",(void*)f_3283},
{"f_3292:posixunix_scm",(void*)f_3292},
{"f_3234:posixunix_scm",(void*)f_3234},
{"f_3244:posixunix_scm",(void*)f_3244},
{"f_3247:posixunix_scm",(void*)f_3247},
{"f_3250:posixunix_scm",(void*)f_3250},
{"f_3219:posixunix_scm",(void*)f_3219},
{"f_3181:posixunix_scm",(void*)f_3181},
{"f_3211:posixunix_scm",(void*)f_3211},
{"f_3198:posixunix_scm",(void*)f_3198},
{"f_3201:posixunix_scm",(void*)f_3201},
{"f_3135:posixunix_scm",(void*)f_3135},
{"f_3139:posixunix_scm",(void*)f_3139},
{"f_3078:posixunix_scm",(void*)f_3078},
{"f_3071:posixunix_scm",(void*)f_3071},
{"f_2890:posixunix_scm",(void*)f_2890},
{"f_3065:posixunix_scm",(void*)f_3065},
{"f_2900:posixunix_scm",(void*)f_2900},
{"f_3011:posixunix_scm",(void*)f_3011},
{"f_3055:posixunix_scm",(void*)f_3055},
{"f_3057:posixunix_scm",(void*)f_3057},
{"f_3015:posixunix_scm",(void*)f_3015},
{"f_3047:posixunix_scm",(void*)f_3047},
{"f_3049:posixunix_scm",(void*)f_3049},
{"f_3018:posixunix_scm",(void*)f_3018},
{"f_3044:posixunix_scm",(void*)f_3044},
{"f_3021:posixunix_scm",(void*)f_3021},
{"f_3041:posixunix_scm",(void*)f_3041},
{"f_3024:posixunix_scm",(void*)f_3024},
{"f_3038:posixunix_scm",(void*)f_3038},
{"f_3027:posixunix_scm",(void*)f_3027},
{"f_3035:posixunix_scm",(void*)f_3035},
{"f_3030:posixunix_scm",(void*)f_3030},
{"f_2927:posixunix_scm",(void*)f_2927},
{"f_2933:posixunix_scm",(void*)f_2933},
{"f_2916:posixunix_scm",(void*)f_2916},
{"f_2922:posixunix_scm",(void*)f_2922},
{"f_2911:posixunix_scm",(void*)f_2911},
{"f_2906:posixunix_scm",(void*)f_2906},
{"f_2901:posixunix_scm",(void*)f_2901},
{"f_2717:posixunix_scm",(void*)f_2717},
{"f_2876:posixunix_scm",(void*)f_2876},
{"f_2884:posixunix_scm",(void*)f_2884},
{"f_2724:posixunix_scm",(void*)f_2724},
{"f_2861:posixunix_scm",(void*)f_2861},
{"f_2864:posixunix_scm",(void*)f_2864},
{"f_2865:posixunix_scm",(void*)f_2865},
{"f_2727:posixunix_scm",(void*)f_2727},
{"f_2851:posixunix_scm",(void*)f_2851},
{"f_2734:posixunix_scm",(void*)f_2734},
{"f_2736:posixunix_scm",(void*)f_2736},
{"f_2755:posixunix_scm",(void*)f_2755},
{"f_2837:posixunix_scm",(void*)f_2837},
{"f_2844:posixunix_scm",(void*)f_2844},
{"f_2831:posixunix_scm",(void*)f_2831},
{"f_2770:posixunix_scm",(void*)f_2770},
{"f_2824:posixunix_scm",(void*)f_2824},
{"f_2821:posixunix_scm",(void*)f_2821},
{"f_2811:posixunix_scm",(void*)f_2811},
{"f_2787:posixunix_scm",(void*)f_2787},
{"f_2809:posixunix_scm",(void*)f_2809},
{"f_2795:posixunix_scm",(void*)f_2795},
{"f_2802:posixunix_scm",(void*)f_2802},
{"f_2799:posixunix_scm",(void*)f_2799},
{"f_2782:posixunix_scm",(void*)f_2782},
{"f_2780:posixunix_scm",(void*)f_2780},
{"f_2605:posixunix_scm",(void*)f_2605},
{"f_2611:posixunix_scm",(void*)f_2611},
{"f_2632:posixunix_scm",(void*)f_2632},
{"f_2711:posixunix_scm",(void*)f_2711},
{"f_2636:posixunix_scm",(void*)f_2636},
{"f_2639:posixunix_scm",(void*)f_2639},
{"f_2646:posixunix_scm",(void*)f_2646},
{"f_2648:posixunix_scm",(void*)f_2648},
{"f_2665:posixunix_scm",(void*)f_2665},
{"f_2669:posixunix_scm",(void*)f_2669},
{"f_2677:posixunix_scm",(void*)f_2677},
{"f_2681:posixunix_scm",(void*)f_2681},
{"f_2626:posixunix_scm",(void*)f_2626},
{"f_2448:posixunix_scm",(void*)f_2448},
{"f_2553:posixunix_scm",(void*)f_2553},
{"f_2561:posixunix_scm",(void*)f_2561},
{"f_2548:posixunix_scm",(void*)f_2548},
{"f_2450:posixunix_scm",(void*)f_2450},
{"f_2457:posixunix_scm",(void*)f_2457},
{"f_2460:posixunix_scm",(void*)f_2460},
{"f_2463:posixunix_scm",(void*)f_2463},
{"f_2547:posixunix_scm",(void*)f_2547},
{"f_2467:posixunix_scm",(void*)f_2467},
{"f_2481:posixunix_scm",(void*)f_2481},
{"f_2491:posixunix_scm",(void*)f_2491},
{"f_2503:posixunix_scm",(void*)f_2503},
{"f_2513:posixunix_scm",(void*)f_2513},
{"f_2426:posixunix_scm",(void*)f_2426},
{"f_2446:posixunix_scm",(void*)f_2446},
{"f_2433:posixunix_scm",(void*)f_2433},
{"f_2436:posixunix_scm",(void*)f_2436},
{"f_2380:posixunix_scm",(void*)f_2380},
{"f_2384:posixunix_scm",(void*)f_2384},
{"f_2393:posixunix_scm",(void*)f_2393},
{"f_2396:posixunix_scm",(void*)f_2396},
{"f_2370:posixunix_scm",(void*)f_2370},
{"f_2378:posixunix_scm",(void*)f_2378},
{"f_2360:posixunix_scm",(void*)f_2360},
{"f_2368:posixunix_scm",(void*)f_2368},
{"f_2350:posixunix_scm",(void*)f_2350},
{"f_2358:posixunix_scm",(void*)f_2358},
{"f_2340:posixunix_scm",(void*)f_2340},
{"f_2348:posixunix_scm",(void*)f_2348},
{"f_2330:posixunix_scm",(void*)f_2330},
{"f_2338:posixunix_scm",(void*)f_2338},
{"f_2320:posixunix_scm",(void*)f_2320},
{"f_2328:posixunix_scm",(void*)f_2328},
{"f_2310:posixunix_scm",(void*)f_2310},
{"f_2318:posixunix_scm",(void*)f_2318},
{"f_2211:posixunix_scm",(void*)f_2211},
{"f_2262:posixunix_scm",(void*)f_2262},
{"f_2257:posixunix_scm",(void*)f_2257},
{"f_2213:posixunix_scm",(void*)f_2213},
{"f_2220:posixunix_scm",(void*)f_2220},
{"f_2205:posixunix_scm",(void*)f_2205},
{"f_2209:posixunix_scm",(void*)f_2209},
{"f_2199:posixunix_scm",(void*)f_2199},
{"f_2203:posixunix_scm",(void*)f_2203},
{"f_2193:posixunix_scm",(void*)f_2193},
{"f_2197:posixunix_scm",(void*)f_2197},
{"f_2187:posixunix_scm",(void*)f_2187},
{"f_2191:posixunix_scm",(void*)f_2191},
{"f_2181:posixunix_scm",(void*)f_2181},
{"f_2185:posixunix_scm",(void*)f_2185},
{"f_2146:posixunix_scm",(void*)f_2146},
{"f_2150:posixunix_scm",(void*)f_2150},
{"f_2153:posixunix_scm",(void*)f_2153},
{"f_2102:posixunix_scm",(void*)f_2102},
{"f_2141:posixunix_scm",(void*)f_2141},
{"f_2137:posixunix_scm",(void*)f_2137},
{"f_2130:posixunix_scm",(void*)f_2130},
{"f_2106:posixunix_scm",(void*)f_2106},
{"f_2084:posixunix_scm",(void*)f_2084},
{"f_2088:posixunix_scm",(void*)f_2088},
{"f_2099:posixunix_scm",(void*)f_2099},
{"f_2095:posixunix_scm",(void*)f_2095},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
