# Distributed under the terms of the GNU General Public License v2

inherit subversion flag-o-matic eutils

DESCRIPTION="A next generation init replacement"
HOMEPAGE="http://initng.thinktux.net/"
ESVN_REPO_URI="http://svn.initng.thinktux.net/initng/"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~arm ~hppa ~ia64 ~s390 ~x86"
IUSE="debug"

src_compile() {
	cd ${S}

	ebegin "Reconfiguring configure scripts (be patient)"
	libtoolize --force --copy || die "libtoolize"
	aclocal || die "aclocal"
	autoheader || die "autoheader"
	autoconf || die "autoconf"
	automake --add-missing --copy --gnu || die "automake"
	eend $?

	if ! use debug
	then
		myconf="--disable-debug" || die
	fi

	econf --sbindir=/sbin --libdir=/lib ${myconf} || die
	
	emake || die
}

src_install() {
	make install DESTDIR="${D}" || die
	dodoc README FAQ AUTHORS ChangeLog NEWS TEMPLATE_HEADER TODO doc/databases.txt doc/empty.conf doc/hard.conf doc/initng.txt
}

pkg_postinst() {
	einfo "remember to add init=/sbin/initng in your grub or lilo config to use initng"
	einfo "Happy testing."
}
