# Note, most of this is taken from /usr/share/initramfs-tools/scripts/init-top/usplash in debian.
service system/usplash {
	need = system/initial;
	env SPLASH=false;
	env VESA=false;
	script start = {
		# test, why are we doing this?
		chvt 6
		for x in `/bin/cat /proc/cmdline`
		do
			case ${x} in
				splash*)
					SPLASH=true
					;;
				vga=*)
					VESA=true
					;;
			esac
		done
		
		if [ "${SPLASH}" = "true" ]
		then
			[ "${VESA}" = "true" ] && vmod=vesafb || vmod=vga16fb
			for module in bitblit font tileblit fbcon cfbcopyarea cfbfillrect cfbimgblt softcursor vgastate ${vmod}
			do
				/sbin/modprobe ${module}
			done
			/bin/mknod /dev/fb0 c 29 0
			for i in `/usr/bin/seq 0 8`
			do
				/bin/mknod /dev/tty${i} c 4 ${i}
			done
			/sbin/usplash -c &

			sleep 1
			usplash_write "TIMEOUT 30"
			
			sleep 0.5
			usplash_write "TEXT Loading usplash"
		fi
	}
}
