service system/usb {
	need = system/bootmisc system/modules/usbcore;
	script start = {
		# Check what USB fs the kernel support.  Currently
		# 2.5+ kernels, and later 2.4 kernels have 'usbfs',
		# while older kernels have 'usbdevfs'.
		usbfs=`/bin/grep -ow "usb(dev)?fs" /proc/filesystems`

		if [ -n "${usbfs}" -a -e /proc/bus/usb -a ! -e /proc/bus/usb/devices ]
		then
			echo "Mounting USB device filesystem (${usbfs}) ..."
			usbgid=`/usr/bin/awk -F: '/^usb:/{print $3; exit}' /etc/group`
			if [ -n "${usbgid}" ]
			then
				/bin/mount -t ${usbfs} usbfs /proc/bus/usb ${usbgid:+-o devmode=0664,devgid=${usbgid}} >/dev/null 2>&1 &
			else
				/bin/mount -t ${usbfs} usbfs /proc/bus/usb >/dev/null 2>&1 &
			fi
		fi
	};
}
