service system/urandom {
	need = system/bootmisc system/modules/nvram;
	env SAVEDFILE=/var/run/random-seed;
	script start = {
		[ -c /dev/urandom ] || exit 1
		[ -f "${SAVEDFILE}" ] && /bin/cat "${SAVEDFILE}" >/dev/urandom
		if ! /bin/rm -f "${SAVEDFILE}" 2>&1 >/dev/null
		then
			echo "Skipping ${SAVEDFILE} initialization (ro root?)"
			exit 1
		fi
		umask 077
		/bin/dd if=/dev/urandom of=${SAVEDFILE} count=1 >/dev/null 2>&1
	};

	script stop = {
		umask 077
		/bin/dd if=/dev/urandom of=${SAVEDFILE} count=1 >/dev/null 2>&1
	};
}
