service system/static-modules {
	need = system/bootmisc;
	script start = {
		load_modules() {
			[ -r "${1}" ] || return 1
			/bin/grep -v "^#" "${1}" | /bin/grep -v "^$" | while read MODULE MODARGS
			do
				echo "Loading module \"${MODULE}\" ..."
				/sbin/modprobe -q ${MODULE} ${MODARGS}
			done
		}
		# GENTOO: Don't probe kernel version, initng, requires 2.6 anyway
		load_modules /etc/modules.autoload.d/kernel-2.6
		load_modules /etc/modules
		if [ -n "`/sbin/modprobe -l -t boot \*`" ]
		then	
			echo "Loading of modules in /lib/modules/boot is broken!"
			# Don't add -l here - it suppresses the error message,
			# but it also prevents the modules from being loaded
			/sbin/modprobe -a -t boot \*
		fi
		exit 0  # Bad things happen if we fail
	};
}
