# very unclean. not initngish
service system/sraid {
	need = system/initial system/mountroot;
	critical;
	script start = {
		retval=0
		# You need a properly configured /etc/raidtab for raidtools usage or a
		# properly configured /etc/mdadm.conf for mdadm usage. Devices in
		# /etc/mdadm.conf are initialized first, so any duplicate devices in
		# /etc/raidtab will not get initialized.
		if [ -f /proc/mdstat ]
		then
			# If /etc/mdadm.conf exists, grab all the RAID devices from it
			[ -f /etc/mdadm.conf ] && mdadm_devices=`/usr/bin/awk '/^[[:space:]]*ARRAY/ { print $2 }' /etc/mdadm.conf`
			
			# If /etc/raidtab exists, grab all the RAID devices from it
			[ -f /etc/raidtab ] && raidtools_devices=`/usr/bin/awk '/^[[:space:]]*raiddev/ { print $2 }' /etc/raidtab`
			
			echo "Starting up RAID devices ... "
			rc=0
			for i in ${mdadm_devices}
			do
				raiddev=${i##*/}
				raidstat=`/bin/egrep "^${raiddev} : active" /proc/mdstat`
				if [ -z ${raidstat} ]
				then
					# First scan the /etc/fstab for the "noauto"-flag
					# for this device. If found, skip the initialization
					# for it to avoid dropping to a shell on errors.
					# If not, try raidstart...if that fails then
					# fall back to raidadd, raidrun.  If that
					# also fails, then we drop to a shell
					retval=1
					noauto=`/bin/egrep "^${i}" /etc/fstab | /bin/grep -c 'noauto'`
					echo "  Trying ${raiddev}..."
					raiddev=""
					
					if [ ${noauto} -gt 0 ]
					then
						retval=0
						raiddev=" (skipped)"
					fi
					if [ ${retval} -gt 0 -a -x /sbin/mdadm ]
					then
						/sbin/mdadm -As "${i}" >/dev/null 2>&1
						retval=${?}
					fi
					echo "${raiddev}"
					
					if [ ${retval} -gt 0 ]
					then
						rc=1
						echo "Raid is up..."
					else
						echo "Problems initiating raid..."
					fi
				fi
			done

				for i in ${raidtools_devices} ; do
				raiddev=${i##*/}
				raidstat=`/bin/egrep "^${raiddev} : active" /proc/mdstat`
				if [[ -z ${raidstat} ]] ; then
					# First scan the /etc/fstab for the "noauto"-flag
					# for this device. If found, skip the initialization
					# for it to avoid dropping to a shell on errors.
					# If not, try raidstart...if that fails then
					# fall back to raidadd, raidrun.  If that
					# also fails, then we drop to a shell
					retval=1
					noauto=`/bin/egrep "^${i}" /etc/fstab | /bin/grep -c 'noauto'`
						echo "  Trying ${raiddev}..."
						raiddev=""
					if [[ ${noauto} -gt 0 ]] ; then
						retval=0
						raiddev=" (skipped)"
					fi
					if [[ ${retval} -gt 0 ]] && [[ -x /sbin/raidstart ]] ; then
						/sbin/raidstart "${i}"
						retval=${?}
					fi
					if [[ ${retval} -gt 0 ]] && [[ -x /sbin/raid0run ]] ; then
						/sbin/raid0run "${i}"
						retval=${?}
					fi
					if [[ ${retval} -gt 0 ]] && [[ -x /sbin/raidadd ]] && [[ -x /sbin/raidrun ]] ; then
						/sbin/raidadd "${i}"
						/sbin/raidrun "${i}"
						retval=${?}
					fi
						echo "${raiddev}"
					if [[ ${retval} -gt 0 ]] ; then
						rc=1
						echo "Raid is up ..."
						#echo ${retval}
					else
						echo "Problems with raid ..."
						#echo ${retval}
					fi
				fi
			done
			# A non-zero return means there were problems.
			if [[ ${rc} -gt 0 ]] ; then
				echo
				echo "An error occurred during the RAID startup"
				echo "Dropping you to a shell; the system will reboot"
				echo "when you leave the shell."
				echo; echo
				exit 1
			fi
		fi
	
	
		exit ${retval}
	};
}
