# TODO: Test if we have sarted with fb before starting splashy
service system/splashy {
	need = system/initial;
	env spl_pidfile=/etc/splashy/splashy.pid;
	env spl_fifo=/etc/splashy/splashy.fifo;
	env_file = /etc/default/splashy;
	env SPL_MSG=Starting ${NAME} boot sequence;
	script start = {
		[ -x /sbin/splashy ] || exit 0
		. /etc/init.d/splashy-functions.sh
		/usr/sbin/start-stop-daemon --start --quiet --pidfile ${spl_pidfile} --exec /sbin/splashy -- boot 2>/dev/null
		exec /sbin/ngc -S "splashy,boot"
	};

# the stop script is called on shutdown
# it will start splashy again to show the "shutdown complete" progress bar
	script stop = {
		[ -x /sbin/splashy ] || exit 0
		. /etc/init.d/splashy-functions.sh
		/usr/sbin/start-stop-daemon --start --quiet --pidfile ${spl_pidfile} --exec ${DAEMON} -- boot 2> /dev/null
		exec /sbin/ngc -S "splashy,shutdown"
	};
}

service system/splashy/chvt {
	script start = {
		x_vt=""
		for i in `/usr/bin/seq 0 10`
		do
			x_vt=`ps -C X -o args= | /bin/sed 's/.* vt\([0-9]*\).*/\1/g'`
			[ ! -z "${x_vt}" ] && break
			sleep .2
		done
		[ "${x_vt}" -gt 0 ] && exit 0
		exec /bin/chvt ${x_vt}
	}
}
