service system/selinux/dev {
	need = system/initial/mountvirtfs;
	script start = {
		# Check SELinux status
		selinuxfs=`/usr/bin/awk '$3=="selinuxfs" {print $2}' /proc/mounts`
		SELINUX=
		if [ -n "${selinuxfs}" -a "`/bin/cat /proc/self/attr/current`" != "kernel" ]
		then
			if [ -r ${selinuxfs}/enforce ]
			then
				SELINUX=`/bin/cat ${selinuxfs}/enforce`
			else
				# assume enforcing if you can't read it
				SELINUX=1
			fi
		fi
		if [ -n "${SELINUX}" -a -x /sbin/restorecon ] && /bin/fgrep -q " /dev " /proc/mounts
		then
			/sbin/restorecon -R /dev 2>/dev/null
		fi
	};
}

service system/selinux/relabel {
	need = system/mountroot;
	script start = {
		# Check SELinux status
		selinuxfs=`/usr/bin/awk '$3=="selinuxfs" {print $2}' /proc/mounts`
		SELINUX=
		if [ -n "${selinuxfs}" -a "`/bin/cat /proc/self/attr/current`" != "kernel" ]
		then
			if [ -r ${selinuxfs}/enforce ]
			then
				SELINUX=`/bin/cat ${selinuxfs}/enforce`
			else
				# assume enforcing if you can't read it
				SELINUX=1
			fi
		fi

		relabel_selinux() {
			echo
			echo '*** Warning -- SELinux relabel is required. ***'
			echo '*** Disabling security enforcement.         ***'
			echo '*** Relabeling could take a very long time, ***'
			echo '*** depending on file system size.          ***'
			echo
			echo "0" > ${selinuxfs}/enforce
			/sbin/fixfiles restore >/dev/null 2>&1
			/bin/rm -f /.autorelabel
			echo '*** Enabling security enforcement.          ***'
			echo ${SELINUX} >${selinuxfs}/enforce
		}

		# Check to see if a full relabel is needed
		if [ -n "${SELINUX}" ]
		then
			if [ -f /.autorelabel ] || echo "${cmdline}" | /bin/grep -q autorelabel
			then
				relabel_selinux
			fi
		else
			if [ -d /etc/selinux ]
			then
				[ -f /.autorelabel ] || /bin/touch /.autorelabel
			fi
		fi
	};
}
