service system/pcmcia {
	need = system/bootmisc;
	env_file = /etc/conf.d/pcmcia;
	script start = {
		cleanup() {
			while read SN CLASS MOD INST DEV EXTRA
			do
				if [ "x${SN}" != "xSocket" ]
				then
					/etc/pcmcia/${CLASS} stop ${DEV} 2> /dev/null
				fi
			done
		}

		umask 022

		# Scheme is set for the /etc/pcmcia/shared script
		echo ${SCHEME} > /var/run/pcmcia-scheme

		# clean up any old interfaces
		[ -r /var/run/stab ] && /bin/cat /var/run/stab | cleanup

		# if /var/lib/pcmcia exists (and sometimes it gets created accidentally
		# if you run pcmcia-cs apps w/out the proper flags), then it will really
		# confuse the process
		[ -d /var/lib/pcmcia ] && /bin/rm -rf /var/lib/pcmcia

		if [ -e /proc/bus/pccard ]
		then
			echo "PCMCIA support detected ..."
		else
			echo "Trying to load pcmcia modules, should have been loaded with coldplug/pci or static-modules ..."
			/sbin/modprobe pcmcia_core ${CORE_OPTS}
			if [ -n "${PCIC}" ]
			then
				if ! /sbin/modprobe ${PCIC} ${PCIC_OPTS}
				then
					echo "'/sbin/modprobe ${PCIC}' failed"
					echo "Trying alternative PCIC driver: ${PCIC_ALT}"
					/sbin/modprobe ${PCIC_ALT} ${PCIC_ALT_OPTS}
				fi
			fi
			/sbin/modprobe ds
		fi
	};
}
