service system/netmount {
	need = system/bootmisc daemon/portmap;
	require_network;
	script start = {
		if ! /bin/mount -aFt afs,cifs,coda,ncpfs,nfs,nfs4,smbfs
		then
			echo "Mounting failed, trying to mount network filesystems again ..."
			/bin/mount -at afs,cifs,coda,ncpfs,nfs,nfs4,smbfs
		fi
	};
	script stop = {
		if ! /bin/umount -at afs,cifs,coda,ncpfs,nfs,nfs4,smbfs
		then
			echo "Unmounting failed, trying to unmount network filesystems again ..."
			/bin/umount -aft afs,cifs,coda,ncpfs,nfs,nfs4,smbfs
		fi
	};
}
