service system/mountroot/dmsetup {
	need = system/initial system/modules/dm-mod;
	exec start = /usr/sbin/dmsetup mknodes;
}

service system/mountroot/lvm {
	need = system/initial system/modules/lvm system/modules/lvm-mod system/mountroot/dmsetup;
	env dm_dir=/dev/mapper;
	env dm_file=${dm_dir}/control;
	script start = {
		/bin/mknod --mode=600 /dev/lvm c 109 0
		if [ ! -f /dev/.devfsd ]
		then
			major=`/bin/grep "[0-9] misc$" /proc/devices | /bin/sed 's/[ ]\+misc//'`
			minor=`/bin/grep "[0-9] device-mapper$" /proc/misc | /bin/sed 's/[ ]\+device-mapper//'`
			[ -d ${dm_dir} ] || /bin/mkdir --mode=755 ${dm_dir}
			[ -c ${dm_file} -o -z "${major}" -o -z "${minor}" ] || /bin/mknod --mode=600 ${dm_file} c ${major} ${minor}
		fi
		/usr/sbin/vgscan --ignorelockingfailure --mknodes
		/usr/sbin/vgchange --ignorelockingfailure -a y
	};
}

service system/mountroot/evms {
	need = system/initial;
	exec start = /sbin/evms_activate;
}

service system/mountroot/check {
	need = system/initial;
	use = system/mountroot/evms system/mountroot/lvm system/mountroot/dmsetup;
	critical;
	script start = {
		retval=0
		if [ ! -f /fastboot ]
		then
			echo "Remounting root filesystem read-only (if necessary) ..."

			if [ -f /forcefsck ]
			then
				echo "Checking root filesystem (full fsck forced)"
				/bin/mount -n -o remount,ro /
				/sbin/fsck -C -a -f /
				# /forcefsck isn't deleted because system/mountfs need it.
				# it'll be deleted in that script.
				retval=${?}
			else
				# Obey the fs_passno setting for / (see fstab(5))
				# - find the / entry
				# - make sure we have 6 fields
				# - see if fs_passno is something other than 0
				ROOTLINE=`/usr/bin/awk '$1~"^/" && $2=="/" && $6!="0" {print $0} {}' /etc/fstab`
				if [ -n "${ROOTLINE}" ]
				then
					echo "Checking root filesystem ..."
					/bin/mount -n -o remount,ro /
					/sbin/fsck -C -T -a /
					retval=${?}
				else
					echo "Skipping root filesystem check (fstab's passno == 0) ..."
					retval=0
				fi
			fi

			if [ "${retval}" -eq 0 ]
			then
				exit 0
			else
				echo "Filesystem couldn't be fixed :("
				exit 1
			fi
		fi
	};
}

service system/mountroot/rootrw {
	need = system/initial system/mountroot/check;
	use = system/mountroot/evms system/mountroot/lvm system/mountroot/dmsetup;
	critical;
	script start = {
		if /bin/mount -vf -o remount / | /bin/grep "\(.*rw.*\)"
		then
			echo "Remounting root filesystem read/write"
			/bin/mount -n -o remount,rw / >/dev/null 2>&1
			result=${?}
			# code 32 means 'not implemented', we got it on livecd using
			# unionfs combined with squashfs
			if [ ${result} -ne 0 -a ${result} -ne 32 ]
			then
				echo "Root filesystem could not be mounted read/write :("
				exit 1
			fi
		fi
		
		if [ -f /etc/sysconfig/pingwinek ]
		then
			. /etc/sysconfig/pingwinek
		else
    			SYSTEM_TYPE="hdd";
		fi
	
		# autogeneration fstab on livecd
		if [ $SYSTEM_TYPE = "livecd" ]
		then
			pgw-fstab --set livecd
		fi
	};
	# Someday, it shud also cleanup.
	# stop {
	#	#Unmount root fs ro.
	#	mount -n -o remount,ro /
	# };
}

service system/mountroot {
	need = system/initial system/mountroot/rootrw;
	script start = {
		/bin/rm /etc/mtab
		if ! /bin/touch /etc/mtab
		then
			echo "Skipping /etc/mtab initialization (ro root?)"
			exit 0
		fi
		# Add the entry for / to mtab
		/bin/mount -f /
	
		# Don't list root more than once
		/bin/grep -v " / " /proc/mounts >>/etc/mtab
		# Now make sure /etc/mtab have additional info (gid, etc) in there

		/bin/cat /proc/mounts | while read pm_fs pm_mountpoint pm_junk
		do
			/bin/cat /etc/fstab | while read ef_fs ef_mountpoint ef_junk
			do
				if [ "${pm_mountpoint}" = "${ef_mountpoint}" ]
				then
					echo "Mounting ${pm_mountpoint} rw ..."
					/bin/mount -f -o remount "${pm_mountpoint}"
					continue
				fi
			done
		done

		# Remove stale backups
		/bin/rm -f /etc/mtab~ /etc/mtab~~
		# Return Happily., or sulogin will be executed.
		exit 0
	};
}
