service system/mountfs {
	need = system/initial system/mountroot system/checkfs;
	use = system/sraid system/hdparm system/selinux/relabel;
	# system/modules
	critical;
	script start = {
		# /bin/mount local filesystems in /etc/fstab.
		if /bin/mount -aFt reiserfs,reiser4,ext2,ext3,xfs,jfs,vfat,ntfs,tmpfs,subfs
		then
			echo "mounting failed, trying mount local filesystems again ..."
			if ! /bin/mount -at reiserfs,reiser4,ext2,ext3,xfs,jfs,vfat,ntfs,tmpfs,bind,subfs
			then
				echo "WARNING, failed to mount some local filesystems"
				#this is not critical, lets continue anyway.
			fi
		fi

		# /bin/mount all type bind after the other mounts.
		for i in `/bin/grep bind /etc/fstab | /usr/bin/awk '{ print $1; }'`
		do
			/bin/mount ${i}
		done

		# Always return happily, or sulogin will be executed.
		exit 0
	};
}
