service system/modules/* {
	need = system/initial system/mountroot;
	script start = {
		/sbin/modprobe ${NAME} || true
	};
	script stop = {
		/sbin/modprobe -r ${NAME} || true
	};
}

service system/modules {
	need = system/initial system/mountroot;
	script start = {
		# Should not fail if kernel do not have module
		# support compiled in ...
		[ -f /proc/modules ] || exit 0

		# Here we should fail, as a modular kernel do need
		# depmod command ...
		if [ ! -e /lib/modules/`/bin/uname -r`/modules.dep ]
		then
			if [ ! -x /sbin/depmod ]
			then
				echo "ERROR:  system is missing /sbin/depmod !"
				exit 1
			fi
			/sbin/depmod
			exit 0
		else
			echo "Found modules.dep, skipping depmod ..."
		fi


		# if /etc/modules.d is newer then /etc/modules.conf

		if [ /etc/modules.d -nt /etc/modules.conf ]
		then
			echo "Calculating module dependencies ..."
			if [ ! -x /sbin/depmod ]
			then
				echo "ERROR:  system is missing /sbin/depmod !"
				exit 1
			fi
			/sbin/depmod
			exit 0
		else
			echo "Module dependencies up to date ..."
		fi

		wait
		exit 0
	};
}
