service system/keymaps {
	need = system/bootmisc system/sysctl;
	env_file = /etc/sysconfig/keyboard;

	script start = {
		if [ -e /etc/console/boottime.kmap.gz ]
		then
			/bin/loadkeys -q /etc/console/boottime.kmap.gz >/dev/null 2>&1
			exit 0
		fi

		WINDOWKEYS_KEYMAP=

		# Force linux keycodes for PPC.
		[ -f /proc/sys/dev/mac_hid/keyboard_sends_linux_keycodes ] && \
			echo 1 >/proc/sys/dev/mac_hid/keyboard_sends_linux_keycodes

		# New kbd support.
		if [ -x /bin/loadkeys ]
		then
			[ "${SET_WINDOWKEYS}" = "yes" ] && WINDOWKEYS_KEYMAP="windowkeys"
			/bin/loadkeys -q ${WINDOWKEYS_KEYMAP} ${KEYMAP} ${EXTENDED_KEYMAPS} >/dev/null 2>&1
		else
			echo "/bin/loadkeys not found" >&2
			exit 1
		fi

		# Set terminal encoding to either ASCII or UNICODE.
		# See utf-8(7) for more information.
		termencoding=
		if [ "${UNICODE}" = "yes" ]
		then
			dumpkey_opts=""
			[ -n "${DUMPKEYS_CHARSET}" ] && dumpkey_opts="-c ${DUMPKEYS_CHARSET}"
			/bin/kbd_mode -u
			/bin/dumpkeys ${dumpkey_opts} | loadkeys --unicode
			termencoding=`/usr/bin/printf '\033%G'`
		else
			termencoding=`/usr/bin/printf '\033(K'`
		fi

		[ -d /dev/vc ] && ttydev=/dev/vc/ || ttydev=/dev/tty
		for n in `/usr/bin/seq 1 11`
		do
			echo -n ${termencoding} >${ttydev}${n}
		done
	};
}
