# Unmount and free the initrd.
service system/initrd-tools {
	need = system/initial;
	env_file = /etc/default/initrd-tools.sh;
	script start = {
		[ "${KEEPINITRD}" = yes ] && exit
		command -v blockdev >/dev/null 2>&1 || exit 0

		if ! [ -f /proc/mounts ]
		then
			mount -n /proc || exit
			trap 'umount -n /proc' EXIT
		fi

		/bin/grep -q '^[^ ]* /initrd ' /proc/mounts || exit 0

		if [ -c /initrd/dev/.devfsd ]
		then
			umount /initrd/dev || exit
		fi
		umount /initrd || exit

		if [ -b /dev/ram0 ]
		then
			blockdev --flushbufs /dev/ram0
		elif [ -b /dev/rd/0 ]
		then
			blockdev --flushbufs /dev/rd/0
		else
			echo "Cannot find initrd device" >&2
			exit 1
		fi
	};
}
