
# This one shud be run first, and have no dependencys.
# Its purpose is to mount /proc /dev and /sys.
service system/initial/mountvirtfs {
	critical;
	script start = {
		# test, if all necasary directories exists.
		for dir in /proc /dev /sys
		do
			if [ ! -d ${dir} ] # no?
			then
				echo "The dir \"${dir}\" is missing, cant mount it!" >&2
				echo "Please sulogin, remount rw and create them." >&2
				exit 1 # we can't work. critical!
			fi
		done

		mount -n -t proc proc /proc &
		mount -n -t sysfs sys /sys &
		# we need /dev/null direct, so we create it by hand.
		{	mount -n -o size=10M,mode=0755 -t tmpfs udev /dev && \
			/bin/rm -f /dev/null && \
			/bin/mknod /dev/null c 1 3 -m 666
		} &

		wait
		exit 0
	};
}

# This service is responsible for
# filling the newly moutned /dev with devices
# Warning, it depends on udevd to run, or no hotplug request
# can succeed.
service system/initial/filldev {
	need = system/initial/mountvirtfs system/initial/udevd;
	critical; # this script can't be fail.
	script start = {
		# which system needs this?
		if [ -e /etc/udev/links.conf ]
		then
			echo "Parsing /etc/udev/links.conf ..."
			/bin/grep '^[^#]' /etc/udev/links.conf | \
			while read type name arg1
			do
				[ "${type}" -a "${name}" -a ! -e "/dev/${name}" -a ! -L "/dev/${name}" ] || continue
				case "${type}" in
					L) /bin/ln -snf ${arg1} /dev/${name} & ;;
					D) /bin/mkdir -p /dev/${name} ;;
					M) /bin/mknod --mode=600 /dev/${name} ${arg1} &;;
					*) echo "links.conf: unparseable line (${type} ${name} ${arg1})" ;;
				esac
			done
		fi

		# and this?
		# A complete dir to copy
		if [ -d /lib/udev/devices ]
		then
			echo "Creating /dev from /lib/udev/devices ..."
			# Copy over default device tree
			(cd /lib/udev/devices && /usr/bin/find -print0 | /usr/bin/cpio --quiet -0pmdu /dev) &	
		fi

		# and this?
		# If no-one abow work
		if [ ! -e /etc/udev/links.conf -a ! -d /lib/udev/devices ]
		then
			# Some manually, youst to be sure.		
			/bin/ln -snf /proc/self/fd /dev/fd &
			/bin/ln -snf fd/0 /dev/stdin &
			/bin/ln -snf fd/1 /dev/stdout &
			/bin/ln -snf fd/2 /dev/stderr &
			/bin/ln -snf /proc/kcore /dev/core &
			/bin/ln -snf /proc/asound/oss/sndstat /dev/sndstat &
		fi

		# which system provides udevsynthesize? gentoo does not.
		# and which provides udevplug? gentoo does not, too.

		# run syntesizers that will make hotplug events for every
		# devices that is currently in the computer, that will
		# create all dev files.
		if [ -x "/sbin/udevsynthesize" ]
		then
			udevd_timeout=60
			echo "Running /sbin/udevsynthesize to populate /dev ..."
			/bin/mkdir -p /dev/.udev/db/
			/bin/mkdir -p /dev/.udev/queue/
			/bin/mkdir -p /dev/.udevdb/
			
			/sbin/udevsynthesize
			
			# wait for the udevd childs to finish
			echo "Waiting for /dev to be fully populated ..."
			while [[ -d /dev/.udev/queue/ && "${udevd_timeout}" -ne 0 ]]
			do
				sleep 0.2
				udevd_timeout=`/usr/bin/expr ${udevd_timeout} - 1`
			done
		elif [ -x "/sbin/udevplug" ]
		then
			/sbin/udevplug
		elif [ -x "/sbin/udevstart" ]
		then
			/sbin/udevstart
			# this require kernel 2.6.15
			# synthesize only selected uevents after udevstart
    			for i in /sys/bus/*/devices/*/uevent
			do
        			echo "add" > "$i"
			done
		fi
		echo "Mounting devpts at /dev/pts ..."
		/bin/mkdir -p /dev/pts && /bin/mount -n -t devpts -o gid=5,mode=0620 none /dev/pts &

		echo "Mounting devshm at /dev/shm ..."
		/bin/mkdir -p /dev/shm && /bin/mount -n -t tmpfs none /dev/shm &

		[ ! -e /dev/MAKEDEV -a /sbin/MAKEDEV ] && \
				/bin/ln -fs /sbin/MAKEDEV /dev/MAKEDEV &

		wait
		exit 0
	};
}


# udevd to handle udev requests
daemon system/initial/udevd {
	# first we must run udevstart or something like, because, it will kill our udevd.
	# btw: we kill all udevd, which runs before.
	# Deac, THIS SERVICE CANT, be depending on system/initial/udev/start, becouse all udev tools
	# like udevplug, and udevstart needs udevd to be running, to work.
	need = system/initial/mountvirtfs;
	respawn;
	pid_of = udevd;
	critical;
	script daemon = {
		# Make sure hotplug is not missing.
		# and what is, if we know it?
		[ -e /proc/sys/kernel/hotplug ] || echo "/proc/sys/kernel/hotplug is missing!"

		# we kill it, because udevd can run only once
		# system/initial/udev/start starts udevd too, so we must kill it.
		/usr/bin/killall udevd >/dev/null 2>&1

		# Setup hotplugging (if possible)
		echo "/sbin/udevsend" >/proc/sys/kernel/hotplug

		# Launch udevd
		exec /sbin/udevd --daemon;
	}
	
	script stop = {
		# every new hotplug-event can do something wrong.
		echo "" >/proc/sys/kernel/hotplug
	};
}


service system/initial/loglevel {
	# Set the console loglevel to 1 for a cleaner boot
	# the logger should anyhow dump the ring-0 buffer at start to the
	# logs, and that with dmesg can be used to check for problems
	exec start = /bin/dmesg -n 1;
	# Increase the debug level a bit
	exec stop = /bin/dmesg -n 2;
}

virtual system/initial {
	need = system/initial/loglevel system/initial/mountvirtfs system/initial/udevd system/initial/filldev;
	use = system/selinux/dev;
}
