# /etc/env.d/01hostname in gentoo is setted by init-script.
# i say, you should set a link: /etc/conf.d/hostname <- /etc/env.d/01hostname, but don't do it at the moment!
service system/hostname {
	need = system/initial;
	env HOSTNAME=localhost;
	env_file = /etc/conf.d/hostname;
	script start = {
		myhost=`/bin/hostname 2>/dev/null`

		# If the hostname is already set via the kernel, and /etc/hostname
		# isn't setup, then we shouldn't go reseting the configuration #38172.
		[ -z "${myhost}" -o "${myhost}" = "(none)" ] && myhost="localhost"
		
		if [ -f /etc/hostname ]
		then
			myhost="`/bin/cat /etc/hostname`"
		else
			myhost="${HOSTNAME}"
		fi
		echo "Setting hostname to ${myhost} ..."
		/bin/hostname "${myhost}"
	};
}
