service system/console-screen {
	need = system/initial system/keymaps system/mountfs;
	script start = {
		if [ -d /etc/console-tools/config.d ]
		then
			for i in `/usr/sbin/run-parts --list /etc/console-tools/config.d`
			do
			   . ${i}
			done
		fi

		# Different device name for 2.6 kernels and devfs
		if [ `/bin/uname -r | /usr/bin/cut -f 2 -d .` = 6 -a -e /dev/.devfsd ]
		then
			VCSTIME_OPT="-2 /dev/vcsa0"
		else
			VCSTIME_OPT=""
		fi

		# be sure the main program is installed
		[ -x "/usr/bin/consolechars" ] || exit 0

		# set DEVICE_PREFIX depending on devfs/udev
		if [ -d /dev/vc ]
		then
			DEVICE_PREFIX="/dev/vc/"
		else
			DEVICE_PREFIX="/dev/tty"
		fi

		reset_vga_palette () {
			if [ -f /proc/fb ]
			then
				# They have a framebuffer device.
				# That means we have work to do...
				echo -n "]R"
			fi
		}

		VT="no"
		# If we can't access the console, quit
		CONSOLE_TYPE=`/bin/fgconsole 2>/dev/null` || exit 0
		if [ ! "${CONSOLE_TYPE}" = "serial" ]
		then
			/usr/bin/readlink /proc/self/fd/0 | /bin/grep -q -e /dev/vc -e '/dev/tty[^p]' -e /dev/console
			if [ ${?} -eq 0 ]
			then
				VT="yes"
				reset_vga_palette
			fi
		fi

		[ "${VT}" = "no" ] && exit 0

		# start vcstime
		if [ "${DO_VCSTIME}" = "yes" -a -x /usr/sbin/vcstime ]
		then
			echo Starting clock on text console: `basename /usr/sbin/vcstime` ...
			/usr/sbin/vcstime ${VCSTIME_OPT} &
		fi


		# Global default font+sfm
		if [ "${SCREEN_FONT}" ]
		then
			echo "Setting up general console font ... "
			SCREEN_FONT="-f ${SCREEN_FONT}"

			# maybe use an external SFM
			[ "${SCREEN_FONT_MAP}" ] && SCREEN_FONT_MAP="-u ${SCREEN_FONT_MAP}"
			# Set for the first 6 VCs (as they are allocated in /etc/inittab)

			NUM_CONSOLES=`/bin/fgconsole --next-available`
			NUM_CONSOLES=`/usr/bin/expr ${NUM_CONSOLES} - 1`
			for vc in `/usr/bin/seq 0 ${NUM_CONSOLES}`
			do
				/usr/bin/consolechars --tty=${DEVICE_PREFIX}${vc} ${SETFONT_OPT} ${SCREEN_FONT} ${SCREEN_FONT_MAP} || {
					echo " failed."
					break
				}
			done
		fi


		# Per-VC font+sfm
		PERVC_FONTS="`set | /bin/grep "^SCREEN_FONT_vc[0-9]*="  | tr -d \' `"
		if [ "${PERVC_FONTS}"  ]
		then
			echo "Setting up per-VC fonts ... "
			for font in ${PERVC_FONTS}
			do
				# extract VC and FONTNAME info from variable setting
				vc=`echo ${font} | cut -b15- | cut -d= -f1`
				eval font=\${SCREEN_FONT_vc${vc}}
				[ X"${QUIET_PERVC}" != X1 ] && echo -n "${DEVICE_PREFIX}${vc}, "
				# eventually find an associated SFM
				eval sfm=\${SCREEN_FONT_MAP_vc${vc}}
				[ "${sfm}" ] && sfm="-u ${sfm}"

				/usr/bin/consolechars --tty=${DEVICE_PREFIX}${vc} ${SETFONT_OPT} -f ${font} ${sfm}
			done
		fi

		# Global ACM
		[ "${APP_CHARSET_MAP}" ] && /usr/bin/charset G0 ${APP_CHARSET_MAP}

		# Per-VC ACMs
		PERVC_ACMS="`set | /bin/grep "^APP_CHARSET_MAP_vc[0-9]*="  | tr -d \' `"
		if [ "${PERVC_ACMS}" ]
		then
			echo "Setting up per-VC ACM's ... "
			for acm in ${PERVC_ACMS}
			do
				# extract VC and FONTNAME info from variable setting
				vc=`echo ${acm} | cut -b19- | cut -d= -f1`
				eval acm=\${APP_CHARSET_MAP_vc${vc}}
				[ "${QUIET_PERVC}" != "1" ] && echo -n "${DEVICE_PREFIX}${vc} (${acm}), "
				eval "/usr/bin/charset --tty='${DEVICE_PREFIX}${vc}' G0 '${acm}'"
			done
		fi


		# Go to UTF-8 mode as necessary
		#
		if [ -f /etc/environment ]
		then
			for var in LANG LC_ALL LC_CTYPE
			do
				value=`/bin/egrep "^[^#]*${var}=" /etc/environment | /usr/bin/tail -n1 | /usr/bin/cut -d= -f2`
				eval ${var}=${value}
			done
		fi
		CHARMAP=`LANG=${LANG} LC_ALL=${LC_ALL} LC_CTYPE=${LC_CTYPE} /usr/bin/locale charmap`
		if [ "${CHARMAP}" = "UTF-8" ]
		then
			/bin/unicode_start 2>/dev/null || true
		else
			/bin/unicode_stop 2>/dev/null || true
		fi

		# screensaver stuff
		setterm_args=""
		[ "${BLANK_TIME}" ] && setterm_args="${setterm_args} -blank ${BLANK_TIME}"
		[ "${BLANK_DPMS}" ] && setterm_args="${setterm_args} -powersave ${BLANK_DPMS}"
		[ "${POWERDOWN_TIME}" ] && setterm_args="${setterm_args} -powerdown ${POWERDOWN_TIME}"
		[ "${setterm_args}" ] && setterm ${setterm_args}

		# Keyboard rate and delay
		KBDRATE_ARGS=""
		[ -n "${KEYBOARD_RATE}" ] && KBDRATE_ARGS="-r ${KEYBOARD_RATE}"
		[ -n "${KEYBOARD_DELAY}" ] && KBDRATE_ARGS="${KBDRATE_ARGS} -d ${KEYBOARD_DELAY}"
		[ -n "${KBDRATE_ARGS}" ] && /bin/kbdrate -s ${KBDRATE_ARGS}

		# Inform gpm if present, of potential changes.
		if [ -f /var/run/gpm.pid ]
		then
			/bin/kill -WINCH `/bin/cat /var/run/gpm.pid` 2> /dev/null
		fi

		# Allow user to remap keys on the console
		if [ -r /etc/console-tools/remap ]
		then
			/bin/dumpkeys < ${DEVICE_PREFIX}1 |/bin/sed -f /etc/console-tools/remap |/bin/loadkeys --quiet
		fi
		# Set LEDS here
		if [ "${LEDS}" != "" ]
		then
			for i in `/usr/bin/seq 1 12`
			do
					/bin/setleds -D ${LEDS} <${DEVICE_PREFIX}${i}
			done
		fi
	};
}
