service system/alsasound/loadmodules {
	need = system/initial system/mountroot system/modules;
	use = system/coldplug system/static-modules;
	env alsascrdir=/etc/alsa.d;
	script start = {
		# List of drivers for each card.
		DRIVERS=`/sbin/modprobe -c | /usr/bin/awk '/^[[:space:]]*alias[[:space:]]+snd-card-[[:digit:]]/ { print $2 } {}'`

		# Fall back on the automated aliases if we don't have ALSA configured properly...
		if [ -z "${DRIVERS}" ] && ! ([ -d /proc/asound -a -z "`/bin/grep ' no soundcards ' /proc/asound/cards`" ])
		then
			echo "Could not detect custom ALSA settings.  Loading all detected alsa drivers."
			DRIVERS="`/sbin/modprobe -c | /bin/grep pci: |  /usr/bin/awk '{ print $3 }' | /bin/grep snd.* | sort | uniq`"
			[ -z "${DRIVERS}" ] && echo "Unable to find any ALSA drivers. Have you compiled alsa-drivers correctly?"
		fi

		if /sbin/modprobe -c | /bin/grep -q "snd.*oss$"
		then
			# Test for use of OSS
			OSS=`/sbin/modprobe -l | /bin/grep "snd.*oss" | /bin/sed -e "s:\/.*\/::" -e "s:\..*::"`
			# Add oss modules to list
			for i in ${OSS}
			do
				DRIVERS="${DRIVERS} ${i}"
			done
		fi

		# We want to ensure snd-seq is loaded as it is needed for things like
		# timidity even if we don't use a real sequencer.
		DRIVERS="${DRIVERS} `/sbin/modprobe -l | /bin/grep "snd.seq\." | /bin/sed -e "s:\/.*\/::" -e "s:\..*::"`"

		# We want to ensure snd-ioctl32 is loaded as it is needed for 32bit
		# compatibility
		DRIVERS="${DRIVERS} `/sbin/modprobe -l | /bin/grep "snd.ioctl32\." | /bin/sed -e "s:\/.*\/::" -e "s:\..*::"`"

		for DRIVER in ${DRIVERS}
		do
			if [ ! "${DRIVER}" = off ]; then
				echo "  Loading: ${DRIVER} ..."
				/sbin/modprobe ${DRIVER}
			fi
		done
			
		if [ -f /proc/asound/seq/drivers ] ; then
			SEQUENCERS=`/usr/bin/awk -F, '$2~/^empty$/ {print $1}' /proc/asound/seq/drivers`
			for SEQUENCER in ${SEQUENCERS}
			do
				echo "  Loading: ${SEQUENCER} ..."
				/sbin/modprobe ${SEQUENCER}
			done
		fi
				
		for DRIVER in ${DRIVERS}
		do
			TMP=${DRIVER##snd-}
			TMP=${TMP##snd_}
			if [ -x "${alsascrdir}/${TMP}" ]; then
				echo "  Running: ${alsascrdir}/${TMP} ..."
				${alsascrdir}/${TMP}
			fi
		done
				
		if [ ! -d /proc/asound -o  ! -z "`/bin/grep ' no soundcards ' /proc/asound/cards`" ]
		then
			echo "ERROR: Failed to load necessary drivers"
		fi
	};

	script stop = {
		LOADED_MODULES=`/sbin/lsmod | /bin/grep -E "^snd" | /usr/bin/awk '{print $1}'`
		for MODULE in ${LOADED_MODULES}
		do
			/sbin/rmmod ${MODULE} >& /dev/null
		done
		/sbin/rmmod soundcore >& /dev/null
		/sbin/rmmod gameport >& /dev/null	

		# Return success if the modules are unloaded
		[ -z "`/sbin/lsmod | /bin/grep -E "^snd" | /usr/bin/awk '{print $1}'`" ]
	};
}

service system/alsasound {
	need = system/initial system/mountfs system/alsasound/loadmodules;
	env asoundcfg=/etc/asound.state;
	env alsascrdir=/etc/alsa.d;
	script start = {
		echo "Restoring Mixer Levels ..."
		if [ ! -r ${asoundcfg} ]
		then
			echo "No mixer config in ${asoundcfg}, you have to unmute your card!"
			#this is not fatal!
		elif [ -x /usr/sbin/alsactl ]
		then
			CARDS=`/bin/cat /proc/asound/cards | /usr/bin/awk '/: / { print $1 }'`
			for CARDNUM in ${CARDS}
			do
				/usr/sbin/alsactl -f ${asoundcfg} restore ${CARDNUM}
			done
		else
			echo "ERROR: Cannot find alsactl, did you forget to install media-sound/alsa-utils?"
			exit 1
		fi
		exit 0
	};

	script stop = {
		if [ ! -d /proc/asound ]
		then
			echo "ALSA is not loaded"
			exit 1
		fi

		echo "Storing ALSA Mixer Levels"

		if [ -x /usr/sbin/alsactl ]
		then
			/usr/sbin/alsactl -f ${asoundcfg} store
		else
			echo "ERROR: Cannot find alsactl."
		fi

		echo "Kill processes using alsa"
		#
		# Kill processes holding open sound devices
		#
		# DEVS=`/usr/bin/find /dev/ -follow -type c -maxdepth 1 -print 2>/dev/null | xargs ls -dils | /bin/grep "1*1[46]," | cut -d: -f2 | cut -d" " -f2; echo /proc/asound/dev/*`
		/sbin/fuser -k /dev/admmidi? /dev/adsp? /dev/amidi? /dev/audio* /dev/dmfm* \
			/dev/dmmidi? /dev/dsp* /dev/dspW* /dev/midi0? /dev/mixer? /dev/music \
			/dev/patmgr? /dev/sequencer* /dev/sndstat /proc/asound/dev/* \
			/dev/sound/* /dev/snd/* 2>/dev/null 1>/dev/null

		#
		# remove all sequencer connections if any
		#
		[ -f /proc/asound/seq/clients -a -x /usr/bin/aconnect ] && \
			/usr/bin/aconnect --removeall
	};
}
