
service net/lo {
	need = system/mountfs system/modules system/hostname;
	use = system/static-modules system/coldplug;
	start {
          ifconfig lo 127.0.0.1 netmask 255.0.0.0 lo && route add -net 127.0.0.0 netmask 255.0.0.0 lo
          /etc/rc.d/rc.inet1 start
          exit 0
        }
        stop {
          route del -net 127.0.0.0 netmask 255.0.0.0 lo && ifconfig lo down
          /etc/rc.d/rc.inet1 stop
          exit 0
        }
}

service net {
	network_provider;
	stdall = /dev/null;
	need = system/bootmisc;
	use = system/static-modules system/coldplug daemon/cardmgr;
	script start = {
		# Put up the interface
		/sbin/ifup ${NAME}
		# Check so its up
		/sbin/ifconfig ${NAME} | /usr/bin/grep -qe "inet addr" -e "inet6 addr" || exit 1
		exit 0
	};
	script stop = {
		set -e
		# Shut down.
		/sbin/ifdown ${NAME}
		# Check so its down.
		/sbin/ifconfig ${NAME} | /usr/bin/grep -qe "inet addr" -e "inet6 addr" && exit 1
		exit 0
	};
}
