service daemon/xfs/chkfontpath {
	need = system/bootmisc;
	script start = {
		umask 133

		if [ -x /usr/sbin/chkfontpath ]
		then
			# chkfontpath output filtering, strips all of the junk output by
			# chkfontpath that we do not want, including headers, FPE numbers and
			# whitespace and other junk.  Also filters out FPE's with trailing
			# modifiers such as ":unscaled" et al.
			for dir in `/usr/sbin/chkfontpath --list | /bin/sed -e '/^Current/d;s#^[0-9]*: ##g;s#^/.*:[a-z]*$##g;/^[[:space:]]*$/d' | /bin/sort -u`
			do
				if [ -d "${dir}" ]
				then
					cd "${dir}"
					# If fonts.dir does not exist, or if there are files in the
					# directory with a newer change time, regenerate fonts.dir, etc.
					# Using "-cnewer" here fixes bug #53737
					if [ ! -e fonts.dir -o -n "`/usr/bin/find . -maxdepth 1 -type f -cnewer fonts.dir -not -name 'fonts.cache*'`" ]
					then
						/bin/rm -f fonts.dir
						if /bin/ls | /bin/grep -iqs '\.ot[cf]$'
						then
							# Opentype fonts found, generate fonts.scale and fonts.dir
							/usr/bin/mkfontscale . && /usr/bin/mkfontdir . >/dev/null 2>&1
						elif /bin/ls | /bin/grep -iqs '\.tt[cf]$'
						then
							# TrueType fonts found, generate fonts.scale and fonts.dir
							/usr/sbin/ttmkfdir -d . -o fonts.scale && /usr/bin/mkfontdir . >/dev/null 2>&1
						elif /bin/ls | /bin/grep -Eiqsv '(^fonts\.(scale|alias|cache.*)$|.+(\.[ot]t[cf]|dir)$)'
						then
							# This directory contains non-TrueType/non-Opentype fonts
							/usr/bin/mkfontdir . >/dev/null 2>&1
						fi
					fi
				fi
			done
		fi
		# Now we run fc-cache, assuming fonts may have been added, without
		# explicitly checking, as it is rather fast anyway.  Some older versions
		# of fc-cache will SEGV, which is prevented by invoking it with HOME=/
		[ -x "/usr/bin/fc-cache" ] && HOME=/ "/usr/bin/fc-cache"

		FONT_UNIX_DIR=/tmp/.font-unix
		# Clean out .font-unix dir, and recreate it with the proper ownership and
		# permissions.
		/bin/rm -rf ${FONT_UNIX_DIR}
		/bin/mkdir ${FONT_UNIX_DIR}
		/bin/chown root:root ${FONT_UNIX_DIR}
		/bin/chmod 1777 ${FONT_UNIX_DIR}
	};
}

daemon daemon/xfs {
	need = system/bootmisc daemon/xfs/chkfontpath;
	exec daemon = /usr/bin/xfs -droppriv -nodaemon;
}
