service daemon/postgres/initdb {
	need = system/bootmisc;
	env DATADIR=/srv/pgsql;
	script start = {
		if [ ! -f ${DATADIR}/PG_VERSION ]
		then
			if [ ! -d ${DATADIR} ]
			then
				/bin/mkdir -p ${DATADIR}
				chown postgres.postgres ${DATADIR}
				chmod go-rwx ${DATADIR}
			fi
			# Initialize the database
			su - postgres -c "/usr/bin/initdb --pgdata=${DATADIR} > /dev/null 2>&1" < /dev/null

			exec test -f ${DATADIR}/PG_VERSION
			# here was some output
		fi
	};
}

daemon daemon/postgres {
	need = system/bootmisc;
	use = daemon/postgres/initdb;
	env DATADIR=/srv/pgsql;
	require_network;
	suid = postgres;
	sgid = postgres;
	pid_of = postmaster;
	exec daemon = /usr/bin/pg_ctl -D${DATADIR} -p /usr/bin/postmaster -o -p5432 start;
	exec kill = /usr/bin/pg_ctl -D${DATADIR} -s -m fast stop;
}
