daemon daemon/openvpn/* {
	need = system/bootmisc;
	require_network;
	exec daemon = /usr/sbin/openvpn --config /etc/openvpn/${NAME}/local.conf --writepid /var/run/openvpn-${NAME}.pid --cd /etc/openvpn/${NAME};
}

service daemon/openvpn/prepare {
	need = system/bootmisc system/modules/tun;
	script start = {
		if [ -h /dev/net/tun -a -c /dev/misc/net/tun ]
		then
			echo "Detected broken /dev/net/tun symlink, fixing..."
			/bin/rm /dev/net/tun
			/bin/ln -s /dev/misc/net/tun /dev/net/tun
		fi
	};
}

service daemon/openvpn {
	need = system/bootmisc system/modules/tun;
	script start = {
		if [ ! -d /etc/openvpn ]
		then
			echo "Cant find openvpn conf dir! ..."
			exit 1
		fi
	
		cd /etc/openvpn
		for VPN in *
		do
			[ -e ${VPN}/local.conf ] && /sbin/ngc --start daemon/openvpn/${VPN}
		done
	};
	script stop = {
		cd /etc/openvpn
		for VPN in *
		do
			[ -e ${VPN}/local.conf ] && /sbin/ngc --stop daemon/openvpn/${VPN}
		done
	};
}
