daemon daemon/oidentd {
	need = system/initial system/mountroot;
	env OIDENT_OPTIONS=;
	env OIDENT_USER=nobody;
	env OIDENT_GROUP=nogroup;
	require_network;
	script daemon = {
		if [ "${OIDENT_BEHIND_PROXY}" = "yes" ]
		then
			# If we have a default router, then allow it to proxy auth requests to us
			GATEWAY=`netstat -nr | /usr/bin/awk '/^0.0.0.0/{print $2}'`
			[ -n "${GATEWAY}" ] && OIDENT_OPTIONS="${OIDENT_OPTIONS} -P ${GATEWAY}"
		fi
		exec /usr/sbin/oidentd -i ${OIDENT_OPTIONS} -u ${OIDENT_USER} -g ${OIDENT_GROUP}
	};
}
