service daemon/mysql/initdb {
	need = system/bootmisc;
	env DATA=/srv/mysql;
	script start = {
		if [ ! -d ${DATA}/db/mysql ]
		then
			if [ ! -d ${DATA} ]
			then
				/bin/mkdir -p ${DATA}
				chown mysql.mysql ${DATA}
				chmod go-rwx ${DATA}
			fi
			su mysql -c "/usr/bin/mysql_install_db" >/dev/null 2>&1
		fi
		exec [ -f ${DATA}/db/mysql/db.frm ]
	};
}

daemon daemon/mysql {
	need = system/bootmisc;
	use = daemon/mysql/initdb;
	require_network;
	exec daemon = /usr/bin/mysqld_safe --pid-file=/var/run/mysqld/mysqld.pid;
	pid_file = /var/run/mysqld/mysqld.pid;
	forks = noret;
	script kill = {
		kill `cat /var/run/mysqld/mysqld.pid`
	};
}
