daemon daemon/ifplugd/* {
	need = system/bootmisc;
	use = system/static-modules system/coldplug system/ifrename;
	stdout = /dev/null;
	stderr = /dev/null;
	exec_path daemon = /usr/sbin/ifplugd;
	exec_args daemon =  -i ${NAME} --no-daemon;
	#execs kill = /usr/sbin/ifplugd;
	#exec_args kill = -k --wait-on-kill -i ${NAME};
	#pid_file = /var/run/ifplugd.${NAME}.pid;
}

service daemon/ifplugd {
	need = system/bootmisc;
	use = system/static-modules system/coldplug system/ifrename;
	#stdall = /dev/null;
	
	script start = {
		for IF in `/usr/bin/awk 'BEGIN { FS=":" } /eth|wlan/ { gsub(/\W/,"",$1); print $1;}' /proc/net/dev`
		do
			/sbin/ngc -u daemon/ifplugd/${IF}
		done
	};

	script stop = {
		for IF in `/usr/bin/awk 'BEGIN { FS=":" } /eth|wlan/ { gsub(/\W/,"",$1); print $1;}' /proc/net/dev`
		do
			/sbin/ngc -d daemon/ifplugd/${IF}
		done
	};
}
