daemon daemon/hddtemp {
	need = system/bootmisc;
	pid_of = hddtemp;
	env SERVICE=true;
	env DISKS=/dev/hd? /dev/sr? /dev/sg? /dev/sd?;
	env INTERFACE=0.0.0.0;
	env PORT=7634;
	env SEPARATOR=|;
	env SYSLOG=0;
	env_file = /etc/conf.d/hddtemp;
	script daemon = {
		[ -n "${SYSLOG}" -a "${SYSLOG}" != "0" ] && SYSLOG_ARG="-S ${SYSLOG}"
		[ "${RUN_DAEMON}" = "true" -o "${RUN_DAEMON}" = "yes" ] && DAEMON_ARG="-d -l ${INTERFACE} -p ${PORT} -s ${SEPARATOR}"
		[ -x "/usr/sbin/hddtemp" ] || exit 1

		CDROMS_LIST="`/bin/grep "^drive name:" /proc/sys/dev/cdrom/info 2>/dev/null | /bin/sed -e 's/^drive name:\t//g' -e 's/\t/ \/dev\//g'`"
		CDROMS_LIST="${CDROMS_LIST} `/bin/grep -sl '^ide-scsi ' /proc/ide/hd*/driver | /usr/bin/awk -F / '{ print "/dev/"$4 }'`"

		for disk in ${DISKS}
		do
			echo ${CDROMS_LIST} | /bin/grep -wq ${disk} && continue
			echo ${DISKS_NOPROBE} | /bin/grep -wq ${disk} && continue
			if /usr/sbin/hddtemp -wn ${OPTIONS} ${disk} 2>/dev/null | /bin/grep -q '^[0-9]\+$'
			then
				DISKS_LIST="${DISKS_LIST} ${disk}"
			fi
		done

		[ -n "${DISKS_LIST}" -o -n "${DISKS_NOPROBE}" ] && /usr/sbin/hddtemp ${DAEMON_ARG} ${SYSLOG_ARG} ${OPTIONS} ${DISKS_NOPROBE} ${DISKS_LIST}
	};
}
