daemon daemon/dhcpcd/* {
	need = system/bootmisc;
	use = system/static-modules system/coldplug;
	pid_file = /var/run/dhcpcd-${NAME}.pid;
	respawn;
	env_file = /etc/conf.d/net;
	script daemon = {
		eval opts=\"\$\{dhcpcd_${NAME}\}\"

		# Gentoo dhcpcd supports the -o option which stops the
		# interface from being taken down when dhcpcd exits
		# This is needed if something like ifplugd or wpa_supplicant
		# is controlling dhcp on the interface
		/sbin/dhcpcd -h 2>&1 | /bin/grep -q "dknorz" && opts="${opts} -o"
		
		eval d=\" \$\{dhcp_${NAME}\} \"
		[ "${d}" = "  " ] && d=" ${dhcp} "
		
		for o in d
		do
			case ${o} in
				nodns) opts="${opts} -R" ;;
				nontp) opts="${opts} -N" ;;
				nonis) opts="${opts} -Y" ;;
				nohostname) opts="${opts} -h" ;;
			esac
		done

		# Bad things happen if we get an infinite lease,
		# so try and make sure we don't
		echo "${opts}" | /bin/grep -w -- '-l' > /dev/null || opts="${opts} -l 86400"

		h=`hostname`
		if [ -n "${h}" -a ! "${h}" = "(none)" -a ! "${h}" = "localhost" ]
		then
			echo "${opts}" | /bin/grep -w -- '-h' || opts="${opts} -h ${h}"
		fi
		exec /sbin/dhcpcd ${opts} ${NAME}
	};
}
