service daemon/acpid/modules {
	need = system/bootmisc;
	script start = {
		# Check for ACPI support on kernel side
		[ -d /proc/acpi ] || exit 0

		LIST=`/sbin/lsmod | /bin/sed -ne '2,$p'`
		
		# Get list of available modules
		LOC="/lib/modules/`uname -r`/kernel/drivers/acpi"
		if [ -d ${LOC} ]
		then
			# we doesn't support linux 2.4, so we need to look for .ko
			MODAVAIL=`/usr/bin/find ${LOC} -type f -name "*.ko" -printf ".ko\n" | /bin/sed 's/\.ko$//'`
		else
			MODAVAIL=""
		fi
		
		# If no modules is set to load.
		[ "${MODULES}" = "all" ] && MODULES="${MODAVAIL}"
		
		if [ -n "${MODULES}" ]
		then
			for mod in ${MODULES}
			do
				echo ${MODAVAIL} | /bin/grep -q -w "${mod}" || continue
				echo ${LIST} | /bin/grep -q -w "${mod}" || /sbin/modprobe ${mod}
			done
		fi
		exit 0
	};
}

daemon daemon/acpid {
	need = system/bootmisc daemon/acpid/modules;
	use = system/discover system/coldplug;

	env OPTIONS=;
	exec daemon = /usr/sbin/acpid -f -c /etc/acpi/events ${OPTIONS};
}
