/*
 * Simple http (web) server.
 * Jim Rees University of Michigan April 1998
 * Doc page by Mark Eichin <eichin@thok.org> The Herd Of Kittens
 * July 1998
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <System/DataMgr.h>
#include <UI/UIAll.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>
#include <System/Unix/sys_socket.h> /* added for write() */

#include "httpd.h"

char html_doc_intro[] = 
"<h1>DOC Files</h1>\n"
"DOC is a format generated by tools like makedoc7, screwdriver.com, and\n"
"the TopGun Wingman gateway.  DOC files can be read on the pilot by\n"
"AportisDOC, J-DOC, TealDOC, QED, and other programs.\n"
"(All of these use type REAd creator TEXt.)\n"
"<br>\n";

char html_doc_sorry[] =
"<h2>No DOC files found</h2>\n"
"Sorry, there don't appear to be any DOC files installed here.\n"
"To scan all databases, check the <a href=\"/debug/\">debug page</a>.<p>\n";

int send_doc_index(int fd)
{
    int i, n;
    Err st;
    DmSearchStateType dmst;
    UInt cardno = 0;
    LocalID thisdbid;

    wrstr(fd, html0, "text/html");
    wrstr(fd, html_doc_intro);

    st = DmGetNextDatabaseByTypeCreator(1, /* Boolean newSearch */
					&dmst, /* stateInfoP */
					'TEXt',	/* ULong type */
					'REAd',	/* ULong creator */
					0, /* Boolean onlyLatestVers */
			 		&cardno, /* UIntPtr cardNoP */
					&thisdbid /* LocalID* dbIDP */);

    if (st) {
	wrstr(fd, html_doc_sorry);
	wrstr(fd, html_go_home);
	return 0;
    }

    wrstr(fd, "<h1>DOC files available</h1>\n<ul>\n");
    while(!st) {
	/* for now, snarf debug code */
	char namebuf[100];
	char typebuf[5], createbuf[5];
	UInt atts, vers;
	ULong date_cr, date_mod, date_bkp, modnum, typeid, creatorid;
	LocalID appinfo, sortinfo;

	namebuf[0] = 0;
	st = DmDatabaseInfo(cardno,	/* cardNo */
			    thisdbid, /* dbID */
			    namebuf, /* const CharPtr nameP*/
			    &atts, /* UIntPtr attributesP */
			    &vers, /* UIntPtr versionP */
			    &date_cr, /* ULongPtr crDateP */
			    &date_mod, /* ULongPtr modDateP */
			    &date_bkp, /* ULongPtr bckUpDateP */
			    &modnum, /* ULongPtr	modNumP */
			    &appinfo, /* LocalID* appInfoIDP */
			    &sortinfo, /* LocalID* sortInfoIDP */
			    &typeid, /* ULongPtr typeP */
			    &creatorid /* ULongPtr creatorP */);
	if (st) {
	    wrstr(fd, "<li> dmdbi(0x%x) failed (0x%x)\n", 
		  (int)thisdbid, (int)st);
	    continue;
	}
	wrstr(fd, "<li><a href=\"/doc/%lx\">%s</a>\n", thisdbid, namebuf);
	/* end of snarf */
	st = DmGetNextDatabaseByTypeCreator(0, /* Boolean newSearch */
					    &dmst, /*  stateInfoP */
					    'TEXt', /* ULong type */
					    'REAd', /* ULong creator */
					    0, /* Boolean onlyLatestVers */
					    &cardno, /* UIntPtr cardNoP */
					    &thisdbid /* LocalID* dbIDP */);
	/* loop back around with new sample data */
    }
    wrstr(fd, "</ul><p>\n");
    wrstr(fd, html_go_home);

}



typedef struct DocHeader {
    UInt compressed;
    UInt x1;
    ULong truelength;
    UInt nrecs;
    UInt recsize;
    ULong pad;
} DocHeader, *DocHeaderP;

char *doc_decomp_2(int fd, UChar *inbuf, UChar *outbuf, int inbytes);

int send_doc_file(int fd, char* url)
{
    LocalID dbid;
    Err st;
    ULong numrecs, numbytes, databytes;
    DmOpenRef docref;
    int i;
    VoidHand hh;
    DocHeaderP dhp;
    int compressflag, ndocrecs, recsize;
    ULong truelength;
    unsigned char *outbuf, *outptr;

    if (sscanf(url, "/doc/%lx", &dbid) != 1) {
	send_404(fd, url);
	return 0;
    }

    wrstr(fd, html0, "text/html");
    /* do the lookup and get the title later */
    wrstr(fd, "<h1>Doc</h1>\ndbid %lx:\n<br>\n", dbid);

    st = DmDatabaseSize(0, /* UInt cardNo */
			dbid, /* LocalID dbID */
			&numrecs, /* ULongPtr numRecordsP */
			&numbytes, /* ULongPtr totalBytesP */
			&databytes /* ULongPtr dataBytesP */);
    if (st) {
	wrstr(fd, "dmdbsz(0x%x) failed (0x%x)\n", (int)dbid, (int)st);
	return 0;
    }
    wrstr(fd, "DOC %ld recs, %ld/%ld bytes\n", 
	  numrecs, databytes, numbytes);
    wrstr(fd, "<p>\n");

    docref = DmOpenDatabase(0, /* UInt cardNo */
			    dbid, /* LocalID dbID */
			    dmModeReadOnly /* UInt mode*/);

    if (!docref) {
	wrstr(fd, "open failed: docref NULL\n");
	wrstr(fd, html_go_home);
	return 0;
    }

    hh = DmQueryRecord(docref, /* DmOpenRef dbP */
		       0 /* UInt index */);
    dhp = (DocHeaderP)MemHandleLock(hh);
    if (!dhp) {
	wrstr(fd, "%d: no handle\n", i);
    } else {
	/* later, just ref don't copy */
	compressflag = dhp->compressed;
	truelength = dhp->truelength;
	ndocrecs = dhp->nrecs;
	recsize = dhp->recsize;
    }
    MemHandleUnlock(hh);

    wrstr(fd, "<pre>\n");
    switch (compressflag) {
    case 1:
	for (i = 0; i < ndocrecs; i++) {
	    char *chp;
	    hh = DmQueryRecord(docref, /* DmOpenRef dbP */
			       i /* UInt index */);
	    chp = (char*)MemHandleLock(hh);
	    
	    if (!chp) {
		wrstr(fd, "%d: no handle\n", i);
	    } else {
		write(fd, chp, MemPtrSize(chp));
	    }
	    MemHandleUnlock(hh);
	}
	break;
    case 2:
	outptr = outbuf = (unsigned char*)MemPtrNew(recsize);
	if (!outbuf) { 
	    wrstr(fd, "memptrnew failed\n");
	    break; 
	}
	for (i = 1; i < ndocrecs; i++) {
	    unsigned char *chp;
	    hh = DmQueryRecord(docref, /* DmOpenRef dbP */
			       i /* UInt index */);
	    chp = (unsigned char*)MemHandleLock(hh);
	    
	    if (!chp) {
		wrstr(fd, "%d: no handle\n", i);
	    } else {
		outptr = doc_decomp_2(fd, chp, outbuf, MemPtrSize(chp));
		write(fd, outbuf, outptr-outbuf);
	    }
	    MemHandleUnlock(hh);
	}
	MemPtrFree(outbuf);
	break;

    default:
	wrstr(fd, "compress(%d) not yet handled\n", compressflag);
	break;
    }
    wrstr(fd, "</pre>\n");

    st = DmCloseDatabase(docref /* DmOpenRef dbP */);
    if (st) {
	wrstr(fd, "<p> db close failed (0x%x)\n", (int)st);
    }

    wrstr(fd, html_go_home);
}


char *doc_decomp_2(int fd, UChar *inbuf, UChar *outbuf, int inbytes)
{
    unsigned char *outptr = outbuf;
    unsigned int m, n, c, c2;

    while(inbytes > 0) {
	c = *(inbuf++); inbytes--;
	if (c && c < 9) {
	    /* copy 1..9 */
	    memcpy(outptr, inbuf, c);
	    inbuf += c; outptr += c; inbytes -= c;
	} else if (c < 128) {
	    /* self */
	    *(outptr++) = c;
	} else if ((c & 0300) == 0300) {
	    /* space lead */
	    *(outptr++) = ' ';
	    *(outptr++) = c & 0177;
	} else if ((c & 0300) == 0200) {
	    /* the tricky copying one */
	    c2 = *(inbuf++); inbytes--;
	    /* do this the clever way... */
	    m = ((c & 077) << 5)
		+ ((c2 & 0377) >> 3);
	    n = (c2 & 07) + 3;

	    if (n <= m) {
		memcpy(outptr, outptr-m, n);
		outptr += n;
	    } else {
		while (n >= m) {
		    memcpy(outptr, outptr-m, m);
		    outptr += m; n -= m; 
		}
		/* now n < m but n is still a distance... */
		if(n > 0) {
		    memcpy(outptr, outptr-m, n);
		    outptr += n;
		}
	    }
	} else {
#define MSG "Invalid Byte in Decompression\n"
	    memcpy(outptr, MSG, strlen(MSG));
	    outptr += strlen(MSG);
	    break;
	}
    }
    return outptr;
}
