/*
 * Simple http (web) server.
 * Jim Rees University of Michigan April 1998
 * Debug page by Mark Eichin <eichin@kitten.gen.ma.us> The Herd Of Kittens
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <System/DataMgr.h>
#include <UI/UIAll.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>

#include "httpd.h"

int send_debug_index(int fd)
{
    int i, n;

    wrstr(fd, html0, "text/html");

    n = DmNumDatabases(0);	/* cardno = 0? */

    wrstr(fd, "<h1>Debug</h1>\n%d databases:\n<ul>\n", n);

    for (i = 1; i < n; i++) {
	LocalID dbid;
	Err st;
	char namebuf[100];
	char typebuf[5], createbuf[5];
	UInt atts, vers;
	ULong date_cr, date_mod, date_bkp, modnum, typeid, creatorid;
	LocalID appinfo, sortinfo;
	ULong numrecs, numbytes, databytes;

	dbid = DmGetDatabase(0, i);
	if (!dbid) {
	    wrstr(fd, "<li> dmgdb(0,%d) failed\n", i);
	    break;
	}

	namebuf[0] = 0;
	st = DmDatabaseInfo(0,	/* cardNo */
			    dbid, /* dbID */
			    namebuf, /* const CharPtr nameP*/
			    &atts, /* UIntPtr attributesP */
			    &vers, /* UIntPtr versionP */
			    &date_cr, /* ULongPtr crDateP */
			    &date_mod, /* ULongPtr modDateP */
			    &date_bkp, /* ULongPtr bckUpDateP */
			    &modnum, /* ULongPtr	modNumP */
			    &appinfo, /* LocalID* appInfoIDP */
			    &sortinfo, /* LocalID* sortInfoIDP */
			    &typeid, /* ULongPtr typeP */
			    &creatorid /* ULongPtr creatorP */);
	if (st) {
	    wrstr(fd, "<li> dmdbi(0x%x) failed (0x%x)\n", (int)dbid, (int)st);
	    continue;
	}
	memcpy(typebuf, (char*)&typeid, 4);
	typebuf[4] = 0;
	memcpy(createbuf, (char*)&creatorid, 4);
	createbuf[4] = 0;

	st = DmDatabaseSize(0, /* UInt cardNo */
			    dbid, /* LocalID dbID */
			    &numrecs, /* ULongPtr numRecordsP */
			    &numbytes, /* ULongPtr totalBytesP */
			    &databytes /* ULongPtr dataBytesP */);
	if (st) {
	    wrstr(fd, "<li> dmdbsz(0x%x) failed (0x%x)\n", (int)dbid, (int)st);
	    continue;
	}
	wrstr(fd, "<li>Info %d = %s [%s:%s] %ld recs, %ld/%ld bytes\n", 
	      i, namebuf, typebuf, createbuf,
	      numrecs, databytes, numbytes);
    }
    wrstr(fd, "</ul><p>\n");
    wrstr(fd, html_go_home);
}
