/**************************************************************************
 * moon.hxx
 * Written by Durk Talsma. Originally started October 1997, for distribution  
 * with the FlightGear project. Version 2 was written in August and 
 * September 1998. This code is based upon algorithms and data kindly 
 * provided by Mr. Paul Schlyter. (pausch@saaf.se). 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: moon.hxx,v 1.5 1999/06/15 19:55:33 curt Exp $
 **************************************************************************/
#ifndef _MOON_HXX_
#define _MOON_HXX_

#include <Aircraft/aircraft.hxx>
#include <Include/fg_constants.h>
#include <Main/views.hxx>
#include <Time/fg_time.hxx>

#include "celestialBody.hxx"
#include "star.hxx"

class Moon : public CelestialBody
{
private:
  void TexInit();  // This should move to the constructor eventually.

  GLUquadricObj *moonObject;
  GLuint Sphere;
  GLuint moon_texid;
  GLuint moon_halotexid;
  GLubyte *moon_texbuf;
  GLubyte *moon_halotexbuf;
  
  void setHalo();
public:
  Moon ( FGTime *t);
  ~Moon();
  void updatePosition(FGTime *t, Star *ourSun);
  void newImage();
};


#endif // _MOON_HXX_
