/* tri2obj.h -- read in a .ele/.node file pair generated by the triangle 
 *              program and output a Wavefront .obj file.
 *
 * Written by Curtis Olson, started October 1997.
 *
 * Copyright (C) 1997  Curtis L. Olson  - curt@infoplane.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: tri2obj.h,v 1.5 1998/03/03 16:01:00 curt Exp $
 * (Log is kept at end of this file)
 */


#ifndef TRI2OBJ_H
#define TRI2OBJ_H


#include <stdio.h>
#include <string.h>


#define MAX_NODES 200000
#define MAX_TRIS  400000


/* Initialize a new mesh structure */
void triload(char *basename, char *basepath);


#endif /* TRI2OBJ_H */


/* $Log: tri2obj.h,v $
 * Revision 1.5  1998/03/03 16:01:00  curt
 * More c++ compile tweaks.
 *
 * Revision 1.4  1998/01/17 01:25:40  curt
 * Added support for shared normals.
 *
 * Revision 1.3  1997/11/15 18:05:06  curt
 * minor tweaks ...
 *
 * Revision 1.2  1997/11/14 00:29:13  curt
 * Transform scenery coordinates at this point in pipeline when scenery is
 * being translated to .obj format, not when it is being loaded into the end
 * renderer.  Precalculate normals for each node as average of the normals
 * of each containing polygon so Garoude shading is now supportable.
 *
 * Revision 1.1  1997/10/29 23:05:15  curt
 * Initial revision.
 *
 */
