// dem2node.cxx -- main loop
//
// Written by Curtis Olson, started May 1997.
//
// Copyright (C) 1997  Curtis L. Olson  - curt@infoplane.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: dem2node.cxx,v 1.2 1998/04/14 02:26:02 curt Exp $
// (Log is kept at end of this file)
//


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <DEM/dem.hxx>
#include <Bucket/bucketutils.h>


// static float dem_data[DEM_SIZE_1][DEM_SIZE_1];
// static float output_data[DEM_SIZE_1][DEM_SIZE_1];


int main(int argc, char **argv) {
    // DEM data
    fgDEM dem;
    struct fgBUCKET p;
    char fg_root[256];
    char filename[256];
    double error;
    int i, j;

    if ( argc != 4 ) {
	printf("Usage: %s <FG_ROOT> <file.dem> <error_tolerance> (in m^2)\n",
	       argv[0]);
	exit(-1);
    }

    // set fg_root
    strcpy(fg_root, argv[1]);

    // set input dem file name
    strcpy(filename, argv[2]);

    // determine error tolerance
    error = atof(argv[3]);

    printf("fg_root = %s  filename = %s  error = %.2f\n", 
	   fg_root, filename, error);

    dem.open(filename);
    dem.parse();
    dem.close();

    fgBucketFind(dem.info_originx() / 3600.0, dem.info_originy() / 3600.0, &p);

    for ( j = 0; j < 8; j++ ) {
	for ( i = 0; i < 8; i++ ) {
	    p.x = i;
	    p.y = j;
	    dem.fit(fg_root, error, &p);
	}
    }

    return(0);
}


// $Log: dem2node.cxx,v $
// Revision 1.2  1998/04/14 02:26:02  curt
// Code reorganizations.  Added a Lib/ directory for more general libraries.
//
// Revision 1.1  1998/04/08 23:04:49  curt
// Adopted Gnu automake/autoconf system.
//
// Revision 1.1  1998/03/19 02:49:09  curt
// Renamed to dem2node.c
//
// Revision 1.1  1998/03/19 01:58:20  curt
// Renamed to demfit2node.c
//
// Revision 1.12  1998/03/19 01:57:12  curt
// Renamed
//
// Revision 1.5  1998/03/19 01:46:46  curt
// Updated to use class fgDEM.
//
// Revision 1.4  1998/01/31 00:41:24  curt
// Made a few changes converting floats to doubles.
//
// Revision 1.3  1998/01/27 18:37:02  curt
// Lots of updates to get back in sync with changes made over in .../Src/
//
// Revision 1.2  1998/01/09 23:08:35  curt
// Restructured to split 1deg x 1deg dem's into 64 subsections.
//
// Revision 1.1  1997/11/23 00:53:42  curt
// Initial revision.
//
