// tile.hxx -- routines to handle a scenery tile
//
// Written by Curtis Olson, started May 1998.
//
// Copyright (C) 1998  Curtis L. Olson  - curt@infoplane.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: tile.hxx,v 1.7 1998/06/12 00:58:05 curt Exp $
// (Log is kept at end of this file)


#ifndef _TILE_HXX
#define _TILE_HXX


#ifndef __cplusplus                                                          
# error This library requires C++
#endif                                   

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef HAVE_WINDOWS_H
#  include <windows.h>
#endif

#include <GL/glut.h>
#include <XGL/xgl.h>

#ifdef __sun__
extern "C" void *memmove(void *, const void *, size_t);
extern "C" void *memset(void *, int, size_t);
#endif

#include <list>         // STL list

#include <Bucket/bucketutils.h>
#include <Include/fg_types.h>


// Object fragment data class
class fgFRAGMENT {

public:
    // culling data for this object fragment (fine grain culling)
    fgCartesianPoint3d center;
    double bounding_radius;

    // variable offset data for this object fragment for this frame
    fgCartesianPoint3d tile_offset;

    // saved transformation matrix for this fragment (used by renderer)
    // GLfloat matrix[16];

    // material property pointer
    void *material_ptr;

    // OpenGL display list for fragment data
    GLint display_list;

    // Constructor
    fgFRAGMENT ( void );

    // Destructor
    ~fgFRAGMENT ( void );
};


// Scenery tile class
class fgTILE {

public:

    // culling data for whole tile (course grain culling)
    fgCartesianPoint3d center;
    double bounding_radius;
    fgCartesianPoint3d offset;

    // this tile's official location in the world
    struct fgBUCKET tile_bucket;

    // the tile cache will mark here if the tile is being used
    int used;

    list < fgFRAGMENT > fragment_list;

    // Constructor
    fgTILE ( void );

    // Destructor
    ~fgTILE ( void );
};


#endif // _TILE_HXX 


// $Log: tile.hxx,v $
// Revision 1.7  1998/06/12 00:58:05  curt
// Build only static libraries.
// Declare memmove/memset for Sloaris.
//
// Revision 1.6  1998/06/08 17:57:54  curt
// Working first pass at material proporty sorting.
//
// Revision 1.5  1998/06/06 01:09:32  curt
// I goofed on the log message in the last commit ... now fixed.
//
// Revision 1.4  1998/06/06 01:07:18  curt
// Increased per material fragment list size from 100 to 400.
// Now correctly draw viewable fragments in per material order.
//
// Revision 1.3  1998/06/05 22:39:54  curt
// Working on sorting by, and rendering by material properties.
//
// Revision 1.2  1998/06/03 00:47:50  curt
// No .h for STL includes.
// Minor view culling optimizations.
//
// Revision 1.1  1998/05/23 14:09:21  curt
// Added tile.cxx and tile.hxx.
// Working on rewriting the tile management system so a tile is just a list
// fragments, and the fragment record contains the display list for that fragment.
//
