/**************************************************************************
 * hud.hxx -- hud defines and prototypes (initial draft)
 *
 * Written by Michele America, started September 1997.
 *
 * Copyright (C) 1997  Michele F. America  - nomimarketing@mail.telepac.pt
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: hud.hxx,v 1.7 1998/06/12 00:56:00 curt Exp $
 * (Log is kept at end of this file)
 **************************************************************************/


#ifndef _HUD_HXX
#define _HUD_HXX


#ifndef __cplusplus
# error This library requires C++
#endif


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef __sun__
extern "C" void *memmove(void *, const void *, size_t);
extern "C" void *memset(void *, int, size_t);
#endif

#include <fg_typedefs.h>
#include <fg_constants.h>

#include <Aircraft/aircraft.h>
#include <Flight/flight.h>
#include <Controls/controls.h>

//using namespace std;

#include <deque>         // STL


#ifndef WIN32

  typedef struct {
      int x, y;
  } POINT;

  typedef struct {
      int top, bottom, left, right;
  } RECT;

#endif


// View mode definitions

enum VIEW_MODES{ HUD_VIEW, PANEL_VIEW, CHASE_VIEW, TOWER_VIEW };

// DAY, NIGHT and brightness levels need to be visible where dialogs and
// controls can be used to set intensity and appropriate color. This will
// be moved.
// Hud general constants
#define DAY                1
#define NIGHT              2
#define BRT_DARK           3
#define BRT_MEDIUM         4
#define BRT_LIGHT          5
#define SIZE_SMALL         6
#define SIZE_LARGE         7

// Label constants
#define SMALL              1
#define LARGE              2

#define BLINK              3
#define NOBLINK            4

enum fgLabelJust{ LEFT_JUST, CENTER_JUST, RIGHT_JUST } ;

// Ladder constants
#define NONE               1
#define UPPER_LEFT         2
#define UPPER_CENTER       3
#define UPPER_RIGHT        4
#define CENTER_RIGHT       5
#define LOWER_RIGHT        6
#define LOWER_CENTER       7
#define LOWER_LEFT         8
#define CENTER_LEFT        9
#define SOLID_LINES       10
#define DASHED_LINES      11
#define DASHED_NEG_LINES  12


#define HORIZON_FIXED	1
#define HORIZON_MOVING	2
#define LABEL_COUNTER	1
#define LABEL_WARNING	2

// Ladder orientaion
// #define HUD_VERTICAL        1
// #define HUD_HORIZONTAL		2
// #define HUD_FREEFLOAT		3

// Ladder orientation modes
// #define HUD_LEFT    		1
// #define HUD_RIGHT         	2
// #define HUD_TOP           	1
// #define HUD_BOTTOM        	2
// #define HUD_V_LEFT    		1
// #define HUD_V_RIGHT         	2
// #define HUD_H_TOP           	1
// #define HUD_H_BOTTOM        	2


// Ladder sub-types
// #define HUD_LIM				1
// #define HUD_NOLIM			2
// #define HUD_CIRC			3

// #define HUD_INSTR_LADDER	1
// #define HUD_INSTR_CLADDER	2
// #define HUD_INSTR_HORIZON	3
// #define HUD_INSTR_LABEL		4

extern double get_throttleval ( void );
extern double get_aileronval  ( void );
extern double get_elevatorval ( void );
extern double get_elev_trimval( void );
extern double get_rudderval   ( void );
extern double get_speed       ( void );
extern double get_aoa         ( void );
extern double get_roll        ( void );
extern double get_pitch       ( void );
extern double get_heading     ( void );
extern double get_altitude    ( void );
extern double get_sideslip    ( void );
extern double get_frame_rate  ( void );
extern double get_latitude    ( void );
extern double get_lat_min     ( void );
extern double get_longitude   ( void );
extern double get_long_min    ( void );
extern double get_fov         ( void );
extern double get_vfc_ratio   ( void );

enum  hudinstype{ HUDno_instr,
              HUDscale,
              HUDlabel,
              HUDladder,
              HUDcirc_ladder,
              HUDhorizon,
              HUDguage,
              HUDdual_inst,
              HUDmoving_scale,
              HUDtbi
              };

enum ReadOriented{ ReadRIGHT, ReadLEFT, ReadTOP, ReadBOTTOM };

class instr_item {  // An Abstract Base Class (ABC)
  private:
    static UINT      instances;     // More than 64K instruments? Nah!
    UINT             handle;
    RECT             scrn_pos;      // Framing - affects scale dimensions
                                    // and orientation. Vert vs Horz, etc.
    DBLFNPTR         load_value_fn;
    ReadOriented     oriented;
    bool             is_enabled;
    bool             broken;
    int              brightness;
    UINT             scr_span;      // Working values for draw;
    POINT            mid_span;      //

  public:
    instr_item( RECT           scrn_pos,
                DBLFNPTR       data_source,
                ReadOriented   orient,
                bool           working      = true);

    instr_item( const instr_item & image );

    instr_item & operator = ( const instr_item & rhs );
    virtual ~instr_item ();

    int          get_brightness  ( void ) { return brightness;}
    RECT         get_location    ( void ) { return scrn_pos;  }
    bool         is_broken       ( void ) { return broken;    }
    bool         enabled         ( void ) { return is_enabled;}
    double       get_value       ( void ) { return load_value_fn();}
    UINT         get_span        ( void ) { return scr_span;  }
    POINT        get_centroid    ( void ) { return mid_span;  }
    ReadOriented get_orientation ( void ) { return oriented;  }

    virtual void display_enable( bool working ) { is_enabled = !! working;}


    virtual void update( void );
    virtual void break_display ( bool bad );
    virtual void SetBrightness( int illumination_level ); // fgHUDSetBright...
    UINT    get_Handle( void );
    virtual void draw( void ) = 0;   // Required method in derived classes
};

typedef instr_item *HIptr;

extern deque< instr_item * > HUD_deque;

// instr_item           This class has no other purpose than to maintain
//                      a linked list of instrument and derived class
// object pointers.


class instr_label : public instr_item {
  private:
    const char *pformat;
    const char *pre_str;
    const char *post_str;
    fgLabelJust justify;
    int         fontSize;
    int         blink;

  public:
    instr_label( RECT         the_box,
                 DBLFNPTR     data_source,
                 const char  *label_format,
                 const char  *pre_label_string    = 0,
                 const char  *post_label_string   = 0,
                 ReadOriented orientation         = ReadTOP,
                 fgLabelJust  justification       = CENTER_JUST,
                 int          font_size           = SMALL,
                 int          blinking            = NOBLINK,
                 bool         working             = true);

    ~instr_label();

    instr_label( const instr_label & image);
    instr_label & operator = (const instr_label & rhs );

    virtual void draw( void );       // Required method in base class
};

typedef instr_label * pInstlabel;

//
// instr_scale           This class is an abstract base class for both moving
//                       scale and moving needle (fixed scale) indicators. It
// does not draw itself, but is not instanciable.
//

class instr_scale : public instr_item {
  private:
    int    range_shown;   // Width Units.
    int    Maximum_value; //                ceiling.
    int    Minimum_value; // Representation floor.
    UINT   Maj_div;       // major division marker units
    UINT   Min_div;       // minor division marker units
    UINT   Modulo;        // Roll over point
    double scale_factor;  // factor => screen units/range values.

  public:
    instr_scale( RECT         the_box,
                 DBLFNPTR     load_fn,
                 ReadOriented orient,
                 int          show_range,
                 int          max_value,
                 int          min_value    =   0,
                 UINT         major_divs   =  10,
                 UINT         minor_divs   =   5,
                 UINT         rollover     =   0,
                 bool         working      = true);

    virtual ~instr_scale();
    instr_scale( const instr_scale & image);
    instr_scale & operator = (const instr_scale & rhs);

    virtual void draw   ( void ) {}; // No-op here. Defined in derived classes.
    UINT   div_min      ( void ) { return Min_div;}
    UINT   div_max      ( void ) { return Maj_div;}
    int    min_val      ( void ) { return Minimum_value;}
    int    max_val      ( void ) { return Maximum_value;}
    UINT   modulo       ( void ) { return Modulo; }
    double factor       ( void ) { return scale_factor;}
    double range_to_show( void ) { return range_shown;}
};

// moving_scale_instr      This class displays the indicated quantity on
//                         a scale that moves past the pointer. It may be
// horizontal or vertical, read above(left) or below(right) of the base
// line.

class moving_scale : public instr_scale {
  private:
    double val_span;
    double half_width_units;

  public:
    moving_scale( RECT         box,
                  DBLFNPTR     load_fn,
                  ReadOriented readway,
                  int          maxValue,
                  int          minValue,
                  UINT         major_divs,
                  UINT         minor_divs,
                  UINT         modulator,
                  double       value_span,
                  bool         working = true);

    ~moving_scale();
    moving_scale( const moving_scale & image);
    moving_scale & operator = (const moving_scale & rhs );
//    virtual void display_enable( bool setting );
    virtual void draw( void );       // Required method in base class
};

typedef moving_scale * pMoveScale;

class guage_instr : public instr_scale {
  private:

  public:
    guage_instr( RECT         box,
                 DBLFNPTR     load_fn,
                 ReadOriented readway,
                 int          maxValue,
                 int          minValue,
                 UINT         major_divs,
                 UINT         minor_divs,
                 UINT         modulus,
                 bool         working = true);

    ~guage_instr();
    guage_instr( const guage_instr & image);
    guage_instr & operator = (const guage_instr & rhs );
    virtual void draw( void );       // Required method in base class
};

typedef guage_instr * pGuageInst;
//
// dual_instr_item         This class was created to form the base class
//                         for both panel and HUD Turn Bank Indicators.

class dual_instr_item : public instr_item {
  private:
    DBLFNPTR alt_data_source;

  public:
    dual_instr_item ( RECT         the_box,
                      DBLFNPTR     chn1_source,
                      DBLFNPTR     chn2_source,
                      bool         working     = true,
                      ReadOriented readway  = ReadTOP);

    virtual ~dual_instr_item() {};
    dual_instr_item( const dual_instr_item & image);
    dual_instr_item & operator = (const dual_instr_item & rhs );

    double current_ch1( void ) { return alt_data_source();}
    double current_ch2( void ) { return get_value();}
    virtual void draw ( void ) { }
};

class fgTBI_instr : public dual_instr_item {
  private:
    UINT BankLimit;
    UINT SlewLimit;
    UINT scr_hole;

  public:
    fgTBI_instr( RECT      the_box,
                 DBLFNPTR  chn1_source  = get_roll,
                 DBLFNPTR  chn2_source  = get_sideslip,
                 UINT      maxBankAngle = 45,
                 UINT      maxSlipAngle =  5,
                 UINT      gap_width    =  5,
                 bool      working      =  true);

    fgTBI_instr( const fgTBI_instr & image);
    fgTBI_instr & operator = (const fgTBI_instr & rhs );

    ~fgTBI_instr();

    UINT bank_limit( void ) { return BankLimit;}
    UINT slew_limit( void ) { return SlewLimit;}

    virtual void draw( void );       // Required method in base class
};

typedef fgTBI_instr * pTBI;

class HudLadder : public dual_instr_item {
  private:
    UINT   width_units;
    int    div_units;
    UINT   minor_div;
    UINT   label_pos;
    UINT   scr_hole;
    int    vmax;
    int    vmin;
    double factor;

  public:
    HudLadder( RECT      the_box,
               DBLFNPTR  ptch_source    = get_roll,
               DBLFNPTR  roll_source    = get_pitch,
               UINT      span_units     = 45,
               int       division_units = 10,
               UINT      minor_division = 0,
               UINT      screen_hole    = 70,
               UINT      lbl_pos        = 0,
               bool      working        = true );

    ~HudLadder();

    HudLadder( const HudLadder & image );
    HudLadder & operator = ( const HudLadder & rhs );
    virtual void draw( void );
};


//using namespace std;
//deque <instr_item>  * Hdeque_ptr;

extern int  fgHUDInit( fgAIRCRAFT * /* current_aircraft */ );
extern void fgUpdateHUD( void );

/*
bool AddHUDInstrument( instr_item *pBlackBox );
void DrawHUD ( void );
bool DamageInstrument( INSTR_HANDLE unit );
bool RepairInstrument( INSTR_HANDLE unit );


void fgUpdateHUD ( Hptr hud );
void fgUpdateHUD2( Hptr hud ); // Future use?
void fgHUDSetTimeMode( Hptr hud, int time_of_day );
*/

#endif // _HUD_H

/* $Log: hud.hxx,v $
 * Revision 1.7  1998/06/12 00:56:00  curt
 * Build only static libraries.
 * Declare memmove/memset for Sloaris.
 *
 * Revision 1.6  1998/06/03 00:43:28  curt
 * No .h when including stl stuff.
 *
 * Revision 1.5  1998/05/17 16:58:13  curt
 * Added a View Frustum Culling ratio display to the hud.
 *
 * Revision 1.4  1998/05/16 13:04:15  curt
 * New updates from Charlie Hotchkiss.
 *
 * Revision 1.3  1998/05/13 18:27:55  curt
 * Added an fov to hud display.
 *
 * Revision 1.2  1998/05/11 18:13:12  curt
 * Complete C++ rewrite of all cockpit code by Charlie Hotchkiss.
 *
 * Revision 1.15  1998/02/23 19:07:57  curt
 * Incorporated Durk's Astro/ tweaks.  Includes unifying the sun position
 * calculation code between sun display, and other FG sections that use this
 * for things like lighting.
 *
 * Revision 1.14  1998/02/21 14:53:14  curt
 * Added Charlie's HUD changes.
 *
 * Revision 1.13  1998/02/20 00:16:22  curt
 * Thursday's tweaks.
 *
 * Revision 1.12  1998/02/19 13:05:52  curt
 * Incorporated some HUD tweaks from Michelle America.
 * Tweaked the sky's sunset/rise colors.
 * Other misc. tweaks.
 *
 * Revision 1.11  1998/02/16 13:38:42  curt
 * Integrated changes from Charlie Hotchkiss.
 *
 * Revision 1.11  1998/02/16 13:38:42  curt
 * Integrated changes from Charlie Hotchkiss.
 *
 * Revision 1.10  1998/02/12 21:59:42  curt
 * Incorporated code changes contributed by Charlie Hotchkiss
 * <chotchkiss@namg.us.anritsu.com>
 *
 * Revision 1.8  1998/02/07 15:29:35  curt
 * Incorporated HUD changes and struct/typedef changes from Charlie Hotchkiss
 * <chotchkiss@namg.us.anritsu.com>
 *
 * Revision 1.7  1998/02/03 23:20:15  curt
 * Lots of little tweaks to fix various consistency problems discovered by
 * Solaris' CC.  Fixed a bug in fg_debug.c with how the fgPrintf() wrapper
 * passed arguments along to the real printf().  Also incorporated HUD changes
 * by Michele America.
 *
 * Revision 1.6  1998/01/22 02:59:30  curt
 * Changed #ifdef FILE_H to #ifdef _FILE_H
 *
 * Revision 1.5  1998/01/19 19:27:01  curt
 * Merged in make system changes from Bob Kuehne <rpk@sgi.com>
 * This should simplify things tremendously.
 *
 * Revision 1.4  1998/01/19 18:40:21  curt
 * Tons of little changes to clean up the code and to remove fatal errors
 * when building with the c++ compiler.
 *
 * Revision 1.3  1997/12/30 16:36:41  curt
 * Merged in Durk's changes ...
 *
 * Revision 1.2  1997/12/10 22:37:40  curt
 * Prepended "fg" on the name of all global structures that didn't have it yet.
 * i.e. "struct WEATHER {}" became "struct fgWEATHER {}"
 *
 * Revision 1.1  1997/08/29 18:03:22  curt
 * Initial revision.
 *
 */
