-- F l i g h t G e a r   M a k e   R e a d m e --

This document describes the FlightGear make system, the idea of commonrules,
commondefs, and how to build new makefiles using this system. The current
system was implemented with v.24 of FlightGear and implemented to consolidate
build targets, definitions, and rules for simplicity and maintainability.


-- E n v i r o n m e n t   V a r s --

To build any of the FlightGear source, several environment variables must
first be set:

 FG_ROOT
	This variable must point at the "FlightGear" top level directory. It's
	used by various subsystems to determine where the FlightGear structure
 	begins.

 FG_ROOT_SRC
	This variable must point at the FlightGear "Src" directory. It's used
	by the make system to determine where common make utilities are found.

 FG_ROOT_LIB
	This variable must point at the FlightGear "Lib" directory. It's used
	to determine where all the FlightGear libraries are built, and in the
 	future, will be used by the FlightGear runtime to determine where 
	FlightGear-specific shared libraries can be found.


-- H o w   T o   B u i l d   N e w   M a k e f i l e s --

Using the commondefs and commonrules make components is very simple. The
basic concept is that common make variable definitions live in the 
$FG_ROOT_SRC/commondefs file. These variables combine locally defined
makefile variables to generate aggregate make variables. Local additions
to these aggregate variables follow a simple rule - local versions of
the commondefs variables are prefixed with 'L'. For example, for a
local makefile to add additional definitions to the aggregate CDEFS 
variable, it would define the variable LCDEFS with the required values.
The second half of this system, $FG_ROOT_SRC/commonrules, is even simpler.
It merely contains a bunch of common make rules which most local makefiles
will likely want to use. A few of these rules are defined shortly. 

To create your own local FlightGear makefile, follow these instructions:

 1) Define all local source files and targets using the following make
    variables:

	CFILES = local c source files (with extension .c)
	CXXFILES = local cxx source files (with extension .cxx)
	LDLIBRARY = name of shared library to be build using all objects
	            generated from CFILES & CXXFILES
	ARLIBRARY = name of archive library to be built using all objects
	            generated from CFILES & CXXFILES
	TARGETS = the primary file to be built

 2) Define all local flags, defs, and libs for the C, CXX, and link phases
    using the following make variables:

	LCDEFS = local c compile -defines (using -D FOO syntax)
	LCFLAGS = local c compile options (like -g, -Wall, etc.)
	LCXXDEFS = local cxx compile defines (using -D FOO syntax)
	LCXXFLAGS = local cxx compile options (like -g, -Wall, etc.)
	LLDFLAGS = local link flags (like -shared, -woff, -L/foo, etc.)
	LLDLIBS = local link libraries

    Lastly, feel free to define LDIRT, a list of extra goop which will be
    removed upon invocation of a 'make clean'.

 3) This next step is order dependant. That is, the inclusion of the
    commondefs file is necessary at this point to assemble the above
    local defs in with the global FlightGear defs. Include this file
    using:

	include $FG_ROOT_SRC/commondefs

 4) Define any rules which are necessary to make TARGETS which are not
    already defined in commonrules. Commonrules includes rules for

    	clean: removal of all objects, dependency files, etc.
	clobber: removal of all editor backups, and clean
	.c.o: how to build .c files into .o files
 	.cxx.o: how to build .cxx files into .o files
	building LDLIBRARY
	building ARLIBRARY
	building dependency file (depend)
 
To get some insight into how these work, investigate any of the local
FlightGear makefiles in Math, Main, Astro, etc., for a quick example.
Also, peruse commonrules and commondefs to understand a bit of the
mechanisms these two files provide.
