/**************************************************************************
 * fg_config.h -- Flight Gear runtime config utility functions
 *
 * Written by Paul Bleisch, started January 1998. 
 *
 * Copyright (C) 1998 Paul Bleisch, pbleisch@acm.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * (Log is kept at end of this file)
 **************************************************************************/

#ifndef _FG_CONFIG_H_
#define _FG_CONFIG_H_

#include <Main/fg_debug.h>

typedef enum {
  FG_CVNONE = 0,
  FG_CVUINT,
  FG_CVINT,
  FG_CVSTRING,
  FG_CVREAL,
  FG_CVVOID,
  FG_CVBOOL,

  FG_CVREFERENCE = 0x80000000
} fgCVTYPE;
    
typedef int (*fgCVVERIFYCB)( struct tagfgCV *current, 
			     struct tagfgCV *int ); 

typedef union {
  unsigned int uintval;
  int intval;
  char *strval;
  void *voidval;
  int boolval;
  double realval;
} fgCVVALUE;

typedef struct tagfgCV {
  fgCVTYPE  type;
  char *symbol;
  fgCVVALUE value;
  fgCVVERIFYCB verify;
} fgCV;


/* Write functions */
void fgUpdateCVMulti( char **keyvaluepairs, int numkvps );
void fgUpdateCV( char *symbol, fgCVTYPE intype, fgCVVALUE inval ); 

/* Read functions */
int fgGetCVInt( char *symbol );
unsigned int fgGetCVUnsigned( char *symbol );
char *fgGetCVStr( char *symbol );
void *fgGetCVVoid( char *symbol );
int fgGetCVBool( char *symbol );
double fgGetCVReal( char *symbol );

/* Debug */
void fgDumpCV( void );

#endif /* _FG_CONFIG_H_ */
