/* ---------------------- keys.h -------------------------
//
//**$Log:   E:/bc/h/keys.h_v  $
//
//   Rev 1.0   12 Nov 1996 14:39:40   CHOTCHKISS
//Initial revision.
//
//    Rev 1.1   29 Mar 1990 10:23:04   CHOTCHKISS
// Added support for CTRL- and ALT- key recognition and verified
// the codes experimentally.
//
//    Rev 1.0   16 Mar 1990 15:28:20   CHOTCHKISS
// Initial revision.
*/

#ifndef KEYS_H
#define KEYS_H

#define HT         9
#define RUBOUT     8
#define BS         8
#define BELL       7
#define ESC       27
#define SHIFT_HT 143

#define CTRL_A     1
#define CTRL_B     2
#define CTRL_C     3
#define CTRL_D     4
#define CTRL_E     5
#define CTRL_F     6
#define CTRL_G     7
#define CTRL_H     8
#define CTRL_I     9
#define CTRL_J    10
#define CTRL_K    11
#define CTRL_L    12
#define CTRL_M    13
#define CTRL_N    14
#define CTRL_O    15
#define CTRL_P    16
#define CTRL_Q    17
#define CTRL_R    18
#define CTRL_S    19
#define CTRL_T    20
#define CTRL_U    21
#define CTRL_V    22
#define CTRL_W    23
#define CTRL_X    24
#define CTRL_Y    25
#define CTRL_Z    26

#define ALT_A    158
#define ALT_B    176
#define ALT_C    174
#define ALT_D    160
#define ALT_E    146
#define ALT_F    161
#define ALT_G    162
#define ALT_H    163
#define ALT_I    151
#define ALT_J    164
#define ALT_K    165
#define ALT_L    166
#define ALT_M    178
#define ALT_N    177
#define ALT_O    152
#define ALT_P    153
#define ALT_Q    144
#define ALT_R    147
#define ALT_S    159
#define ALT_T    148
#define ALT_U    150
#define ALT_V    175
#define ALT_W    145
#define ALT_X    173
#define ALT_Y    149
#define ALT_Z    172

#define ALT_1      248 /*   0x0154 */
#define ALT_2      249 /*   0x0155 */
#define ALT_3      250 /*   0x0156 */
#define ALT_4      251 /*   0x0157 */
#define ALT_5      252 /*   0x0158 */
#define ALT_6      253 /*   0x0159 */
#define ALT_7      254 /*   0x015a */
#define ALT_8      255 /*   0x015b */
#define ALT_9      128 /*   0x015c */
#define ALT_0      129 /*   0x015d */
#define ALT_Minus  130 /*   0x015e */
#define ALT_Equal  131 /*   0x015f */

#define F1       187
#define F2       188
#define F3       189
#define F4       190
#define F5       191
#define F6       192
#define F7       193
#define F8       194
#define F9       195
#define F10      196

#define HOME     199
#define UP       200
#define PGUP     201

#define BWD      203

#define FWD      205

#define END      207
#define DN       208
#define PGDN     209
#define INS      210
#define DEL      211

#define SHFT_F1  212
#define SHFT_F2  213
#define SHFT_F3  214
#define SHFT_F4  215
#define SHFT_F5  216
#define SHFT_F6  217
#define SHFT_F7  218
#define SHFT_F8  219
#define SHFT_F9  220
#define SHFT_F10 221

#define CTRL_F1  222
#define CTRL_F2  223
#define CTRL_F3  224
#define CTRL_F4  225
#define CTRL_F5  226
#define CTRL_F6  227
#define CTRL_F7  228
#define CTRL_F8  229
#define CTRL_F9  230
#define CTRL_F10 231

#define ALT_F1   232
#define ALT_F2   233
#define ALT_F3   234
#define ALT_F4   235
#define ALT_F5   236
#define ALT_F6   237
#define ALT_F7   238
#define ALT_F8   239
#define ALT_F9   240
#define ALT_F10  241

#define CTRL_HOME  247
#define CTRL_BS    243  /* CTRL + Left Arrow  */
#define CTRL_FWD   244  /* CTRL + Right Arrow */
#define CTRL_END   245
#define CTRL_PGU   132  /* thought it was 248 */
#define CTRL_PGD   246  /* thought it was 256 */
#define CTRL_BKSP  127

#endif