/*
//  Alterations: Copyright C. Hotchkiss 1996
//
**$Log:   E:/bc/h/typedefs.h_v  $
//
//   Rev 1.4   11 Nov 1997 15:34:28   CHOTCHKISS
//Expanded definitions.
//
//   Rev 1.3   20 Jan 1997  9:21:26   CHOTCHKISS
//Minor additions.
//
//   Rev 1.2   12 Nov 1996 15:06:52   CHOTCHKISS
//Dropped PC Write print format control lines.
*
*   Rev 1.1   20 Nov 1995 15:59:02   CHOTCHKISS
*Additions and improvements. Memcheck compatibilities.
*
*   Rev 1.0   06 Apr 1995 14:00:32   CHOTCHKISS
*Initial revision.

*/
/*
//    TYPEDEFS.H - General purpose definition file
//    Copyright (C) 1992 Paradigm Systems.  All rights reserved.
//
//    Function    
//    ========
//    This file contains the general purpose definitions common to the
//    all Paradigm applications.  By defining synonyms for the physical
//    data types to be manipulated, portability between memory models
//    and machines is maximized.
//
//    Note that this file follows the system include files and before
//    any application include files.
*/

#if !defined(_TYPEDEFS)
#define _TYPEDEFS

//
//    Define the types to be used to manipulate 8-, 16-, and 32-bit
//    data.
//
typedef unsigned int   BIT ;     // Use for defining Borland bit fields
typedef char           CHAR ;    // 8-bit signed data
typedef const char     COCHAR;
typedef unsigned char  UCHAR ;   // 8-bit unsigned data
typedef unsigned char  BYTE;
typedef int            INT ;     // 16-bit signed data
typedef unsigned int   UINT ;    // 16-bit unsigned data
typedef const int      COINT;    // 16=bit constant int
typedef const UINT     COUINT;
typedef long           LONG ;    // 32-bit signed data
typedef unsigned long  ULONG ;   // 32-bit unsigned data

typedef unsigned short UWORD;   // Unsigned 16 bit quantity (WIN=SHORT)
typedef signed   short WORD;    // Signed   16 bit quantity
typedef BYTE           UBYTE;    // Used in some 3rd party code
typedef int            BOOLEAN;  //

typedef float          FLOAT ;   // 32-bit floating point data
typedef double         DOUBLE ;  // 64-bit floating point data
typedef long double    LDOUBLE ; // 80-bit floating point data

#ifndef bool
typedef int bool;
#endif
typedef int BOOL;
typedef int Bool;

typedef void(*VFNPTR)   ( void );
typedef void(*VFNINTPTR)( int  );
typedef int (*FNPTR)    ( void );
typedef int (*FNINTPTR) ( int  );
typedef int (*FNUIPTR)  ( UINT );

#ifndef DLIN_LIMIT
#define DLIN_LIMIT 100
#endif
#if defined(__cplusplus)
typedef void interrupt (*ISRP)(...) ; /* Interrupt table vector entries */
#else
typedef void interrupt (*ISRP)() ;    /* Interrupt table vector entries */
#endif

#ifndef TRUE
//typedef enum   {
//        FALSE = 0,
//        TRUE
//      } BOOL ;              // Simple enumeration for booleans
#define TRUE 1
#define FALSE 0
#endif
#ifndef EOF
#define EOF (-1)
#endif

/*
//    Define some common macros that show up everywhere.  These are
//
//      lowbyte(x)        Extract the low order byte of UINT 'x'
//      highbyte(x)       Extract the high order byte of UINT 'x'
//      dim(x)          Computes the dimension of a array 'x'
//      setvect(inum, addr) Install interrupt handler 'addr' in vector 'inum'
//      getvect(inum)     Get the contents of interrupt vector 'inum'
*/

//
//  MEMCHECK does not like these definitions in BC++ 3.1 so we will
//  knock them out here if MEMCHECK is in use.
//
#ifdef NOMEMCHECK

#define lowbyte(word)     ((word) & 0xff)
#define highbyte(word)      lowbyte((word) >> 8)
#define dim(x)          (sizeof(x) / sizeof(x[0]))
#define setvect(inum, addr) *((ISRP far *) ((inum) * 4)) = ((ISRP) addr)
#define getvect(inum)       (ISRP) (*((ISRP far *) ((inum) * 4)))


#endif

#endif

  /* !defined(_TYPEDEFS) */

