/**************************************************************************
 * hud.h -- hud defines and prototypes (initial draft)
 *
 * Written by Michele America, started September 1997.
 *
 * Copyright (C) 1997  Michele F. America  - nomimarketing@mail.telepac.pt
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: hud.h,v 1.11 1998/02/16 13:38:42 curt Exp $
 * (Log is kept at end of this file)
 **************************************************************************/


#ifndef _HUD_H
#define _HUD_H

#include <Include/fg_typedefs.h>
#include <Aircraft/aircraft.h>
#include <Flight/flight.h>
#include <Controls/controls.h>

// View mode definitions

enum VIEW_MODES { HUD_VIEW, PANEL_VIEW, CHASE_VIEW, TOWER_VIEW };

// Hud general constants
#define DAY                1
#define NIGHT              2
#define BRT_DARK           3
#define BRT_MEDIUM         4
#define BRT_LIGHT          5
#define SIZE_SMALL         6
#define SIZE_LARGE         7

// Instrument types
#define ARTIFICIAL_HORIZON	1
#define SCALE              2
#define LADDER             3
#define LABEL              4

// Scale constants
#define HORIZONTAL         1
#define TOP                2
#define BOTTOM             3
#define VERTICAL           4
#define LEFT               5
#define RIGHT              6
#define LIMIT              7
#define NOLIMIT            8
#define ROUNDROB           9

// Label constants
#define SMALL              1
#define LARGE              2

#define BLINK              3
#define NOBLINK            4

enum fgLabelJust { LEFT_JUSTIFY, CENTER_JUSTIFY, RIGHT_JUSTIFY };

// Ladder constants
#define NONE               1
#define UPPER_LEFT         2
#define UPPER_CENTER       3
#define UPPER_RIGHT        4
#define CENTER_RIGHT       5
#define LOWER_RIGHT        6
#define LOWER_CENTER       7
#define LOWER_LEFT         8
#define CENTER_LEFT        9
#define SOLID_LINES       10
#define DASHED_LINES      11
#define DASHED_NEG_LINES  12


#define HORIZON_FIXED	1
#define HORIZON_MOVING	2
#define LABEL_COUNTER	1
#define LABEL_WARNING	2

// Ladder orientaion
// #define HUD_VERTICAL        1
// #define HUD_HORIZONTAL		2
// #define HUD_FREEFLOAT		3

// Ladder orientation modes
// #define HUD_LEFT    		1
// #define HUD_RIGHT         	2
// #define HUD_TOP           	1
// #define HUD_BOTTOM        	2
// #define HUD_V_LEFT    		1
// #define HUD_V_RIGHT         	2
// #define HUD_H_TOP           	1
// #define HUD_H_BOTTOM        	2


// Ladder sub-types
// #define HUD_LIM				1
// #define HUD_NOLIM			2
// #define HUD_CIRC			3

// #define HUD_INSTR_LADDER	1
// #define HUD_INSTR_CLADDER	2
// #define HUD_INSTR_HORIZON	3
// #define HUD_INSTR_LABEL		4

// CLO 2/21/98 - added to fix compile error
typedef struct  {
  int x;
  int y;
} POINT;

// CLO 2/21/98 - added to fix compile error
typedef struct  {
  int left;
  int right;
  int top;
  int bottom;
} RECT;

typedef enum{ HUDno_instr,
                   HUDscale,
                   HUDcirc_scale,
                   HUDladder,
                   HUDcirc_ladder,
                   HUDhorizon,
                   HUDlabel,
                   HUDcontrol_surfaces,
                   HUDcontrol
                   } hudinstype;

typedef enum{ ReadRight, ReadLeft, ReadUP, ReadDN, ReadMirror }ReadOriented;

typedef struct {
	int type;
	int x_pos;
	int y_pos;
	int size;
	int blink;
	int justify;
	char *pre_str;
	char *post_str;
	char *format;
	double (*load_value)( void ); // pointer to routine to get the data
} HUD_label, *pHUDlabel;


typedef struct  {
  int type;
  int sub_type;
  int scr_pos;
  int scr_min;
  int scr_max;
  int div_min;
  int div_max;
  int orientation;
  int minimum_value;
  int maximum_value;
  int width_units;
  double (*load_value)( void );
}HUD_scale,  *pHUDscale;

typedef struct  {
	int type;
	int scr_pos;
	int scr_min;
	int scr_max;
	int div_min;
	int div_max;
	int orientation;
	int label_position;
	int width_units;
	double (*load_value)( void );
}HUD_circular_scale, *pHUD_circscale;

typedef struct {
	int scr_min;
	int scr_max;
	int div_min;
	int div_max;
	int orientation;
	int label_position;
	int width_units;
	double (*load_value)( void );
} HUD_circular_ladder, *pHUDcircladder;

typedef struct {
  int x_pos;
  int y_pos;
  double(*load_value)(void);
} HUD_control_surfaces, *pHUDControlSurfaces;

typedef struct {
  int ctrl_x;
  int ctrl_y;
  int ctrl_length;
  int orientation;
  int alignment;
  int min_value;
  int max_value;
  int width_units;
  double (*load_value)(void);
} HUD_control, *pHUDControl;


//    Update();          // Follow the data changes.
//    Repaint();         // Respond to uncover/panel repaints.
//    Break();           // Show a frown.
//    Fix();             // Return to normal appearance and function.
//    Night_Day();       // Illumination changes appearance/bitmaps.
//

//    instrument_item *next;
//    instrument_item *prev;

class instrument_item {  // An Abstract Base Class (ABC)
  private:
    RECT             scrn_pos;       // Framing - affects scale dimensions
                                     // and orientation. Vert vs Horz, etc.
    DBLFNPTR         load_value_fn;
    ReadOriented     oriented;
    bool             is_enabled;
    bool             broken;
    int              brightness;

  public:
    instrument_item( UINT             left         = 0,
                     UINT             top          = 0,
                     UINT             right        = 0,
                     UINT             bottom       = 0,
                     DBLFNPTR         data_source  = 0,
                     ReadOriented     orientation  = ReadRight,
                     bool             enabled      = FALSE);

    instrument_item( RECT             scrn_pos,
                     DBLFNPTR         data_source,
                     ReadOriented     orientation,
                     bool             enabled);

    instrument_item( const instrument_item & image );

    instrument_item & operator = ( const instrument_item & rhs );
    ~instrument_item ();

    RECT get_location( void ) { return scrn_pos;}
    bool is_broken   ( void ) { return broken;}
    void         display_enable( BOOL on ) { is_enabled = !! on;};
    double       current_value( void ) { return load_value_fn();}

    virtual void update( void );
    virtual void turn_lamp( BOOL on) {lamp = !!on;};
    virtual void break_display ( BOOL bad );
    virtual void SetBrightness( int illumination_level ); //fgHUDSetBright...
    virtual void Init( fgAIRCRAFT *cur_aircraft );
    virtual void draw( void ) = 0;    // Required method in derived classes
};

typedef instrument_item *HIptr;

class instr_label : public instrument_item {
  private:
    fgLabelJust justify;
    const char *ptext;
    const char *pre_string;
    const char *post_string;
    int         size;
    char      (*load_str)(void);
    int         blink;

  public:
    instr_label( UINT         left                = 0,
                 UINT         top                 = 0,
                 UINT         right               = 0,
                 UINT         bottom              = 0,
                 ReadOriented orientation         = ReadRight,
                 fgLabelJust  justification       = LEFT_JUSTIFY,
                 BOOL         enabled             = FALSE,
                 const char  *label_image         = 0,
                 const char  *pre_label_string    = 0,
                 const char  *post_label_string   = 0,
                 int          size                = SMALL,
                 char      ( *data_source)(void)  = 0,
                 int          blinking            = NOBLINK);

    ~instr_label();

    instr_label( const HUD_label *phud_label);

    instr_label( const instr_label & image);
    instr_label & operator = (const instr_label & rhs );


    virtual void draw( void );       // Required method in base class
};

typedef instr_label * pInstlabel;

class moving_scale_instr : public instrument_item {
  private:
    const char *ptext;
    int         orientation;

  public:
    moving_scale_instr( UINT         left         = 0,
                        UINT         top          = 0,
                        UINT         right        = 0,
                        UINT         bottom       = 0,
                        DBLFNPTR      data_source = 0,
                        ReadOriented orientation  = ReadRight,
                        const char  *label_image  = 0
                        );
    ~moving_scale_instr();
    moving_scale_instr( const moving_scale_instr & image);
    moving_scale_instr & operator = (const moving_scale_instr & rhs );
    display_enable( bool on );
    virtual void draw( void );       // Required method in base class
};

typedef moving_scale_instr * pMoveScale;

class dual_instr_item : public instrument_item {
  private:
    DBLFNPTR alt_data_source;

  public:
    dual_instr_item ( UINT         left        = 0,
                      UINT         top         = 0,
                      UINT         right       = 0,
                      UINT         bottom      = 0,
                      DBLFNPTR     chn1_source = 0,
                      DBLFNPTR     chn2_source = 0);

    dual_instr_item( const dual_instr_item *pdual_instr_item);

    virtual ~dual_instr_item();
    dual_instr_item( const dual_instr_item & image);
    dual_instr_item & operator = (const dual_instr_item & rhs );

    double current_ch1( void ) { return alt_data_source();}
    double current_ch2( void ) { return current_data();}
    virtual void draw( void );
};

class fgTBI_instr : public dual_instr_item {
  private:
    UINT BankLimit;
    UINT SlewLimit;
    UINT scr_hole;
    UINT mid_scr;

  public:
    fgTBI_instr( UINT      left         = 290,
                 UINT      top          = 110,
                 UINT      right        = 40,
                 UINT      bottom       = 100,
                 DBLFNPTR  chn1_source  = get_roll,
                 DBLFNPTR  chn2_source  = get_sideslip,
                 UINT      maxBankAngle = 45,
                 UINT      maxSlipAngle =  5,
                 UINT      gap_width    =  5);

    fgTBI_instr( const fgTBI_instr & image);
    fgTBI_instr & operator = (const fgTBI_instr & rhs );

    ~fgTBI_instr();

    UINT bank_limit( void ) { return BankLimit;}
    UINT slew_limit( void ) { return SlewLimt;}

    virtual void draw( void );       // Required method in base class
};

typedef fgTBI_instr * pTBI;

typedef struct  {
	int type;
	int x_pos;
	int y_pos;
	int scr_width;
	int scr_height;
	int scr_hole;
	int div_units;
	int label_position;
	int width_units;
	double (*load_roll)( void );
	double (*load_pitch)( void );
}HUD_ladder, *pHUDladder;

class HudLadder : public dual_instr_item {
  private:
    UINT   label_position;
    UINT   div_units;
    int    minimum_value;
    int    maximum_value;
    int    width_units;
    int    modulo;
    double factor;
    int    scr_span;
    int    mid_scr;

  public:
    HudLadder( UINT      left          = 330 - 60,
               UINT      top           = 60,
               UINT      right         = 330 + 60,
               UINT      bottom        = 100,
               DBLFNPTR  ptch_source   = get_roll,
               DBLFNPTR  roll_source   = get_sideslip,
               UINT      div_units     = 10,
               UINT      scrn_hole     = 70,
               UINT      lbl_pos       = 0);

    ~HudLadder();

    HudLadder( const HudLadder & image );
    HudLadder & operator = ( const HudLadder & rhs );
    virtual void draw( void );
};

/*
bool AddHUDInstrument( instrument_item *pBlackBox );
void DrawHUD ( void );
bool DamageInstrument( INSTR_HANDLE unit );
bool RepairInstrument( INSTR_HANDLE unit );


void fgUpdateHUD ( Hptr hud );
void fgUpdateHUD2( Hptr hud ); // Future use?
void fgHUDSetTimeMode( Hptr hud, int time_of_day );
*/

#endif // _HUD_H

/* $Log: hud.h,v $
 * Revision 1.11  1998/02/16 13:38:42  curt
 * Integrated changes from Charlie Hotchkiss.
 *
 * Revision 1.10  1998/02/12 21:59:42  curt
 * Incorporated code changes contributed by Charlie Hotchkiss
 * <chotchkiss@namg.us.anritsu.com>
 *
 * Revision 1.8  1998/02/07 15:29:35  curt
 * Incorporated HUD changes and struct/typedef changes from Charlie Hotchkiss
 * <chotchkiss@namg.us.anritsu.com>
 *
 * Revision 1.7  1998/02/03 23:20:15  curt
 * Lots of little tweaks to fix various consistency problems discovered by
 * Solaris' CC.  Fixed a bug in fg_debug.c with how the fgPrintf() wrapper
 * passed arguments along to the real printf().  Also incorporated HUD changes
 * by Michele America.
 *
 * Revision 1.6  1998/01/22 02:59:30  curt
 * Changed #ifdef FILE_H to #ifdef _FILE_H
 *
 * Revision 1.5  1998/01/19 19:27:01  curt
 * Merged in make system changes from Bob Kuehne <rpk@sgi.com>
 * This should simplify things tremendously.
 *
 * Revision 1.4  1998/01/19 18:40:21  curt
 * Tons of little changes to clean up the code and to remove fatal errors
 * when building with the c++ compiler.
 *
 * Revision 1.3  1997/12/30 16:36:41  curt
 * Merged in Durk's changes ...
 *
 * Revision 1.2  1997/12/10 22:37:40  curt
 * Prepended "fg" on the name of all global structures that didn't have it yet.
 * i.e. "struct WEATHER {}" became "struct fgWEATHER {}"
 *
 * Revision 1.1  1997/08/29 18:03:22  curt
 * Initial revision.
 *
 */
