/**************************************************************************
 * sun.h
 *
 * Written 1997 by Durk Talsma, started October, 1997.  For the flight gear
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: sun.h,v 1.5 1998/03/09 22:47:26 curt Exp $
 * (Log is kept at end of this file)
 **************************************************************************/


#ifndef _SUN_H
#define _SUN_H


extern fgSUNPOS solarPosition;


void fgCalcSunPos (struct OrbElements sunParams);
extern struct OrbElements pltOrbElements[9];

/* Initialize the Sun */
void fgSunInit( void );

/* Draw the Sun */
void fgSunRender( void );


#endif /* _SUN_H */


/* $Log: sun.h,v $
 * Revision 1.5  1998/03/09 22:47:26  curt
 * Incorporated Durk's updates.
 *
 * Revision 1.4  1998/02/23 19:07:57  curt
 * Incorporated Durk's Astro/ tweaks.  Includes unifying the sun position
 * calculation code between sun display, and other FG sections that use this
 * for things like lighting.
 *
 * Revision 1.3  1998/01/22 02:59:29  curt
 * Changed #ifdef FILE_H to #ifdef _FILE_H
 *
 * Revision 1.2  1998/01/19 18:40:19  curt
 * Tons of little changes to clean up the code and to remove fatal errors
 * when building with the c++ compiler.
 *
 * Revision 1.1  1998/01/07 03:16:21  curt
 * Moved from .../Src/Scenery/ to .../Src/Astro/
 *
 * Revision 1.3  1997/12/11 04:43:56  curt
 * Fixed sun vector and lighting problems.  I thing the moon is now lit
 * correctly.
 *
 * Revision 1.2  1997/11/25 19:25:39  curt
 * Changes to integrate Durk's moon/sun code updates + clean up.
 *
 * Revision 1.1  1997/10/25 03:16:12  curt
 * Initial revision of code contributed by Durk Talsma.
 *
 */
