\name{reorder}
\alias{reorder}
\alias{reorder.dendrogram}
\title{ Reorder a dendrogram }
\description{
  There are many different orderings of a dendrogram that are consistent
  with the structure imposed.  This function takes a dendrogram and a
  vector of values and reorders the dendrogram in the order of the
  supplied vector, maintaining the constraints on the dendrogram.
}
\usage{
reorder(x, \dots)

\method{reorder}{dendrogram}(x, wts, \dots)
}
\arguments{
  \item{x}{the object to be reordered}
  \item{wts}{numeric weights (arbitrary values) for reordering.}
  \item{\dots}{additional arguments}
}
\details{
  Using the weights \code{wts}, the leaves of the dendrogram are
  reordered so as to be in an order as consistent as possible with the
  weights.  Afterward, at each node, the branches are ordered in
  increasing weights (where the weight of a branch is defined as the sum
  of the weights of its sub branches).
}
\value{
  From \code{reorder.dendrogram} a dendrogram, where each node has a
  further attribute \code{value} with its corresponding weight.
}
\author{R. Gentleman}
\seealso{\code{\link{heatmap}}, \code{\link{cophenetic}} }

\examples{
  set.seed(123)
  x <- rnorm(10)
  hc <- hclust(dist(x))
  dd <- as.dendrogram(hc)
  dd.reorder <- reorder(dd, 10:1)

  op <- par(mfcol = 1:2)
  plot(dd, main = "random dendrogram `dd'")
  plot(dd.reorder, main = "reorder(dd, 10:1)")
  par(op)
}
\keyword{manip}
