\name{cat}
\title{Concatenate and Print}
\usage{
cat(\dots , file = "", sep = " ", fill = FALSE, labels = NULL,
    append = FALSE)
}
\alias{cat}
\description{
  Prints the arguments, coercing them if necessary to character mode first.
}
\arguments{
  \item{\dots}{\R objects which are coerced to character strings,
    concatenated, and printed, with the remaining arguments
    controlling the output.}
  \item{file}{A connection, or a character string naming the file
    to print to.  If
    \code{""} (the default), \code{cat} prints to the standard output
    connection, the console unless redirected by \code{\link{sink}}.
#ifdef unix
    If it is \code{"|cmd"}, the output is piped to the command given
    by \file{cmd}, by opening a pipe connection.
#endif
  }
  \item{sep}{character string to insert between the objects to print.}
  \item{fill}{a logical or numeric controlling how the output is
    broken into successive lines.  If \code{FALSE} (default), only newlines
    created explicitly by \samp{\\n} are printed.  Otherwise, the
    output is broken into lines with print width equal to the option
    \code{width} if \code{fill} is \code{TRUE}, or the value of
    \code{fill} if this is numeric.}
  \item{labels}{character vector of labels for the lines printed.
    Ignored if \code{fill} is \code{FALSE}.}
  \item{append}{logical. Only used if the argument \code{file} is the
    name of file (and not a connection or \code{"|cmd"}).
    If \code{TRUE} output will be appended to
    \code{file}; otherwise, it will overwrite the contents of
    \code{file}.}
}
\details{
  \code{cat} converts its arguments to character strings, concatenates
  them, separating them by the given \code{sep=} string, and then
  prints them.

  No linefeeds are printed unless explicitly requested by \samp{\\n}
  or if generated by filling (if argument \code{fill} is \code{TRUE} or
  numeric.)

  \code{cat} is useful for producing output in user-defined functions.
}
\value{
  None (invisible \code{NULL}).
}
\references{
  Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988)
  \emph{The New S Language}.
  Wadsworth \& Brooks/Cole.
}
\seealso{
  \code{\link{print}}, \code{\link{format}}, and \code{\link{paste}}
  which concatenates into a string.
}
\examples{
iter <- rpois(1, lambda=10)
## print an informative message
cat("iteration = ", iter <- iter + 1, "\n")

## 'fill' and label lines:
cat(paste(letters, 100* 1:26), fill = TRUE,
    labels = paste("{",1:10,"}:",sep=""))
}
\keyword{print}
\keyword{file}
\keyword{connection}
