\name{data}
\title{Data Sets}
\usage{
data(\dots, list = character(0), package = c(.packages(),.Autoloaded),
     lib.loc = .lib.loc)
show.data(package = c(.packages(),.Autoloaded), lib.loc = .lib.loc)
}
\alias{data}
\alias{show.data}
\arguments{
 \item{\dots}{a sequence of \code{name}s or character strings}
 \item{list}{a character vector}
 \item{package}{a name or character vector giving the packages to look
  into for data sets.
  By default, all packages in the search path are used.}
 \item{lib.loc}{a character vector of directory names of \R libraries.
  Defaults to all libraries currently known.}}
\description{
\code{data} loads or lists via \code{show.data} the available data sets.
The data sets to be loaded can be specified as a sequence of \code{name}s
or character strings, or as the character vector \code{list}, or as both.

If no data sets are specified or \code{show.data} is called directly,
the available data sets are displayed.

Currently, four formats of data files are supported:
\enumerate{
  \item files ending \code{".RData"} or \code{".rda"} are
  \code{\link{load}()ed}. 
  \item files ending \code{".R"} or \code{".r"} are
  \code{\link{source}()d} in.
  \item files ending \code{".tab"} or \code{".txt"} are read using
    \code{\link{read.table}(\dots, header = TRUE)}, and hence result in
    a \code{\link{data.frame}}.
  \item files ending \code{".csv"} are read using
    \code{\link{read.table}(\dots, header = TRUE, sep=";")},
    and also result in a \code{\link{data.frame}}.
}
}
\value{
    A character vector of all data sets specified, an empty character
    vector if none were specified.
}
\details{
    If no data sets are specified, \code{data} calls \code{show.data}.
    \code{show.data} looks for a file \file{00Index} (failing that the
    deprecated convention of \file{index.doc}) in a \file{data}
    directory of each specified package, and uses these files to prepare
    a listing. If there is a \file{data} area but no index a warning is
    given: such packages are incomplete. 
}

\seealso{
\code{\link{help}} for obtaining documentation on data sets.
}
\examples{
data()                       # list all available data sets
data(package = base)         # list the data sets in the base package
data(crimes, "deaths")       # load the data sets `crimes' and `deaths'
help(crimes)                 # give information on data set `crimes'
}
\keyword{documentation}
\keyword{datasets}
