C-----------------------------------------------------------------------
C
C  R : A COMPUTER LANGAGE FOR STATISTICAL DATA ANALYSIS
C  COPYRIGHT (C) 1996  ROBERT GENTLEMAN AND ROSS IHAKA
C
C  THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C  IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C  THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
C  (AT YOUR OPTION) ANY LATER VERSION.
C
C  THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
C  BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  SEE THE
C  GNU GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C  YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C  ALONG WITH THIS PROGRAM; IF NOT, WRITE TO THE FREE SOFTWARE
C  FOUNDATION, INC., 675 MASS AVE, CAMBRIDGE, MA 02139, USA.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE DQRLS(X,N,P,Y,NY,TOL,B,RSD,QTY,K,JPVT,QRAUX,WORK)
      INTEGER N,P,NY,K,JPVT(P)
      DOUBLE PRECISION X(N,P),Y(N,NY),TOL,B(P,NY),RSD(N,NY),
     .                 QTY(N,NY),QRAUX(P),WORK(P)
C
C     DQRFIT IS A SUBROUTINE TO COMPUTE LEAST SQUARES SOLUTIONS
C     TO THE SYSTEM
C
C     (1)               X * B = Y
C
C     WHICH MAY BE EITHER UNDER-DETERMINED OR OVER-DETERMINED.
C     THE USER MUST SUPPLY A TOLERANCE TO LIMIT THE COLUMNS OF
C     X USED IN COMPUTING THE SOLUTION.  IN EFFECT, A SET OF
C     COLUMNS WITH A CONDITION NUMBER APPROXIMATELY BOUNDED BY
C     1/TOL IS USED, THE OTHER COMPONENTS OF B BEING SET TO ZERO.
C
C     ON ENTRY
C
C        X      DOUBLE PRECISION(N,P).
C               X CONTAINS N-BY-P COEFFICIENT MATRIX OF
C               THE SYSTEM (1), X IS DESTROYED BY DQRFIT.
C
C        N      THE NUMBER OF ROWS OF THE MATRIX X.
C
C        P      THE NUMBER OF COLUMNS OF THE MATRIX X.
C
C        Y      DOUBLE PRECISION(N,NY)
C               Y CONTAINS THE RIGHT HAND SIDE(S) OF THE SYSTEM (1).
C
C        NY     THE NUMBER OF RIGHT HAND SIDES OF THE SYSTEM (1).
C
C        TOL    DOUBLE PRECISION
C               TOL IS THE NONNEGATIVE TOLERANCE USED TO
C               DETERMINE THE SUBSET OF COLUMNS OF X INCLUDED
C               IN THE SOLUTION.  COLUMNS ARE PIVOTED OUT OF
C               DECOMPOSITION IF
C
C        JPVT   INTEGER(P)
C               THE VALUES IN JPVT ARE PERMUTED IN THE SAME
C               WAY AS THE COLUMNS OF X.  THIS CAN BE USEFUL
C               IN UNSCRAMBLING COEFFICIENTS ETC.
C
C        WORK   DOUBLE PRECISION(2*P)
C               WORK IS AN ARRAY USED BY DQRDC2 AND DQRSL.
C
C     ON RETURN
C
C        X      CONTAINS THE OUTPUT ARRAY FROM DQRDC2.
C               NAMELY THE QR DECOMPOSITION OF X STORED IN
C               COMPACT FORM.
C
C        B      DOUBLE PRECISION(P,NY)
C               B CONTAINS THE SOLUTION VECTORS WITH ROWS PERMUTED
C               IN THE SAME WAY AS THE COLUMNS OF X.  COMPONENTS
C               CORRESPONDING TO COLUMNS NOT USED ARE SET TO ZERO.
C
C        RSD    DOUBLE PRECISION(N,NY)
C               RSD CONTAINS THE RESIDUAL VECTORS Y-X*B.
C
C        QTY    DOUBLE PRECISION(N,NY)     T
C               QTY CONTAINS THE VECTORS  Q Y.   NOTE THAT
C               THE INITIAL P ELEMENTS OF THIS VECTOR ARE
C               PERMUTED IN THE SAME WAY AS THE COLUMNS OF X.
C
C        K      INTEGER
C               K CONTAINS THE NUMBER OF COLUMNS USED IN THE
C               SOLUTION.
C
C        JPVT   HAS ITS CONTENTS PERMUTED AS DESCRIBED ABOVE.
C
C        QRAUX  DOUBLE PRECISION(P)
C               QRAUX CONTAINS AUXILIARY INFORMATION ON THE
C               QR DECOMPOSITION OF X.
C
C
C     ON RETURN THE ARRAYS X, JPVT AND QRAUX CONTAIN THE
C     USUAL OUTPUT FROM DQRDC, SO THAT THE QR DECOMPOSITION
C     OF X WITH PIVOTING IS FULLY AVAILABLE TO THE USER.
C     IN PARTICULAR, COLUMNS JPVT(1), JPVT(2),...,JPVT(K)
C     WERE USED IN THE SOLUTION, AND THE CONDITION NUMBER
C     ASSOCIATED WITH THOSE COLUMNS IS ESTIMATED BY
C     ABS(X(1,1)/X(K,K)).
C
C     DQRFIT USED THE LINPACK ROUTINES DQRDC AND DQRSL.
C
C     INTERNAL VARIABLES.
C
      INTEGER INFO,J,JJ,KK,M
      DOUBLE PRECISION T
C
C     REDUCE X.
C
      CALL DQRDC2(X,N,N,P,TOL,K,QRAUX,JPVT,WORK)
C
C     SOLVE THE TRUNCATED LEAST SQUARES PROBLEM FOR EACH RHS.
C
      IF(K .EQ. 0) GO TO 30
      DO 20 JJ=1,NY
   20    CALL DQRSL(X,N,N,K,QRAUX,Y(1,JJ),RSD(1,JJ),QTY(1,JJ),
     1      B(1,JJ),RSD(1,JJ),RSD(1,JJ),1110,INFO)
   30 CONTINUE
C
C     SET THE UNUSED COMPONENTS OF B TO ZERO.
C
      KK = K + 1
      DO 50 J=KK,P
         DO 40 JJ=1,NY
            B(J,JJ) = 0.
   40    CONTINUE
   50 CONTINUE
      RETURN
      END
