C-----------------------------------------------------------------------
C
C  R : A COMPUTER LANGAGE FOR STATISTICAL DATA ANALYSIS
C  COPYRIGHT (C) 1996  ROBERT GENTLEMAN AND ROSS IHAKA
C
C  THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C  IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
C  THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
C  (AT YOUR OPTION) ANY LATER VERSION.
C
C  THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
C  BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  SEE THE
C  GNU GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C  YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
C  ALONG WITH THIS PROGRAM; IF NOT, WRITE TO THE FREE SOFTWARE
C  FOUNDATION, INC., 675 MASS AVE, CAMBRIDGE, MA 02139, USA.
C
C-----------------------------------------------------------------------
C
C     CH2INV COMPUTES THE INVERSE OF A POSTIVE-DEFINITE SYMMETRIC
C     MATRIX FROM ITS CHOLESKI FACTORIZATION.  THIS CAN BE USED FOR
C     EXAMPLE TO COMPUTE THE DISPERSION MATRIX FOR THE ESTIMATED
C     PARAMETERS IN A REGRESSION ANALYSIS.
C
C     ON ENTRY
C
C         X         DOUBLE PRECISION(LDX,K)
C                   THE CHOLESKI DECOMPOSITION OR THE
C                   QR DECOMPOSITION AS COMPUTED BY DQRDC
C                   OR DQRDC2
C
C         LDX       INTEGER
C                   THE LEADING DIMENSION OF THE ARRAY X
C
C         N         INTEGER
C                   THE NUMBER OF ROWS OF THE MATRIX X
C
C         K         INTEGER
C                   THE NUMBER OF COLUMNS IN THE MATRIX K
C
C     ON RETURN
C
C         V         DOUBLE PRECISION(K,K)
C                   THE VALUE OF INVERSE(X'X)
C
C     THIS VERSION DATED AUG 24, 1996.
C     ROSS IHAKA, UNIVERSITY OF AUCKLAND.
C
      SUBROUTINE CH2INV(X, LDX, N, V, INFO)
      DOUBLE PRECISION X(LDX, N), V(N, N)
C
      DOUBLE PRECISION D
      INTEGER I, J
C
      DO 20 I=1,N
        IF(X(I,I) .EQ. 0.0D0) THEN
          INFO = I
          RETURN
        END IF
        DO 10 J=I,N
          V(I,J) = X(I,J)
   10   CONTINUE
   20 CONTINUE
      CALL DPODI(V, N, N, D, 1)
      DO 40 I=1,N
        IM1 = I-1
        DO 30 J=1,IM1
          V(I,J) = V(J,I)
   30   CONTINUE
   40 CONTINUE
      RETURN
      END
